<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Vlastnosti dalšího klíče',
    'additional-key-info.update' => 'Získat další klíč',
    'additional-key-info.updateDescription' => 'Obnovit další klíč a nainstalovat ho.',
    'additional-key-info.download' => 'Stáhnout klíč',
    'additional-key-info.downloadDescription' => 'Stáhnout aktuální licenční klíč.',
    'additional-key-info.install' => 'Instalovat klíč',
    'additional-key-info.installDescription' => 'Instalovat aktuální licenční klíč.',
    'additional-key-info.revert' => 'Vrátit zpět klíč',
    'additional-key-info.revertDescription' => 'Vrátit se k dříve nainstalovanému licenčnímu klíč.',
    'additional-key-info.revertNotAvailableDescription' => 'Žádný klíč nebyl nainstalován.',
    'additional-key-info.installSuccess' => 'Instalace licenčního klíče byla zahájena.',

    'additional-key-revert.title' => 'Vrácení dodatečného klíče',
    'additional-key-revert.success' => 'Dodatečný klíč byl vrácen.',

    'additional-key-upload.title' => 'Nainstalovat licenční klíč',
    'additional-key-upload.success' => 'Nový další klíč byl nahrán.',

    'additional-keys.title' => 'Další licenční klíče',

    'change-subscriptions-owner.title' => 'Změna přiřazení vybraných předplacených služeb',
    'change-subscriptions-owner.success' => 'Vlastnictví předplatného se změnilo',

    'customers.hint' => 'Zde budete spravovat účty zákazníků vašich hostitelských služeb: vytvářet účty s předplatným služeb, spravovat stávající zákazníky a odebírat účty. Chcete-li spravovat weby, poštu, nebo jiné služby poskytované zákazníkovi, kliknutím na odkaz v pravém sloupci seznamu přejděte na jejich Panel zákazníka.',

    'customer-domains.hint' => 'Zde budete nastavovat a spravovat weby.',

    'customer-subscriptions.hint' => 'Zde budete spravovat předplacené služby zákazníků.',

    'domains.hint' => 'Zde můžete zobrazit informace o všech názvech domén zaregistrovaných v systému a pokračovat ve správě hostitelských služeb. Chcete-li přidat doménu pro sebe nebo pro hostující zákazníky, stačí kliknout na položku Přidat doménu. Při vytváření domény budete vyzváni k vytvoření nového zákazníka a předplatného, nebo k výběru z již existujících.',

    'database-servers.title' => 'Databázové servery',

    'database-server-create.title' => 'Nový databázový server',

    'database-server-properties.title' => 'Databázový server',

    'database-server-upgrade.drawerTitle' => 'Aktualizace MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Aktualizace je dokončená',
    'database-server-upgrade.drawerSubTitle.line1' => 'Komponentu drawer není možné zavřit, dokud probíhá aktualizace.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Pokud dojde během aktualizace k potížím, pomůže vám %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Databázový server MariaDB byl aktualizován na verzi %%releaseVersion%%. Pokud narazíte na potíže, jděte na %%troubleshootingArticle%% a řiďte se pokyny.',
    'database-server-upgrade.upToDate' => 'Verze LTS už nainstalovaná je.',
    'database-server-upgrade.troubleshootingArticle' => 'tento článek ve znalostní bázi',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Přečtěte si %%troubleshootingArticle%% pro pomoc s řešením problémů s aktualizací MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Aktualizujte si místní databázový server MariaDB na aktuální verzi vydání s dlouhodobou podporou (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Důrazně doporučujeme udělat si před aktualizací zálohu serveru a aktualizaci provádět v době, kdy je provoz na webu malý, mimo špičku.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Během aktualizace MariaDB budou server Plesk a na něm hostované weby nedostupné. Aktualizace MariaDB většinou probíhá bez chyb a trvá kolem 10 minut, i přesto ale může mít vliv na celý server.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Poznámka: pokud používáte verzi MariaDB 5.5, Plesk ji nejprve aktualizuje na verzi 10.5. Po této aktualizaci znovu spusťte průvodce a pokračujte aktualizací na aktuální LTS verzi MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Aktuální verze',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'Verze MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Vyberte, na jakou verzi chcete aktualizovat',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Žádná velká vydání',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Poznámky k vydání',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Datum vydání: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Datum ukončení životního cyklu: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Aktualizovat je možné jen fork operace MariaDB dodávané prodejci operačního systému nebo samotné MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontroly před aktualizací',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Analýza konfiguračních soborů MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analýza databází pomocí mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analýza konfigurace správce balíčků',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Kontrola kompatibility systému',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Kontrola WebSocketu',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Zaškrtněte všechna políčka, abyste mohli pokračovat v aktualizaci. Je to nezbytné abychom se přesvědčili, že souhlasíte se změnami v konfiguraci, které aktualizace provede, a že máte možnost provést případnou obnovu.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Tyto proměnné budou z důvodů kompatibility s novou verzí odstraněny:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => 'Tyto konfigurační soubory budou odstraněny, protože jsou součástí balíčku mariadb-server, který bude aktualizován:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} ze {count, plural,one {souboru {files}} other {# souborů: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Přístup k možnostem obnovy (příkazový řádek serveru a nástroj Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Potvrzuji, že mám SSH přístup k serveru',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => '%%sshTerminalExtension%% můžete otevířt v nové záložce prohlížeče pomocí SSH klienta (nezavírejte přitom okno rozšíření terminálu SSH, dokud aktualizace neskončí). Pokud aktualizace selže, pomůže vám přístup přes SSH s obnovou.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'rozšíření terminálu SSH',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Potvrzuji, že mám přístup k nástroji Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Otevřete %%repairKit%% v nové záložce v prohlížeči a přihlaste se pomocí údajů administrátora. Nezavírejte okno rozšíření Repair Kit, dokud nebude aktualizace dokončena.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Sada Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Zálohovat databáze',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Před aktualizací zálohovat všechny dabatáze hostované na serveru',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk uloží zálohy databází do adresáře %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket není v Plesku dostupný',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Bez WebSocketu neuvidíte v reálném čase výstup procesu aktualizace.',

    'database-server-upgrade.submitPopover.title' => 'Abyste zabránili případné ztrátě dat, důrazně doporučujeme před pokračováním vytvořit si výpis hostovaných databází. Určitě chcete pokračovat bez vytvoření výpisu?',

    'database-server-databases.title' => 'Databáze',

    'database-server-change-password.title' => 'Heslo správce',

    'home.title' => 'Domů',

    'license.title' => 'Informace o licencích',

    'primary-key-info.title' => 'Licenční klíč Plesk',
    'primary-key-info.update' => 'Obnovit klíče',
    'primary-key-info.updateDescription' => 'Obnovit objednané licenční klíče a nainstalovat je.',
    'primary-key-info.upload' => 'Instalovat klíč',
    'primary-key-info.uploadDescription' => 'Nahrát a nainstalovat nový licenční klíč.',
    'primary-key-info.revert' => 'Vrátit zpět klíč',
    'primary-key-info.revertDescription' => 'Vrátit se k dříve nainstalovanému licenčnímu klíč.',
    'primary-key-info.expireTitle' => 'Vaše licence Plesk vypršela',
    'primary-key-info.header' => 'Některé zásadní služby kvůli tomu tak nejsou dostupné. %%warning%%',
    'primary-key-info.headWarning' => 'Vaše weby můžou být ohroženy!',
    'primary-key-info.softwareUpdatesTitle' => 'Aktualizace softwaru',
    'primary-key-info.softwareUpdates' => '%%title%% jsou vypnutí. Systém může být zranitelný vůči hrozbám.',
    'primary-key-info.websiteBackupsTitle' => 'Zálohy webu',
    'primary-key-info.websiteBackups' => '%%title%% už nejsou dostupné. Hrozí vám ztráta dat.',
    'primary-key-info.sslCertificatesTitle' => 'Certifikáty SSL/TLS',
    'primary-key-info.sslCertificates' => '%%title%% se už nebudou automaticky prodlužovat. To může ohrozit zabezpečení a důvěru.',
    'primary-key-info.monitoringTitle' => 'Monitoring',
    'primary-key-info.monitoring' => '%%title%% je nedostupný. Je tak možné, že nezjistíte přetížení nebo problémy s výkonem.',
    'primary-key-info.fileDbManagementTitle' => 'Správa souborů a databází',
    'primary-key-info.fileDbManagement' => '%%title%% je vypnutá. Nemůžete efektivně spravovat své soubory a databáze.',
    'primary-key-info.technicalSupportTitle' => 'Technická podpora',
    'primary-key-info.technicalSupport' => '%%title%% není dostupná. Ztráta přístupu k pomoci v případě potíží se serverem může vést k dlouhým výpadkům.',
    'primary-key-info.renewLicense' => 'Kupte si novou licenci Plesk pro obnovení těchto služeb.',
    'primary-key-info.footer' => 'Pokud máte dotazy nebo potřebujete pomoc, ',
    'primary-key-info.supportLink' => 'kontaktujte podporu Plesk',

    'primary-key-revert.title' => 'Vrácení licenčního klíče',
    'primary-key-revert.success' => 'U klíče platformy Plesk bylo provedeno vrácení.',

    'primary-key-upload.title' => 'Nainstalovat licenční klíč',
    'primary-key-upload.success' => 'Nový klíč Plesk byl nahrán.',

    'resellers.hint' => 'Toto je místo, kde můžete spravovat účty prodejců – vaši zákazníci, kteří prodávají hostitelské služby a hostí své vlastní weby. Zde můžete vytvářet účty společně s předplatným služeb, spravovat stávající zákazníky a odebírat účty.',

    'reseller-customers.hint' => 'Zde budete nastavovat a spravovat zákazníky.',

    'reseller-domains.hint' => 'Zde budete nastavovat a spravovat weby.',

    'reseller-subscriptions.hint' => 'Zde budete spravovat předplacené služby prodejce.',

    'subscriptions.hint' => 'Předplacením plánu hostování od vás odběratelé získají služby hostování. Tyto předplacené služby můžete spravovat zde, stejně jako své vlastní předplacené služby, které jste vytvořili, abyste hostili své weby. Chcete-li spravovat weby, poštu, nebo jiné služby poskytované s předplatným, kliknutím na odkaz v pravém sloupci seznamu přejděte na Panel zákazníka.',

    'server-mail-settings.title' => 'Nastavení',
    'server-mail-spam-filter.title' => 'Filtrování nevyžádané pošty',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Černá listina',
    'server-mail-white-list.title' => 'Bílá listina',
    'server-mail-queue.title' => 'Fronta e-mailů',
    'server-mail-statistics.title' => 'Statistiky',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Nastavení',
    'server-spam-filter.black-list' => 'Černá listina',
    'server-spam-filter.white-list' => 'Bílá listina',

    'firewall.title' => 'Správa brány firewall',
    'firewall-general.title' => 'Obecné',
    'firewall-general.toggleStatus' => 'Ochrana branou firewall',
    'firewall-general.buttonDefault' => 'Obnovit výchozí',
    'firewall-general.buttonPanic' => 'Nouzový režim (Panic)',
    'firewall-general.confirmationDefault' => 'Obnovit výchozí nastavení brány firewall?',
    'firewall-general.confirmationPanic' => 'Zapnout Režim paniky? Uživatelé nebudou mít přístup ke svým doménám a některé síťové služby mohou přestat fungovat.',
    'firewall-general.successDefault' => 'Bylo obnoveno výchozí nastavení brány firewall.',
    'firewall-general.successPanic' => 'Režim paniky byl povolen.',
    'firewall-general.info' => 'Brána firewall blokuje z bezpečnostních důvodů veškerá připojení kromě výslovně povolených připojení. Připojení můžete povolit tím, že vytvoříte pravidlo. Další informace naleznete v dokumentaci',
    'firewall-general.interfaces' => 'Síťová rozhraní',
    'firewall-icmp.title' => 'Protokol ICMP',
    'firewall-rules.title' => 'Pravidla brány firewall',

    'dns.title' => 'Nastavení DNS',
    'dns-records.title' => 'Šablona záznamů zón',
    'dns-soa-record.title' => 'Šablona nastavení zóny',

    'php-handler.title' => 'Nastavení pro %%name%%',
    'php-handler.extensions.title' => 'Rozšíření',
    'php-handler.extensions.description' => 'Tato nastavení rozšíření PHP jsou pouze pro tuto obslužnou rutinu.',
    'php-handler.extensions.descriptionShared' => 'Tato nastavení jsou společná pro následující obslužné rutiny PHP: %%handlers%%. Nastavení platí pro všechny weby, které používají tyto obslužné rutiny.',
    'php-handler.extensions.buttonManage' => 'Spravovat balíčky PECL',
    'php-handler.extensions.manage.title' => 'Spravovat balíčky PECL',
    'php-handler.extensions.manage.risks' => 'Rozšíření PHP jsou zajišťována balíčky PECL třetích stran. Instalujete je na vlastní riziko.',
    'php-handler.extensions.manage.description' => 'Instalujte, upgradujte a odinstalujte balíčky PECL. Změny budou použity na všechny weby běžící na rutinách %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Proč v seznamu není požadovaný balíček?',
    'php-handler.extensions.manage.limitations' => 'Rozšíření PHP dodaná poskytovatelem řídicího panelu a distributorem OS v seznamu nejsou.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Obnovit",
    'ServerInformation.sectionGeneral' => "Obecné",
    'ServerInformation.cpu' => "Procesor (CPU)",
    'ServerInformation.version' => "Verze",
    'ServerInformation.os' => "Operační systém",
    'ServerInformation.key' => "Licenční klíč Plesk",
    'ServerInformation.uptime' => "Doba od spuštění",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# den} few {# dny} other {# dnů}} {hours, plural, one {# hodina} few {# hodiny} other {# hodin}} {minutes, plural, one {# minuta} few {# minuty} other {# minut}}",
    'ServerInformation.sectionCpu' => "Využití CPU",
    'ServerInformation.la1min' => "Poslední 1 minuta",
    'ServerInformation.la5min' => "Posledních 5 minut",
    'ServerInformation.la15min' => "Posledních 15 minut",
    'ServerInformation.sectionMemory' => "Využití paměti",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Celkem (kromě kernelu)",
    'ServerInformation.memoryTotal' => "Celkem",
    'ServerInformation.memoryUsed' => "Využito",
    'ServerInformation.memoryFree' => "Volná",
    'ServerInformation.memoryShared' => "Sdílené",
    'ServerInformation.memoryBuffer' => "Vyrovnávací paměť",
    'ServerInformation.memoryCached' => "Využitá vyrovnávací paměť (Cached)",
    'ServerInformation.memoryAvailable' => "Dostupná",
    'ServerInformation.memoryUsage' => "Využití",
    'ServerInformation.sectionSwap' => "Využití odkládacího souboru",
    'ServerInformation.sectionVirtualMemory' => "Využití virtuální paměti",
    'ServerInformation.swapTotal' => "Celkem",
    'ServerInformation.swapUsed' => "Využito",
    'ServerInformation.swapFree' => "Volná",
    'ServerInformation.swapUsage' => "Využití",
    'ServerInformation.sectionHarddisk' => "Využití pevného disku",
    'ServerInformation.harddiskDirectory' => "Systém souborů",
    'ServerInformation.harddiskProtectedDir' => "Důležité adresáře",
    'ServerInformation.harddiskTotal' => "Celkem",
    'ServerInformation.harddiskUsed' => "Využito",
    'ServerInformation.harddiskAvailable' => "Dostupná",
    'ServerInformation.harddiskCapacity' => "Kapacita",
    'ServerInformation.sectionDomains' => "Domény",
    'ServerInformation.activeDomains' => "Aktivní",
    'ServerInformation.inactiveDomains' => "Neaktivní",
    'ServerInformation.problemDomains' => "Problémy",
    'ServerInformation.refreshed' => "Informace aktualizovány.",

    'ServerAbout.copyright' => '© 2025 WebPros International GmbH. Všechna práva vyhrazena.',
    'ServerAbout.linkLicenseManagement' => 'Přejít k informacím o licenci',
    'ServerAbout.panelVersion' => 'Verze',
    'ServerAbout.installedPatchVersion' => 'Aktualizovat #%%patch%%',
    'ServerAbout.licenseKey' => 'Licenční klíč',
    'ServerAbout.productDescription' => 'Plesk je vedoucí platforma WebOps ke spouštění, automatizaci a vývoji aplikací, webů a podnikání v hostování.',
    'ServerAbout.readEula' => 'Přečíst odkaz %%link%%.',
    'ServerAbout.linkEula' => 'Licenční smlouva s koncovým uživatelem (EULA)',
    'ServerAbout.visitForum' => 'Navštívit %%link%%',
    'ServerAbout.linkForum' => 'Fórum Plesk',
    'ServerAbout.followUs' => 'Sledujte nás',
    'ServerAbout.visitSite' => 'Další informace na %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Najít inspiraci na %%link%%',
    'ServerAbout.linkBlog' => 'Blog Plesk',
    'ServerAbout.ip2locationCopyright' => 'Pro %%link%% Plesk používá databázi IP2Location LITE.',
    'ServerAbout.linkGeolocation' => 'IP geolokace',

    'ServerAbout.darkThemePromoTitle' => 'Gratulujeme!',
    'ServerAbout.darkThemePromoDescription' => 'Našli jste kouzelnou kočičku.',
    'ServerAbout.darkThemePromoButton' => 'Abrakadabra! Přejděte na temnou stranu',
    'ServerAbout.darkThemeTourDescription' => 'Přepnutím této možnosti můžete povolit nebo zakázat tmavý motiv vašeho rozhraní.',
    'ServerAbout.darkThemeTourButton' => 'Hotovo',

    'ts-sessions.title' => 'Relace terminálového serveru',
    'ts-sessions-properties.title' => 'Vlastnosti relace',

    'BandwidthLimiting.bandwidthThrottling' => 'Nelze ovládat omezování šířky pásma, protože není nainstalován systém QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Omezování šířky pásma je k dispozici pouze pro domény s webhostingem.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximální využití šířky pásma',
    'BandwidthLimiting.bandwidthHint' => 'Omezení využití šířky pásma se vztahuje pouze na data přenášená prostřednictvím protokolu HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Připojení omezena na',
    'BandwidthLimiting.maxConnectionHint' => 'Pokud omezujete šířku pásma, doporučujeme omezit také počet současných připojení k webu. V případě četných požadavků na web by jinak mohlo dojít ke zvýšení procesní zátěže webového.',
    'BandwidthLimiting.kbps' => 'kB/s',
    'BandwidthLimiting.success' => 'Nastavení omezení šířky pásma bylo změněno.',
    'BandwidthLimiting.unlimited' => 'Neomezeno',

    'ip-address-domains.title' => 'Webové stránky, které používají IP adresu %%ipAddress%% typu %%type%%',
    'ip-address-domains.site' => 'Web',
    'ip-address-domains.setAsDefault' => 'Nastavit jako výchozí',
    'ip-address-domains.type-SHARED' => 'Sdílený',
    'ip-address-domains.type-EXCLUSIVE' => 'vyhrazený',

    'HotlinkProtection.virtualHostingRequired' => 'Ochrana HotLink je k dispozici pouze pro domény s webhostingem.',
    'HotlinkProtection.enabledLabel' => 'Zapnout ochranu HotLink',
    'HotlinkProtection.extensionsLabel' => 'Přípony chráněných souborů',
    'HotlinkProtection.friendsLabel' => 'Adresy schválených webů',
    'HotlinkProtection.success' => 'Nastavení ochrany HotLink bylo změněno.',

    'Odbc.add' => 'Přidat ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% vytvořeno / %%allowed%% povoleno.',
    'Odbc.limitExceeded' => 'Překročen limit připojení ODBC DSN.',
    'Odbc.unlimited' => 'Neomezeno',
    'Odbc.addTooltip' => 'Přidat datový zdroj ODBC.',
    'Odbc.status' => 'Stav',
    'Odbc.name' => 'Název připojení',
    'Odbc.driver' => 'Ovladač',
    'Odbc.description' => 'Popis připojení',
    'Odbc.hostname' => 'Název hostitele',
    'Odbc.statusSystem' => 'Toto je systémový DSN.',
    'Odbc.statusConfigured' => 'DSN je nakonfigurován.',
    'Odbc.statusNotConfigured' => 'DSN není nakonfigurován.',
    'Odbc.noSelectionText' => 'Vyberte jednu nebo několik položek k odebrání.',
    'Odbc.removeConfirmation' => 'Odstranit {count, plural, one {} few {# vybraná připojení} many {# vybraných připojení}=1 {připojení {name}} other {# vybraných připojení}}?',
    'Odbc.removeSuccess' => 'Vybraná připojení byla odstraněna.',

    'DomainAliasSettings.title' => 'Nastavení aliasu domény',
    'DomainAliasSettings.updateSuccess' => 'Vlastnosti aliasu domény %%name%% byly změněny. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Nastavení webu se použije během %%restartInterval%% minut.',

    'Home.Backup.offStatus' => 'Záloha není platná. Obnovit data ze souboru není možné.',
    'Home.Backup.task-failedStatus' => 'Úloha zálohování se nezdařila.',
    'Home.Backup.activeSchedule' => 'Plán: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Plány: %%schedules%%',
    'Home.Backup.noSchedule' => "Není nastavený plán záloh",
    'Home.Backup.period_hourly' => 'Po hodinách %%schedule%%',
    'Home.Backup.period_daily' => 'Denně %%schedule%%',
    'Home.Backup.period_weekly' => 'Týdně %%schedule%%',
    'Home.Backup.period_monthly' => 'Měsíčně %%schedule%%',
    'Home.Backup.create' => 'Vytvořit zálohu',
    'Home.Backup.schedule' => 'Rozvrh',
    'Home.ChangeLog.seeHistory' => 'Zobrazit historii změn',
    'Home.CustomButtons.add' => 'Přidat uživatelské tlačítko',
    'Home.CustomButtons.noButtons' => 'Neexistují žádná uživatelská tlačítka',
    'Home.Customization.title' => 'Řídicí panel',
    'Home.Customization.description' => 'Vyberte, které možnosti chcete vidět',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Zabezpečení',
    'Home.Customization.backup' => 'Poslední záloha serveru',
    'Home.Customization.ipBan' => 'Blokování IP adresy',
    'Home.Customization.mailQueue' => 'Fronta e-mailů',
    'Home.Customization.mySubscriptions' => 'Moje předplacené služby',
    'Home.Customization.overusedSubscriptions' => 'Předplatná s překročeným limitem',
    'Home.Customization.serverInfo' => 'Informace o serveru',
    'Home.Customization.updates' => 'Aktualizace Plesk',
    'Home.Customization.promo' => 'Akce',
    'Home.Customization.changeLog' => 'Co je nového',
    'Home.Customization.customButtons' => 'Zákaznická tlačítka',
    'Home.Customization.drag' => 'Panel přesunete potažením',
    'Home.EmptyView.title' => 'Vyberte možnosti, které se mají zobrazovat, a využívejte potenciál řídicího panelu na maximum.',
    'Home.EmptyView.titleLocked' => 'Váš poskytovatel služeb řídicí panel zamknul.',
    'Home.EmptyView.customize' => 'Přizpůsobit',
    'Home.Extension.title' => 'Rozšíření',
    'Home.IpBan.banned' => 'Zabanovaných',
    'Home.IpBan.trusted' => 'Důvěryhodných',
    'Home.IpBan.more' => 'Více',
    'Home.MailQueue.total' => 'Celkem',
    'Home.MailQueue.deferred' => 'Odložené',
    'Home.MailQueue.held' => 'Pozdržené',
    'Home.MailQueue.more' => 'Více',
    'Home.MailQueue.clean' => 'Vyčistit frontu e-mailů',
    'Home.MailQueue.checkLogs' => 'Zkontrolovat protokoly',
    'Home.MailQueue.repair' => 'Opravit',
    'Home.MailQueue.cleanConfirmQuestion' => 'Vyčistit frontu e-mailů?',
    'Home.MailQueue.cleanConfirmYes' => 'Ano',
    'Home.MailQueue.cleanConfirmNo' => 'Ne',
    'Home.MailQueue.queueCleaned' => 'Fronta e-mailů byla úspěšně vymazána.',
    'Home.OverusedSubscriptions.empty' => 'Nenašla se žádná předplatná s překročeným limitem',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% z %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Ukázat vše s překročeným limitem: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Otevřít jako seznam',
    'Home.PromoNewHomeView.title' => 'Vítá vás nová domovská stránka!',
    'Home.PromoNewHomeView.description' => 'Pokud narazíte na potíže, dejte nám vědět. Hodně nám to pomůže s dalším zlepšováním.',
    'Home.PromoNewHomeView.feedback' => 'Sdílet zpětnou vazbu',
    'Home.PromoNewHomeView.switch' => 'Přepnout zpátky na „Domů“',
    'Home.ServerInfo.hostname' => 'Název hostitele',
    'Home.ServerInfo.copyHostname' => 'Zkopírovat název hostitele',
    'Home.ServerInfo.ipAddress' => 'IP adresa',
    'Home.ServerInfo.copyIpAddress' => 'Zkopírovat IP adresu',
    'Home.ServerInfo.publicIpAddress' => 'Veřejná IP adresa',
    'Home.ServerInfo.copyPublicIpAddress' => 'Zkopírovat veřejnou IP adresu',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.copyOs' => 'Zkopírovat OS',
    'Home.ServerInfo.uptime' => 'Doba od spuštění',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# den} few {# dny} other {# dnů}} {hours, plural, one {# hodina} few {# hodiny} other {# hodin}} {minutes, plural, one {# minuta} few {# minuty} other {# minut}}",
    'Home.ServerInfo.more' => 'Více',
    'Home.Subscriptions.add' => 'Přidat nové',
    'Home.Subscriptions.empty' => 'Vytvořit předplatná pro hostování několika webů v izolovaném prostředí na serveru. %%link%%',
    'Home.Subscriptions.help' => 'Další informace',
    'Home.Updates.title' => 'Aktualizace produktu',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% aktualizace #%%patch%%',
    'Home.Updates.manageComponents' => 'Přidat nebo odebrat součásti',
    'Home.Updates.lastUpdated' => 'Poslední aktualizace: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Zjišťovat aktualizace',
    'Home.Updates.enableAutoupdate' => 'Povolit automatické aktualizace',
    'Home.Updates.lastChecked' => 'Poslední kontrola: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => 'verze %%availableVersion%% už je k dispozici',
    'Home.Updates.installNewVersion' => 'Nainstalovat',
    'Home.Updates.patchAvailable' => 'Jsou k dispozici malé aktualizace',
    'Home.Updates.patchAvailableVersion' => 'Jsou k dispozici menší aktualizaci pro verzi %%currentVersion%%',
    'Home.Updates.installPatch' => 'Aktualizovat nyní',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Dostupná aktualizace pro {package}} other {Dostupných aktualizací pro {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural,one {# balíček} few {# balíčky} other {# balíčků}}',
    'Home.Updates.installUpdates' => '{total, select,1 {Aktualizovat} other {Aktualizovat vše}}',
    'Home.Promo.close' => 'Zavřít blok',
    'Home.Promo.viewSlide' => 'Zobrazit snímek %%slideNumber%%',
    'Home.Promo.Customize.title' => 'Přizpůsobte si řídicí panel podle svého!',
    'Home.Promo.Customize.content' => 'S novým řídicím panelem na míru máte oblíbené funkce doslova na dosah klepnutí',
    'Home.Promo.Customize.action' => 'Přizpůsobit',
    'Home.Promo.SwitchToPuv.title' => 'Máte informace o zobrazeních rozhraní v platformě Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Pokud svým zákazníkům neposkujete hostingové služby v podobě balíčků, můžete vyzkoušet rozhraní, které je pro správu webů, souborů, databází, e-mailových účtů a webových aplikací pohodlnější.',
    'Home.Promo.SwitchToPuv.action' => 'Vyzkoušet',
    'Home.Status.error' => 'Chyba',
    'Home.Status.warning' => 'Varování',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Nastavení hostování',
    'HostingSettings.updateSuccess' => 'Nastavení bylo aktualizováno.',
    'HostingSettings.emptyLogin' => 'Musíte zadat přihlašovací jméno.',
    'HostingSettings.emptyPassword' => 'Musíte zadat heslo.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Server FTP nepodporuje adresy IPv6. Přidělte alespoň jednu adresu IPv4, jinak uživatel nebude moci nahrát soubory na server prostřednictvím FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Nastavení domény',
    'HostingSettings.domainSettingsSection.domainName' => 'Název domény',
    'HostingSettings.domainSettingsSection.description' => 'Například priklad.com ',

    'HostingSettings.submitPopover.title' => 'Odstranit obsah %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Změna typu hostingu webové stránky na "%%type%%" trvale odstraní veškerý obsah na webu, včetně následujících adresářů:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Chcete změnit typ hostování pro váš web?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Pro přístup k dalším nastavením zadejte jméno a heslo uživatele systému a pak klikněte na „vytvořit webový prostor“.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Pro přístup k dalším nastavením klikněte na „Další“ pro vytvoření hostingu.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Typ hostingu',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Předávání',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Žádný webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Použijte zónu DNS domény pro poštovní schránky pod tímto názvem domény',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Cesta k domovskému adresáři webu',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Upřednostňovaná doména',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Návštěvníky sem přesměruje pro SEO optimalizovaný stavový kód HTTP 301.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Přesměrovat návštěvníky na',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Typ přesměrování',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Přesunuto trvale (kód 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Přesměruje návštěvníky webových stránek na jiný web a zobrazí jim cílovou adresu. Takové přesměrování udrží pozici webu ve vyhledávání',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Přesunuto dočasně (kód 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Pokud nechcete, aby vyhledávače indexovaly tyto dočasné stránky, přesměrujte návštěvníky webu na kopii dočasného webu.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Rámcové přesměrování',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Přesměrujte návštěvníky webu na jiný web, ale neukazujte jim cílovou adresu, aby o přesměrování nevěděli.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Upřednostňovaná doména',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Žádné',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Kořen dokumentu',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Kořen dokumentu nelze změnit, protože jsou na tomto webu nainstalovány webové aplikace.',
    'HostingSettings.domainSettingsSection.save' => 'Uložit',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Režim kompatibility',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Spustit web v režimu kompatibility pro starší verze "Oddělit obsah SSL/TLS a obsah bez SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Tento web běží v režimu kompatibility a není možné spravovat ho přes rozhraní Plesk. Je to proto, že jste před aktualizací používali zastaralou možnost „Oddělit obsah s SLL/TLS od obsahu bez SSL/TLS“. Od verze Plesk 11 už weby ukládají svůj obsah, který je dostupný přes HTTP a HTTPS spojení ve stejném adresáři. Doporučujeme přesunout všechna data z adresáře httpsdocs/ do adresáře httpdocs/ a pak režim kompatibility vypnout. Aplikace nainstalované v adresáři httpsdocs/ díky tomu budou dostupné i přes internet. Myslete ale na to, že znovu zapnout režim kompatibility už pak nebude možné.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Provést změnu nastavení?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Taková změna nastavení je v rozporu s bezpečnostními pravidly serveru a může negativně ovlivnit jeho výkon nebo ho udělat zranitelnějším vůči útokům.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Změnit',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Vrátit uložený',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Bude použita předvolba bezpečných nastavení',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Pro vyšší bezpečnost použijte přednastavené volby, které jsou bezpečné. Nezapomíntejte, že některá oprávnění umožňují odběratelům tato nastavení upravovat.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Použít bezpečné předvolby',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Další informace o nastavení zabezpečeného hostingu',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Podpora SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Povoleno',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Šifrujte spojení mezi webem a prohlížečem návštěvníka.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certifikát',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Pro povolení HTTPS nahrajte SSL/TLS certifikát do repozitáře domény a pak ho tady vyberte.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Přesměrujte návštěvníky z HTTP na HTTPS pomocí SEO optimalizovaného stavového kódu 301',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Ve vašem úložišti nejsou žádné certifikáty SSL/TLS. Chcete-li přidat certifikát, přejděte na %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'tato stránka',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (jiné úložiště)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nevybráno',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Skriptování pro web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Vyberte, které programovací a skriptovací jazyky má webový server interpretovat.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'adresář cgi-bin je umístěn v %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Použít SSI na soubory *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET verze',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Vlastní chybové dokumenty',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'adresář cgi-bin je umístěn v',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'kořen dokumentu této domény',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'kořenový adresář webového prostoru',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'kořen této domény ve starodávném stylu',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Vlastní chybové dokumenty',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Další oprávnění pro zápis/úpravy',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Nástroj pro publikování na webu Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webová statistika',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Nástroj',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Chránit přístup k webovým statistikám prostřednictvím vašeho přihlašovacího jména FTP a hesla',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Zakázáno',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Nastavení webového prostoru',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP adresy',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Disková kvóta',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Povoleno',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Zakáže operace se soubory webu pokud bude překročena kvóta pro místo na disku zadaná v nastaveních předplatného (pokud existuje).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Kvóta pevného disku není podporována kvůli způsobu konfigurace souborového systému serveru.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Pověření uživatele systému',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Spravujte soubory a složky webu přes FTP nebo správce souborů. Pro přístup k serveru můžete využít SSH, pokud je povoleno.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Spravujte soubory a složky webu přes FTP nebo správce souborů. Pro přístup k serveru můžete využít vzdálenou plochu, pokud je povolena.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Uživatelské jméno',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Heslo',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Pro změnu hesla uživatele systému zadejte nové heslo.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Přístup SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Přístup přes vzdálenou plochu',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Povoleno',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Přihlaste se na server pomocí přihlašovacích údajů uživatele systému.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Zakázáno',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Pro {count, plural, one {# doménu} few {# domény} many {# domén} other {# domén}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Následující nastavení je vzájemné pro {count, plural, one {# doménu ve webovém prostoru {name}} few {všechny # domény ve webovém prostoru {name}} many {všech # domén ve webovém prostoru {name}} other {všech # domén ve webovém prostoru {name}}}:',

    'OdbcAdd.title' => 'Přidat ODBC DSN',
    'OdbcAdd.nameLabel' => 'Název připojení',
    'OdbcAdd.descriptionLabel' => 'Popis připojení',
    'OdbcAdd.driver' => 'Ovladač',
    'OdbcAdd.submit' => 'Vytvořit ODBC DSN',

    'OdbcEdit.title' => 'Nastavit připojení ODBC',
    'OdbcEdit.saveSuccess' => 'Nastavení připojení byla uložena.',
    'OdbcEdit.test' => 'Otestovat připojení',
    'OdbcEdit.connectSuccess' => 'Připojení proběhlo úspěšně.',

    'OdbcEdit.excel.driver.label' => 'Ovladač',
    'OdbcEdit.excel.dbq.label' => 'Cesta k souboru databáze',
    'OdbcEdit.excel.defaultdir.label' => 'Výchozí datový adresář',
    'OdbcEdit.excel.fil.label' => 'Verze databáze',
    'OdbcEdit.excel.maxbuffersize.label' => 'Max. velikost vyrovnávací paměti',
    'OdbcEdit.excel.pagetimeout.label' => 'Časový limit stránky',

    'OdbcEdit.access.driver.label' => 'Ovladač',
    'OdbcEdit.access.dbq.label' => 'Cesta k souboru databáze',
    'OdbcEdit.access.uid.label' => 'ID přihlášení',
    'OdbcEdit.access.pwd.label' => 'Heslo',
    'OdbcEdit.access.pagetimeout.label' => 'Časový limit stránky',
    'OdbcEdit.access.pagetimeout.description' => 'Časové období v desetinách sekundy, po které nepoužitá stránka zůstává v mezipaměti. Tato možnost platí pro všechny zdroje dat, které používají ovladač Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Max. velikost vyrovnávací paměti',
    'OdbcEdit.access.maxbuffersize.description' => 'Velikost vnitřní vyrovnávací paměti, v kB, zarovnáno na hranici 256 kB.',
    'OdbcEdit.access.readonly.label' => 'Pouze ke čtení',
    'OdbcEdit.access.readonly.description' => 'Označí databázi jako pouze ke čtení, čímž zakáže všechny aktualizace.',
    'OdbcEdit.access.exclusive.label' => 'Výhradní',
    'OdbcEdit.access.exclusive.description' => 'Označí databázi jako výhradní, čímž zakáže sdílené aktualizace.',
    'OdbcEdit.access.safetransactions.label' => 'Bezpečné transakce',
    'OdbcEdit.access.safetransactions.description' => 'Při nastavení na 0 (výchozí nastavení), budou všechny transakce potvrzeny okamžitě. Při nastavení na 1 se všechny transakce uloží na disk pouze při operaci potvrzení, ale výkon se lehce sníží.',
    'OdbcEdit.access.threads.label' => 'Vlákna',
    'OdbcEdit.access.threads.description' => 'Počet vláken běžících na pozadí pro používaný modul.',
    'OdbcEdit.access.maxscanrows.label' => 'Max. počet řádků ke kontrole',
    'OdbcEdit.access.maxscanrows.description' => 'Počet řádků, které je nutno naskenovat při nastavení datového typu sloupce na základě stávajících dat.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Určuje, jak se změny provedené mimo transakci zapíší do databáze.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Určuje, zda bude ovladač MS Access provádět explicitní uživatelsky definované transakce asynchronně.',

    'OdbcEdit.mssql.driver.label' => 'Ovladač',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'ID přihlášení',
    'OdbcEdit.mssql.pwd.label' => 'Heslo',
    'OdbcEdit.mssql.database.label' => 'Výchozí databáze',
    'OdbcEdit.mssql.app.label' => 'Název aplikace',
    'OdbcEdit.mssql.wsid.label' => 'ID pracovní stanice',
    'OdbcEdit.mssql.language.label' => 'Výchozí jazyk',
    'OdbcEdit.mssql.oemtoansi.label' => 'Převod rozšířených znaků na hodnoty OEM',

    'OdbcEdit.mysql.driver.label' => 'Ovladač MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Název hostitele serveru MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Výchozí databáze',
    'OdbcEdit.mysql.user.label' => 'Uživatelské jméno',
    'OdbcEdit.mysql.user.description' => 'Uživatelské jméno použité k připojení do MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Heslo',
    'OdbcEdit.mysql.password.description' => 'Heslo pro uživatelský účet na serveru',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Port TCP/IP, který se má použít, pokud není server místním hostitelem',
    'OdbcEdit.mysql.socket.label' => 'Soket',
    'OdbcEdit.mysql.socket.description' => 'Pojmenovaný kanál systému Windows, s nímž se má propojit, pokud je server místním hostitelem',
    'OdbcEdit.mysql.option.label' => 'Možnost',
    'OdbcEdit.mysql.option.description' => 'Nastavení, která určují, jak by MyODBC mělo fungovat. Viz <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentace</a>',

    'ProtectedDirectoryList.add' => 'Přidat chráněný adresář',
    'ProtectedDirectoryList.addTooltip' => 'Vytvořit chráněný adresář.',
    'ProtectedDirectoryList.name' => 'Jméno',
    'ProtectedDirectoryList.realmTitle' => 'Název chráněné oblasti',
    'ProtectedDirectoryList.noSelectionText' => 'Vyberte jednu nebo několik položek k odebrání.',
    'ProtectedDirectoryList.edit' => 'Upravit',
    'ProtectedDirectoryList.remove' => 'Odstranit ochranu',
    'ProtectedDirectoryList.removeTooltip' => 'Odstranit ochranu z vybraných adresářů.',
    'ProtectedDirectoryList.removeConfirmation' => 'Tento proces odstraní ochranu z {count, plural, =1 {adresáře {name}} few {# zvolených adresářů} other {# zvolených adresářů}}. {count, plural,=1 {Tento adresář bude volně dostupný} few {Tyto adresáře budou volně dostupné} other {Tyto adresáře budou volně dostupné}} užvatelům na Internetu.',
    'ProtectedDirectoryList.removeSuccess' => 'Vybrané adresáře byly odstraněny.',

    'ProtectedDirectoryAdd.title' => 'Vytvořit chráněný adresář',
    'ProtectedDirectoryAdd.submit' => 'Vytvořit',
    'ProtectedDirectoryAdd.success' => 'Chráněný adresář %%path%% byl úspěšně vytvořen',

    'ProtectedDirectoryEdit.title' => 'Nastavení chráněného adresáře',
    'ProtectedDirectoryEdit.success' => 'Nastavení chráněného adresáře se změnilo',

    'ProtectedDirectoryUserAdd.title' => 'Vytvořit uživatele chráněného adresáře',
    'ProtectedDirectoryUserAdd.subtitle' => 'Adresář %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Uživatelské jméno',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Heslo',
    'ProtectedDirectoryUserAdd.submit' => 'Vytvořit',
    'ProtectedDirectoryUserAdd.success' => 'Pro chráněný adresář byl vytvořen uživatel %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Heslo pro uživatele chráněného adresáře',
    'ProtectedDirectoryUserPassword.subtitle' => 'Uživatel %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Heslo',
    'ProtectedDirectoryUserPassword.submit' => 'Uložit',
    'ProtectedDirectoryUserPassword.success' => 'Pověření uživatele byl uložena.',

    'SummaryReport.Layout.title' => 'Vlastnosti rozvržení sestav',
    'SummaryReport.Layout.success' => 'Rozvržení reportu %%name%% bylo aktualizováno.',

    'SummaryReport.Layout.Add.title' => 'Vytvořit rozvržení sestavy',
    'SummaryReport.Layout.Add.success' => 'Rozvržení reportu %%name%% bylo vytvořeno.',

    'SummaryReport.Report.buttonLayouts' => 'Rozvržení',
    'SummaryReport.Report.buttonSchedule' => 'Rozvrh',
    'SummaryReport.Report.buttonProperties' => 'Vlastnosti',
    'SummaryReport.Report.buttonTrafficHistory' => 'Historie přenosu dat',
    'SummaryReport.Report.buttonPrint' => 'Vytisknout',
    'SummaryReport.Report.buttonSend' => 'Odeslat e‑mailem',
    'SummaryReport.Report.successSent' => 'Zpráva byla odeslána na %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Plán doručení pro %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Plán doručení sestavy bylo aktualizován.',

    'SummaryReport.Schedule.Add.title' => 'Vytvořte plány doručení pro %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Byl vytvořen plán doručení sestavy.',

    'VirtualDirectory.errNotExist' => 'Virtuální adresář je nasměrován na fyzickou složku, která neexistuje.',
    'VirtualDirectory.errNoPermissions' => 'Nemáte oprávnění prohlížet obsah tohoto adresáře.',
    'VirtualDirectory.tabBrowse' => 'Adresáře',
    'VirtualDirectory.tabBrowseHint' => 'Na webu %%site%% pracujte s fyzickými a virtuálními soubory a adresáři.',
    'VirtualDirectory.tabMimeTypes' => 'Typy MIME',
    'VirtualDirectory.tabMimeTypesHint' => 'Spravovat registrované typy MIME.',
    'VirtualDirectory.tabErrorDocs' => 'Chybové dokumenty',
    'VirtualDirectory.tabErrorDocsHint' => 'Spravovat chybové dokumenty.',
    'VirtualDirectory.tabProtection' => 'Ochrana',
    'VirtualDirectory.tabProtectionHint' => 'Omezit práva pro přístup k adresáři ochranou heslem.',

    'VirtualDirectory.errorDocType.default' => 'Výchozí',
    'VirtualDirectory.errorDocType.file' => 'Soubor',
    'VirtualDirectory.errorDocType.url' => 'Adresa URL',

    'VirtualDirectory.Sidebar.buttonProperties' => 'Vlastnosti adresáře',
    'VirtualDirectory.Sidebar.buttonPropertiesHint' => 'Zobrazit a změnit vlastnosti virtuálního adresáře.',
    'VirtualDirectory.Sidebar.buttonPermissions' => 'Přístupová oprávnění k adresáři',
    'VirtualDirectory.Sidebar.buttonPermissionsHint' => 'Nastavit přístupová oprávnění k adresáři.',
    'VirtualDirectory.Sidebar.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.Sidebar.buttonAspDotNetHint' => 'Konfigurovat nastavení ASP.NET.',
    'VirtualDirectory.Sidebar.buttonPhp' => 'PHP',
    'VirtualDirectory.Sidebar.buttonPhpHint' => 'Konfigurovat nastavení PHP.',

    'VirtualDirectory.CreateDirectory.title' => 'Vytvořit adresář',
    'VirtualDirectory.CreateDirectory.name' => 'Název adresáře',
    'VirtualDirectory.CreateDirectory.success' => 'Byl vytvořen adresář %%name%%.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Adresář %%name%% už existuje.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Vytvořit virtuální adresář',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'Byl vytvořen adresář %%name%%.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Vlastnosti virtuálního adresáře',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Virtuální adresář byl upraven.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Zavřít',

    'VirtualDirectory.MimeTypeList.add' => 'Přidat typ MIME',
    'VirtualDirectory.MimeTypeList.edit' => 'Upravit typ MIME',
    'VirtualDirectory.MimeTypeList.addHint' => 'Registrovat nový typ MIME.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Rozšíření',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Obsah',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Vyberte jednu nebo několik položek k odebrání.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Odstranit {count, plural, =1 {vybraný typ MIME} one {# vybraný typ MIME} few {# vybrané typy MIME} other {# vybraných typů MIME}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Vybrané typy MIME byly odstraněny.',

    'VirtualDirectory.CreateMimeType.title' => 'Přidat typ MIME',
    'VirtualDirectory.CreateMimeType.success' => 'Byl zaregistrován nový typ MIME.',

    'VirtualDirectory.EditMimeType.title' => 'Upravit typ MIME',
    'VirtualDirectory.EditMimeType.success' => 'Typ MIME byl upraven.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Chyba',
    'VirtualDirectory.ErrorDocList.columnName' => 'Popis',
    'VirtualDirectory.ErrorDocList.columnType' => 'Typ',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Umístění',
    'VirtualDirectory.ErrorDocList.edit' => 'Upravit',

    'VirtualDirectory.EditErrorDoc.title' => 'Upravit chybový dokument',
    'VirtualDirectory.EditErrorDoc.success' => 'Chybový dokument byl upraven.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Chyba',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Typ',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Umístění',

    'VirtualDirectory.Protection.notSupported' => 'Ochrana adresáře není pro tento adresář podporovaná, protože jeho jméno je delší než 245 znaků nebo obsahuje nepodporované znaky.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Ochrana virtuálního adresáře je zakázána',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Ochránit',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'Adresář %%path%% je chráněný.',
    'VirtualDirectory.Protection.tools' => 'Nástroje',
    'VirtualDirectory.Protection.removeProtection' => 'Odstranit ochranu',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Vytvořte adresu URL odpovídající adresáři, který je přístupný všem.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Odstranit ochranu virtuálního adresáře? Při této akci budou odebráni všichni uživatelé chráněných adresářů a nastavení ochrany adresáře.',
    'VirtualDirectory.Protection.settings' => 'Nastavení',
    'VirtualDirectory.Protection.settingsTooltip' => 'Zobrazit umístění adresáře a zadat titul pro chráněnou oblast.',

    'VirtualDirectory.AspDotNet.title' => 'Konfigurovat nastavení ASP.NET',

    'VirtualDirectory.Php.title' => 'Verze PHP',
    'VirtualDirectory.Php.version' => 'Verze',
    'VirtualDirectory.Php.success' => 'Verze PHP byla aktualizována.',


    'MassMailPage.sendEmail' => 'Odeslat hromadný e-mail',
    'MassMailPage.selectAtLeastOneTemplate' => 'Vyberte alespoň jednu šablonu',
    'MassMailPage.confirmRemoval' => 'Určitě chcete odstranit {count, select, 1 {vybranou šablonu} other {vybraných šablon}}?',
    'MassMailPage.remove' => 'Odebrat',
    'MassMailPage.filters' => 'Filtry',
    'MassMailPage.name' => 'Název šablony',
    'MassMailPage.sender' => 'Odesílatel',
    'MassMailPage.recipients' => 'Příjemci',
    'MassMailPage.subject' => 'Předmět',
    'MassMailPage.created' => 'Datum vytvoření',
    'MassMailPage.send' => 'Odeslat',
    'MassMailPage.recipientsNone' => 'Žádný',
    'MassMailPage.recipientsAdmins' => 'Správce',
    'MassMailPage.recipientsResellers' => 'Všichni prodejci',
    'MassMailPage.recipientsResellersSelected' => 'Vybraní prodejci',
    'MassMailPage.recipientsResellersExcept' => 'Všichni prodejci kromě vybraných',
    'MassMailPage.recipientsClients' => 'Všichni odběratelé',
    'MassMailPage.recipientsClientsSelected' => 'Vybraní zákazníci',
    'MassMailPage.recipientsClientsExcept' => 'Všichni zákazníci kromě vybraných',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {Šablona odebrána} other {Šablony odebrány}}.',
    'MassMailPage.emptyViewTitle' => 'Žádné šablony hromadných e-mailů',
    'MassMailPage.addNew' => 'Vytvořit šablonu',
    'CreateMassMailTemplatePage.templateCreated' => 'Šablona byla vytvořena.',
    'EditMassMailTemplatePage.templateUpdated' => 'Šablona byla aktualizována.',
    'SendMassMailPage.emailSent' => 'E-mail odeslán.',
    'SendMassMailPage.fieldIsRequired' => 'Pole nemůže být prázdné',
    'SendMassMailPage.saveAsTemplate' => 'Uložit zprávu jako novou šablonu',
    'SendMassMailPage.newTemplateName' => 'Nový název šablony',
    'SendMassMailPage.selectedTemplate' => 'Vybraná šablona',
    'SendMassMailPage.send' => 'Odeslat',
    'VirtualHostTemplatePage.name' => 'Jméno',
    'VirtualHostTemplatePage.sizeInBytes' => 'Velikost',
    'VirtualHostTemplatePage.modified' => 'Datum modifikace',
    'VirtualHostTemplatePage.permissions' => 'Oprávnění',
    'VirtualHostTemplatePage.user' => 'Uživatel',
    'VirtualHostTemplatePage.group' => 'Skupina',
    'VirtualHostTemplatePage.uploadTemplate' => 'Nahrát',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Šablona byla nahrána.',
    'VirtualHostTemplatePage.root' => 'Virtuální šablony',
    'VirtualHostTemplatePage.emptyViewTitle' => 'V šabloně nejsou žádné soubory',
    'VirtualHostTemplatePage.total' => 'Celkový počet položek v adresáři {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Použít výchozí hodnoty',
    'VirtualHostTemplatePage.successfullyReset' => 'Šablona se změnila na výchozí.',

    'TrafficUsageByDomain.List.service' => 'Služba',
    'TrafficUsageByDomain.List.usage' => 'Využito',
    'TrafficUsageByDomain.List.incoming' => 'V',
    'TrafficUsageByDomain.List.outgoing' => 'Ven',
    'TrafficUsageByDomain.List.percentOfAll' => '% ze všech',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Název domény',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Jméno vlastníka",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Využito',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Limit',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Dostupná',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Použito (v %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Pouze mé domény',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Jen domény prodejce',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Jméno vlastníka',

    'TrafficUsageByReseller.emptyView' => 'Prodejce nemá žádné zákazníky',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Vlastní domény prodejce",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Domény zákazníků prodejce: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Informace a statistiky',
    'InfoAndStatistics.Main.overview' => 'Přehled',
    'InfoAndStatistics.Main.domains' => 'Domény',
    'InfoAndStatistics.Main.trafficUsage' => 'Využití přenosu dat',
    'InfoAndStatistics.Main.reports' => 'Sestavy',
    'InfoAndStatistics.Main.serverSettings' => 'Nastavení serveru',
    'InfoAndStatistics.TrafficUsage.customers' => 'Zákazníci',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Distributoři',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domény',

    'ConfigureMailClient.title' => 'Vyberte si poštovního klienta',
    'ConfigureMailClient.description' => 'K automatickému nastavení e-mailu %%email%%',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Ruční',
    'ConfigureMailClient.Common.email' => 'Email:',
    'ConfigureMailClient.Common.start' => 'Spustit',
    'ConfigureMailClient.Common.finish' => 'Dokončit',
    'ConfigureMailClient.Common.next' => 'Další',
    'ConfigureMailClient.Common.prev' => 'Předchozí',
    'ConfigureMailClient.Common.back' => 'Zpět',
    'ConfigureMailClient.Common.manualLink' => 'Máte potíže s přidáváním poštovního účtu? Zkuste ruční nastavení.',
    'ConfigureMailClient.Thunderbird.title' => 'Nastavení e-mailového účtu',
    'ConfigureMailClient.Thunderbird.description' => 'Za účelem přidání poštovního účtu do programu Mozilla Thunderbird postupujte dle pokynů.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Otevřete Thunderbird',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Otevřete na svém počítači Thunderbird a pak v hlavní nabídce aplikace Thunderbird klikněte na „Nastavení účtu“.',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Přidejte svůj účet',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Klikněte na „Akce účtu“ a pak na „Přidat poštovní účet“.',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Zadejte své údaje',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Zadejte své jméno tak, jak se má zobrazovat ve zprávách, které odešlete. Zadejte také svou e-mailovou adresu a heslo a klikněte na „Pokračovat“.',
    'ConfigureMailClient.Thunderbird.step4.title' => 'A je to!',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Thunderbird se teď pokusí automaticky přidat váš poštovní účet.',

    'ConfigureMailClient.Outlook.title' => 'Nastavení e-mailového účtu',
    'ConfigureMailClient.Outlook.warning' => 'Váš poštovní účet nejsme schopni přidat automaticky do programu Outlook 2019 nebo jeho novější verze.',
    'ConfigureMailClient.Outlook.warningTooltip' => 'Poštovní účty přidáváme automaticky díky funkci autodiscover. Outlook 2019 a novější verze používají k vyřizování požadavků autodiscover proxy servery Microsoftu, které nejsou v Plesku ani v rozšíření Plesk Premium Email podporovány.',
    'ConfigureMailClient.Outlook.description' => 'Pokud chcete přidat svůj poštovní účet do aplikace Microsoft Office Outlook 2016, řiďte se následujícími pokyny.',
    'ConfigureMailClient.Outlook.step1.title' => 'Přidejte nový účet',
    'ConfigureMailClient.Outlook.step1.description' => 'Otevřete si na počítači Outlook 2016 a pak přejděte na kartu „Soubor“.',
    'ConfigureMailClient.Outlook.step2.title' => 'Přidejte nový účet',
    'ConfigureMailClient.Outlook.step2.description' => 'Klikněte na „Přidat účet“.',
    'ConfigureMailClient.Outlook.step3.title' => 'Zadejte svou e-mailovou adresu',
    'ConfigureMailClient.Outlook.step3.description' => 'Zadejte svou e-mailovou adresu.',
    'ConfigureMailClient.Outlook.step4.title' => 'Zadejte své heslo',
    'ConfigureMailClient.Outlook.step4.description' => 'Zadejte heslo k poštovnímu účtu a pak klikněte na „Připojit“.',
    'ConfigureMailClient.Outlook.step5.title' => 'A je to!',
    'ConfigureMailClient.Outlook.step5.description' => 'Nastavení svého účtu dokončíte kliknutím na „OK“.',

    'ConfigureMailClient.Outlook365.title' => 'Nastavení e-mailového účtu',
    'ConfigureMailClient.Outlook365.warning' => 'Váš poštovní účet nejsme schopni přidat automaticky do programu Outlook 2019 nebo jeho novější verze.',
    'ConfigureMailClient.Outlook365.warningTooltip' => 'Poštovní účty přidáváme automaticky díky funkci autodiscover. Outlook 2019 a novější verze používají k vyřizování požadavků autodiscover proxy servery Microsoftu, které nejsou v Plesku ani v rozšíření Plesk Premium Email podporovány.',
    'ConfigureMailClient.Outlook365.description' => 'Pokud chcete přidat svůj poštovní účet do aplikace Microsoft Outlook 365, řiďte se následujícími pokyny.',
    'ConfigureMailClient.Outlook365.step1.title' => 'Přidejte nový účet',
    'ConfigureMailClient.Outlook365.step1.description' => 'Otevřete na počítači aplikaci Outlook 365. Pokud ještě nemáte v Outlook 365 nastavený poštovní účet, zadejte svou e-mailovou adresu v průvodci.',
    'ConfigureMailClient.Outlook365.step2.title' => 'Přidejte nový účet',
    'ConfigureMailClient.Outlook365.step2.description' => 'Jako poskytovatele e-mailu vyberte IMAP. Zadejte heslo, použijte doporučená nastavení a klikněte na „Pokračovat“.',
    'ConfigureMailClient.Outlook365.step3.title' => 'Zadejte svou e-mailovou adresu',
    'ConfigureMailClient.Outlook365.step3.description' => 'Potvrďte synchronizaci svého IMAP účtu a počkejte, až se nastavení dokončí.',
    'ConfigureMailClient.Outlook365.step4.title' => 'Jak přidat víc účtů',
    'ConfigureMailClient.Outlook365.step4.description' => 'Pokud chcete do Outlook 365 přidat víc účtů, klikněte na „Přidat účet“.',
    'ConfigureMailClient.Outlook365.step5.title' => 'A je to!',
    'ConfigureMailClient.Outlook365.step5.description' => 'Opakujte výše uvedené kroky pro přidání nového účtu.',

    'ConfigureMailClient.Gmail.title' => 'Nastavení e-mailového účtu',
    'ConfigureMailClient.Gmail.description' => 'Abyste přidali svůj počtovní účet do aplikace Gmail na mobilním zařízení, postupujte dle těchto pokynů.',
    'ConfigureMailClient.Gmail.step1.title' => 'Přidejte nový účet',
    'ConfigureMailClient.Gmail.step1.description1' => 'Otevřete aplikaci Gmail na telefonu s Androidem. Vpravo nahoře klepněte na svůj profilový obrázek.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Klepněte na „Přidat další účet“.',
    'ConfigureMailClient.Gmail.step1.description3' => 'Klepněte na „Ostatní“.',
    'ConfigureMailClient.Gmail.step2.title' => 'Zadejte svou e-mailovou adresu',
    'ConfigureMailClient.Gmail.step2.description' => 'Zadejte svou e-mailovou adresu a pak klepněte na „Další“.',
    'ConfigureMailClient.Gmail.step3.title' => 'Vyberte typ účtu',
    'ConfigureMailClient.Gmail.step3.description' => 'Abyste zachovali kopie stažených e-mailových zpráv na serveru, klepněte na „Osobní (IMAP)“. Pokud chcete stažené e-mailové zprávy ze serveru smazat, klepněte na „Osobní (POP3)“.',
    'ConfigureMailClient.Gmail.step4.title' => 'Zadejte své heslo',
    'ConfigureMailClient.Gmail.step4.description' => 'Zadejte heslo ke svému poštovnímu účtu a pak klepněte na „Další“.',
    'ConfigureMailClient.Gmail.step5.title' => 'Nastavení odebírání pošty',
    'ConfigureMailClient.Gmail.step5.description' => 'Vyberte, zda odstranění e-mailů v aplikaci provede také odstranění e-mailu ze serveru a pak klepněte na „Další“.',
    'ConfigureMailClient.Gmail.step6.title' => 'Nastavení účtu',
    'ConfigureMailClient.Gmail.step6.description1' => 'Aplikace automaticky načte nastavení serveru odchozí pošty.',
    'ConfigureMailClient.Gmail.step6.description2' => 'Pokud chcete, můžete výchozí nastavení účtu změnit a pak klepnout na „Další“.',
    'ConfigureMailClient.Gmail.step7.title' => 'A je to!',
    'ConfigureMailClient.Gmail.step7.description1' => '(Volitelné) Zadejte své jméno tak, jak chcete, aby se zobrazovalo ve vámi odeslaných zprávách.',
    'ConfigureMailClient.Gmail.step7.description2' => 'Nastavení svého účtu dokončíte kliknutím na „Další“.',

    'ConfigureMailClient.Ios.title' => 'Nastavení e-mailového účtu',
    'ConfigureMailClient.Ios.description' => 'Na svém zařízení s iOS naskenujte QR kód, nebo otevřete níže uvedený odkaz. Tím automaticky přidáte svůj poštovní účet do aplikace iOS Mail.',
    'ConfigureMailClient.Ios.link'  =>  'Přidejte účet do iOS Mail',

    'ConfigureMailClient.Manual.title' => 'Ruční nastavení poštovního účtu',
    'ConfigureMailClient.Manual.description' => 'Při přidávání e-mailu %%email%% do poštovního klienta použijte tyto hodnoty.',
    'ConfigureMailClient.Manual.username' => 'Uživatelské jméno poštovního serveru:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Server odchozí pošty (vyžaduje ověření):',
    'ConfigureMailClient.Manual.incomingServer' => 'Server příchozí pošty:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Podporované protokoly příchozí pošty:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Podporované protokoly odchozí pošty:',


    'Databases.Page.title' => 'Databáze pro %%database%%',
    'Databases.Page.databaseTab' => 'Databáze',
    'Databases.Page.userTab' => 'Správa uživatelů',
    'Databases.Page.serversLink' => 'Databázové servery',
    'Databases.Page.backupLink' => 'Správa zálohování',

    'Databases.List.add' => 'Přidat databázi',
    'Databases.List.find' => 'Najít databázi...',
    'Databases.List.databaseColumn' => 'Databáze',
    'Databases.List.relatedToColumn' => 'Souvisí s',
    'Databases.List.relatedToDomains' => 'Související s %%domains%%',
    'Databases.List.noRelatedDomains' => 'Přiřadit tuto databázi k webu',
    'Databases.List.noDomainRelations' => 'Žádné související weby',
    'Databases.List.openWebAdmin' => 'phpMyAdmin',
    'Databases.List.changeRelatedDomain' => 'Změnit',
    'Databases.List.connectionInfo' => 'Informace o připojení',
    'Databases.List.downloadDump' => 'Exportovat výpis',
    'Databases.List.uploadDump' => 'Importovat výpis',
    'Databases.List.copy' => 'Kopírovat databázi',
    'Databases.List.checkDatabase' => 'Zkontrolovat a opravit',
    'Databases.List.assignToSubscription' => 'Přejít na předplatné',
    'Databases.List.assignToSubscription_powerUser' => 'Přesunout na webový prostor',
    'Databases.List.remove' => 'Odebrat',
    'Databases.List.removeConfirmation' => 'Chcete odebrat databázi %%name%%?',
    'Databases.List.removeButtonDisabledHint' => 'Databázi nelze odebrat, protože ji používá nainstalovaná webová aplikace.',
    'Databases.List.databaseRemoved' => 'Databáze byla odebrána.',
    'Databases.List.downloadMsSqlClient' => 'Stáhnout místního klienta SQL',
    'Databases.List.downloadMsSqlClientHint' => 'Stáhnout místního klienta SQL',
    'Databases.List.webadmin' => 'Správce webu',
    'Databases.List.webadminHint' => 'Přistupte k tomuto serveru prostřednictvím správce webu databáze.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => 'Nelze %%action%% výpis: předplatné je pozastavené.',
    'Databases.List.dumpExport' => 'exportovat',
    'Databases.List.dumpImport' => 'importovat',
    'Databases.List.copyDatabaseName' => 'Zkopírovat název databáze',
    'Databases.List.copySuccess' => 'Databáze %%name%% byla zkopírována do schránky',

    'Databases.DatabaseSummary.host' => 'Hostitel',
    'Databases.DatabaseSummary.serverUnavailable' => 'Server není k dispozici.',
    'Databases.DatabaseSummary.user' => 'Uživatel',
    'Databases.DatabaseSummary.users' => 'Uživatelé',
    'Databases.DatabaseSummary.noUser' => 'Žádní uživatelé databáze',
    'Databases.DatabaseSummary.seeAll' => 'zobrazit vše',
    'Databases.DatabaseSummary.createUser' => 'Vytvořit uživatele',
    'Databases.DatabaseSummary.calculatingSize' => 'Probíhá výpočet velikosti...',
    'Databases.DatabaseSummary.tablesCount' => 'Tabulky',
    'Databases.DatabaseSummary.size' => 'Velikost',

    'Databases.InPlaceSelect.editButtonHint' => 'Upravit',
    'Databases.InPlaceSelect.saveButtonHint' => 'Uložit',
    'Databases.InPlaceSelect.closeButtonHint' => 'Zrušit',
    'Databases.InPlaceSelect.selectWebsiteAriaLabel' => 'vybrat web',

    'Databases.ConnectionInfo.title' => 'Údaje o připojení',
    'Databases.ConnectionInfo.description' => 'pro databázi %%database%%',
    'Databases.ConnectionInfo.hint' => 'Tyto podrobnosti o připojení databáze můžete použít například při instalaci webové aplikace.',
    'Databases.ConnectionInfo.host' => 'Hostitel',
    'Databases.ConnectionInfo.copyHost' => 'Zkopírovat hosta do schránky',
    'Databases.ConnectionInfo.databaseName' => 'Název databáze',
    'Databases.ConnectionInfo.copyDatabaseName' => 'Zkopírovat název databáze do schránky',
    'Databases.ConnectionInfo.user' => 'Uživatelské jméno',
    'Databases.ConnectionInfo.copyUser' => 'Zkopírovat jméno uživatele do schránky',
    'Databases.ConnectionInfo.password' => 'Heslo',
    'Databases.ConnectionInfo.noDefaultUser' => 'Žádný výchozí uživatel',

    'Databases.Add.title' => 'Přidat databázi',
    'Databases.Add.name' => 'Název databáze',
    'Databases.Add.server' => 'Databázový server',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => 'Související web',
    'Databases.Add.noDomainRelations' => 'Žádné související weby',
    'Databases.Add.userSection' => 'Uživatelé',
    'Databases.Add.userSectionDescription' => 'Vytvořit výchozího uživatele databáze. Plesk má přístup do databáze jménem tohoto uživatele. Pokud nejsou k databázi přiřazeni žádní uživatelé, databáze není přístupná.',
    'Databases.Add.createUser' => 'Vytvořit uživatele databáze',
    'Databases.Add.username' => 'Jméno uživatele databáze',
    'Databases.Add.password' => 'Heslo',
    'Databases.Add.passwordConfirmation' => 'Potvrdit heslo',
    'Databases.Add.allDbAccess' => 'Uživatel má přístup do všech databází v rámci vybraného předplatného',
    'Databases.Add.aclRadio' => 'Řízení přístupu',
    'Databases.Add.aclLocalhost' => 'Povolit pouze místní připojení',
    'Databases.Add.aclAny' => 'Povolit vzdálené připojení z libovolného hostitele',
    'Databases.Add.aclCustom' => 'Povolit vzdálené připojení od',
    'Databases.Add.aclExample' => "thomas.loc.gov %.loc.gov x.y.% 144.155.166.177 144.155.166.% 144.155.166.0/255.255.255.0 Zadané hostitelé mají povolen přístup do databáze jménem tohoto uživatele.",
    'Databases.Add.aclHostsLabel' => 'Zadejte názvy hostitelů nebo IP adresy vzdálených hostitelů, kteří sem mají povolený přístup',
    'Databases.Add.remoteAccess' => 'Vzdálený přístup',
    'Databases.Add.remoteAccessDenied' => 'Použít pravidla brány firewall v systému',
    'Databases.Add.remoteAccessAllowed' => 'Povolit vzdálené připojení od',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nUvedené IP adresy mají povolený přístup do serveru databáze prostřednictvím pravidla ve firewallu. Změny, které v tomto seznamu provedete, budou předmoderovány vaším poskytovatelem hostingu.",
    'Databases.Add.remoteAccessHint' => 'Obraťte se na svého poskytovatele hostingu a ujistěte se, že možnost, kterou jste zadali, bude splňovat aktuální pravidla brány firewall pro příchozí přístup k MariaDB/MySQL.',
    'Databases.Add.example' => "Například: %%example%%",
    'Databases.Add.denied' => 'Použít pravidla brány firewall v systému',
    'Databases.Add.allowed' => 'Povolit vzdálené připojení od',
    'Databases.Add.databaseCreated' => 'Databáze %%name%% byla vytvořena.',
    'Databases.Add.create' => 'Vytvořit databázi',

    'Databases.Clone.title' => 'Kopírování databáze',
    'Databases.Clone.clone' => 'OK',
    'Databases.Clone.warning' => 'Varování: pokud se názvy tabulek shodují, tabulka ze zdroje nahradí tabulku v cíli.',
    'Databases.Clone.formDescription' => 'Zkopírujte obsah databáze do nové nebo existující databáze. Při kopírování do existující databáze se tabulky ze zdrojové databáze přidají do seznamu tabulek v cílové databázi.',
    'Databases.Clone.copyData' => 'Vytvořit úplnou kopii',
    'Databases.Clone.copyDataHint' => 'V případě výběru bude zkopírována celá databáze (včetně struktury a data). V případě vymazání bude zkopírována pouze struktura tabulek.',
    'Databases.Clone.copyHint' => 'Chystáte se zkopírovat databázi %%databaseName%%',
    'Databases.Clone.server' => 'Server cílové databáze',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => 'Jiný…',
    'Databases.Clone.database' => 'Cílová databáze',
    'Databases.Clone.newDatabase' => 'Vytvořit databázi s názvem',
    'Databases.Clone.newDatabaseName' => 'Název nové databáze',
    'Databases.Clone.existingDatabaseName' => 'Název existující databáze',
    'Databases.Clone.existingDatabase' => 'Kopírovat do existující databáze',
    'Databases.Clone.externalDbHost' => 'Název hostitele nebo IP adresa',
    'Databases.Clone.externalDbLogin' => 'Uživatelské jméno',
    'Databases.Clone.externalDbPassword' => 'Heslo',
    'Databases.Clone.subscription' => 'Cílová předplacená služba',
    'Databases.Clone.subscription_powerUser' => 'Cílový webový prostor',
    'Databases.Clone.cloneInProgress' => 'Klonování databáze %%source%% na databázi %%destination%%. O průběhu budete informování e-mailem (%%email%%).',
    'Databases.Clone.unableToClone' => 'Nelze zkopírovat databázi: „%%source%%“.',
    'Databases.Clone.unableToCreateExternalDatabase' => 'Na zadaném serveru nelze vytvořit databázi „%%destination%%“.',
    'Databases.Clone.databaseCloned' => 'Databáze „%%source%%“ byla zkopírována.',
    'Databases.Clone.emailSubjSuccess' => 'Databáze „%%sourceDatabase%%“ byla zkopírována.',
    'Databases.Clone.emailSubjFailure' => 'Nepodařilo se zkopírovat databázi: „%%sourceDatabase%%“.',
    'Databases.Clone.emailBodySuccess' => 'Databáze „%%sourceDatabase%%“ (%%sourceHost%%) byla zkopírována do databáze „%%destDatabase%%“ (%%destHost%%).',
    'Databases.Clone.emailBodyFailure' => 'Nelze zkopírovat databázi „%%sourceDatabase%%“ (%%sourceHost%%) do databáze „%%destDatabase%%“ (%%destHost%%). Kopírování selhalo.',
    'Databases.Clone.localServer' => 'místní server',

    "Databases.Import.confirm" => 'Importovat výpis',
    'Databases.Import.recreateDatabase' => 'Obnovit databázi',
    'Databases.Import.rootDirectory' => 'Kořenový adresář',
    'Databases.Import.uploadFromFile' => 'Nahrát výpis z lokálního počítače',
    'Databases.Import.uploadFromWebspace' => 'Improtovat výpis z hostingového serveru',
    'Databases.Import.uploadHint' => 'Chystáte se importovat výpis do %%databaseName%%',
    'Databases.Import.uploadPopupTitle' => 'Importovat výpis databáze',
    'Databases.Import.uploading' => 'Importuji...',
    'Databases.Import.waitMessage' => 'Počkejte prosím…',

    "Databases.Export.confirm" => 'Export Dump (Export výpisu)',
    'Databases.Export.downloadDumpAutomatically' => 'Automaticky stáhnout výpis po vytvoření',
    'Databases.Export.downloadDumpName' => 'Název souboru výpisu',
    'Databases.Export.downloadHint' => 'Chystáte se vytvořit výpis %%database%% a stáhnout ho',
    'Databases.Export.downloadPopupTitle' => 'Export Dump (Export výpisu)',
    'Databases.Export.downloadRelativePath' => 'Uložit výpis do následujícího adresáře',
    'Databases.Export.rootDirectory' => 'Kořenový adresář',
    'Databases.Export.waitMessage' => 'Počkejte prosím…',

    'MoveDatabasePage.title' => 'Přesunout databáze na jiné předplatné',
    'MoveDatabasePage.title_powerUser' => 'Přesunout databáze na jiný webový prostor',
    'MoveDatabasePage.description' => 'Chystáte se přesunout databázi %%name%%',
    'MoveDatabasePage.hint' => 'Vybrané databáze budou přesunuty do vybraného předplatného. Uživatelé databáze budou přesunuti taky, pokud nemají přístup k dalším databázím. Poznámka: uživatelé, kteří měli k databázi před jejím přesunem přístup, už do ní nebudou mít přístup přes odkaz v Plesku.',
    'MoveDatabasePage.subscriptionName' => 'Přejít na předplatné',
    'MoveDatabasePage.subscriptionName_powerUser' => 'Přesunout na webový prostor',
    'MoveDatabasePage.save' => 'Přesunout',

    'WebProsAccountPage.descriptionHead' => 'Přistup ke všem službám WebPros a serveru Plesk pomocí jednoho zabezpečeného loginu.',
    'WebProsAccountPage.descriptionBody' => 'Přes svůj WebPros účet máte přístup k řídícimu panelu, podpoře a službám Monitoring, Plesk University a KA Partner Central, takže můžete celý ekosystém WebPros snadno ovládat a spravovat.',
    'WebProsAccountPage.buttonLogin' => 'Přihlásit se účtem WebPros',
    'WebProsAccountPage.buttonSkip' => 'Přeskočit do příštího přihlášení',
];