<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'configuration.title' => 'Mail Client Setup',
    'configuration.copyConfiguratorLink' => 'Copy the setup wizard link',
    'configuration.hint' => 'Select the platform to set up the email client:',
    'configuration.autoTitle' => 'Microsoft Outlook, Gmail, or Thunderbird',

    'configuration.addAccount' => '"Add Mail Account"',
    'configuration.addAnotherAccount' => '"Add another account"',
    'configuration.accountSettings' => '"Account settings"',
    'configuration.changeAccountSettings' => '"Change account settings"',
    'configuration.continue' => '"Continue"',
    'configuration.finish' => '"Finish"',
    'configuration.next' => '"Next"',
    'configuration.other' => '"Other"',
    'configuration.domainMailSettings' => 'Mail Settings',
    'configuration.issueCertificate' => 'Issue a new SSL certificate',

    'configuration.unavailableGlobally' => 'Automatic configuration is not available on this server.',
    'configuration.unavailableInServicePlan' => 'Automatic configuration is not available in the domain\'s service plan.',
    'configuration.unavailableNoHosting' => 'Automatic configuration is not available for domains without hosting.',

    'configuration.supportedClients' => 'The following mail clients can be configured automatically:',

    'configuration.supportedClientThunderbird' => 'Mozilla Thunderbird',
    'configuration.supportedClientGmail' => 'Gmail on Android',
    'configuration.supportedClientIos' => 'iOS Mail',
    'configuration.supportedClientOutlook' => 'Outlook (only Outlook 2016 and earlier versions are supported)',

    'configuration.enableAutodiscoveryHeader' => 'How to set up automatic mail client configuration:',

    'configuration.enableAutodiscoveryStep1' => 'Enable mail autodiscover.',
    'configuration.enableAutodiscoveryStep2' => '%%variant1%% or %%variant2%%.',
    'configuration.enableAutodiscoveryStep2.2' => 'assign a valid SSL certificate in %%domainSettings%%',
    'configuration.enableAutodiscoveryStep2.1' => '%%issueCertificate%% using the SSL It! extension (with the "Assign the certificate to mail domain" option enabled)',
    'configuration.enableAutodiscoveryStep3' => 'If you do not manage DNS records in Plesk, manually create the following SRV records at your DNS provider:',

    'configuration.enableAutodiscoveryTableRecordType' => 'Record type',
    'configuration.enableAutodiscoveryTableService' => 'Service',
    'configuration.enableAutodiscoveryTableProtocol' => 'Protocol',
    'configuration.enableAutodiscoveryTablePort' => 'Port',

    'configuration.thunderbirdStep1' => 'Open Mozilla Thunderbird.',
    'configuration.thunderbirdStep2' => 'Click %%add%% in the %%settings%% menu.',
    'configuration.thunderbirdStep3' => 'Specify the following:',
    'configuration.thunderbirdStep3.1' => 'Your name, as you want it to appear in any messages you send.',
    'configuration.thunderbirdStep3.2' => 'Your email address and password.',
    'configuration.thunderbirdStep4' => 'Click %%continue%%.',
    'configuration.thunderbirdStep5' => 'Thunderbird will automatically set up the settings.',

    'configuration.gmailStep1' => 'Open Gmail on Android.',
    'configuration.gmailStep2' => 'In the top right corner, tap your profile picture, tap %%add%%, and then choose %%other%%.',
    'configuration.gmailStep3' => 'Enter your email address, and then tap %%next%%.',
    'configuration.gmailStep4' => 'Select the account type, and then tap %%next%%. To keep copies of email messages on the server, select the IMAP option. Otherwise, select POP3.',
    'configuration.gmailStep5' => 'Enter your email account password, and then tap %%next%%.',
    'configuration.gmailStep6' => 'The application will automatically fetch the incoming server settings. Select whether deleting emails from your inbox will also delete them from your Plesk server, and then tap %%next%%.',
    'configuration.gmailStep7' => 'The application will automatically fetch the outgoing server settings. Tap %%next%%.',
    'configuration.gmailStep8' => 'Keep the default Gmail sync settings or change them, and then tap %%next%%.',
    'configuration.gmailStep9' => '(Optional) Change the account name and/or specify the name that will be displayed on sent messages. Tap %%next%% to exit the setup.',

    'configuration.outlookWarning' => 'Autodiscover is not compatible with Outlook versions later than Outlook 2016. These mail clients use Microsoft proxy servers for autodiscover requests, which are not supported in Plesk or the Plesk Premium Email extension.',
    'configuration.outlookStep1' => 'Open Microsoft Office Outlook 2016.',
    'configuration.outlookStep2' => 'Go to File > Add Account.',
    'configuration.outlookStep3' => 'Enter your name, email address, and password in the corresponding fields, and then click %%next%%.',
    'configuration.outlookStep4' => 'Wait until Microsoft Office Outlook completes the setup.',
    'configuration.outlookStep5' => 'The setup is finished:',
    'configuration.outlookStep5.1' => 'To exit the setup, click %%finish%%.',
    'configuration.outlookStep5.2' => 'To view the configured settings, select the %%checkbox%% checkbox, and then click %%finish%%.',

    'configuration.thunderbirdTab' => 'Thunderbird',
    'configuration.gmailTab' => 'Gmail',
    'configuration.iosTab' => 'iOS Mail',
    'configuration.outlookTab' => 'Outlook',
    'configuration.manualTab' => 'Manual setup',
    'configuration.manualTitle' => 'Manual setup',
    'configuration.automaticTab' => 'Autodiscover setup',
    'configuration.iosTitle' => 'iOS Mail',
    'configuration.autoInstructions' => 'Open your email client and enter the mailbox name. The email client will be configured automatically.',
    'configuration.iosInstructions' => 'To automatically configure your email client, scan the following QR code with your phone\'s camera:',
    'configuration.iosLink' => 'Or open the following link on the device on which you want to configure the email client:',
    'configuration.iosLinkNoQrCode' => 'Open the following link on the device on which you want to configure the email client:',
    'configuration.smtpAuth' => '(requires authentication)',
    'configuration.fieldUsername' => 'Mail server username',
    'configuration.fieldIncomingServer' => 'Incoming mail server',
    'configuration.fieldOutgoingServer' => 'Outgoing mail server',
    'configuration.fieldIncomingProtocols' => 'Supported incoming mail protocols',
    'configuration.fieldOutgoingProtocols' => 'Supported outgoing mail protocols',

    'configuration.documentationButton' => 'See full documentation with screenshots',
    'configuration.manualConfigurationButton' => 'Auto-configuration failed? Try manual setup',

    'configuration.unsecureSslNote' => 'Note: You may see the "Untrusted certificate" error when you access your mailbox. It happens if the SSL/TLS certificate of the mail server or domain is self-signed or assigned to another domain. If so, make sure that the domain name of the mail server is valid.',
    'configuration.copied' => 'Copied',

    'create.title' => 'Create Email Address',

    'delete.infoEmailsDeleted' => 'Selected email addresses were deleted.',
    'delete.infoEmailsNotDeleted' => 'Unable to delete some of the selected email addresses.',

    'clear.infoEmailsCleared' => 'The selected mailboxes were emptied.',
    'clear.infoEmailsNotCleared' => 'Unable to empty some of the selected mailboxes.',

    'edit.unknownEmail' => 'The email address was not found. This can happen if email address was removed by someone else while you tried to access it.',

    'index.title' => 'Mail',
    'index.tabTitle' => 'Email Address',
    'index.buttonsAreaDescription' => 'Configure your mail account, improve accuracy of spam detection, and work with your mail using webmail.',
    'index.buttonWebmail' => 'Open Webmail',
    'index.hintWebmail' => 'Work with your mail using a web browser.',
    'index.buttonEmailAddressSettings' => 'Change Mail Account Settings',
    'index.hintEmailAddressSettings' => 'Configure settings and services available for your mail account: set the mailbox size, switch mailbox on or off, set up mail forwarding, email aliases, and automatic responses to incoming email messages.',
    'index.buttonConfigureMailApplication' => 'Learn How to Configure Email Client',
    'index.hintConfigureMailApplication' => 'Learn how to configure your email client program for working with your mailbox.',

    'list.title' => 'Mail',
    'list.titleForDomain' => 'Mail of %%name%%',
    'list.tabTitle' => 'Email Addresses',
    'list.hint' => 'Create and manage email accounts associated with your domains. For each email account, you can set up a mailbox, a number of additional email addresses that will point to the same mailbox (email aliases), an auto-reply, and mail forwarding to one or several email addresses. You can also set up protection from spam and viruses, if these services are available for your account.',
    'list.sectionTools' => 'Tools',
    'list.infoNewEmailCreated' => 'Email address %%name%% was created.',
    'list.infoEmailUpdated' => 'The settings of email address %%name%% were saved.',
    'list.attachmentError' => 'The changes to attachment files were not saved. %%message%%',
    'list.usageTitle' => '%%created%% email addresses were created out of %%allowed%% allowed.',
    'list.usageLink' => 'Buy additional User Pack',
    'list.contactToProvider' => 'To obtain an additional User Pack, contact your service provider.',

    'recalculate-usage.usageCalculated' => 'Information about the disk space usage was updated.',

    'update-outgoing-messages.stateChanged' => 'The limit on the number of outgoing messages was changed for the selected domains.',
    'update-outgoing-messages.outgoingMessagesLimitValueInvalid' => 'The value must be in the range %%min%%..%%max%% for email address %%mailname%%. Only the Plesk administrator can adjust this setting.',
    'update-outgoing-messages.mailnameOutgoingMessagesLimitIsNotSupported' => 'Limiting the number of outgoing messages is not supported for the email address %%mailname%%.',
    'update-outgoing-messages.mailManagementIsNotAllowed' => 'Mail settings management is not allowed for the mailname %%mailname%%.',

    'error.mailServiceUnavailable' => 'Mail service unavailable on this domain',
    'error.mailServiceUnavailableAllDomains' => 'Mail service unavailable on all domains',
    'error.mailServiceDisabled' => 'Mail service is disabled on this domain',
];
