<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => '子網或 IP 地址',
    'access-network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => '時事通訊',
    'admin.announcement-settings.getConsentLoading' => '正在檢索有關時事通訊的資訊...',
    'admin.announcement-settings.getConsentWarning' => '無法檢索您的訂閱狀態。',
    'admin.announcement-settings.sendAnnounceConsent' => '我想要接收來自 WebPros 的時事通訊。這些訊息可能包括安全相關的、技術和常規產品方面的資訊。我同意並授權 WebPros 根據現行適用的資料保護法收集、處理和使用我的個人資料（郵箱），包括跨境處理，直接或通過協力廠商服務給我發送時事通訊。取消勾選該核取方塊則表示撤銷同意並令 WebPros 停止向我發送郵件以及從其系統中永久移除我的個人資料。',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => '此處列出的 WebPros 公司可以使用我的姓名和電子郵件地址（%%adminEmail%%），以便向我提供個人化行銷內容，例如時事通訊以及有關 WebPros 產品的個別優惠。徵詢同意的公司包括：WebPros International LLC 和 WebPros International GmbH。在我撤銷同意之前，資訊將根據 %%privacyPolicy%% 的規定使用，並可能在內部與 WebPros 集團的其他實體共用。我可以隨時修改或撤銷同意，只要清除核取方塊、點選收到的任何通訊內容中的連結或向 privacy@plesk.com 發送電子郵件即可。',
    'admin.announcement-settings.privacyPolicy' => 'WebPros 隱私權原則',
    'admin.announcement-settings.noConsent' => '取消訂閱 WebPros 通訊。',
    'admin.announcement-settings.reportConsentError' => '無法保存您從 Plesk 接收資訊的設定：%%error%%。',
    'admin.announcement-settings.profileUpdateError' => '很抱歉，我們目前無法更新您的個人資料。請稍後再試。',
    'admin.announcement-settings.invalidConsentType' => "未知同意類型：'%%type%%'",
    'admin.announcement-settings.retry' => '重新嘗試',
    'admin.announcement-settings.consentGivenInfo' => '我們希望您一直喜歡我們的 WebPros 通用通訊。我們現在可以為您提供更為完善的方案，能夠根據您的需要來提供有用資訊和幫助提示，更具個性化。欲接收個性化的 WebPros 通訊，請選擇下面的第一條聲明，然後點按“確定”。',

    'admin.personal-info.title' => '編輯管理員資訊',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 設定',
    'admin.personal-info.settingsSectionLegend' => '設定',

    'admin-alias.login' => '用戶名',
    'admin-alias.password' => '密碼',
    'admin-alias.passwordConfirmation' => '確認密碼',
    'admin-alias.email' => '電郵地址',
    'admin-alias.contact' => '聯繫名稱',
    'admin-alias.comments' => '備註',
    'admin-alias.emptyLogin' => '請提供一個用戶名。',
    'admin-alias.loginTooLong' => '該用戶名的長度超過了 20 個字元。',
    'admin-alias.emptyEmail' => '請提供一個電郵地址。',
    'admin-alias.emptyContactName' => '請提供一個聯繫名稱。',
    'admin-alias.contactNameTooLong' => '此聯繫名稱的長度超過了 255 個字元。',
    'admin-alias.emptyPassword' => '請提供一個密碼。',
    'admin-alias.commentsTooLong' => '該備註的長度超過了 255 個字元。',
    'admin-alias.emailActivation' => '通過電子郵件啟動帳戶',
    'admin-alias.simplePanel' => '啟用限制模式',
    'admin-alias.simplePanelHint' => '選擇此選項來限制其它管理員可以在Plesk中採取操作的次數。若要更改可用的操作，請點按%%link%%。',
    'admin-alias.simplePanelLink' => '工具 & 設定> 限制模式設定',
    'admin-alias.lockPowerUser' => '為其他管理員提供高級用戶試圖',
    'admin-alias.lockPowerUserHint' => '限制查看其它Plesk管理員的能力（無法連接客戶、經銷商和服務計畫）。',

    'admin-info.plesk-settings.multiplyLogin' => '允許在該帳戶下進行多個會話',
    'admin-info.plesk-settings.adminLanguage' => '管理員的介面語言',
    'admin-info.plesk-settings.password' => '密碼',
    'admin-info.plesk-settings.passwordConfirmation' => '確認密碼',
    'admin-info.plesk-settings.oldPassword' => '舊密碼',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => '舊密碼不正確。請重試。',

    'admin-panel.form.contact-info.login' => '登入名',
    'admin-panel.form.contact-info.contactName' => '連絡人姓名',
    'admin-panel.form.contact-info.emptyLogin' => '請提供登入資訊。',
    'admin-panel.form.contact-info.emptyContactName' => '請提供連絡人姓名。',
    'admin-panel.form.contact-info.loginTooLong' => '登入資訊太長 (最大允許%max%)。',
    'admin-panel.form.contact-info.contactNameTooLong' => '連絡人姓名太長 (最大允許%max%)。',
    'admin-panel.form.contact-info.email' => '電郵地址',
    'admin-panel.form.contact-info.emptyEmail' => '請提供電郵地址。',
    'admin-panel.form.contact-info.companyName' => '公司名稱',
    'admin-panel.form.contact-info.longCompanyName' => '公司名太長(最長%max%)。',
    'admin-panel.form.contact-info.phone' => '電話號碼',
    'admin-panel.form.contact-info.longPhone' => '電話號碼太長(最長%max%)。',
    'admin-panel.form.contact-info.fax' => '傳真號碼',
    'admin-panel.form.contact-info.imNumber' => '即時通訊',
    'admin-panel.form.contact-info.longFax' => '傳真號太長(最長%max%)',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '指定的電話號碼無效。',
    'admin-panel.form.contact-info.faxRegexNotMatch' => '該傳真號不正確。',
    'admin-panel.form.contact-info.address' => '地址',
    'admin-panel.form.contact-info.longAddress' => '地址太長(最長%max%)。',
    'admin-panel.form.contact-info.city' => '城市',
    'admin-panel.form.contact-info.longCity' => '城市名太長。',
    'admin-panel.form.contact-info.shortCity' => '此城市名稱太短。',
    'admin-panel.form.contact-info.state' => '省/市/自治區',
    'admin-panel.form.contact-info.postalCode' => '郵遞區號',
    'admin-panel.form.contact-info.country' => '國家/地區',
    'admin-panel.form.contact-info.additionalInfo' => '其他資訊',
    'admin-panel.form.contact-info.additionalInfoHint' => '僅純文字：將忽略所有 HTML 標記。',
    'admin-panel.form.contact-info.duplicateEmail' => '系統中已存在帶有相同電郵地址的用戶。',

    'admin-panel.form.domain-info-section.domainInfoSection' => '訂閱',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '網站屬性',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '網站屬性',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '網站屬性',
    'admin-panel.form.domain-info-section.createSubscription' => '為客戶創建訂閱',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '如果您此刻不想為客戶創建主機服務訂閱或設定網站請清空該核取方塊。沒有訂閱，客戶將無法登入到客戶面板。',
    'admin-panel.form.domain-info-section.domainName' => '域名',
    'admin-panel.form.domain-info-section.emptyDomainName' => '您必須提供一個域名。',
    'admin-panel.form.domain-info-section.shared' => '共用',
    'admin-panel.form.domain-info-section.exclusive' => '獨立',
    'admin-panel.form.domain-info-section.userName' => '用戶名',
    'admin-panel.form.domain-info-section.userNameHint' => '用於管理在訂閱內創建的網站檔和資料夾的系統使用者帳戶。',
    'admin-panel.form.domain-info-section.emptyLogin' => '您必須提供一個用戶名。',
    'admin-panel.form.domain-info-section.password' => '密碼',
    'admin-panel.form.domain-info-section.emptyPassword' => '您必須提供一個密碼。',
    'admin-panel.form.domain-info-section.passwordConfirmation' => '確認密碼',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "託管網站的 IP 位址是網站的虛擬主機的網路位址。",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 地址',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "託管網站的 IP 位址是網站的虛擬主機的網路位址。",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 地址',
    'admin-panel.form.domain-info-section.noIpAddressHint' => '無',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '其它的訂閱設定',
    'admin-panel.form.domain-info-section.credentials' => '系統使用者驗證憑據',
    'admin-panel.form.domain-info-section.credentialsHint' => '通過 FTP 和 SSH 存取託管的檔',
    'admin-panel.form.domain-info-section.credentialsHintWin' => '以通過 FTP 和 RDP 存取託管的檔',

    'admin-panel.form.login-info.userName' => '用戶名',
    'admin-panel.form.login-info.emptyUserName' => '請提供用戶名。',
    'admin-panel.form.login-info.password' => '密碼',
    'admin-panel.form.login-info.emptyPassword' => '請提供密碼。',
    'admin-panel.form.login-info.passwordConfirmation' => '重複密碼',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => '更改密碼也將更改內部電子郵寄地址密碼',
    'admin-panel.form.login-info.emailActivation' => '通過電子郵件啟動帳戶',
    'admin-panel.form.login-info.emailActivationHint' => '除非使用者通過電子郵件中所發送的連結啟動帳戶，或管理員手動啟動該帳戶，創建的帳號便會處於非活動狀態。',

    'admin-panel.form.subscription-info-section.subscription' => '訂閱',
    'admin-panel.form.subscription-info-section.servicePlan' => '服務方案',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '當前服務方案',
    'admin-panel.form.subscription-info-section.newServicePlan' => '新服務方案',
    'admin-panel.form.subscription-info-section.adminPlan' => '簡單方案',
    'admin-panel.form.subscription-info-section.none' => '無',
    'admin-panel.form.subscription-info-section.addonPlans' => '附加方案',
    'admin-panel.form.subscription-info-section.customizeSubscription' => '方案關聯性更改後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '創建後繼續自訂訂閱參數。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "創建客戶後繼續自訂訂閱參數。",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '創建後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => '注意執行此操作將鎖定訂閱不能同步。',
    'admin-panel.form.subscription-info-section.buttonOk' => '添加訂閱',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'app.configure.otherSettings' => '其他',
    'app.configure.passwordConfirmation' => '確認密碼',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => '強制更新所有安裝的應用程式',
    'app.update-settings.forceUpdatesHint' => '允許客戶的應用程式在更新發行時自動接收更新。客戶將無法關閉應用程式的自動更新。警告：謹慎使用此選項，因為更新對應用程式功能影響很大。例如，應用程式擴展可能無法用於該應用程式的其它版本。',
    'app.update-settings.suggestUpdates' => '預設打開選項“自動更新該應用程式”',
    'app.update-settings.suggestUpdatesHint' => '對於新安裝的應用程式，將會打開應用程式設定中的“自動更新該應用程式”選項。',

    'backup.server-settings.rotation' => '可以進行存儲的完整備份檔案的最大數量（包括計畫和手動備份）',
    'backup.server-settings.rotationDescription' => '用戶可以在伺服器存儲中存儲這麼多完整的備份。如果存儲中完整備份的數量已超出限制，僅能保存最近的備份。增量備份不會影響。',
    'backup.server-settings.maxProcesses' => '同時運行計畫備份進程的最大數量',
    'backup.server-settings.niceScheduled' => '運行低優先順序的計畫備份進程',
    'backup.server-settings.niceScheduledPriority' => '優先順序',
    'backup.server-settings.niceScheduledPriorityDescription' => '輸入 1 到 19 之間的值，數值越高優先順序越低。',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 優先順序',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '輸入 0 到 7 之間的值，數值越高優先順序越低。',
    'backup.server-settings.niceAlways' => '運行所有低優先順序的備份進程',
    'backup.server-settings.niceAlwaysPriority' => '優先順序',
    'backup.server-settings.niceAlwaysPriorityDescription' => '輸入 1 到 19 之間的值，數值越高優先順序越低。',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 優先順序',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '輸入 0 到 7 之間的值，數值越高優先順序越低。',
    'backup.server-settings.compressionLevel' => '壓縮層級',
    'backup.server-settings.compressionLevelNoCompression' => '無壓縮',
    'backup.server-settings.compressionLevelFastest' => '最快',
    'backup.server-settings.compressionLevelFast' => '快速',
    'backup.server-settings.compressionLevelNormal' => '正常',
    'backup.server-settings.compressionLevelMaximum' => '中等',
    'backup.server-settings.freeSpaceRequired' => '只有您的伺服器有指定容量的可用磁碟空間才開始備份（以 MB 為單位）',
    'backup.server-settings.checkBackupDiskSpace' => '僅在您的伺服器有足夠的可用磁碟空間容量時啟動備份',
    'backup.server-settings.mssqlNativeBackupEnabled' => '請使用本地 MS SQL 備份功能（對於遠端資料庫，請確保您已在 工具與設定> 資料庫伺服器 中配置了遠端 MS SQL 伺服器的備份設定）',
    'backup.server-settings.localFtpRestriction' => '允許在本機伺服器上設定 FTP 備份存儲',
    'backup.server-settings.backupSecuritySettings' => '備份安全設定',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => '如果上傳到遠端存放失敗請把備份保存在伺服器存儲中',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => '將要進行遠端存放的手動和計畫備份如果上傳到遠端存放失敗則將被保存在本機伺服器存儲中。使用者必須有在伺服器存儲中存儲備份的許可權。',
    'backup.server-settings.AllowScheduleHourly' => '允許客戶及代理商設定小時計備份排程',

    'change-current-subscription.hint' => '您可以在此處更改訂閱服務方案的關聯性。注意，選擇"無"作為新服務方案將從服務方案取消綁定訂閱，並設定成"自訂"。',
    'change-current-subscription.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'change-password.oldPassword' => '舊密碼',
    'change-password.password' => '新密碼',
    'change-password.passwordConfirmation' => '確認密碼',
    'change-password.oldPasswordIsIncorrect' => '舊密碼不正確。請重試。',
    'change-password.unableToFindAdditionalAdminAccount' => '無法找到其它管理員帳戶。',
    'change-password.warningAboutAdminPasswordSyntax' => "該密碼應介於 %%min%% - %%max%% 之間且不得包含用戶名。密碼中不得使用引號、空格以及國家字母字元。",
    'change-password.warningAboutWinAdminPasswordSyntax' => "密碼中不得使用引號、空格、分號以及國家字母字元。該密碼應介於 %%min%% 和 %%max%% 之間且不得包含用戶名。",

    'change-reseller-oversell-policy.oversellPolicy' => '超額銷售策略',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '允許超額銷售',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '超額銷售允許代理商超額出售通過方案分配給他們的資源。若允許超額銷售，代理商則可支配實際使用的資源而不是初始分配的資源。',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '不允許超額銷售',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '若不允許超額銷售，不管實際使用的資源是多少，代理商都只能出售通過方案初始分配給他們的資源。',

    'change-reseller-subscription.hint' => '您可以在此處更改與代理商訂閱關聯的服務方案。注意，選擇"無"作為新服務方案會將訂閱從服務方案取消綁定，並設定為"自訂"。',
    'change-reseller-subscription.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',
    'change-reseller-subscription.servicePlan' => '新方案',
    'change-reseller-subscription.oldSubscription' => '當前方案',
    'change-reseller-subscription.none' => '無',
    'change-reseller-subscription.infoSubscriptionChanged' => '訂閱相關服務方案已更新。',
    'change-reseller-subscription.customizeSubscription' => '與服務方案的關聯更新後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',

    'change-subscription.hint' => '您可在此更改所選訂閱與服務方案的相關性。',
    'change-subscription.selectPlanLegend' => '服務方案',
    'change-subscription.selectPlanDescription' => '若要切換到其它服務方案，請從清單中選擇新方案。注意，若選擇\'無\'則取消訂閱和服務方案的綁定，使其成為\'自訂\'訂閱。',
    'change-subscription.servicePlan' => '新服務方案',
    'change-subscription.selectAddonPlansLegend' => '附加方案',
    'change-subscription.selectAddonPlansDescription' => '添加或移除附加方案。',
    'change-subscription.noChange' => '無變更',
    'change-subscription.none' => '無',
    'change-subscription.add' => '添加',
    'change-subscription.del' => '移除',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => '子網或 IP 地址',
    'control-panel-access.network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '使用管理員許可權存取 Plesk',
    'control-panel-access.settings.policyAllow' => '允許，清單中的網路除外。',
    'control-panel-access.settings.policyDeny' => '拒絕不在清單中的網路。',

    'create-subscription.title' => '添加一個訂閱',
    'create-subscription.titleOwn' => '創建自己的訂閱',
    'create-subscription.poolIsEmpty' => '無法創建訂閱因為沒有共用 IP 地址且 Plesk 中沒有可用的獨立 IP 地址。',
    'create-subscription.infoNewSubscriptionCreated' => '已創建訂閱 %%name%%。',
    'create-subscription.createBeforeAppInstall' => '您需要有一個訂閱來安裝應用程式。',

    'customer.hint' => '您可在此新增客戶並為其訂閱主機服務。首先在 Plesk 中創建客戶帳戶然後訂閱主機方案以及附加方案。訂閱也可以不與任何方案綁定，提供自訂的資源和服務 — 具體操作是選擇服務方案旁邊的\'無\'。',
    'customer.contactInfoSection' => '聯繫資訊',
    'customer.additionalInfoSection' => '其它的客戶資訊',
    'customer.accessToPanelSection' => '存取 Plesk',
    'customer.contactInfoSectionHint' => '輸入客戶聯繫資訊。',
    'customer.accessToPanelSectionHint' => '客戶將用於存取其客戶面板的驗證憑據。',
    'customer.unableCreateSubscription' => '無法創建訂閱: %%reason%%',
    'customer.poolIsEmpty' => 'IP池為空',
    'customer.buttonOk' => '添加客戶',

    'database-settings.dbPrefixRadio' => '添加首碼和底線到資料庫名稱的開頭',
    'database-settings.dbPrefixNone' => '無',
    'database-settings.dbPrefixUsername' => '用戶名',
    'database-settings.dbPrefixExternalId' => '訂閱的外部 ID',
    'database-settings.dbPrefixCustom' => '自訂首碼',
    'database-settings.dbUserPrefixRadio' => '添加首碼和底線到資料庫用戶名稱的開頭',
    'database-settings.dbUserPrefixHint' => '資料庫用戶名稱如：<prefix>_<database_user_name>。因資料庫用戶名長度的限制，<prefix> 可能被縮寫。',
    'database-settings.grantAlterDatabase' => '授予所有 Microsoft SQL Server 資料庫使用者修改資料庫的許可權',
    'database-settings.grantAlterDatabaseHint' => '新的和現有的用戶都將被授予該許可權',
    'database-settings.aclRadio' => 'MariaDB/MySQL 資料庫使用者遠端存取許可權的預設設定',
    'database-settings.aclLocalhost' => '僅允許本地連接',
    'database-settings.aclAny' => '允許來自任何主機的遠端連接',
    'database-settings.aclCustom' => '允許遠端連接來自',
    'database-settings.aclDescription' => '此設定僅可修改用戶的許可權。要啟用對本地MariaDB/MySQL伺服器的遠端存取，請在%%serverLink%%中選擇相應的選項',
    'database-settings.aclDescriptionLink' => '本地 MariaDB/MySQL 設定',
    'database-settings.example' => "例如：",
    'database-settings.aclExampleDescription' => "所指定的主機可以代表此使用者存取該資料庫。",
    'database-settings.dbPrefixAlphaNumeric' => '首碼值只能包含字母數位值和底線。',

    'dns.add-acl-record.description' => '添加允許接收 DNS 區域副本的 DNS 伺服器 IP 位址。',
    'dns.add-acl-record.ipAddress' => 'IP 地址',
    'dns.add-acl-record.ipAddressWithMask' => 'IP 地址/遮罩',

    'dns.settings.recursion' => '遞迴DNS查詢',
    'dns.settings.recursionOn' => '允許所有請求',
    'dns.settings.recursionLocal' => '僅允許本地請求',
    'dns.settings.recursionLocalnets' => '僅允許執行來自本地網路的請求',
    'dns.settings.recursionOff' => '拒絕所有請求',
    'dns.settings.customConfiguration' => '其它 DNS 設定',
    'dns.settings.customConfigurationPlaceholder' => '您在此處指定的設定將覆蓋伺服器範圍內的設定。',
    'dns.settings.customConfigurationHint' => '如果無法找到指定的設定，請使用 named.conf 的語法將它們添加到上面的欄位中。',
    'dns.settings.customConfigurationExample' => '例如，要隱藏 DNS 伺服器的主機名稱，請添加以下行： ',
    'dns.settings.restoreDefaultButton' => '使用默認設定',

    'dns.template.synchronize-done' => '已成功應用該 DNS 區域範本。',
    'dns.template.synchronize-error' => '該 DNS 區域範本未應用至一些 DNS 區域。',
    'dns.template.synchronize-progress' => '應用該 DNS 區域範本。',

    'domain-restriction.name' => '域名',
    'domain-restriction.nameDescription' => '您可以使用星號 (*) 指定一個萬用字元模式。例如，*.example.com',
    'domain-restriction.domainAlreadyExists' => '列表中已存在指定的域名。',

    'event-handler.eventLabel' => '事件',
    'event-handler.priorityLabel' => '優先順序',
    'event-handler.userLabel' => '用戶',
    'event-handler.commandLabel' => '命令',
    'event-handler.commandHint' => '為了獲取最佳結果，請在 \'命令\' 欄位中輸入指令檔的完整路徑。不建議輸入系統命令，因為可能無效。例如，帶有輸出重定向操作符 /&gt; or &lt; 的命令可能無效。',
    'event-handler.priorityHighestText' => '低',
    'event-handler.priorityHighText' => '最高',
    'event-handler.priorityNormalText' => '自訂',
    'event-handler.priorityLowText' => '低',
    'event-handler.priorityLowestText' => '正常',
    'event-handler.priorityCustomText' => '自訂',
    'event-handler.priorityHighestOption' => '最高 (%%value%%)',
    'event-handler.priorityHighOption' => '高 (%%value%%)',
    'event-handler.priorityNormalOption' => '正常 (%%value%%)',
    'event-handler.priorityLowOption' => '低 (%%value%%)',
    'event-handler.priorityLowestOption' => '最低 (%%value%%)',

    'extension.upload.fileUpload' => '進入擴展套裝程式檔的路徑',

    'external-webmail.hint' => '您在 Plesk 中註冊了其它的 web 郵箱後，該 web 郵箱即會以一個選項的形式在主機方案和訂閱的 \'郵件\' 屬性中出現，從而供客戶使用。該 web 郵箱名稱將會在 web 郵箱選項清單中顯示，點按 客戶面板 中郵箱旁邊的 web 郵箱圖示即會打開其 URL。',
    'external-webmail.name' => 'web 郵箱服務名稱',
    'external-webmail.url' => 'web 郵箱服務URL',
    'external-webmail.enabled' => '可用',

    'ftp-settings.generalSection' => '常規',
    'ftp-settings.portRange' => '適用於被動FTP模式連接的埠或埠範圍',
    'ftp-settings.hintPortRange' => '（預設值：%%defaultPortRange%%）',

    'health.upload.hint' => '上傳健康伺服器監控配置。上傳後，即會應用配置。',
    'health.upload.selectFile' => '設定檔',

    'install-local-package.selectUploadType' => '選擇下面的一項：',
    'install-local-package.uploadAsFile' => '上傳一個 APS 包',
    'install-local-package.downloadFromCatalog' => '從應用程式目錄選擇應用程式',
    'install-local-package.formInfo' => "通過上傳新的應用程式或從應用程式目錄添加應用程式以擴展可用應用程式清單。",
    'install-local-package.invalidFileExtension' => '上傳的應用程式必須是 ZIP 壓縮檔，副檔名為.zip。',
    'install-local-package.packagesNotSelected' => '未選定套裝軟體。',
    'install-local-package.fileNotUploaded' => '無法上傳檔案。',
    'install-local-package.visible' => '設定客戶可用',
    'install-local-package.isCommercial' => '該應用程式為商業應用程式需要購買許可證金鑰。',
    'install-local-package.visibleDescription' => '設定客戶可安裝此應用程式。',

    'ip-address.addTitle' => '添加 IP 地址',
    'ip-address.editTitle' => '介面%%interface%%上的 IP 地址 %%address%%',
    'ip-address.generalSection' => '通用',
    'ip-address.interface' => '介面',
    'ip-address.addressAndSubnetPrefixLength' => 'IP 地址與子網路遮罩',
    'ip-address.addressHintIPv4' => '例如：123.123.123.123/16、123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => '例如：2002:7b7b:7b7b::1/64、123.123.123.123/16、123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => '公共 IP 地址',
    'ip-address.hintPublicIp' => '如果您的 Plesk 伺服器部署在 NAT 後則可使用公共 IP 位址',
    'ip-address.distributionType' => '該 IP 地址被分配為',
    'ip-address.distributionTypeShared' => '共用',
    'ip-address.distributionTypeExclusive' => '獨立',
    'ip-address.certificate' => 'SSL/TLS 證書',
    'ip-address.defaultSite' => '默認網站',
    'ip-address.ftpOverSslNotSupportedByServer' => '已安裝的 FTP 伺服器不支援 FTPS。',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => '安裝的 FTP 伺服器不支援 IPv6 位址',
    'ip-address.interfaceDHCPEnabled' => '無法添加 IP 地址。該網路介面會自動獲取 IP 位址。',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '注意：為所有未知的域名啟用了自訂 Plesk URL；將會在 "https://%%ip%%/" 上顯示 Plesk 介面而不是預設的網站',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => '網路介面卡%%interface%% 不存在。移動此 IP 位址到其他網路介面卡或從列表移除該 IP 位址。',
    'ip-address.none' => '無',

    'ip-ban.filter.name' => '名稱',
    'ip-ban.filter.content' => '內容',
    'ip-ban.filter.filterExistsError' => '相同名稱的篩檢程式已經存在。',

    'ip-ban.jail.name' => '名稱',
    'ip-ban.jail.filter' => '篩檢程式',
    'ip-ban.jail.filterDescription' => '選擇篩檢程式。',
    'ip-ban.jail.action' => '操作',
    'ip-ban.jail.actionDescription' => '在此處選擇一項操作並點按按鈕以添加該操作。',
    'ip-ban.jail.logPath' => '日誌路徑',
    'ip-ban.jail.banTime' => 'IP 地址禁止時段',
    'ip-ban.jail.maxRetry' => '登錄嘗試失敗最多次數。',
    'ip-ban.jail.timeUnit' => '秒',
    'ip-ban.jail.addAction' => '添加',
    'ip-ban.jail.chooseAction' => '選擇：',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 驗證失敗（當登入到檔時）',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 驗證失敗（任何日誌記錄）',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 驗證失敗（當登入到系統日誌時）',
    'ip-ban.jail.apache-badbots-filter-description' => '垃圾郵件機器人程式和惡劣的網路爬蟲',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP 和 POP3 驗證失敗',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 驗證失敗',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 驗證失敗（主動模式）',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde web 郵箱驗證失敗',
    'ip-ban.jail.plesk-modsecurity-filter-description' => '違反 Web 應用程式防火牆 (ModSecurity) 安全和存取控制',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 驗證失敗',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 驗證失敗',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube web 郵箱驗證失敗',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 驗證失敗',
    'ip-ban.jail.plesk-manual-filter-description' => '用於手動禁止的虛擬篩檢程式',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP 用戶端錯誤（包括 RBL）',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP 用戶端錯誤、驗證失敗和 DDoS 攻擊',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP 和 SASL 驗證失敗',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 攻擊',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP 用戶端錯誤和驗證失敗',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP 用戶端錯誤（包括 RBL）',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP 用戶端錯誤（僅 RBL）',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD 登錄失敗',
    'ip-ban.jail.recidive-filter-description' => 'Fail2Ban 禁止重複託管',
    'ip-ban.jail.sshd-filter-description' => 'SSH 登錄失敗',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH 登入失敗、協商失敗和 DDoS 攻擊',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH 登入失敗和 DDoS 攻擊',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH 登入和協商失敗',
    'ip-ban.jail.firewallcmd-allports-action-description' => '通過 firewalld 防火牆禁止，在所有埠上',
    'ip-ban.jail.firewallcmd-multiport-action-description' => '通過 firewalld 防火牆禁止，在多個埠上',
    'ip-ban.jail.firewallcmd-new-action-description' => '通過 firewalld 防火牆禁止，在一個埠上',
    'ip-ban.jail.iptables-action-description' => '通過 iptables 防火牆禁止，在單個埠上',
    'ip-ban.jail.iptables-allports-action-description' => '通過 iptables 防火牆禁止，在所有埠上',
    'ip-ban.jail.iptables-multiport-action-description' => '通過 iptables 防火牆禁止，在多個埠上',
    'ip-ban.jail.sendmail-action-description' => '通過 Sendmail 發送郵件通知',
    'ip-ban.jail.jailExistsError' => '相同名稱的 jail 已經存在。',
    'ip-ban.jail.invalidInteger' => '指定的值無效。請指定一個整數。',

    'ip-ban.settings.pageHint' => '您可在此設定禁止 IP 位址以保護您的伺服器和託管的網站免受惡意流量的入侵。',
    'ip-ban.settings.detectionEnabled' => '啟用入侵檢測',
    'ip-ban.settings.banPeriod' => 'IP 地址禁止時段',
    'ip-ban.settings.banTimeWindow' => '檢測後續攻擊的時間間隔',
    'ip-ban.settings.maxRetries' => '禁止 IP 地址前失敗的次數',
    'ip-ban.settings.timeUnit' => '秒',
    'ip-ban.settings.invalidInteger' => '提供的值無效。請提供一個正整數。',

    'ip-ban.trusted-ip.ipAddress' => 'IP 地址',
    'ip-ban.trusted-ip.hintIpAddress' => '一個 IP 位址、一個 CIDR 遮罩或一個 DNS 主機名稱',
    'ip-ban.trusted-ip.ipAddressDescription' => '描述',
    'ip-ban.trusted-ip.hintIpAddressDescription' => '對地址被添加到信任清單的解釋.',

    'login-info.hint' => '在此處您可以修改客戶用於存取其客戶面板的用戶名和密碼。',
    'login-info.resellerHint' => '在此處您可以修改代理商用於存取其 Plesk 的用戶名和/或密碼。',
    'login-info.myProfileHint' => '您可在此修改用於存取 Plesk 的密碼。',

    'firewall-rule.titleEdit' => '編輯防火牆規則',
    'firewall-rule.titleNew' => '添加規則',
    'firewall-rule.isEnabled' => '啟用規則',
    'firewall-rule.name' => '規則名稱',
    'firewall-rule.profiles' => '設定檔',
    'firewall-rule.profilesHint' => '您必須至少選擇一個設定檔。',
    'firewall-rule.profileDomain' => '域名',
    'firewall-rule.profilePrivate' => '私有',
    'firewall-rule.profilePublic' => '公共',
    'firewall-rule.action' => '操作',
    'firewall-rule.actionAllow' => '允許',
    'firewall-rule.actionBlock' => '拒絕',
    'firewall-rule.port' => '允許連接到下列埠或埠範圍',
    'firewall-rule.portHint' => '例如：1000 或 1000-1051',
    'firewall-rule.protocolTcp' => 'TCP 協議',
    'firewall-rule.protocolUdp' => 'UDP 協議',
    'firewall-rule.remoteAddresses' => '遠程地址',
    'firewall-rule.remoteAddressesHint' => '例如：192.168.0.1 or 192.168.0.0/16',
    'firewall-rule.newRule' => '新建規則',
    'firewall-rule.successNew' => '已添加了防火牆規則。',
    'firewall-rule.successEdit' => '已更新了防火牆規則。',

    'mail.lists-server-settings.email' => "郵寄清單管理員的電郵地址",
    'mail.lists-server-settings.emptyEmail' => '請提供電郵地址。',
    'mail.lists-server-settings.newPassword' => '新密碼',
    'mail.lists-server-settings.emptyPassword' => '請提供一個密碼。',
    'mail.lists-server-settings.passwordConfirmation' => '確認密碼',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => '已配置郵寄清單軟體。',

    'mail.outgoing-messages.hint' => '在此處您可以指定一個郵箱的傳出資訊的限制。',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '傳出郵件資訊的最大數量',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => '默認（每小時 %%domainOutgoingMessages%% 條資訊）',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => '該郵箱的自訂值',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '條資訊（每小時）',

    'mail-gate-settings.host' => '主機名稱稱或 IP 地址',
    'mail-gate-settings.port' => '埠',
    'mail-gate-settings.login' => '用戶名',
    'mail-gate-settings.password' => '密碼',
    'mail-gate-settings.encryption' => 'SMTP 伺服器需要加密連接',
    'mail-gate-settings.allowUsers' => '允許用戶腳本通過該 SMTP 伺服器 （使用指定的用戶名和密碼）發送郵件。',
    'mail-gate-settings.useDefaultSettings' => '使用與 Plesk 一起安裝的郵件伺服器和 Plesk 創建的默認郵件帳戶',

    'mail-gate.hint' => '您可在此指定當未安裝 Plesk 郵件伺服器或 Plesk 郵件伺服器被禁止外發郵件時該使用的 SMTP 伺服器。該伺服器將被 Plesk 用作 SMTP 中繼以及用於發送如郵件通知之類等外發郵件的用戶腳本。',
    'mail-gate.enableMailGate' => '允許 Plesk 通過該 SMTP 伺服器發送郵件通知',
    'mail-gate.notifications' => '由外部 SMTP 伺服器發送的郵件通知',
    'mail-gate.smtpSettings' => '外部的 SMTP 伺服器設定',

    'optimization-settings.apacheModulesSection' => 'Apache 模組',
    'optimization-settings.nginxSettingsSection' => 'Nginx 設定',
    'optimization-settings.nginxHttp3Enabled' => 'HTTP/3 支援',
    'optimization-settings.nginxHttp3EnabledHint' => '在所有的主機網站上啟用全伺服器的 HTTP/3 支援，可提升現代網路的網站效能。不過，若有需要您可以在設定中，為個別訂閱停用 HTTP/3 支援。啟用或停用 HTTP/3 支援的時間，取決於受影響網域的數量，可能會需要數分數的時間。',
    'optimization-settings.apacheSettingsSection' => 'Apache 設定',
    'optimization-settings.additionalPageHint' => '只有在您完全瞭解所做操作帶來的後果影響後再切換模組。注意某些修改可能會降低 Apache 的性能或甚至會導致其無法正常運行。',
    'optimization-settings.pageHint' => '在此處您可以通過關閉未使用的 Apache 模組優化 Plesk。該優化會提升記憶體利用率而能夠讓您服務更多主機客戶。注意，一些模組是相互依附的，只有關閉（啟用）其依附的模組才能關閉（啟用）該模組。',
    'optimization-settings.advancedUsersOnlyWarning' => '該功能僅適用於高級用戶。',
    'optimization-settings.apacheRestartInterval' => 'Apache 重啟間隔（秒）',
    'optimization-settings.apacheRestartIntervalHint' => 'Plesk 會對域名和子域名所做的修改在指定的間隔時間內檢查一次。如果有些修改需要重啟 web 伺服器，Plesk 會重啟 Apache。',
    'optimization-settings.gracefulRestart' => 'Apache 平滑重啟',
    'optimization-settings.gracefulRestartHint' => '選中此核取方塊以避免每次更改主機設定時伺服器上託管的所有網站出現停機情況。',
    'optimization-settings.pipedLog' => '管道日誌',
    'optimization-settings.mpmMode' => 'MPM 模式',
    'optimization-settings.moduleDeprecated' => '（已棄用）',

    'personal-info.contactInfoSection' => '聯繫資訊',
    'personal-info.hint' => '您可以在此處編輯使用者聯繫信息。',
    'personal-info.hintMyProfile' => '您可以在此處編輯聯繫資訊。',

    'php-handler.extension.title' => '安裝 PECL 套裝程式',
    'php-handler.extension.description' => "您可以通過使用套裝程式名指定附加參數來安裝擴展的測試版，例如， 'msgpack-beta'。",
    'php-handler.extension.name' => '套裝程式名',

    'php-handler.ini.formHint' => '該 php.ini 檔僅被該處理常式使用。',
    'php-handler.ini.formHintSharedIni' => '該 php.ini 檔還被以下 PHP 處理常式使用：%%handlers%%。該設定應用到使用這些處理常式的所有網站。',
    'php-handler.ini.incorrectTextForIniFile' => "指定的設定不正確且無法被保存到 php.ini 文件。錯誤：%%message%%。",

    'plan-item-custom.planItemName' => '服務名稱',
    'plan-item-custom.buttonLabel' => '此名稱還將用作自訂按鈕的標籤。',
    'plan-item-custom.planItemDescription' => '服務訂閱',
    'plan-item-custom.buttonTooltip' => '此文本還將用作自訂按鈕的工具提示',
    'plan-item-custom.url' => '連接到自訂按鈕的 URL',
    'plan-item-custom.backgroundImage' => '自訂按鈕的背景圖片',
    'plan-item-custom.emptyItemName' => '請提供服務標籤。',
    'plan-item-custom.emptyItemDescription' => '請提供用於服務工具提示的文本。',
    'plan-item-custom.emptyUrl' => '請指定一個URL。',
    'plan-item-custom.longItemName' => '此服務標籤太長。允許的最大長度為 %max% 符號。',
    'plan-item-custom.longItemDescription' => '此服務文本太長。允許的最大長度為 %max% 符號。',
    'plan-item-custom.longUrl' => '此 URL 太長。允許的最大長度為 %max% 符號。',
    'plan-item-custom.useCustomButton' => '使用自訂按鈕',
    'plan-item-custom.useCustomButtonHint' => '將自訂按鈕置於使用者的首頁與網站頁面。',
    'plan-item-custom.openCustomButtonInSameWindow' => '在 Plesk 中打開 URL',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => '指定是否在 Plesk 頁面上或新的流覽器視窗中打開 URL。',
    'plan-item-custom.openCustomButtonWithoutFrame' => '不要使用幀',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => '若您添加一個自訂按鈕，通過該按鈕能夠進入客戶面板中的 Plesk 擴展或某個應用程式，則可以指定顯示該擴展/應用程式的方式：在幀中或作為 Plesk GUI 的一部分顯示。',
    'plan-item-custom.includeDomId' => '包含訂閱 ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => '包含主域名',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => '包含 FTP 用戶名',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => '包含 FTP 密碼',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '包含客戶ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "包含客戶的公司名稱",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "包含客戶的聯繫名稱",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "包含客戶的電子郵箱",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',
    'plan-item-custom.fileNotUploaded' => '無法上傳檔案。',

    'preview-domain-settings.previewType' => '選擇如何預覽網站',
    'preview-domain-settings.previewQuick' => '默認的快速預覽',
    'preview-domain-settings.previewDisabled' => '禁用快速預覽',
    'preview-domain-settings.previewQuickDescription' => '即刻預覽，推薦此選項。',
    'preview-domain-settings.previewZoneTypeInternal' => '在 Plesk 中的一個域名上快速預覽',
    'preview-domain-settings.previewZoneDomainIdDescription' => '選擇一個 Plesk 網站用於預覽。',
    'preview-domain-settings.previewZoneDomainCreate' => '若要使用該功能，至少%%link%%一個域名。',
    'preview-domain-settings.subscriptionCreateLink' => '創建',
    'preview-domain-settings.previewZoneTypeExternal' => '在一個外部域名上快速預覽',
    'preview-domain-settings.previewZoneDomainNameDescription' => '使用外部域名（DNS 區域）。如果您使用該選項，添加以下 DNS 記錄（A 類型）至外部域名區域： *.<Plesk_IP>.external.dom。此處的 <Plesk_IP> 是 Plesk 伺服器 IP，其中代表 IPv4 的點號（.）或代表 IPv6 的冒號（:）都由破折號（-）代替。如，*.192-0-2-12.external.dom。如果 Plesk 有多個註冊的 IP 位址，請為每一個位址添加一個記錄。',
    'preview-domain-settings.sitePreviewProtection' => '需要驗證',
    'preview-domain-settings.sitePreviewProtectionDescription' => '需要 FTP 登入名和密碼才能預覽。',
    'preview-domain-settings.nginxNotInstalled' => '無法進行默認的快速預覽因為未安裝 nginx web 伺服器。',
    'preview-domain-settings.nginxDisabled' => '無法進行默認的快速預覽因為 nginx web 伺服器已被禁用。',

    'reseller-preferences.settingsSection' => '設定',
    'reseller-preferences.multiLogin' => '允許多個會話',
    'reseller-preferences.language' => '介面語言',
    'reseller-preferences.interfaceView' => '選擇介面',
    'reseller-preferences.serviceProviderView' => '服務提供者視圖',
    'reseller-preferences.serviceProviderViewHint' => '此視圖適用於那些使用服務方案向其客戶提供和銷售 web 主機服務的伺服器管理員。',
    'reseller-preferences.powerUserView' => '高級使用者視圖',
    'reseller-preferences.powerUserViewHint' => '此視圖最適合於管理網站、其檔、資料庫、電子郵件帳戶、web應用程式和其他服務。',

    'reseller.hint' => '您可在此新增代理商並為其訂閱主機服務。',
    'reseller.contactInfoSection' => '聯繫資訊',
    'reseller.contactInfoSectionHint' => '輸入代理商聯繫資訊。',
    'reseller.accessToPanelSection' => '存取 Plesk',
    'reseller.accessToPanelSectionHint' => '代理商將用於存取 Plesk 管理其註冊的服務的驗證憑據。',
    'reseller.subscription' => '訂閱',
    'reseller.subscriptionSectionHint' => '選擇代理商要訂閱的服務方案。',
    'reseller.servicePlan' => '服務方案',
    'reseller.none' => '無',
    'reseller.customizeSubscription' => '創建代理商後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',
    'reseller.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'security-policy.encryptionSection' => '增強安全模式',
    'security-policy.encryptionSectionHint' => '增強安全模式引入了對 Plesk 中敏感性資料的增強保護。在這種模式下，Plesk 採用了多個安全機制，這些機制對 Plesk 用戶來說是絕對透明的。為了提升 Plesk 的安全度，我們建議您打開該模式。',
    'security-policy.encryptionEnable' => '增強安全模式',
    'security-policy.securePassword' => '增強安全模式',
    'security-policy.strengthSection' => '密碼強度',
    'security-policy.strengthSectionHint' => '大多數使用者可以在Plesk中設定或更改的密碼都要經過驗證，以確保它們滿足這裡設定的最低密碼強度要求。強式密碼至少有9-12個字元長，包括數位、大寫字母和小寫字母、特殊字元，沒有字典單詞。這些相對難猜測，但也要記住。<a href="%%link%%" target="_blank">瞭解更多有關密碼強度的資訊</a>。',
    'security-policy.passwordStrength' => '最小密碼強度',
    'security-policy.secureFtpSection' => '安全 FTP',
    'security-policy.ftpOverSsl' => 'FTPS 使用策略',
    'security-policy.ftpOverSslHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。您可在此選擇允許哪種連接。',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。您可在此選擇允許哪種連接。選定的選項將應用到伺服器上所有的 IP 地址。若要按每 IP 位址使用自訂設定，請選擇相應的選項，然後在 工具與設定> IP 地址 中更改 FTPS 策略。',
    'security-policy.ftpOverSslCustomHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。如果要按每 IP 位址調整 FTPS 設定，請首先進入 工具與設定 > 安全性原則 > 安全 FTP 中選擇選項 "按每 IP 位址使用自訂 FTPS 設定"。',
    'security-policy.ftpOverSslOptionRequired' => '僅允許安全 FTPS 連接',
    'security-policy.ftpOverSslOptionEnabled' => '允許安全 FTPS 和非安全 FTP 連接',
    'security-policy.ftpOverSslOptionDisabled' => '僅允許非安全 FTP 連接。不使用 FTPS',
    'security-policy.ftpOverSslOptionCustom' => '每 IP 位址使用自訂 FTPS 策略',
    'security-policy.prohibitWebConfigHandlersSection' => '自訂處理常式策略',
    'security-policy.prohibitWebConfigHandlersSectionHint' => '啟用此選項以禁止客戶通過 web.config 檔覆蓋在伺服器級別定義的 IIS 處理常式。',
    'security-policy.prohibitWebConfigHandlers' => '禁止通過 web.config 覆蓋處理常式',
    'security-policy.emailPasswordsSection' => '儲存電子郵件密碼',
    'security-policy.emailPasswordsSectionHint' => '電子郵件帳號的密碼可對應地加密或雜湊。變更此設定後，新政策將會套用至所有新建立的帳號，也會在下次變更密碼時套用在既有的帳號。',
    'security-policy.emailPasswordHashingLabel' => '儲存方式',
    'security-policy.emailPasswordSymmetric' => '對應加密',
    'security-policy.emailPasswordHashing' => '雜湊',
    'security-policy.emailPasswordSymmetricHint' => '更加方便，可將密碼加密。',
    'security-policy.emailPasswordHashingHint' => '更加安全，無法將密碼解密。',

    'server-mail-antivirus.used' => '使用的反病毒軟體',
    'server-mail-antivirus.policy' => '使用伺服器級設定',
    'server-mail-antivirus.policyOff' => '掃描關閉',
    'server-mail-antivirus.policyAny' => '掃描傳入郵件和傳出郵件',
    'server-mail-antivirus.policyFrom' => '僅掃描傳出郵件',
    'server-mail-antivirus.policyTo' => '僅掃描傳入郵件',
    'server-mail-antivirus.allowPersonalSettings' => '允許個人設定',
    'server-mail-antivirus.allowPersonalSettingsDesc' => '允許覆寫各個電子郵件地址的伺服器設定',
    'server-mail-antivirus.incoming' => '用於傳入郵件',
    'server-mail-antivirus.outgoing' => '用於傳出郵件',
    'server-mail-antivirus.success' => '防病毒設定已更改。',

    'server-mail-black-list.title' => '將域名添加到黑名單中',
    'server-mail-black-list.domainName' => '域名',
    'server-mail-black-list.emailAddress' => '電郵地址',
    'server-mail-black-list.emailAddressHint' => '“@”符號左邊不得含有非 ASCII 字元。位址可以包含“*”和“?”萬用字元 (如：*@domain.com、user?@*.com)。域名的非 ASCII 部分不得包含萬用字元。',
    'server-mail-black-list.action' => '對符合標準的郵件執行的操作：',
    'server-mail-black-list.actionDelete' => '從伺服器刪除',
    'server-mail-black-list.actionSpam' => '標識為垃圾郵件',
    'server-mail-black-list.success' => '域名被添加到黑名單中。',

    'server-mail-white-list.title' => '網路被添加到白名單中。',
    'server-mail-white-list.descEmailAddress' => '在這裡指定的電子郵寄地址將不會被SpamAssassin識別為垃圾郵件。',
    'server-mail-white-list.descIpAddress' => '此處指定的IP條目將被添加到郵件伺服器的例外項中。',
    'server-mail-white-list.ipAddress' => 'IP 地址/遮罩',
    'server-mail-white-list.ipAddressHint' => 'IP 位址可以包含萬用字元或 CIDR 遮罩。',
    'server-mail-white-list.emailAddress' => '電郵地址',
    'server-mail-white-list.emailAddressHint' => '“@”符號左邊不得含有非 ASCII 字元。位址可以包含“*”和“?”萬用字元 (如：*@domain.com、user?@*.com)。域名的非 ASCII 部分不得包含萬用字元。',
    'server-mail-white-list.emailAddressOrIp' => '電子郵寄地址或IP位址',
    'server-mail-white-list.wildcardPattern' => 'IP位址可以包含萬用字元(例如，123.123.*.123)。',
    'server-mail-white-list.cidrPattern' => 'IP位址可以包含CIDR遮罩(例如，10.0.0.0/8)。',
    'server-mail-white-list.success' => '網路被添加到白名單中。',

    'server-mail-settings.general.title' => '常規選項',
    'server-mail-settings.general.mailUiEnabled' => '在 Plesk 裡啟用郵件管理功能',
    'server-mail-settings.general.mailUiEnabledHint' => '清除核取方塊會移除建立信箱的能力，並會透過 Plesk GUI 變更網域的電子郵件設定。電子郵件服務將會持續運作，也能繼續使用 Web 信箱。',
    'server-mail-settings.general.serverName' => '安裝的郵件伺服器',
    'server-mail-settings.general.changeServerName' => '安裝並使用其它郵件伺服器',
    'server-mail-settings.general.imapServerName' => '已安裝 IMAP/POP3 伺服器',
    'server-mail-settings.general.changeImapServerName' => '安裝和使用其它 IMAP/POP3 伺服器',
    'server-mail-settings.general.changeServerHint' => '您可以 %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => '最大郵件大小',
    'server-mail-settings.general.kbytes' => 'KB',
    'server-mail-settings.general.maxConnections' => '連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => '啟動的伺服器 (IMAP 或 POP3) 的最大數量。',
    'server-mail-settings.general.maxConnectionsHintDovecot' => '同時可登入的郵件用戶的最大數量。',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => '每個 IP 位址的連接的最大數量',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => '每個 IP 位址一個用戶可連接的最大數量。',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => '接受來自同一 IP 位址的連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量。',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => '允許郵件用戶接收來自每個 IP 位址的連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量。',
    'server-mail-settings.general.messageSubmission' => '啟用埠 587 上的 SMTP 服務',
    'server-mail-settings.general.messageSubmissionOnAllIp' => '在所有 IP 地址上啟用埠 587 上的 SMTP 服務',
    'server-mail-settings.general.messageSubmissionBindTo' => '啟用',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => '所有 IP 地址',
    'server-mail-settings.general.outgoingEmailMode' => '傳出郵件模式',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => '發自域名的 IP 地址',
    'server-mail-settings.general.outgoingEmailModeDomainName' => '發自域名的 IP 位址並在 SMTP 問候中使用域名',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => '發自指定的 IP 地址',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => '無',
    'server-mail-settings.general.subaddressing' => '開啟電子郵件子定址',
    'server-mail-settings.general.subaddressingHint' => '此選項會開啟為郵寄清單配置 %%verpStyleLink%% 電子郵箱位址的功能',
    'server-mail-settings.general.verpStyleLink' => 'VERP 式',
    'server-mail-settings.general.mboxQuotaWarning' => '啟用郵箱配額警告',
    'server-mail-settings.general.mboxQuotaWarningHint' => '當郵件用戶的郵箱配額使用超過了 95% 時發送通知給郵件用戶',
    'server-mail-settings.general.mboxQuotaWarningChange' => '自訂默認的郵箱配額警告',
    'server-mail-settings.general.fixSender' => '修復外發郵件的錯誤設定的寄件者',
    'server-mail-settings.general.fixSenderHint' => '自動為從域名外發郵件設定有效的電子郵件資訊頭和寄件者信封位址以降低被視作垃圾郵件的風險',
    'server-mail-settings.general.maxMessageSizeHint' => '如為有附件的電子郵件，該值應比附件大小高出 35-40%。%%kbLink%%',
    'server-mail-settings.general.maxMessageSizeHintLink' => '更多資訊請查看 KB 文章',

    'server-mail-settings.autodiscover.title' => '郵件 autodiscover',
    'server-mail-settings.autodiscover.description' => '查看其在 %%link%% 中是如何工作運行的',
    'server-mail-settings.autodiscover.link' => '知識庫',
    'server-mail-settings.autodiscover.enabled' => '啟用郵件 autodiscover',
    'server-mail-settings.autodiscover.enabledHint' => '啟用此功能會重新配置啟用了 autodiscover 的所有域名',
    'server-mail-settings.autodiscover.customServer' => '自訂網域名',
    'server-mail-settings.autodiscover.customServerHint' => '將特定的自訂網域名指定為用於內送及外寄郵件的郵件 autodiscover 設定。',
    'server-mail-settings.autodiscover.customServerCertHint' => '注意：域名必須使用有效的 SSL/TLS 證書進行安全保護。',
    'server-mail-settings.autodiscover.reconfigureDns' => '重新配置 autodiscover DNS 記錄',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => '啟用此功能會重新配置啟用了 autodiscover 的所有域名 autodiscover DNS 記錄',

    'server-mail-settings.relay.title' => '中繼選項',
    'server-mail-settings.relay.type' => "郵件中繼",
    'server-mail-settings.relay.open' => "打開",
    'server-mail-settings.relay.openSpamWarning' => "打開郵件中繼會使郵件伺服器出現垃圾郵件。",
    'server-mail-settings.relay.openSpamChange' => "只有當您想暫時測試郵件伺服器或您的Plesk伺服器在內部網路中，無法通過互聯網存取時，才保留該設定。",
    'server-mail-settings.relay.closed' => "關閉",
    'server-mail-settings.relay.auth' => "需要驗證：",
    'server-mail-settings.relay.notSupported' => "郵件伺服器不支援",
    'server-mail-settings.relay.change' => '若要實現 Plesk 能夠在中繼關閉時發送通知，則可以 %%changeLink%%',
    'server-mail-settings.relay.changeLink' => '更改 SMTP 設定',
    'server-mail-settings.relay.pop3' => "POP3優先SMTP",
    'server-mail-settings.relay.lockTime' => "鎖定時間",
    'server-mail-settings.relay.min' => "分鐘",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => '對下面的網路使用無中繼限制：',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP 地址/遮罩",

    'server-mail-settings.outgoing.title' => '對發送電子郵件資訊的限制',
    'server-mail-settings.outgoing.description' => '以下限制是默認的。這些限制可在每個服務方案和訂閱中被覆蓋。此等限制不是伺服器範圍的，但是可作為未指定自訂限制的方案和訂閱的範本。注意對外發電子郵件資訊開啟限制可能會影響郵件伺服器的性能。%%link%%',
    'server-mail-settings.outgoing.learnMore' => '瞭解有關限制發送郵件的更多資訊',
    'server-mail-settings.outgoing.enabled' => '對外發電子郵件資訊開啟限制',
    'server-mail-settings.outgoing.countRecipients' => '計算收件人的數量，而不是郵件',
    'server-mail-settings.outgoing.countRecipientsHint' => '在限制發送郵件和計數統計時，啟用計算收件人而非郵件數量的模式。例如，發送給10個收件人的一條消息將被計算為10條消息。',
    'server-mail-settings.outgoing.mailboxLimit' => '發自一個郵箱的資訊預設限制（每小時）',
    'server-mail-settings.outgoing.domainLimit' => '發自一個域名的資訊預設限制（每小時）',
    'server-mail-settings.outgoing.subscriptionLimit' => '發自一個訂閱的資訊預設限制（每小時）',
    'server-mail-settings.outgoing.unlimited' => '無限',
    'server-mail-settings.outgoing.sendmail' => '允許用戶和腳本使用 Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => '即使在超過了郵箱和域名的限制的情況下腳本和使用者也將能夠使用  Sendmail 發送郵件資訊（代表訂閱的系統使用者）。可通過 Sendmail 發送的資訊最大數量將由整個訂閱的限制所定義。該設定不允許腳本在整個伺服器範圍使用 Sendmail，但是作為服務方案和訂閱的預設設定。',
    'server-mail-settings.outgoing.reportPeriod' => '顯示基於上一次統計的報告',
    'server-mail-settings.outgoing.reportPeriodHint' => '會創建報告，且會在首頁顯示有關在指定期限內嘗試超過郵件傳出限制的警告。',
    'server-mail-settings.outgoing.notificationPeriod' => '發送郵件通知，每隔',
    'server-mail-settings.outgoing.notificationPeriodHint' => '該通知會提供有關在指定期限內嘗試超過郵件傳出限制的統計。',
    'server-mail-settings.outgoing.periodP1D' => '1 日',
    'server-mail-settings.outgoing.periodP1W' => '1 周',
    'server-mail-settings.outgoing.periodP2W' => '2 周',
    'server-mail-settings.outgoing.periodP1M' => '1 個月',
    'server-mail-settings.outgoing.periodPT15M' => '15 分鐘',
    'server-mail-settings.outgoing.periodPT1H' => '1 小時',
    'server-mail-settings.outgoing.periodPT6H' => '6 小時',
    'server-mail-settings.outgoing.periodPT12H' => '12 小時',
    'server-mail-settings.outgoing.whiteListNotEmpty' => '對傳出郵件的限制將不適用於IP地址來自郵件伺服器白名單的寄件者。例如，如果在白名單中有 localhost (127.0.0.0 / 8, ::1 / 128)，不管該限制如何，所有本機伺服器的郵件將被成功發送。寄件者可以使用本地IP位址（在本機伺服器上託管的網站和自訂腳本）或外部IP位址（通過安裝在電腦或移動設備上的郵件用戶端發送郵件的客戶）。要實現該限制適用於所有寄件者（本地的和外部的），請移除所有來自白名單的IP位址和網路。請注意，移除來自白名單的 localhost (127.0.0.0 / 8, ::1 / 128) 可能干擾該伺服器發送郵件網站和腳本的操作。瞭解有關傳出郵件限制的詳情，請查看管理員指南，傳出垃圾郵件防護。',
    'server-mail-settings.outgoing.relayIsOpen' => '郵件中繼已打開：將無法實現對傳出郵件的限制。',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => '一個域名的傳出資訊限制 (%%value%%) 不得大於一個訂閱的傳出資訊限制 (%%highLevelLimitValue%%)。',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => '一個電郵地址的傳出資訊限制 (%%value%%) 不得大於一個域名的傳出資訊限制 (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => '一個電郵地址的傳出資訊限制 (%%value%%) 不得大於一個訂閱的傳出資訊限制 (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Mailman 設定',
    'server-mail-settings.mailman.secureLinks' => '在郵寄清單中使用安全連結',
    'server-mail-settings.mailman.secureLinksHint' => '啟用或禁用郵寄清單中的安全 (HTTPS) 連結生成。',
    'server-mail-settings.mailman.noLocalhost' => '若要使用郵寄清單，您需要在郵件伺服器的白名單中設定有本地主機 (127.0.0.0/8, ::1/128) 。但是，若要使用傳出郵件控制，白名單中則不需要有本地主機。如果您已經啟動了傳出郵件控制，那麼可使用折中方案，即在郵箱上使用郵件轉發而非郵寄清單。',
    'server-mail-settings.mailman.noLocalhostIpv4' => '若要使用郵寄清單，您需要在郵件伺服器的白名單中有本地主機。但是，若要使用傳出郵件控制，白名單中則不需要有本地主機。如果您已經啟動了傳出郵件控制，那麼可使用折中方案，即在郵箱上使用郵件轉發而非郵寄清單。注意現在白名單中沒有 IPv4 本地主機位址 (127.0.0.0/8)，因此傳出郵件控制功能將用於 IPv4 位址。',
    'server-mail-settings.mailman.noLocalhostIpv6' => '若要使用郵寄清單，您需要在郵件伺服器的白名單中有本地主機。但是，若要使用傳出郵件控制，白名單中則不需要有本地主機。如果您已經啟動了傳出郵件控制，那麼可使用折中方案，即在郵箱上使用郵件轉發而非郵寄清單。注意現在白名單中沒有 IPv6 本地主機位址 (::1/128)，因此傳出郵件控制功能將用於 IPv6 位址。',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => '啟用 DMARC 以檢查傳入郵件',
    'server-mail-settings.spam-filter.dmarcHint' => '當為傳入郵件啟用了 DKIM 和 SPF 時此選項可用。',
    'server-mail-settings.spam-filter.dkim' => 'DKIM 垃圾郵件防護',
    'server-mail-settings.spam-filter.singOutgoing' => '允許給發件簽名',
    'server-mail-settings.spam-filter.verifyIncoming' => '驗證傳入郵件',
    'server-mail-settings.spam-filter.verifyIncomingHint' => '當為傳入郵件啟用了 DMARC 時，可能無法關閉此選項。',
    'server-mail-settings.spam-filter.spf' => 'SPF 垃圾郵件防護',
    'server-mail-settings.spam-filter.spfEnabled' => '啟用 SPF 垃圾郵件防護措施以檢查傳入郵件',
    'server-mail-settings.spam-filter.spfEnabledHint' => '當為傳入郵件啟用了 DMARC 時，可能無法關閉此選項。',
    'server-mail-settings.spam-filter.ignoreErrors' => '當有 DNS 查找問題時繼續 SPF 檢查',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => '首先，SPF 會執行 DNS 查找。若選擇該選項，如果 DNS 查找失敗則仍會繼續檢查。如果在當前的檢查模式中沒有任何效果則取消選定該選項。',
    'server-mail-settings.spam-filter.behavior' => 'SPF檢查模式',
    'server-mail-settings.spam-filter.behaviorHint' => '然後，SPF 會應用本地和猜測規則。可能會根據選定的檢查模式和檢查結果拒絕郵件資訊。',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => '只創建 Received-SPF 標頭資訊，不遮罩',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'DNS查找出現問題時，使用臨時錯誤通知',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'SPF解析為“失敗”(拒絕)時，退信',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'SPF解析為“軟失敗”時，退信',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'SPF解析為“中性”時，退信',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'SPF沒有解析為“通過”時，退信',
    'server-mail-settings.spam-filter.localRules' => 'SPF本地規則',
    'server-mail-settings.spam-filter.guessRules' => 'SPF猜測規則',
    'server-mail-settings.spam-filter.explanationText' => 'SPF解釋文本',
    'server-mail-settings.spam-filter.rbl' => "基於 DNS blackhole lists 的垃圾郵件防護措施",
    'server-mail-settings.spam-filter.rblEnabled' => "關閉基於 DNS blackhole lists 的垃圾郵件防護措施",
    'server-mail-settings.spam-filter.rblServer' => "DNSBL 服務的 DNS 區域",
    'server-mail-settings.spam-filter.rblServerHint' => "使用分號隔開項目，例如：'dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => '額外的自動回復消息頭',
    'server-mail-settings.auto-reply-headers.description' => '為來自Plesk伺服器的任何自動回復消息設定額外的消息頭。',
    'server-mail-settings.auto-reply-headers.extra' => '額外的消息頭',

    'server-mail-settings.pop3-names.title' => "POP3/IMAP 郵件帳戶名",
    'server-mail-settings.pop3-names.disabled' => "只能使用 POP3/IMAP 郵件帳戶的全名",
    'server-mail-settings.pop3-names.enabled' => "可使用 POP3/IMAP 郵件帳戶的簡稱 (webmaster) 或全名 (webmaster@domain.com)。",

    'server-mail-settings.success' => '郵件伺服器設定已更改。',

    'server-mail-spam-filter.general' => '常用',
    'server-mail-spam-filter.isEnabled' => '啟用伺服器級SpamAssassin垃圾郵件過濾',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin未安裝。)',
    'server-mail-spam-filter.greylistingSpamProtection' => '啟用伺服器級灰名單垃圾郵件過濾功能',
    'server-mail-spam-filter.isUserSettingsEnabled' => '將單個設定應用到垃圾郵件過濾中',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "垃圾郵件過濾功能已禁用：郵件伺服器不支援郵箱級的垃圾郵件過濾功能。",
    'server-mail-spam-filter.settings' => 'SpamAssassin設定',
    'server-mail-spam-filter.maxChildrenTitle' => '處理上限',
    'server-mail-spam-filter.maxChildrenDescription' => '可運行的 spamd worker 進程的最大數量.',
    'server-mail-spam-filter.requiredHitsTitle' => '所需分數',
    'server-mail-spam-filter.requiredHitsDescription' => '郵件被標識為垃圾郵件需獲得的分值.',
    'server-mail-spam-filter.maxMailLimit' => '如果郵件大小超過此值，不要過濾',
    'server-mail-spam-filter.maxMailLimitText' => '大小限制',
    'server-mail-spam-filter.kbytes' => "KB",
    'server-mail-spam-filter.maxThreadsLimit' => '垃圾郵件篩檢程式可創建的執行緒數量',
    'server-mail-spam-filter.tagTitle' => '垃圾郵件標籤',
    'server-mail-spam-filter.tagDescription' => '下列文字將新增至被視為垃圾郵件的每一則訊息的主題開頭處。',
    'server-mail-spam-filter.alarmMessage' => '垃圾郵件警報文本',
    'server-mail-spam-filter.languages' => '可信的語言',
    'server-mail-spam-filter.locales' => '可信的區域設定',
    'server-mail-spam-filter.success' => '垃圾郵件篩檢程式配置已更改。',
    'server-mail-spam-filter.personalSettingsWarning' => '伺服器管理員已禁止使用個人垃圾郵件過濾設定。不會應用下面指定的垃圾郵件過濾設定。',

    'service-plan.admin-plan.subscription_section' => '通用',
    'service-plan.admin-plan.tools_section' => '工具與資源',
    'service-plan.admin-plan.apps_section' => '應用程式與資料庫',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk 外觀',
    'service-plan.admin-plan.statistics_section' => '統計',
    'service-plan.admin-plan.general_section' => '常用',
    'service-plan.admin-plan.mail_section' => '郵件',
    'service-plan.admin-plan.server_section' => '伺服器',
    'service-plan.admin-plan.modules_section' => '擴展',
    'service-plan.admin-plan.troubleshooting_section' => '幫助與故障排除',
    'service-plan.admin-plan.simplePanel' => '限制模式',
    'service-plan.admin-plan.enabled' => '啟用限制模式',
    'service-plan.admin-plan.enabledDescription' => '選擇此選項來限制管理員可以在Plesk中採取操作的次數。',
    'service-plan.admin-plan.aliasEnabledDescription' => '選擇此選項來限制其它管理員可以在Plesk中採取操作的次數。',

    'service-plan.applications-subscription.useFilterLabel' => '只提供我選擇的應用程式',
    'service-plan.applications-subscription.useFilterDescription' => '使用該選項選擇訂戶可用的應用程式。',
    'service-plan.applications-subscription.applications' => '應用程式',
    'service-plan.applications-subscription.isCommercial' => '該應用程式為商業應用程式需要購買許可證金鑰。',

    'service-plan.applications.useFilterLabel' => '只提供我選擇的應用程式',
    'service-plan.applications.useFilterDescription' => '使用該選項選擇訂戶可用的應用程式。',
    'service-plan.applications.applications' => '應用程式',
    'service-plan.applications.isCommercial' => '該應用程式為商業應用程式需要購買許可證金鑰。',

    'service-plan.dns.dnsZoneType' => '域名 DNS 區域',
    'service-plan.dns.dnsZoneTypeMaster' => '主要',
    'service-plan.dns.dnsZoneTypeSlave' => '輔助',

    'service-plan.extras.groupOtherServices' => '其它服務',
    'service-plan.extras.none' => '無',

    'service-plan.hosting.enablePhysicalHosting' => '啟用主機',
    'service-plan.hosting.sectionCoreHosting' => '常規屬性',
    'service-plan.hosting.sectionScripting' => '腳本',
    'service-plan.hosting.defaultDatabaseServer' => '預設的資料庫伺服器',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '高級',
    'service-plan.hosting.phpSettingsHelpLink' => '瞭解如何選擇最適合的PHP設定',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => '訂閱被掛起時網站的狀態',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '已被掛起訂閱中的網站狀態',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => '當訂閱被掛起（例如，訂閱到期）時選定的狀態將被應用到方案訂閱下的所有網站。',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => '當訂閱被掛起（例如，訂閱到期）時選定的狀態將被應用到網站。',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '禁用',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => '網站訪客將被重定向至 web 伺服器的預設頁面。',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '掛起',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => '網站訪客將會被重定向至自訂的錯誤文檔頁面（帶有搜尋引擎友好 503 HTTP 代碼）。',
    'service-plan.hosting.unpaidWebsiteStatusActive' => '活動',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => '將繼續可以通過互聯網存取網站。',

    'service-plan.ip.sharedIpAddresses' => '分配共用 IP 地址',
    'service-plan.ip.allocateExclusiveIp' => '分配獨立 IP 位址',
    'service-plan.ip.allocateExclusiveIpV4' => '分配獨立 IPv4 位址',
    'service-plan.ip.allocateExclusiveIpV6' => '分配獨立 IPv6 位址',

    'service-plan.mail.mailService' => '郵件服務',
    'service-plan.mail.mailServiceDisabled' => '禁用',
    'service-plan.mail.mailServiceDisabledIncoming' => '已為接收郵件禁用',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk 將不會在域名上提供任何郵件服務。',
    'service-plan.mail.mailServiceDisabledIncomingHint' => '域名只能發送郵件，且只能使用 Sendmail。',
    'service-plan.mail.mailServiceEnabled' => '已啟用',
    'service-plan.mail.mailServiceEnabledHint' => '域名可以發送和接收郵件。',
    'service-plan.mail.mailServiceNotConfigured' => '未配置',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk 將不會在域名上提供任何郵件服務。',
    'service-plan.mail.webMail' => 'web 郵箱',
    'service-plan.mail.mailingLists' => '啟用郵寄清單',
    'service-plan.mail.mailToNonExistentUser' => '關於不存在的用戶的郵件策略',
    'service-plan.mail.mailToNonExistentUserBounce' => '退信通知',
    'service-plan.mail.mailToNonExistentUserRedirect' => '轉發到地址',
    'service-plan.mail.mailToNonExistentUserReject' => '拒絕',
    'service-plan.mail.mailAutodiscovery' => '啟用郵件 autodiscover',
    'service-plan.mail.mailAutodiscoveryDescription' => '請在 <a href="%%link%%" target="_blank">knowledge base</a> 中查看該功能是如何運行的',
    'service-plan.mail.bounceMessage' => '此位址不再接收郵件。',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => '重定向到該 IP 位址的外部郵件伺服器：',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 禁用',
    'service-plan.mail.notConfiguredConfirm' => '永久移除受影響域名的所有郵箱，包括收到的和發送的電子郵件。',
    'service-plan.mail.notConfiguredConfirmError' => '請確認',

    'service-plan.misc.manualSubscriptionUpdateWarning' => '請注意：您更新服務方案時，不會變更保留網站及流量數值的設定。更新每個網域此項設定的唯一方式，就是在 Plesk 資料庫中更新。請參閱<a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">這篇 KB 文章</a>以了解更多詳情。',
    'service-plan.misc.retainEnabled' => '保留網站和流量統計',
    'service-plan.misc.logRotation' => '日誌迴圈',
    'service-plan.misc.logRotationCondition' => '日誌迴圈條件',
    'service-plan.misc.logRotationBySize' => '按大小',
    'service-plan.misc.logRotationByTime' => '按時間',
    'service-plan.misc.logRotationDaily' => '每日',
    'service-plan.misc.logRotationWeekly' => '每週',
    'service-plan.misc.logRotationMonthly' => '每月',
    'service-plan.misc.logRotationSizeDescription' => '大小值必須在 %%min%% 與 %%max%% kB 之間。',
    'service-plan.misc.maximumNumberOfFiles' => '日誌檔最大數量',
    'service-plan.misc.compress' => '壓縮日誌檔',
    'service-plan.misc.sendLogToEmail' => 'Plesk 從 web 和 FTP 伺服器的日誌檔檢索資料後，會通過郵件發送日誌到該位址',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => '月',
    'service-plan.misc.logRotationPeriodGreater' => '日志轮转周期不能比服务器范围内的限制%%max%%长。',

    'service-plan.performance.iisAppPoolAddonsHint' => '如未啟用，訂閱的所有網站都會使用專用於該訂閱的同一 IIS 應用程式池。',

    'service-plan.permissions-subscription.permissionsTabDescription' => '選擇訂閱的服務及許可權。',
    'service-plan.permissions-subscription.showMorePermissions' => '顯示更多可用許可權',
    'service-plan.permissions-subscription.hideMorePermissions' => '顯示較少許可權',
    'service-plan.permissions-subscription.noShellManagement' => '不允許',
    'service-plan.permissions-subscription.systemAccessLabel' => '管理通過SSH存取伺服器',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '允許客戶為其系統使用者啟用 SSH。請設定主機參數 “通過 SSH 在訂閱的系統使用者的名下存取伺服器 shell” 為預設參數。',

    'service-plan.permissions.permissionsTabDescription' => '選擇方案提供的服務和許可權。',
    'service-plan.permissions.permissionsAddonTabDescription' => '選擇將作為附加方案而添加到訂閱的服務及許可權。注意，在附加方案中未選的許可權不會影響到訂閱參數。',
    'service-plan.permissions.permissionsBehaviorDescription' => '許可權能夠讓客戶更改其訂閱的特定設定。當創建了一個訂閱時，Plesk 會將方案的預設值應用到客戶可以更改的設定。之後，更新方案或應用附加方案不會覆蓋客戶所做的更改。',
    'service-plan.permissions.showMorePermissions' => '顯示更多可用許可權',
    'service-plan.permissions.hideMorePermissions' => '顯示較少許可權',
    'service-plan.permissions.noShellManagement' => '不允許',
    'service-plan.permissions.systemAccessLabel' => '管理通過SSH存取伺服器',
    'service-plan.permissions.systemAccessLabel_hint' => '請設定主機參數 “通過 SSH 在訂閱的系統使用者的名下存取伺服器 shell” 為預設參數。',

    'service-plan.resources-subscription.overusePolicy' => '超額使用策略',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '不允許超額使用',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => '阻止超額使用資源。如果資源使用超過了上限值，訂閱會自動被掛起。',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => '允許超額使用磁碟空間與流量',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => '允許超額使用磁碟空間與流量。不允許超額使用其他資源。',
    'service-plan.resources-subscription.overusePolicyAllowed' => '允許超額使用（不建議）',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '允許訂戶超額使用訂閱資源。',
    'service-plan.resources-subscription.overuseNotify' => '超額使用時通過郵件通知我。',
    'service-plan.resources-subscription.oversellPolicy' => '超額銷售策略',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '允許超額銷售',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '超額銷售允許代理商超額出售通過訂閱分配給他們的資源。若允許超額銷售，代理商則可支配實際使用的資源而不是初始分配的資源。',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '不允許超額銷售',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '若不允許超額銷售，不管實際使用的資源是多少，代理商都只能出售通過訂閱初始分配給他們的資源。',
    'service-plan.resources-subscription.mainGroupTitle' => '定義訂閱的資源使用限制。',
    'service-plan.resources-subscription.additionalGroupTitle' => '顯示更多可用資源',
    'service-plan.resources-subscription.hideMoreResources' => '顯示較少資源',

    'service-plan.resources.overusePolicy' => '超額使用策略',
    'service-plan.resources.overusePolicyNotAllowed' => '不允許超額使用',
    'service-plan.resources.overusePolicyNotAllowedHint' => '阻止超額使用資源。如果資源使用超過上限值，訂閱會自動掛起。',
    'service-plan.resources.overusePolicySoftAllowed' => '允許超額使用磁碟空間與流量',
    'service-plan.resources.overusePolicySoftAllowedHint' => '允許超額使用磁碟空間與流量。不允許超額使用其他資源。',
    'service-plan.resources.overusePolicyAllowed' => '允許超額使用（不建議）',
    'service-plan.resources.overusePolicyAllowedHint' => '允許客戶使用比初始分配給方案的更多的資源。',
    'service-plan.resources.overuseNotify' => '超額使用時通過郵件通知我。',
    'service-plan.resources.oversellPolicy' => '超額銷售策略',
    'service-plan.resources.oversellPolicyAllowed' => '允許超額銷售',
    'service-plan.resources.oversellPolicyAllowedHint' => '超額銷售允許代理商超額出售通過方案分配給他們的資源。若允許超額銷售，代理商則可支配實際使用的資源而不是初始分配的資源。',
    'service-plan.resources.oversellPolicyNotAllowed' => '不允許超額銷售',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '若不允許超額銷售，不管實際使用的資源是多少，代理商都只能出售通過方案初始分配給他們的資源。',
    'service-plan.resources.mainGroupTitle' => '定義方案的資源。',
    'service-plan.resources.additionalGroupTitle' => '顯示更多可用資源',
    'service-plan.resources.hideMoreResources' => '顯示較少資源',
    'service-plan.resources.allowSitebuilderUpsell' => '允許客戶創建試用的 Presence Builder 網站。',
    'service-plan.resources.allowSitebuilderUpsellDescription' => '此設定允許客戶創建更多 Presence Builder 網站，不受服務方案的限制。但是客戶將需要購買這些網站才能發佈。',

    'service-plan.servicePlanName' => '服務方案名稱',
    'service-plan.resellerPlanName' => '代理商方案名稱',
    'service-plan.addonPlanName' => '附加方案名稱',
    'service-plan.adminPlanPermissionsTab' => '管理工具',
    'service-plan.adminPlanPermissionsTabDescription' => '選項當啟用了限制模式時，管理員可以使用的功能。',
    'service-plan.hostingPermissionsTab' => '主機工具',
    'service-plan.hostingPermissionsTabDescription' => '選擇當啟用了限制模式時，高級使用者視圖中的管理員可以使用的web主機工具和設定。',
    'service-plan.resourcesTab' => '資源',
    'service-plan.resourcesTabDescription' => '定義方案資源以及資源使用策略。',
    'service-plan.subscriptionResourcesTabDescription' => '定義訂閱資源以及資源使用策略。',
    'service-plan.hostingTab' => '主機參數',
    'service-plan.hostingTabDescription' => '指定主機服務的參數。注意在附加方案中指定的主機設定不會應用到通過服務方案或附加方案授以“主機設定管理”許可權的訂閱。',
    'service-plan.secureSettingsDescription' => '如果您希望提供的主機是最安全的，請%%link%%。如果訂戶享有某些許可權，則可以更改這些設定。請%%helpLink%%。',
    'service-plan.secureSettingsLink' => '應用預設的安全設定',
    'service-plan.secureSettingsHelpLink' => '瞭解安全主機設定',
    'service-plan.mailTab' => '郵件',
    'service-plan.mailTabDescription' => '指定方案的郵件服務參數。',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => '指定方案的 DNS 服務參數。',
    'service-plan.performanceTab' => '性能',
    'service-plan.performanceTabDescription' => '請指定影響方案所有服務性能的系統參數。',
    'service-plan.permissionsTab' => '許可權',
    'service-plan.miscTab' => '日誌與統計',
    'service-plan.miscTabDescription' => '指定如何存儲方案訂閱的統計及日誌。注意這些設定在訂閱中不同步。',
    'service-plan.miscTabAdminPlanDescription' => '請指定如何存儲訂閱的統計和日誌。',
    'service-plan.extrasTab' => '其它服務',
    'service-plan.extrasTabDescription' => '選擇除了網站託管、DNS與郵件服務外的包含在方案裡的其它服務。',
    'service-plan.ipTab' => 'IP地址',
    'service-plan.ipTabDescription' => '定義方案的 IP 資源參數。',
    'service-plan.applicationsTab' => '應用程式',
    'service-plan.applicationsTabDescription' => '為方案選擇可供使用的應用程式。您可選擇應用程式目錄中所有的應用程式，外加您上傳到伺服器中的應用程式，或者手動選擇應用程式。如果您要選擇所有可用的應用程式，則不必在此標籤上做任何操作，只需進入 許可權 標籤選擇 存取應用程式目錄 選項即可。如果您想要手動選擇應用程式，您可在此標籤上操作。',
    'service-plan.applicationsTabDescription-addon' => '選擇可用作附加方案的應用程式',
    'service-plan.applicationsTabDescription-subscription' => '為訂閱選擇可供使用的應用程式。您可選擇應用程式目錄中所有的應用程式，外加您上傳到伺服器中的應用程式，或者手動選擇應用程式。如果您要選擇所有可用的應用程式，則不必在此標籤上做任何操作，只需進入 許可權 標籤選擇 存取應用程式目錄 選項即可。如果您想要手動選擇應用程式，您可在此標籤上操作。',
    'service-plan.planSyncSubsriptionWarning' => '部分訂閱未與方案同步。在訂閱清單中標誌為"未同步"。若要重試同步，轉到訂閱概要頁，並按一下同步按鈕。',
    'service-plan.planSyncResellerWarning' => '部分代理商未與方案同步。代理商清單中都標記為"未同步"。若要重新嘗試同步，轉到代理商概要頁，並按一下同步按鈕。',
    'service-plan.planSyncAdminWarning' => '無法應用更改到訂閱因為 Plesk 不提供這些更改所影響的某些服務或資源。原因：%%reason%%',
    'service-plan.duplicateName' => '相同名稱的方案已經存在。',
    'service-plan.phpSettingsTab' => 'PHP 設定',
    'service-plan.phpHandlerNotFound' => '無法檢索有關該方案的PHP版本的資訊。將其重新安裝或為服務方案選擇其它PHP版本。',
    'service-plan.phpHandlerNotRegistered' => "PHP 版本 %%fullVersion%% 未安裝。使用該服務方案的域名的 PHP 腳本不可用。安裝 PHP <nobr>版本 %%fullVersion%%</nobr> 或為該服務方案選擇其它 PHP 版本。",

    'service-plan.phpSettingsTabDescription' => '您可在此為每個訂閱指定 PHP 設定，覆蓋伺服器級的 php.ini 檔定義的設定。例如，當您想要限制客戶 PHP 腳本佔用的系統資源時，可進行此設定。客戶（如果允許）可使用其為每個域名自行調整的配置覆蓋此 PHP 配置。當您設定一個參數為預設值時，PHP 將會使用來自伺服器級的 PHP 配置的參數值。注意支援使用以下預留位置：{DOCROOT} 和 {WEBSPACEROOT} 代表獲取自訂 PHP 配置的某個域名的文檔根目錄和某個訂閱的根目錄；{TMP} 代表存儲暫存檔案的目錄。注意：以下設定可能會被 .htaccess、php.ini 或 .user.ini 檔案中指定的參數覆蓋。',
    'service-plan.phpSettingsTabDescriptionAddon' => '您可在此為每個訂閱指定 PHP 設定，覆蓋主要服務方案定義的設定。例如，當您想要移除在主要服務方案中設定的一些 PHP 限制時，可進行此設定。當您設定一個參數為預設值時，PHP 將會使用來自服務方案 PHP 配置的參數值。注意支援使用以下預留位置：{DOCROOT} 和 {WEBSPACEROOT} 代表獲取自訂 PHP 配置的某個域名的文檔根目錄和某個訂閱的根目錄；{TMP} 代表存儲暫存檔案的目錄。',
    'service-plan.phpSettingsPhpVersion' => '您目前 PHP 版本是 %%version%%。',
    'service-plan.phpSettingsTabAdminPlanDescription' => '您可在此為每個訂閱指定 PHP 設定，覆蓋伺服器級的 php.ini 檔定義的設定。當您設定一個參數為預設值時，PHP 將會使用來自伺服器級的 PHP 配置的參數值。',
    'service-plan.webServerSettingsTab' => 'Web 伺服器',
    'service-plan.webServerSettingsTabDescription' => '在此處您可以指定該服務方案的 Apache web 伺服器設定。如果 Apache正在使用 nginx 作為前端伺服器。您也可在該頁面上指定 nginx 設定。所有新創建的域將會接收指定的設定。但是，當您更改這些設定時，現有域將不會接收修改。',
    'service-plan.servicesTab' => '服務',
    'service-plan.servicesTabDescription' => '在此處您可以指定分配給服務方案的服務。',
    'service-plan.servicePropertiesTab' => '%%serviceName%% 屬性',
    'service-plan.servicePropertiesTabDescription' => '在此處您可以指定分配給服務方案的 %%serviceName%% 服務的屬性。',
    'service-plan.longTaskWarning' => '在該方案上您有 %%subscriptionsCount%% 個訂閱。注意同步任務可能需要大量時間而將要在後臺執行。',
    'service-plan.hostingParametersTab' => '主機參數',
    'service-plan.adminInfoSection' => '管理員的資訊',
    'service-plan.descriptionInPanel' => '描述',
    'service-plan.longDescription' => '指定的描述太長。',
    'service-plan.conflictPermissions' => '無法授予以下許可權因為它們與代理商方案相衝突：%%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => '啟動類型',
    'services.change-startup-type.autoStartupTypeLabel' => '自動',
    'services.change-startup-type.manualStartupTypeLabel' => '手動',
    'services.change-startup-type.disabledStartupTypeLabel' => '禁用',
    'services.change-startup-type.autoActionError' => '無法設定啟動類型為 \'自動\'：%%error%%',
    'services.change-startup-type.manualActionError' => '無法設定啟動類型為 \'手動\'：%%error%%',
    'services.change-startup-type.disableActionError' => '無法設定啟動類型為 \'禁用\'：%%error%%',

    'sessions.settings.restoreDefaultButton' => '重設為預設值',
    'sessions.settings.restoreDefaultButtonDescription' => '恢復會話參數為預設值。',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => '會話參數有預設值。',
    'sessions.settings.idleTime' => '會話閒置時間',
    'sessions.settings.disableCheckSessionIp' => '允許在單個會話期間更改 IP 位址',
    'sessions.settings.minuteShortTitle' => '分鐘',

    'settings-ui.controls.title' => '控制項',

    'settings-ui.interface-views.description' => "有多個產品 UI 視圖供您使用。因您使用視圖的不同，各個功能與設定所處的位置會不同，甚至啟用/禁用的狀態也會不同。不同的視圖適合不同類型的用戶。",
    'settings-ui.interface-views.panelSimpleLink' => '工具 & 設定> 限制模式設定',
    'settings-ui.interface-views.useCustomView' => '啟用限制模式',
    'settings-ui.interface-views.useCustomViewHint' => '選擇此選項來限制管理員可以在Plesk面板中採取操作的次數。若要更改操作的可用性，請轉到%%customViewSettingsLink%%。',
    'settings-ui.interface-views.powerUserViewHint' => '此視圖最適合於管理網站、其檔、資料庫、電子郵件帳戶、web應用程式和其他服務。',
    'settings-ui.interface-views.selectUiModeTitle' => "選擇介面",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "高級使用者視圖（面向開發者和 web 代理）",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "服務提供者視圖（面向 web 主機提供商）",
    'settings-ui.interface-views.uiModeHintServiceProvider' => '此視圖適用於那些使用服務方案向其客戶提供和銷售 web 主機服務的伺服器管理員。',
    'settings-ui.interface-views.visibilityMailBounce' => '隱藏彈出控制項',
    'settings-ui.interface-views.visibilityMailBounceHint' => '隱藏“允許設定如何處理發送到不存在的電子郵寄地址的郵件”的按鈕',

    'settings-ui.branding.description' => '可通過更改在瀏覽器標題列中顯示頁面的方式和/或替換左上角的 Plesk 徽標來自訂 Plesk 介面品牌。',
    'settings-ui.branding.buttonDefault' => '默認徽標',
    'settings-ui.branding.sectionTitle' => '自訂標題',
    'settings-ui.branding.enableCustomTitle' => '在Plesk頁面上啟用自訂標題',
    'settings-ui.branding.customTitle' => '標題文本',
    'settings-ui.branding.sectionLogo' => '自訂徽標',
    'settings-ui.branding.enableCustomLogo' => '啟用自訂面板徽標',
    'settings-ui.branding.logo' => '徽標文件',
    'settings-ui.branding.logoUrl' => '徽標 URL',
    'settings-ui.branding.logoUrlEnabled' => '自訂',
    'settings-ui.branding.logoUrlDisabled' => '默認',
    'settings-ui.branding.sectionFavicon' => '自訂網站圖示',
    'settings-ui.branding.enableCustomFavicon' => '啟用自訂網站圖示',
    'settings-ui.branding.sectionFaviconDesc' => '為了在不同的流覽器中提供更好的支援，必須以兩種格式上傳相同的網站圖示。',
    'settings-ui.branding.faviconSvg' => '網站圖示檔 SVG',
    'settings-ui.branding.faviconSvgHint' => '允許的格式：SVG',
    'settings-ui.branding.faviconIco' => '網站圖示檔 ICO',
    'settings-ui.branding.faviconIcoHint' => '允許的格式：ICO',
    'settings-ui.branding.show' => '顯示',
    'settings-ui.branding.updateSuccess' => 'Plesk 品牌自訂屬性已更改。',
    'settings-ui.branding.sectionBackground' => '自訂登入畫面背景',
    'settings-ui.branding.enableCustomBackground' => '啟用背景圖像',
    'settings-ui.branding.backgroundFile' => '背景圖片',
    'settings-ui.branding.backgroundColor' => '背景顏色',
    'settings-ui.branding.backgroundResetColor' => '重設',
    'settings-ui.branding.backgroundFit' => '背景貼合',
    'settings-ui.branding.background.fit.fill' => '填滿畫面',
    'settings-ui.branding.background.fit.fit' => '貼合畫面',
    'settings-ui.branding.background.fit.center' => '中心',
    'settings-ui.branding.background.fit.tile' => '方塊',

    'sitebuilder.trial.description' => '您可在此配置 試用後購買 方案。通過此方案客戶能夠使用 Presence Builder 裡所有可用的功能創建網站。但是他們若要發佈試用網站，則必須購買主機服務方案或附加方案。現有客戶也可通過一個主機方案或一個附加方案享用 試用後購買 模式。%%link%%',
    'sitebuilder.trial.descriptionLink' => '參閱文檔瞭解更多資訊。',
    'sitebuilder.trial.lifetimeLabel' => '試用網站期限',
    'sitebuilder.trial.lifetimeUnits' => '天',
    'sitebuilder.trial.lifetimeDescription' => '在這顯示這些未購買的試用網站多長時間將從伺服器上移除。',
    'sitebuilder.trial.signupLabel' => '啟用公共存取試用模式',
    'sitebuilder.trial.signupDescription' => '如果您想要通過推廣配置有 Presence Builder 的主機或通過提供 Presence Builder 演示來吸引客戶，則可以啟用公共存取試用模式，在您的網站上發佈存取試用模式的 URL。',
    'sitebuilder.trial.signupLinkLabel' => '存取試用模式的 URL',
    'sitebuilder.trial.signupLinkDescription' => '此 URL 將在試用模式裡打開 Presence Builder。在您的網站上發佈URL 以吸引客戶。',
    'sitebuilder.trial.promotionLabel' => '在 Presence Builder 編輯器裡顯示試用模式提示',
    'sitebuilder.trial.promotionDescription' => '如果您想要顯示有關 Presence Builder 試用模式的其它通知可使用該選項。',

    'update-settings.policyHintForPum' => '您可以在此設定自動安裝更新。當有可進行手動安裝的更新或更新已被自動安裝時發送通知郵件。',
    'update-settings.policyHint' => '當有可進行手動安裝的更新或更新已被自動安裝時發送通知郵件。',
    'update-settings.branchDisabledDescription' => '不要通知我有關升級版的資訊',
    'update-settings.automaticPatchesInstallation' => '自動安裝 Plesk 更新（推薦）',
    'update-settings.automaticPatchesThirdParty' => '自動為 Plesk 附帶的協力廠商組件安裝更新',
    'update-settings.automaticSystemPackageUpdates' => '自動安裝系統套裝程式更新',
    'update-settings.automaticSystemPackageUpdatesHint' => '注意這將自動為 Plesk 附帶的協力廠商組件安裝更新',
    'update-settings.installerProxyMode' => '透過 Plesk 主機名稱與埠存取 Plesk 安裝程式',
    'update-settings.installerProxyModeHint' => '在不開啟防火牆額外 8447 TCP 埠的前提下，存取 Plesk 安裝程式網頁介面。',
    'update-settings.automaticPatchesNotification' => '通知有關可用的和已安裝的系統包更新的資訊',
    'update-settings.systemPackageUpdatesNotificationsEmail' => '電郵地址',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '通知郵件頻率',
    'update-settings.daily' => '每天',
    'update-settings.weekly' => '每週',
    'update-settings.generalSection' => '常規',
    'update-settings.notificationsSection' => '通知',
    'update-settings.safeUpdatesSection' => '安全更新',
    'update-settings.safeUpdatesSectionHint' => 'Plesk 保證了會從初始安裝系統包的相同 repository 安裝系統包更新。此類更新比較安全。如果您禁用了安全更新，您的系統包管理器可能會從系統中的任一 repository 安裝更新。',
    'update-settings.safeUpdatesSectionWarn' => '我們建議您保留啟用安全更新，除非您是高級用戶。從其它任意 repositories 更新系統包可能會對您的伺服器的正常運行產生不利影響。',
    'update-settings.allowSafeUpdates' => '啟用安全更新系統包',

    'requiredFields' => '必填欄位',

    'ip-ban.banned-ip.ipAddress' => 'IP 地址',
    'ip-ban.banned-ip.hintIpAddress' => 'IP 地址或 CIDR 遮罩。',
    'ip-ban.banned-ip.banType' => '禁止 IP 地址： ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => '為期一週',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => '永久',

    'server-mail-smarthost.settings.title' => '智慧主機設定',
    'server-mail-smarthost.settings.useSmarthost' => '透過智慧主機發送使用者的電子郵件',
    'server-mail-smarthost.configuration.title' => '智慧主機設定',
    'server-mail-smarthost.configuration.hostnameOrIP' => '主機名稱或 IP 地址',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => '若想停用 MX 或 SRV 查找，請在方框中輸入主機名稱或 IP 位址，例如：[example.com]',
    'server-mail-smarthost.configuration.checkConnection' => '查看連線',
    'server-mail-smarthost.configuration.port' => '埠',
    'server-mail-smarthost.configuration.username' => '用戶名',
    'server-mail-smarthost.configuration.password' => '密碼',
    'server-mail-smarthost.configuration.encryption' => '加密連線',
    'server-mail-smarthost.configuration.encryption.Unix.on' => '需要',
    'server-mail-smarthost.configuration.encryption.Unix.off' => '不需要',
    'server-mail-smarthost.configuration.encryption.Windows.off' => '無',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => '需要驗證',
    'server-mail-smarthost.configuration.checkConnection.success' => '已建立與智慧主機間的連線。',
    'server-mail-smarthost.success' => '智慧主機的配置已變更。',
    'server-mail-smarthost.settings.noteTitle' => '請注意：',
    'server-mail-smarthost.settings.note' => '%%title%% 若您設定透過智慧主機發送電子郵件，需要手動更新 SPF、DNS 範本內的其他相關 DNS 紀錄，以及既有網域的 DNS 區域。若想透過智慧主機發送電子郵件，此為避免驗證錯誤的必要步驟。%%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => '查看更多詳情。',
];