<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propriedades da Chave Adicional',
    'additional-key-info.update' => 'Recupere a chave adicional',
    'additional-key-info.updateDescription' => 'Recuperar a chave adicional e instalá-la.',
    'additional-key-info.download' => 'Fazer download da chave',
    'additional-key-info.downloadDescription' => 'Efetuar o download da chave de licença atual.',
    'additional-key-info.install' => 'Instale a chave',
    'additional-key-info.installDescription' => 'Instale a chave de licença atual.',
    'additional-key-info.revert' => 'Reverta a chave',
    'additional-key-info.revertDescription' => 'Reverta para a chave de licença instalada anteriormente.',
    'additional-key-info.revertNotAvailableDescription' => 'Nenhuma chave instalada.',
    'additional-key-info.installSuccess' => 'A instalação da chave de licença foi iniciada.',

    'additional-key-revert.title' => 'Reversão de Chave adicional',
    'additional-key-revert.success' => 'A chave adicional foi revertida.',

    'additional-key-upload.title' => 'Instalar uma Chave de Licença',
    'additional-key-upload.success' => 'A nova chave adicional foi carregada.',

    'additional-keys.title' => 'Chaves de Licença Adicionais',

    'change-owner.title' => 'Reatribuição de assinaturas selecionadas',

    'customers.hint' => 'Você pode gerenciar as contas de seus clientes de serviços de hospedagem aqui: criar contas juntamente com assinaturas de serviços, gerenciar clientes existentes e remover contas. Para administrar websites, e-mails e quaisquer outros serviços fornecidos a um cliente, vá até seus painéis de controle clicando no link Painel do Cliente na lista.',

    'customer-domains.hint' => 'Esta é a área em que você configura e gerencia web sites.',

    'customer-subscriptions.hint' => 'Você pode gerenciar as assinaturas do cliente aqui.',

    'domains.hint' => 'Aqui é onde você visualiza as informações sobre todos os nomes de domínios registrados no sistema e pode continuar a gerenciar os serviços de hospedagem. Para adicionar um domínio para si ou para os clientes da hospedagem, apenas clique em Adicionar Domínio. Você poderá criar um novo cliente e assinatura enquanto cria um domínio, ou selecionar de domínios existentes.',

    'database-servers.title' => 'Servidores de base de dados',

    'database-server-create.title' => 'Novo servidor de banco de dados',

    'database-server-properties.title' => 'Servidor do banco de dados',

    'database-server-upgrade.title' => 'Atualização do servidor do banco de dados',
    'database-server-upgrade.currentVersion' => 'Versão atual',
    'database-server-upgrade.selectVersion' => 'Selecione uma versão',
    'database-server-upgrade.information' => 'Informações',
    'database-server-upgrade.releaseNotes' => 'Notas de lançamento',
    'database-server-upgrade.releaseDate' => 'Liberar data',
    'database-server-upgrade.unable' => 'Não foi possível atualizar',
    'database-server-upgrade.endOfLifeDate' => 'Data do fim da vida útil',
    'database-server-upgrade.description' => 'O MySQL/MariaDB é um sistema de gerenciamento de banco de dados relacional muito utilizado e que é um serviço central na maioria dos sistemas Plesk. Esta interface permite que você atualize seu servidor MySQL/MariaDB para uma versão 10.6. A Plesk atualizará automaticamente sua instalação do MySQL/MariaDB para novas versões pontuais (o terceiro dígito na string de versão), pois essas atualizações envolvem baixo risco aos dados dos seus usuários. As atualizações para novas versões importantes (os primeiros dois dígitos na string de versão) são mais complexas, pois existe um risco substancial de perda de dados. Esta interface tentará guiá-lo pelo processo de atualização da versão mais importante.',
    'database-server-upgrade.warning' => 'Embora atualizações pontuais sejam geralmente seguras, recomendamos fortemente que você faça um backup completo do banco de dados antes de fazer a atualização. Os downgrades para versões mais antigas não são suportados. A reversão para uma versão anterior após atualizar o servidor do banco de dados pode não ser possível. Substituir o MariaDB pelo MySQL 8 é considerado downgrade e não é suportado.',

    'database-server-databases.title' => 'Bancos de dados',

    'database-server-change-password.title' => 'Senha do Administrador',

    'home.title' => 'Página inicial',

    'license.title' => 'Informações de licença',

    'primary-key-info.title' => 'Chave de Licença do Plesk',
    'primary-key-info.update' => 'Recuperar Chaves',
    'primary-key-info.updateDescription' => 'Recuperar chaves de licença solicitadas e instalá-las.',
    'primary-key-info.upload' => 'Instale a chave',
    'primary-key-info.uploadDescription' => 'Fazer upload e instalar uma nova chave de licença.',
    'primary-key-info.revert' => 'Reverta a chave',
    'primary-key-info.revertDescription' => 'Reverta para a chave de licença instalada anteriormente.',

    'primary-key-revert.title' => 'Reversão da Chave de Licença',
    'primary-key-revert.success' => 'A chave Plesk foi revertida.',

    'primary-key-upload.title' => 'Instalar uma Chave de Licença',
    'primary-key-upload.success' => 'A nova chave do Plesk foi carregada.',

    'resellers.hint' => 'Aqui é onde você gerencia as contas de revendedores — de seus clientes que revendem serviços de hospedagem e hospedam seus próprios websites. Aqui você cria contas juntamente com assinaturas de serviços, gerencia clientes existentes e remove contas.',

    'reseller-customers.hint' => 'Esta é a área em que você configura e gerencia clientes.',

    'reseller-domains.hint' => 'Esta é a área em que você configura e gerencia web sites.',

    'reseller-subscriptions.hint' => 'É aqui que você gerencia as assinaturas do revendedor.',

    'subscriptions.hint' => 'Os clientes obtêm os serviços de hospedagem de você assinando um plano de hospedagem. É possível gerenciar essas assinaturas aqui, bem como suas próprias assinaturas criadas para hospedar seus websites. Para administrar websites, e-mails e quaisquer outros serviços fornecidos com uma assinatura, vá até o Painel do Cliente do assinante clicando no link Painel de Controle na lista.',

    'server-mail-settings.title' => 'Configurações',
    'server-mail-spam-filter.title' => 'Filtragem de spam',
    'server-mail-antivirus.title' => 'Antivírus',
    'server-mail-black-list.title' => 'Lista negra',
    'server-mail-white-list.title' => 'Lista branca',
    'server-mail-queue.title' => 'Fila de e-mails',
    'server-mail-statistics.title' => 'Estatísticas',

    'firewall.title' => 'Gerenciamento do firewall',
    'firewall-general.title' => 'Geral',
    'firewall-general.toggleStatus' => 'Proteção de firewall',
    'firewall-general.buttonDefault' => 'Redefinir para Padrão',
    'firewall-general.buttonPanic' => 'Modo de pânico',
    'firewall-general.confirmationDefault' => 'Redefinir as configurações do firewall para os padrões?',
    'firewall-general.confirmationPanic' => 'Ativar o modo de pânico? Os usuários não poderão acessar seus domínios e alguns serviços de rede podem parar de funcionar.',
    'firewall-general.successDefault' => 'As configurações do firewall foram redefinidas para os padrões.',
    'firewall-general.successPanic' => 'O modo de pânico foi ativado.',
    'firewall-general.info' => 'Por motivos de segurança, o firewall bloqueia todas as conexões, com exceção daquelas explicitamente permitidas. Você pode permitir uma conexão criando uma regra. Consultar a documentação para mais informações',
    'firewall-general.interfaces' => 'Interfaces de rede',
    'firewall-icmp.title' => 'Protocolo ICMP',
    'firewall-rules.title' => 'Regras do firewall',

    'dns.title' => 'Configurações de DNS',
    'dns-records.title' => 'Modelo de Registros de Zona',
    'dns-soa-record.title' => 'Modelo de configurações de zona',

    'php-handler.title' => 'Configurações para %%name%%',
    'php-handler.extensions.title' => 'Extensões',
    'php-handler.extensions.description' => 'Estas configurações das extensões do PHP são apenas para este manipulador.',
    'php-handler.extensions.descriptionShared' => 'Estas configurações são comuns para os seguintes manipuladores PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',
    'php-handler.extensions.buttonManage' => 'Gerenciar Pacotes PECL',
    'php-handler.extensions.manage.title' => 'Gerenciar Pacotes PECL',
    'php-handler.extensions.manage.risks' => 'As extensões PHP são fornecidas por pacotes PECL de terceiros. Você os está instalando por sua conta e risco.',
    'php-handler.extensions.manage.description' => 'Instalar, atualizar e desinstalar pacotes PECL. As alterações serão aplicadas a todos os websites em execução no %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Por que o pacote desejado não está na lista?',
    'php-handler.extensions.manage.limitations' => 'As extensões PHP enviadas pelo provedor do painel de controle e pelos fornecedores do sistema operacional não são mostradas na lista.',
    'php-handler.php-ini.title' => 'php.ini',

    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. Todos os direitos reservados.',
    'ServerAbout.linkLicenseManagement' => 'Vá para Informações de Licença',
    'ServerAbout.panelVersion' => 'Versão',
    'ServerAbout.installedPatchVersion' => 'Atualização nº%%patch%%',
    'ServerAbout.licenseKey' => 'Chave de licença',
    'ServerAbout.productDescription' => 'Plesk é a principal plataforma WebOPS usada para executar, automatizar e desenvolver aplicativos, sites e empresas de hospedagem.',
    'ServerAbout.readEula' => 'Leia %%link%%.',
    'ServerAbout.linkEula' => 'Contrato de Licença do Usuário Final',
    'ServerAbout.visitForum' => 'Visite %%link%%',
    'ServerAbout.linkForum' => 'Fórum Plesk',
    'ServerAbout.followUs' => 'Siga-nos',
    'ServerAbout.visitSite' => 'Aprenda mais em %%link%%.',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Encontre inspiração em %%link%%.',
    'ServerAbout.linkBlog' => 'Blog Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Parabéns!',
    'ServerAbout.darkThemePromoDescription' => 'Você encontrou um gatinho mágico adicionado na versão de aniversário Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Vruum! Venha para o lado obscuro',
    'ServerAbout.darkThemeTourDescription' => 'Mude esta opção para habilitar ou desabilitar o tema escuro para sua interface.',
    'ServerAbout.darkThemeTourButton' => 'Consegui',

    'ts-sessions.title' => 'Sessões do Terminal do Servidor',
    'ts-sessions-properties.title' => 'Propriedades da sessão',

    'BandwidthLimiting.title' => 'Limitação de Largura de Banda para %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Não é possível controlar a limitação da largura de banda porque o QoS não está instalado.',
    'BandwidthLimiting.virtualHostingRequired' => 'A limitação de largura de banda está disponível apenas para domínios com hospedagem na web.',
    'BandwidthLimiting.bandwidthLabel' => 'Uso máximo da largura de banda',
    'BandwidthLimiting.bandwidthHint' => 'O limite de uso de largura de banda é aplicado apenas aos dados transferidos por meio do protocolo HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Conexões limitadas a',
    'BandwidthLimiting.maxConnectionHint' => 'Se você limitar a largura de banda, recomendamos que também limite o número de conexões simultâneas ao website. Caso contrário, em caso de solicitações frequentes ao website, os processos do servidor da Web aumentarão a carga do servidor.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'As configurações de limitação de largura de banda foram alteradas.',
    'BandwidthLimiting.unlimited' => 'Ilimitado',

    'ip-address-domains.title' => 'Websites que usam %%type%% endereço IP %%ipAddress%%',
    'ip-address-domains.site' => 'Website',
    'ip-address-domains.setAsDefault' => 'Definir como padrão',
    'ip-address-domains.type-SHARED' => 'compartilhado',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicado',

    'HotlinkProtection.title' => 'Proteção de Hotlink para %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'A Proteção Hotlink está disponível apenas para domínios com hospedagem na web.',
    'HotlinkProtection.enabledLabel' => 'Ativar proteção hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensões de arquivo protegidos',
    'HotlinkProtection.friendsLabel' => 'Endereços de websites amigáveis',
    'HotlinkProtection.success' => 'As configurações de proteção de hotlink foram alteradas.',

    'Odbc.serverTitle' => 'Conexões DSN ODBC',
    'Odbc.domainTitle' => 'Conexão ODBC DSN para %%domainName%%',
    'Odbc.add' => 'Adicionar ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% criado / %%allowed%% permitido.',
    'Odbc.limitExceeded' => 'O limite de conexão ODBC DSN foi excedido.',
    'Odbc.unlimited' => 'Ilimitado',
    'Odbc.addTooltip' => 'Adicionar a fonte de dados ODBC.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Nome da conexão',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Descrição da conexão',
    'Odbc.hostname' => 'Hostname',
    'Odbc.statusSystem' => 'É um sistema DSN.',
    'Odbc.statusConfigured' => 'O DSN está configurado.',
    'Odbc.statusNotConfigured' => 'O DSN não está configurado.',
    'Odbc.noSelectionText' => 'Selecione um ou mais itens para remover.',
    'Odbc.removeConfirmation' => 'Remover {count, plural, one {}=1 {a conexão {name}} other {# conexões selecionadas}}?',
    'Odbc.removeSuccess' => 'As conexões selecionadas foram removidas.',

    'DomainAliasSettings.title' => 'Configurações de Alias de Domínio',
    'DomainAliasSettings.updateSuccess' => 'As propriedades do alias de domínio %%name%% foram alteradas. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'As configurações de website serão aplicadas em %%restartInterval%% minutos.',

    'HostingSettings.title' => 'Configurações de hospedagem',
    'HostingSettings.updateSuccess' => 'As configurações foram atualizadas.',
    'HostingSettings.emptyLogin' => 'Você precisa especificar um nome de usuário.',
    'HostingSettings.emptyPassword' => 'Você precisa especificar uma senha.',
    'HostingSettings.ipV6OnlyNotSupported' => 'O servidor de FTP não suporta IPv6. Efetue a alocação de um endereço IPv4 no mínimo; caso contrário, o usuário não poderá efetuar upload dos arquivos para o servidor via FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Configurações de domínio',
    'HostingSettings.domainSettingsSection.domainName' => 'Nome do domínio',
    'HostingSettings.domainSettingsSection.description' => 'Por exemplo, exemplo.com ',

    'HostingSettings.submitPopover.title' => 'Remover o conteúdo de %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Mudar o tipo de hospedagem do "Site" para "%%type%%" removerá permanentemente todo o conteúdo do site, incluindo os seguintes diretórios:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Você deseja mudar o tipo de hospedagem para seu site?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Para acessar mais configurações, insira as credenciais de usuário do sistema e clique em "Criar espaço na web".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Para acessar mais configurações, clique em "Próximo" para criar a hospedagem.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipo de hospedagem',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipo',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Site',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redirecionamento',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Sem hospedagem web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Use a zona DNS do domínio para ter caixas de e-mail sob este nome de domínio',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Especifique o caminho para o diretório principal do website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Os visitantes serão redirecionados usando um redirecionamento HTTP 301 amigável de SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Encaminhar visitantes para',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipo de redirecionamento',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Movido permanentemente (código 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirecione os vistantes do site para outro site e mostre o endereço de destino. Esse redirecionamento manterá a classificação de pesquisa do website',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Movido permanentemente (código 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirecione os visitantes do site para uma cópia temporária do site quando você não quiser buscar os mecanismos para indexar este site temporário.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Redirecionamento de quadro',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirecionar os visitantes do site para outro site, mas não mostrar-lhes o endereço de destino, para que não saibam sobre o redirecionamento.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Nenhuma',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Documento raiz',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Não é possível alterar o documento raiz, porque existem aplicativos web instalados neste website.',
    'HostingSettings.domainSettingsSection.save' => 'Salvar',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Alterar esta configuração?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Alterar essa configuração contradiz a política de segurança do servidor e pode prejudicar o desempenho ou tornar o servidor vulnerável a ataques.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Trocar',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Reverter',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'A predefinição de configurações seguras é aplicada',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Para maior segurança, aplique a predefinição de configurações seguras. Observe que certas permissões permitem que os assinantes modifiquem essas configurações.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicar predefinição segura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Saiba mais sobre as configurações de hospedagem segura',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Suporte SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Habilitado',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Conexões criptografadas entre o site e o navegador do visitante.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificado',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Para habilitar o HTTPS, faça o upload de um certificado SSL/TLS no repositório do domínio, depois selecione-o aqui.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirecionar visitantes de HTTP ára HTTPS usando um redirecionamento 301 amigável do SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Não há certificados SSL/TLS no seu repositório. Para adicionar um certificado, vá em %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'esta página',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (outro repositório)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Não selecionado',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Selecione quais linguagens de programação e script devem ser interpretadas pelo servidor web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'o diretório cgi-bin está localizado em %%value%%.',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Utilizar o SSI para arquivos *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versão do Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documentos de erro customizados',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'o diretório cgi-bin está localizado em',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'o documento raiz deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'o diretório raiz do espaço web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'o documento raiz de estilo antigo deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documentos de erro customizados',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permissões adicionais de gravação/modificação',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicação do Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Estatísticas da web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Ferramenta',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Proteger o acesso às suas estatísticas da web com seu nome de usuário e senha FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Desabilitado',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Configurações de espaço web',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Endereços IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Cota de espaço em disco',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Habilitado',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Proibir operações nos arquivos do site se a cota de espaço em disco definida nas configurações de assinatura (caso houver) for excedida.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'A cota do disco rígido não é suportada devido à configuração do sistema de arquivos do servidor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credenciais de usuário do sistema',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gerencie os arquivos e pastas do site via FTP ou Gerenciador de arquivos. Acesse o servidor via SSH, se permitido.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gerencie os arquivos e pastas do site via FTP ou Gerenciador de arquivos. Acesse o servidor via Área de trabalho remota, se permitido.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nome do usuário',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Senha',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Especifique uma nova senha aqui para mudar a senha do usuário do sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Acesso SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Acesso à Área de Trabalho remota',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Habilitado',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Acesse o servidor com as credenciais do usuário do sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipo',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Desabilitado',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'For {count, plural, one {}other {# domínios}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'As seguintes configurações são mútuas para todos {count, plural, one {}other {# domínios no espaço web {name}}}:',

    'OdbcAdd.title' => 'Adicionar um ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nome da conexão',
    'OdbcAdd.descriptionLabel' => 'Descrição da conexão',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Criar ODBC DSN',

    'OdbcEdit.title' => 'Configurar uma Conexão ODBC',
    'OdbcEdit.saveSuccess' => 'As configurações de conexão foram salvas.',
    'OdbcEdit.test' => 'Teste de conexão',
    'OdbcEdit.connectSuccess' => 'Conexão com êxito.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Caminho do arquivo de banco de dados',
    'OdbcEdit.excel.defaultdir.label' => 'Diretório de dados padrão',
    'OdbcEdit.excel.fil.label' => 'Versão do banco de dados',
    'OdbcEdit.excel.maxbuffersize.label' => 'Tamanho máx. de buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Timeout de página',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Caminho do arquivo de banco de dados',
    'OdbcEdit.access.uid.label' => 'ID de login',
    'OdbcEdit.access.pwd.label' => 'Senha',
    'OdbcEdit.access.pagetimeout.label' => 'Timeout de página',
    'OdbcEdit.access.pagetimeout.description' => 'O período, em décimos de segundo, que uma página não utilizada permanece no buffer. Esta opção se aplica para todas as fontes de dados que utilizam o driver do Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Tamanho máx. de buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'O tamanho do buffer interno, em KB, alinhado no limite de 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Somente leitura',
    'OdbcEdit.access.readonly.description' => 'Designar o banco de dados como somente leitura e proibir qualquer atualização.',
    'OdbcEdit.access.exclusive.label' => 'Exclusivo',
    'OdbcEdit.access.exclusive.description' => 'Designar o banco de dados como exclusivo para proibir atualizações compartilhadas.',
    'OdbcEdit.access.safetransactions.label' => 'Transações seguras',
    'OdbcEdit.access.safetransactions.description' => 'Se definido para 0 (a configuração-padrão), todas as transações são confirmadas imediatamente. Se definido para 0, todas as transações são salvas para o disco apenas mediante uma operação de confirmação, mas o desempenho cai um pouco.',
    'OdbcEdit.access.threads.label' => 'Tópicos',
    'OdbcEdit.access.threads.description' => 'O número de threads em segundo plano para o mecanismo utilizar.',
    'OdbcEdit.access.maxscanrows.label' => 'Máx. de linhas para escanear',
    'OdbcEdit.access.maxscanrows.description' => 'O número de linhas a ser escaneado ao definir o tipo de dados de uma coluna com base nos dados existentes.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Especificar como as alterações feitas fora de uma transação são gravadas no banco de dados.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Especificar se o driver do MS Access realizará transações definidas pelo usuário explícitas assincronicamente.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Servidor',
    'OdbcEdit.mssql.uid.label' => 'ID de login',
    'OdbcEdit.mssql.pwd.label' => 'Senha',
    'OdbcEdit.mssql.database.label' => 'Banco de Dados padrão',
    'OdbcEdit.mssql.app.label' => 'Nome do aplicativo',
    'OdbcEdit.mssql.wsid.label' => 'ID de estação de trabalho',
    'OdbcEdit.mssql.language.label' => 'Idioma-padrão',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversão de caracteres estendidos para os valores OEM',

    'OdbcEdit.mysql.driver.label' => 'Driver do MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Servidor',
    'OdbcEdit.mysql.server.description' => 'O nome do host do servidor MySQL',
    'OdbcEdit.mysql.database.label' => 'Banco de Dados padrão',
    'OdbcEdit.mysql.user.label' => 'Nome do usuário',
    'OdbcEdit.mysql.user.description' => 'O nome de usuário utilizado para a conexão ao MySQL',
    'OdbcEdit.mysql.password.label' => 'Senha',
    'OdbcEdit.mysql.password.description' => 'A senha para a conta de usuário no servidor',
    'OdbcEdit.mysql.port.label' => 'Porta',
    'OdbcEdit.mysql.port.description' => 'A porta TCP/IP a ser utilizada se o servidor não for o host local',
    'OdbcEdit.mysql.socket.label' => 'Soquete',
    'OdbcEdit.mysql.socket.description' => 'Pipe nomeado do Windows a ser conectado se o servidor for o host local',
    'OdbcEdit.mysql.option.label' => 'Opção',
    'OdbcEdit.mysql.option.description' => 'Opções que especificam como o MyODBC deve funcionar. Consulte a <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentação</a>',

    'ProtectedDirectoryList.title' => 'Diretórios Protegidos de %%domainName%%',
    'ProtectedDirectoryList.add' => 'Acrescente o diretório protegido',
    'ProtectedDirectoryList.addTooltip' => 'Criar um diretório protegido.',
    'ProtectedDirectoryList.name' => 'Nome',
    'ProtectedDirectoryList.realmTitle' => 'Título da área protegida',
    'ProtectedDirectoryList.noSelectionText' => 'Selecione um ou mais itens para remover.',
    'ProtectedDirectoryList.edit' => 'Editar',
    'ProtectedDirectoryList.remove' => 'Remover a proteção',
    'ProtectedDirectoryList.removeTooltip' => 'Remover a proteção dos diretórios selecionados.',
    'ProtectedDirectoryList.removeConfirmation' => 'Esta operação resultará na remoção da proteção de {count, plural, one {}=1 {o diretório {name}} other {# diretórios selecionados}}. {count, plural, one {}=1 {Este diretório} other {Os diretórios}} se tornará acessível aos usuários da Internet.',
    'ProtectedDirectoryList.removeSuccess' => 'Os diretórios selecionados foram removidos.',

    'ProtectedDirectoryAdd.title' => 'Criar um Diretório Protegido',
    'ProtectedDirectoryAdd.submit' => 'Criar',
    'ProtectedDirectoryAdd.success' => 'O diretório protegido %%path%% foi criado com êxito',

    'ProtectedDirectoryEdit.title' => 'Configurações de Diretório Protegido',
    'ProtectedDirectoryEdit.success' => 'As configurações do diretório protegido foram alteradas',

    'SummaryReport.Layout.title' => 'Propriedades do layout de relatório',
    'SummaryReport.Layout.success' => 'O layout de relatório %%name%% foi atualizado.',

    'SummaryReport.Layout.Add.title' => 'Criar um layout de relatório',
    'SummaryReport.Layout.Add.success' => 'O layout de relatório %%name%% foi criado.',
];