<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Logfiler",
    'action-log.fromDate' => "Fra:",
    'action-log.toDate' => "Til:",
    'action-log.clearLog' => "Ryd Log",
    'action-log.downloadLog' => "Download",
    'action-log.loggedActions' => "Loggede handlinger",
    'action-log.storeLogsInDb' => "Gem poster i databasen",
    'action-log.storeNumber' => "Indlæg",
    'action-log.dontRemoveRecs' => "Fjern ikke poster",
    'action-log.confirmCleanLog' => "Er du sikker på, at du vil slette de markerede handlingslog-poster?",
    'action-log.incorrectDate' => "Der er angivet en ugyldig dato.",
    'action-log.incorrectNumPeriods' => "Ugyldig rotationsperiode angivet.",
    'action-log.incorrectNumRecords' => "Ugyldigt antal poster angivet.",
    'action-log.yes' => "Ja",
    'action-log.no' => "Nej",
    'action-log.mixed' => "(blandet)",
    'action-log.period' => "Periode",
    'action-log.invalidDatePeriod' => "Ugyldig datoperiode",
    'action-log.submitDone' => "Ændringer af handlingslog indstillingerne blev gemt.",
    'action-log.clearDone' => "Handlingslog ryddet.",
    'action-log.periodDay' => "dage",
    'action-log.periodWeek' => "uger",
    'action-log.periodMonth' => "Måneder",

    'admin-info.adminInfoSection' => 'Information for administratoren',
    'admin-info.description-admin' => 'Administrators beskrivelse',
    'admin-info.description-reseller' => 'Forhandlers beskrivelse',
    'admin-info.description-owner' => 'Ejers beskrivelse',
    'admin-info.description' => 'Beskrivelse',
    'admin-info.descriptionSuccess' => 'Beskrivelsen blev opdateret.',
    'admin-info.longDescription' => 'Den angivne beskrivelse er for lang. Den kan ikke være længere end %%max%% symboler.',
    'admin-info.add' => 'Tilføj beskrivelse',
    'admin-info.edit' => 'Rediger',
    'admin-info.remove' => 'Slet',
    'admin-info.confirmOnRemove' => 'Vil du virkelig fjerne denne beskrivelse?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% for kunden %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% for forhandleren %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% for abonnementet %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% af %%name%%',
    'admin-info.popupHint-admin' => 'Denne beskrivelse er kun synlig for administrator.',
    'admin-info.popupHint-reseller' => 'Denne beskrivelse er synlig for forhandler og administrator.',
    'admin-info.popupHint-owner' => 'Denne beskrivelse er synlig for forfatteren og forfatterens hosting-udbyder.',
    'admin-info.customerDescriptionHint' => 'Kunder kan ikke se denne beskrivelse.',
    'admin-info.subscriptionDescriptionHint' => "Denne information er kun synlig for hosting-udbyderen (Plesk-administrator eller forhandler).",

    'apache-settings.formGeneralHint' => 'Her kan du angive Apache webserver-indstillinger for dette websted. Brugerdefineret Apache-konfiguration er eksempelvis nyttig hvis du vil bruge en ny type index-filer på dit websted, eller hvis du vil knytte en bestemt MIME-type sammen med bestemte filnavnsudvidelser. Standardværdien betyder, at Apache vil bruge det korresponderende direktiv fra den server-brede konfiguration. Hvis Apache kører med nginx som frontend-server, kan du også angive nginx-indstillingerne på denne side.',
    'apache-settings.general' => 'Almindelige Apache-indstillinger',
    'apache-settings.example' => "F.eks.:\n%%example%%",
    'apache-settings.settingOn' => 'Aktiveret',
    'apache-settings.settingOff' => 'Fra (standard)',
    'apache-settings.settingDefault' => 'Standard',
    'apache-settings.settingCustom' => 'Indtast brugerdefineret værdi',
    'apache-settings.mimeTypes' => 'MIME-typer',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME-typer knytter filnavnsudvidelser sammen med filtyper. Typisk bruges dette til oprettelse af en brugerdefineret filnavnsudvidelse til almindelige filtyper.',
    'apache-settings.handlers' => 'Handlere',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache-handlere definerer hvordan webserveren behandler filer med bestemte filnavnsudvidelser, når der anmodes om dem. Eksempelvis betyder strengen 'php-script .script' at Apache vil behandle .script-filer som php-scripts.",
    'apache-settings.deny' => 'Nægt adgang til webstedet',
    'apache-settings.allow' => 'Udelukker',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angivne hosts og netværk må ikke tilgå stedet. Brug '*' for at afvise alle forbindelser.",
    'apache-settings.allowExample' => "192.168.0.0/16 \n10.1.1.21 \n \nDe angivne hosts og netværk har tilladelse til at tilgå stedet.",
    'apache-settings.directoryIndex' => 'Indeksfiler',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache søger efter de angivne filer, når der anmodes om webstedets indeksside.",
    'apache-settings.expires' => 'Expires (Udløber)',
    'apache-settings.expiresStaticOnly' => 'respons med Expires-headers kun for statiske filer',
    'apache-settings.expiresFullDescription' => 'Webserveren vil tilføje “Expires” responsheaders til websider. Udløbs-tidsmærket hentes ved at tillægge den mængde tid, der er angivet ud over den tid det tager at anmode om en webside.',
    'apache-settings.expiresStaticOnlyDescription' => '"Expires" header vil kun blive føjet til statiske filer. Hvilke filer der behandles som statiske styres af "Smart behandling af statiske filer" og "Levér statiske filer direkte vha. nginx" indstillingerne.',
    'apache-settings.expiresUnitDays' => 'dage',
    'apache-settings.expiresUnitHours' => 'timer',
    'apache-settings.expiresUnitMinutes' => 'minutter',
    'apache-settings.expiresUnitSeconds' => 'sekunder',
    'apache-settings.expiresSize' => 'Varighed indtil udløb',
    'apache-settings.expiresUnitSize' => 'Enheder for varighed indtil udløb',
    'apache-settings.nginxCacheTimeoutSize' => 'Cache-timeout',
    'apache-settings.nginxCacheTimeoutUnitSize' => 'Enheder for cache-timeout',
    'apache-settings.headers' => 'Yderligere headers',
    'apache-settings.headersExample' => "Cache-kontrol: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: AFVIS",
    'apache-settings.headersFullDescription' => "Webserveren tilføjer de angivne HTTP-responsheadere.",
    'apache-settings.restrictFollowSymLinks' => 'Begræns evnen til at følge symbolske links',
    'apache-settings.restrictFollowSymLinksDescription' => "Vælg denne indstilling for at forhindre brugere i at anvende FollowSymLink direktivet i .htaccess og forbedre serverens sikkerhed.",
    'apache-settings.nginx' => 'nginx-indstillinger',
    'apache-settings.nginxProxyMode' => 'Proxy-tilstand',
    'apache-settings.nginxProxyModeDescription' => 'Nginx-proxyanmodninger til Apache Sluk og hold op med at bruge Apache.',
    'apache-settings.nginxHttp3Enabled' => 'HTTP/3-understøttelse',
    'apache-settings.nginxHttp3EnabledDescription' => 'Eksperimentel funktion. I sjældne tilfælde kan dette påvirke webstedets tilgængelighed.',
    'apache-settings.nginxTransparentMode' => 'Smart behandling af statiske filer',
    'apache-settings.nginxTransparentModeDescription' => 'Hvis deaktiveret vil Apache behandle alle anmodninger om statiske filer. og nginx vil kun videregive anmodninger og svar uden ændringer. Deaktivér kun denne indstilling ved fejlfinding.',
    'apache-settings.nginxServeStatic' => 'Levér statiske filer direkte vha. nginx',
    'apache-settings.nginxStaticExtensionsLabel' => 'Angiv filtyper ',
    'apache-settings.nginxStaticExtensions' => 'Angiv filnavnsudvidelsen, adskilt med mellemrum eller med symbolet "|". Anmodninger om disse filer vil blive håndteret af nginx og aldrig nå frem til Apache. Forsigtig: Apache\'s rewrite-regler vil ikke blive anvendt.',
    'apache-settings.nginxServePhp' => 'Behandl PHP-filer vha. nginx',
    'apache-settings.nginxServePhpDescription' => 'PHP-filer (.php) vil blive håndteret af nginx og PHP-FPM. Hvis deaktiveret vil PHP-filer blive behandlet af Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Maksimal tilladt størrelse på HTTP-anmodningens indhold',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Anmodninger med brødtekst der overstiger grænsen kasseres med HTTP 413 Payload Too Large (konfigurerer nginx-direktivværdien "client_max_body_size").',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Indstillingen er deaktiveret globalt via en tom/nul-værdi fra direktivet "clientMaxBodySize" i panelet.ini',
    'apache-settings.nginxCacheEnabled' => 'Aktiver nginx caching',
    'apache-settings.nginxCacheEnabledDescription' => 'Caching kan nedsætte webstedets responstid samt serverbelastningen, men bør anvendes med forsigtighed.',
    'apache-settings.nginxCacheSize' => 'Cache-størrelse',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Cache-timeout',
    'apache-settings.nginxCacheTimeoutDays' => 'dage',
    'apache-settings.nginxCacheTimeoutHours' => 'timer',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutter',
    'apache-settings.nginxCacheTimeoutSeconds' => 'sekunder',
    'apache-settings.nginxCacheKey' => 'Cache-nøgle',
    'apache-settings.nginxCacheCookies' => 'Cache-anmodninger med cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Deaktiver caching for steder',
    'apache-settings.nginxCacheBypass' => 'Forbigå cache når',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'HTTP-no-cache headere er modtaget i en forespørgsel',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'HTTP-godkendelsesheadere er modtaget i en forespørgsel',
    'apache-settings.nginxCacheBypassGetNocache' => 'GET nocache parameter er modtaget i en forespørgsel',
    'apache-settings.nginxCacheUseStale' => 'Returner stale-cached poster',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream returnerer 5xx klientfejl',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream returnerer 4xx klientfejl',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cache opdateres',
    'apache-settings.additional' => 'Ekstra Apache-direktiver',
    'apache-settings.additionalSettingsDescription' => 'Hvis du ikke kan finde bestemte indstillinger, kan du føje dem til felterne herunder. Disse indstillinger vil tilsidesætte de server-brede Apache-direktiver. Direktiverne fra det første felt bruges, når en besøgende tilgår stedet over HTTP. Det andet felt indeholder direktiverne for HTTPS. Generelt bør du tilføje direktiver i begge felter. Brug den samme syntaks som du ville til httpd.include. Hvis du f.eks. vil indstille en brugerdefinerede fejlside, skal du tilføje linjen: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Ekstra direktiver for HTTP',
    'apache-settings.additionalSslSettings' => 'Ekstra direktiver for HTTPS',
    'apache-settings.additionalSettingsError' => 'Ugyldig Apache-konfiguration: %%error%%',
    'apache-settings.rollbackFailed' => 'Kunne ikke bruge den nuværende Apache-konfigurationsfil og rulle tilbage til den foregående version af filen, fordi de begge indeholder en ugyldig konfiguration.',
    'apache-settings.additionalNginx' => 'Ekstra nginx-direktiver',
    'apache-settings.additionalNginxSettingsDescription' => 'Her kan du angive indstillingerne for den nginx reverse proxy server der kører foran Apache. Dine direktiver vil tilsidesætte den server-brede nginx-konfiguration. Du kan f.eks. ønske at ændre forbindelses-timeout eller pakke forespørgsler med gzip. Brug den samme syntaks som du ville til nginx.conf. Hvis du f.eks. vil pakke alle proxy-anmodninger med gzip, skal du tilføje linjen: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Ekstra nginx-direktiver',
    'apache-settings.additionalNginxSettingsError' => 'Ugyldig nginx-konfiguration: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Kunne ikke bruge den nuværende nginx-konfigurationsfil og rulle tilbage til den foregående version af filen, fordi de begge indeholder en ugyldig konfiguration.',
    'apache-settings.clearCache' => 'Ryd cache',
    'apache-settings.clearCacheHint' => 'Ryd nginx-cache til %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Cache ryddet',

    'backup.backup-password-protection.securitySettingsSection' => 'Sikkerhedskopieringens sikkerhedsindstillinger',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Hent adgangskode i Ekstern lagring-indstillingerne',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Angiv adgangskoden manuelt',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Angiv adgangskode',
    'backup.backup-password-protection.backupPassword' => 'Adgangskode',
    'backup.backup-password-protection.inputPasswordType' => 'Adgangskodetype',
    'backup.backup-password-protection.confirmBackupPassword' => 'Gentag adgangskode',
    'backup.backup-password-protection.backupPasswordHint' => 'Ryd denne indstilling, hvis du har glemt adgangskoden. Bemærk, at i dette tilfælde vil visse følsomme data ikke blive gendannet korrekt. Eksempelvis vil brugeradgangskoder blive udskiftet med tilfældige adgangskoder, oplysninger om allerede installerede APS-programmer vil gå tabt, osv.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Hvis du adgangskodebeskyttede denne sikkerhedskopi, skal du indtaste adgangskoden i nedenstående felter. Bemærk, at hvis du indtaster en forkert adgangskode, vil Plesk ikke gendanne sikkerhedskopien. I stedet vil sikkerhedskopien blive kopieret til det lokale opbevaringsområde.',

    'backup.conflict-database.dbMappingLegend' => 'Databaseserver-mapping',
    'backup.conflict-database.serverType' => 'Servertype',
    'backup.conflict-database.hostName' => 'Værtsnavn',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Destinationsdatabaseserver:',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Databasen kan ikke gendannes: Der er ingen passende databaseserver.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Overfør IP-tilknytningsfil',
    'backup.conflict-ip.ipMappingLegend' => 'IP-tilknytning',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Gem aktuel IP-tilknytning som fil',
    'backup.conflict-ip.ipAddressNotFound' => 'Der er ingen ledige IP-adresser af denne type.',
    'backup.conflict-ip.sharedIp' => 'delt',
    'backup.conflict-ip.dedicatedIp' => 'dedikeret',
    'backup.conflict-ip.fileNotFound' => 'Filen må ikke være tom.',
    'backup.conflict-ip.invalidIpToMap' => 'En ugyldig værdi for en gammel IP-adresse: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'En ugyldig værdi for en ny IP-adresse: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP-adressen %%ip%% blev ikke fundet i databasen.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Upload en IP-mappingfil',
    'backup.conflict-ip.ipMappingFileHint' => 'En IP-mappingfil er en almindelig tekstfil. Hver linje i denne fil indeholder IP-tilknytningen i format: <gammel IP-adresse> <ny IP adresse>',
    'backup.conflict-ip.oldIp' => 'Gamle IP-adresser',
    'backup.conflict-ip.newIp' => 'Nye IP-adresser',

    'backup.copy-to-server.ignoreBackupSign' => 'Upload sikkerhedskopifiler uden en gyldig signatur',
    'backup.copy-to-server.wrongPassword' => 'Den angivne adgangskode er forkert. Under gendannelse af sikkerhedskopien, vil Plesk bede dig om at indtaste adgangskoden igen.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Den uploadede sikkerhedskopifil %%fileName%% var ændret, ødelagt, oprettet på en anden server eller i en ældre Plesk-version, der ikke understøtter signering af sikkerhedskopier. Inden gendannelse af data fra denne sikkerhedskopifil skal du være sikker på, at du har tillid til filens kilde.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Kunne ikke uploade sikkerhedskopfilen %%fileName%%. Filen indeholder enten ændrede eller ødelagte data, eller den blev oprettet på en anden server eller i en ældre Plesk-version. Hvis du vil gendanne data fra sikkerhedskopien, skal du kontakte din udbyder.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Kunne ikke uploade sikkerhedskopfilen %%fileName%%. Filen var ændret, ødelagt, oprettet på en anden server eller i en ældre Plesk-version, der ikke understøtter signering af sikkerhedskopier. Hvis du har tillid til denne sikkerhedskopi, skal du vælge "Upload sikkerhedskopier uden en gyldig signatur" og gentage uploadet.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Kunne ikke flytte den valgte sikkerhedskopi %%fileName%% til serverens opbevaringsområde. Fejl: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Følgende dele af den stigende sikkerhedskopi blev ikke kopieret:%%endl%%%%missedParts%%%%endl%%Kopiér de manglende dele.",

    'backup.ftp-settings.isActive' => 'Brug FTP(S)-lagring',
    'backup.ftp-settings.host' => 'FTP-server hostnavn eller IP',
    'backup.ftp-settings.directory' => 'Mappe til lagring af sikkerhedskopifiler',
    'backup.ftp-settings.directoryHint' => 'Eksempelvis /minmappe/minekopier/',
    'backup.ftp-settings.ftpLogin' => 'FTP-brugernavn',
    'backup.ftp-settings.ftpPassword' => 'FTP-adgangskode',
    'backup.ftp-settings.usePassiveMode' => 'Brug passiv tilstand',
    'backup.ftp-settings.useFtps' => 'Brug FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Det er forbudt at anvende den lokale Plesk FTP-server som eksternt opbevaringsområde. Angiv en ekstern lokation.',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP(S-opbevaringsområdeindstillingerne blev konfigureret til lagring af sikkerhedskopier på den server, hvor dit abonnements filer er placeret. En sådan konfiguration anbefales ikke på grund af risikoen for datatab og overforbrug af diskplads.',
    'backup.ftp-settings.enterFtpLogin' => 'Indtast et korrekt brugernavn',
    'backup.ftp-settings.enterFtpPassword' => 'Indtast en korrekt adgangskode',

    'backup.remote-settings.isActive' => 'Brug lagerområdet',
    'backup.remote-settings.initError' => 'Kan ikke initialisere %%extName%% indstillingssiden: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Sikkerhedskopieringens sikkerhedsindstillinger',

    'backup.restore.detailsSection' => 'Detaljer',
    'backup.restore.contentInfoSection' => 'Sikkerhedskopi-indhold',
    'backup.restore.restorationOptionsSection' => 'Gendannelsesindstillinger',
    'backup.restore.emailNotification' => 'Når gendannelsen er afsluttet, send da en advisering til',
    'backup.restore.comments' => 'Kommentarer',
    'backup.restore.creationDate' => 'Oprettelsesdato',
    'backup.restore.systemNotes' => 'Systemnoter',
    'backup.restore.ownerAdmin' => 'Oprettet af administratoren.',
    'backup.restore.ownerReseller' => 'Oprettet af en forhandler.',
    'backup.restore.ownerCustomer' => 'Oprettet af en kunde.',
    'backup.restore.ownerServiceUser' => 'Oprettet af en hjælpebruger.',
    'backup.restore.partOfParentBackup' => 'Del af %%type%% backup.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'forhandler',
    'backup.restore.client' => 'kunde',
    'backup.restore.incremental' => 'Stigende.',
    'backup.restore.multiVolume' => 'Multi-volumen.',
    'backup.restore.backupSize' => 'Sikkerhedskopi-størrelse:',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (denne tilføjelse) + %%base%% (initial sikkerhedskopi) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (denne tilføjelse) + %%prev%% (tidligere tilføjelser) + %%base%% (initial sikkerhedskopi) = %%total%%',
    'backup.restore.download' => 'Download',
    'backup.restore.downloadHint' => 'Download sikkerhedskopifilen til din lokale computer.',
    'backup.restore.downloadDisabled' => 'Download af sikkerhedskopifiler er midlertidigt utilgængelige. Forsøg igen, eller kontakt sin serviceudbyder.',
    'backup.restore.copy' => 'Kopiér til server-opbevaringsområde',
    'backup.restore.copyHint' => 'Kopiér de valgte sikkerhedskopifiler til server-opbevaringsområdet.',
    'backup.restore.contentInfo' => 'Sikkerhedskopien indeholder',
    'backup.restore.restoreButton' => 'Gendan',
    'backup.restore.mail' => 'E-mail',
    'backup.restore.domainConfiguration' => 'Domænekonfiguration',
    'backup.restore.virtualHost' => 'Indhold af virtuel host',
    'backup.restore.database' => 'Databaser',
    'backup.restore.serverConfiguration' => 'Serverindstillinger',
    'backup.restore.serverConfigurationLicense' => 'Licensnøgle',
    'backup.restore.serverPersonalConfiguration' => 'Konfiguration af administratorkonti',
    'backup.restore.serverPersonalDomains' => 'Administrators domæner',
    'backup.restore.serverPersonalClients' => 'Administrators kunder',
    'backup.restore.resellers' => 'Forhandlere',
    'backup.restore.resellerPersonalConfiguration' => 'Forhandlerkonto-konfiguration',
    'backup.restore.resellerPersonalDomains' => 'Forhandlers domæner',
    'backup.restore.resellerPersonalClients' => 'Forhandlers kunder',
    'backup.restore.clientPersonalConfiguration' => 'Kundekonto-konfiguration',
    'backup.restore.clientPersonalDomains' => 'Kundens domæner',
    'backup.restore.restoreModifiedSection' => 'Gendan sikkerhedskopifilen på trods af en ødelagt signatur',
    'backup.restore.restoreModifiedDump' => 'Gendanne denne sikkerhedskopi, på trods af, at den ikke har en gyldig signatur',
    'backup.restore.resolutionPolicy' => 'Løsningspolitik',
    'backup.restore.resolutionPolicyDescription' => 'Timingkonflikter opstår når det gendannede objekt allerede findes i systemet med en nyere ændringsdato, eller hvis det gendannede objekt aktuelt ikke findes i systemet.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Den angivne adgangskode er forkert. Sikkerhedskopifilen bliver kopieret til serverens lokale opbevaringsområde.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Kan ikke gendanne sikkerhedskopien. Den angivne adgangskode er forkert.',
    'backup.restore.serverContentAndConfiguration' => 'Serverkonfiguration og indhold',
    'backup.restore.serverConfigurationOnly' => 'Serverens konfiguration',
    'backup.restore.resellerContentAndConfiguration' => 'Forhandlerkonto-konfiguration og indhold',
    'backup.restore.resellerConfigurationOnly' => 'Forhandlerkonto-konfiguration',
    'backup.restore.clientContentAndConfiguration' => 'Kundekonto-konfiguration og indhold',
    'backup.restore.clientConfigurationOnly' => 'Kundekonto-konfiguration',
    'backup.restore.domainContentAndConfiguration' => 'Domænekonfiguration og indhold',
    'backup.restore.domainConfigurationOnly' => 'Domænekonfiguration',
    'backup.restore.restoreType' => 'Hvad ønsker du at gendanne?',
    'backup.restore.restoreTypeFull' => 'Alle objekter (hele systemet)',
    'backup.restore.restoreTypeGranular' => 'Valgte objekter',
    'backup.restore.restoreObjectType' => 'Objekttype der skal gendannes',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonnement',
    'backup.restore.restoreObjectTypeCustomers' => 'Kunde',
    'backup.restore.restoreObjectTypeResellers' => 'Forhandler',
    'backup.restore.restoreObjectTypeMailUsers' => 'Mailkonto',
    'backup.restore.restoreObjectTypeDatabases' => 'Database',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS-certifikater',
    'backup.restore.restoreObjectTypeSites' => 'Websteder',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS-zone',
    'backup.restore.restoreObjectTypeMailLists' => 'Mailinglister',
    'backup.restore.restoreObjectTypeWebContent' => 'Filer i domæner',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Valgte filer',
    'backup.restore.restoreSubscriptionLookup' => 'Abonnement',
    'backup.restore.restoreComponents' => 'Komponenter der skal gendannes',
    'backup.restore.errorLog' => 'Fejllog',
    'backup.restore.backupDetailsLogDoesntExist' => 'Sikkerhedkopieringslog er ikke til rådighed.',
    'backup.restore.dumpFailedSection' => 'Fejllog',
    'backup.restore.dumpFailed' => 'Kan ikke gendanne data: Sikkerhedskopifilen er ugyldig.',
    'backup.restore.granularNotSupported' => 'Du kan kun vælge objekter til gendannelse, når du gendanner fra sikkerhedskopier, der er oprettet i Plesk 12.0 eller senere.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Gendannelse af alle data fra sikkerhedskopier understøttes ikke i forhandler-superbrugervisning.  Vælg objekter til gendannelse.  Du kan ændre din brugerfladevisning i %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Grænsefladeindstillinger',
    'backup.restore.contentRestoreType' => 'Gendan',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Kun konfiguration af de valgte objekter',
    'backup.restore.contentRestoreTypeFull' => 'Konfiguration og indhold af de valgte objekter',
    'backup.restore.errorWrongFormat' => 'Sikkerhedskopien kan ikke gendannes, fordi dens konfigurationsfil er beskadiget.',
    'backup.restore.errorContentError' => 'Ikke alle sikkerhedskopierede data kan gendannes, fordi sikkerhedskopien indeholder indholdsfejl.',
    'backup.restore.warningSignError' => 'Kunne ikke validere sikkerhedskopisignaturen. Sikkerhedskopifilen kan være blevet ændret, ødelagt, oprettet på en anden server eller i en tidligere Plesk-version.',
    'backup.restore.warningSignErrorNotAdmin' => 'Denne sikkerhedskopi kan kun gendannes af Plesk-administratoren.',
    'backup.restore.warningPartial' => "Følgende dele af den stigende sikkerhedskopi blev ikke fundet:%%endl%%%%missedParts%%%%endl%%Mulighed for at ikke alle filer gendannes. Upload de manglende dele og prøv at gendanne igen.",
    'backup.restore.errorPackedInvalid' => 'Sikkerhedskopien kan ikke gendannes. Sikkerhedskopifilerne kan være blevet ændret, beskadiget, oprettet i en tidligere Plesk-version eller måske mangler de.',
    'backup.restore.warningDeprecatedBackupVersion' => 'Sikkerhedskopien, du forsøger at gendanne, er oprettet i en ikke-understøttet version af Plesk, og den kan ikke gendannes. Brug udvidelsen Plesk Migrator til at overføre dine data fra gamle versioner af Plesk.',
    'backup.restore.encryptionKeyError' => 'Adgangskoder til en eller flere konti i denne sikkerhedskopi kan ikke gendannes. De vil blive nulstillet. Sandsynligvis blev denne sikkerhedskopi oprettet på en anden Plesk-server og krypteret med dennes krypteringsnøgle.',
    'backup.restore.errorCorruptedContent' => 'Følgende filer blev ikke fundet eller var ødelagte: ',
    'backup.restore.statusSection' => 'Status for sikkerhedskopiering',
    'backup.restore.statusDetails' => 'Statusoplysninger',
    'backup.restore.restoreBlocked' => 'Sikkerhedskopien kan ikke gendannes.',
    'backup.restore.restoreBlockedDescription' => 'Sikkerhedskopien af typen %%backupType%% kan ikke gendannes nu. Hvis du vil gendanne den, skal du logge på som sikkerhedskopi-ejer og klikke på dette sikkerhedskopinavn i Backup Manager.',

    'backup.schedule.scheduleSection' => 'Planlægning',
    'backup.schedule.backupEnable' => 'Aktivér denne sikkerhedskopieringsopgave',
    'backup.schedule.backupPeriod' => 'Kør denne sikkerhedskopieringsopgave',
    'backup.schedule.on' => 'på',
    'backup.schedule.at' => 'i',
    'backup.schedule.every' => 'hver',
    'backup.schedule.hours' => '{period, plural, one {time} other {timer}}',
    'backup.schedule.retainHours' => 'timer',
    'backup.schedule.useIncremental' => 'Brug stigende sikkerhedskopiering',
    'backup.schedule.useIncrementalDisableHint' => 'Det valgte indhold til sikkerhedskopiering tillader kun oprettelse af en komplet sikkerhedskopi.',
    'backup.schedule.fullBackupPeriod' => 'Udfør fuld sikkerhedskopiering',
    'backup.schedule.hourly' => 'Timebaseret',
    'backup.schedule.daily' => 'Dagligt',
    'backup.schedule.weekly' => 'Hver uge',
    'backup.schedule.monthly' => 'Hver måned',
    'backup.schedule.yearly' => 'Årligt',
    'backup.schedule.days' => 'dage',
    'backup.schedule.weeks' => 'uger',
    'backup.schedule.months' => 'Måneder',
    'backup.schedule.years' => 'år',
    'backup.schedule.backupTimeDescription' => 'Tidszone: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Standard systemtidszone',
    'backup.schedule.first' => 'første',
    'backup.schedule.last' => 'sidste',
    'backup.schedule.dayOfMonth' => 'dag',
    'backup.schedule.email' => 'Hvis der opstod fejl under afviklingen af denne sikkerhedskopieringsopgave, skal en adviserings- e-mail sendes til',
    'backup.schedule.invalidFields' => 'Nogle felter er tomme, eller indeholder en ugyldig værdi: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maksimalt antal fulde sikkerhedskopifiler til lagring (inklusive både planlagte og manuelle sikkerhedskopier)',
    'backup.schedule.retainDumpFilesFor' => 'Gem komplet sikkerhedskopi i',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Lad dette felt være tomt, hvis du ikke automatisk vil fjerne sikkerhedskopier.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Den maksimumsgrænse, der er specificeret af hosting-udbyderen til serverlagring er %%max%%. Din grænse skal være lavere end eller lig med %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'Den grænse, som hostingudbyderen har angivet for serverlageret, er {max, plural, one {# komplet sikkerhedskopi} other {# komplette sikkerhedskopier}} (herunder alle planlagte og manuelle sikkerhedskopieringer).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Lagring af planlagte abonnementssikkerhedskopier på et eksternt cloud-lager er en premium-funktion, du kan købe i Plesk\'s online butik',
    'backup.schedule.backupHourlyWarning' => 'Aktivering af timebaseret sikkerhedskopiering kan resultere i øget forbrug af serverressourcer.',
    'backup.schedule.titleHourly' => 'Indstillinger for timebaseret sikkerhedskopiering',
    'backup.schedule.titleDaily' => 'Indstillinger for daglig sikkerhedskopiering',
    'backup.schedule.titleWeekly' => 'Indstillinger for ugentlig sikkerhedskopiering',
    'backup.schedule.titleMonthly' => 'Indstillinger for månedlig sikkerhedskopiering',
    'backup.schedule.titleCustom' => 'Brugerdefinerede indstillinger for sikkerhedskopiering',

    'backup.secure-backup.hint' => 'Du kan bruge en adgangskode til kryptering af brugernes adgangskoder i Plesk-databasen i en backup. Bemærk, at gendannelse af en adgangskodebeskyttet backup uden at indtaste adgangskoden vil få Plesk til at generere brugernes adgangskoder tilfældigt.',
    'backup.secure-backup.hintAdmin' => 'Du kan enten kryptere Plesk database adgangskoder i backups med Plesk krypteringsnøglen eller en adgangskode. Nøglen er unik for hver Plesk-installation. Backups der er krypterede med nøglen kan kun gendannes i den Plesk-installation, de blev oprettede i, og de kan ikke bruges i en anden Plesk-installation. Bemærk, at Plesk ikke beskytter alle følsomme data i en backup. Det anbefales, at du lagrer backups på et eksternt lager, og at du aktiverer backup-kryptering på cloud lagrings-siden.',
    'backup.secure-backup.usePasswordProtection' => 'Brug adgangskodebeskyttelse (anbefales)',
    'backup.secure-backup.backupPasswordSource' => 'Adgangskodetype',
    'backup.secure-backup.pleskKey' => 'Plesk\'s krypteringsnøgle',
    'backup.secure-backup.userPassword' => 'Angiven adgangskode',
    'backup.secure-backup.password' => 'Adgangskode',
    'backup.secure-backup.passwordConfirmation' => 'Gentag adgangskode',

    'backup.subform.settingsSection' => 'Indstillinger for sikkerhedskopiering',
    'backup.subform.prefix' => 'Føj et præfiks til sikkerhedskopinavnet',
    'backup.subform.comment' => 'Kommentarer',
    'backup.subform.splitSize' => 'Opret en multivolumen-sikkerhedskopi, volumenstørrelse (MB)',
    'backup.subform.repository' => 'Gem i',
    'backup.subform.repositoryDescription' => 'FTP(S)-opbevaringsområdeindstillinger er ikke angivet. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Både serverlagring og %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Ekstern lagring',
    'backup.subform.remoteRepository' => 'Ekstern lagring',
    'backup.subform.remoteRepositoryText' => 'Vælg ekstern cloud-lagring',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">Konfigurer fjernlagring</a> for at gemme dine sikkerhedskopier i skyen.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">Konfigurer FTP-lagring</a> for at gemme dine sikkerhedskopier off-site.',
    'backup.subform.configureRemoteDesc' => '%%link%% for at gemme dine sikkerhedskopier i skyen.',
    'backup.subform.configureRemoteLink' => 'Konfigurer fjernlager',
    'backup.subform.configureFtpDesc' => '%%link%% for at gemme dine sikkerhedskopier off-site.',
    'backup.subform.configureFtpLink' => 'Konfigurer FTP-lagring',
    'backup.subform.repositoryConfigure' => 'Konfigurer',
    'backup.subform.email' => 'Når en sikkerhedskopieringsopgave er afsluttet, skal adviserings- e-mail sendes til',
    'backup.subform.contentSection' => 'Sikkerhedskopi-indhold',
    'backup.subform.domainConfiguration' => 'Konfiguration',
    'backup.subform.domainConfigurationVhost' => 'Bruger-filer og databaser',
    'backup.subform.domainConfigurationFile' => 'Brugerfiler',
    'backup.subform.domainConfigurationDatabase' => 'Databaser',
    'backup.subform.domainConfigurationMail' => 'Mailbeskeder',
    'backup.subform.content' => 'Sikkerhedskopier',
    'backup.subform.backupAll' => 'Al konfiguration og alt indhold',
    'backup.subform.backupConfiguration' => 'Kun konfiguration',
    'backup.subform.backupVhost' => 'Al konfiguration og indhold undtagen mailbeskeder',
    'backup.subform.backupMailFile' => 'Al konfiguration og indhold undtagen brugerdatabaser',
    'backup.subform.backupMailDatabase' => 'Al konfiguration og indhold undtagen brugerfiler',
    'backup.subform.backupMail' => 'Kun konfiguration og mailbeskeder',
    'backup.subform.backupDatabase' => 'Kun konfiguration og brugerdatabaser',
    'backup.subform.backupFile' => 'Kun konfiguration og brugerfiler',
    'backup.subform.mssqlNativeBackup' => 'Brug native MS SQL sikkerhedskopi-funktionalitet hvis det er muligt',
    'backup.subform.mssqlNativeBackupAdmin' => 'Brug native MS SQL sikkerhedskopieringsfunktionalitet (For eksterne database skal du huske at konfigurere sikkerhedskopieringsindstillingerne for den eksterne MS SQL server i Værktøjer og indstillinger > Databaseservere)',
    'backup.subform.localRepository' => 'Server-opbevaringsområde',
    'backup.subform.localRepositoryPath' => 'Server-opbevaringsområde i %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S)-lagring på %%uri%% <a href="%%link%%">Skift indstillinger</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S)-lagring på %%uri%%',
    'backup.subform.type' => 'Type',
    'backup.subform.typeFullBackup' => 'Fuld',
    'backup.subform.typeIncremental' => 'Stigende',
    'backup.subform.typeIncrementalDescription' => 'Sikkerhedskopier web- og mail hostingdata, der er ændret siden seneste sikkerhedskopiering (databaser sikkerhedskopieres altid fuldt ud).',
    'backup.subform.incrementalNotAvailable' => 'For at oprette stigende sikkerhedskopiversioner, skal du først oprette en fuld sikkerhedskopi.',
    'backup.subform.excludeLogs' => 'Medtag ikke logfiler',
    'backup.subform.excludeFiles' => 'Udeluk bestemte filer fra sikkerhedskopieringen',
    'backup.subform.excludeFilesDescription' => 'Du kan kun udelukke filer inde i webspaces. Angiv stien eller stierne relativt til webspace-roden, og adskil individuelle filer med komma. Brug af maskesymbol er tilladt (f.eks. /somedir/log*).',

    'backup.upload.uploadHint' => 'Her kan du uploade sikkerhedskopifiler til Plesk-opbevaringsområdet. Den maksimale filstørrelse er begrænset til to gigabyte.',
    'backup.upload.backupFile' => 'Sikkerhedskopifil',
    'backup.upload.removeLink' => 'Fjern',
    'backup.upload.addFileLink' => 'Upload flere filer',
    'backup.upload.backupSecuritySettings' => 'Sikkerhedskopieringens sikkerhedsindstillinger',
    'backup.upload.signatureHint' => 'Plesk tjekker sikkerhedskopifilerne for en gyldig struktur og signatur. Filer, der blev ændret, er ødelagte eller oprettede på en anden server, er ikke tillidsvækkende. Nedenstående mulighed gør det muligt at gendanne data fra sådanne filer. Vælg kun denne mulighed, hvis du stoler på sikkerhedskopi-kilden, da upload af en sådan fil kan kompromittere sikkerheden eller afbryde serverens drift. Bemærk: Sikkerhedskopifiler, der er oprettede i Plesk-versioner tidligere end 11.5 betragtes som ikke tillidsvækkende, da de mangler signaturer. Gendan kun sådanne filer, hvis du har tillid til deres kilde.',
    'backup.upload.ignoreSign' => 'Upload sikkerhedskopifiler uden en gyldig signatur',
    'backup.upload.passwordHint' => 'Hvis du adgangskodebeskyttede denne sikkerhedskopi, skal du indtaste adgangskoden i nedenstående felter. Bemærk, at hvis du angiver en forkert adgangskode, vil Plesk advare dig, men systemet vil uploade sikkerhedskopien til serveren alligevel. Under gendannelse af sikkerhedskopien, vil du blive bedt om at indtaste adgangskoden igen.',
    'backup.upload.alreadyExistsWarning' => 'Sikkerhedskopifilen %%fileName%% findes allerede i serverens lokale opbevaringsområde.',
    'backup.upload.incorrectPasswordWarning' => 'Den angivne adgangskode er forkert. Under gendannelse af sikkerhedskopien, vil Plesk bede dig om at indtaste adgangskoden igen.',
    'backup.upload.deprecatedDumpError' => 'Sikkerhedskopien, du forsøger at uploade, er oprettet i en ikke-understøttet version af Plesk, og den kan ikke importeres. Brug udvidelsen Plesk Migrator til at overføre dine data fra gamle versioner af Plesk.',
    'backup.upload.mailFormatWarning' => 'Sikkerhedskopifilen %%fileName%% blev uploadet til opbevaringsområdet. Vigtigt: Sikkerhedskopifilen %%fileName%% indeholder e-mail-indhold, der ikke vil blive gendannet pga. at dens format (Plesk 8.3 - 8.6) ikke er understøttet. For at kunne gendanne dette e-mail-indhold skal du sikkerhedskopiere det vha. Plesk sikkerhedskopieringsværktøjet og vælge indstillingen med dump gendannet til en vilkårlig postserver.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Den uploadede sikkerhedskopifil (%%fileName%%) var ændret, ødelagt, oprettet på en anden server eller i en ældre Plesk-version, der ikke understøtter signering af sikkerhedskopier. Inden gendannelse af data fra denne sikkerhedskopifil skal du være sikker på, at du har tillid til filens kilde.',
    'backup.upload.corruptedSignatureAdminError' => 'Kunne ikke uploade sikkerhedskopfilen (%%fileName%%). Filen var ændret, ødelagt, oprettet på en anden server eller i en ældre Plesk-version, der ikke understøtter signering af sikkerhedskopier. Hvis du har tillid til denne sikkerhedskopi, skal du vælge "Upload sikkerhedskopier uden en gyldig signatur" og gentage uploadet.',
    'backup.upload.corruptedSignatureUserWarning' => 'Den uploadede sikkerhedskopifil (%%fileName%%) indeholder enten ændrede eller ødelagte data, eller den blev oprettet på en anden server eller i en ældre Plesk-version.',
    'backup.upload.corruptedSignatureUserError' => 'Kunne ikke uploade sikkerhedskopfilen (%%fileName%%). Filen indeholder enten ændrede eller ødelagte data, eller den blev oprettet på en anden server eller i en ældre Plesk-version. Hvis du vil gendanne data fra sikkerhedskopien, skal du kontakte din udbyder.',
    'backup.upload.uploadError' => 'Kunne ikke uploade %%fileName%% til serverens opbevaringsområde: %%error%%',
    'backup.upload.fileNotSelected' => 'Ingen filer blev valgt til upload. Vælg mindst én fil.',
    'backup.upload.missedPartsWarning' => "Følgende dele af den stigende sikkerhedskopi blev ikke uploadet:%%endl%%%%missedParts%%%%endl%%Upload de manglende dele.",
    'backup.upload.unknownType' => 'Ukendt objekttype',
    'backup.upload.storageLink' => 'et andet lagringsområde',
    'backup.upload.anotherStorage' => 'Dumpet blev uploadet til %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Forhandleren %%name%% blev ikke fundet. Opret den først for at gendanne det uploadede dump.',
    'backup.upload.clientNotFound' => 'Kunden %%name%% blev ikke fundet. Opret den først for at gendanne det uploadede dump.',
    'backup.upload.domainNotFound' => 'Domænet %%name%% blev ikke fundet. Opret den først for at gendanne det uploadede dump.',

    'backup.web-content-dynamic.addButtonTitle' => 'Tilføj filer',
    'backup.web-content-dynamic.noItems' => 'Der er ikke valgt filer',
    'backup.web-content-dynamic.hint' => 'Brug afkrydsningsfelterne til valg af filer og mapper.',
    'backup.web-content-dynamic.title' => 'Vælg filer',
    'backup.web-content-dynamic.columnName' => 'Navn',
    'backup.web-content-dynamic.columnChangeDate' => 'Ændret',
    'backup.web-content-dynamic.columnSize' => 'Størrelse',
    'backup.web-content-dynamic.columnPermissions' => 'Rettigheder',
    'backup.web-content-dynamic.columnUser' => 'Bruger',
    'backup.web-content-dynamic.columnGroup' => 'Gruppe',
    'backup.web-content-dynamic.waitButtonTitle' => 'Vent venligst',
    'backup.web-content-dynamic.loadingTitle' => 'Vent venligst. Indlæser...',

    'backup.invalidFields' => 'Nogle felter er tomme, eller indeholder en ugyldig værdi.',
    'backup.notEnoughDiskSpace' => 'Der er ikke diskplads nok på %%path%% til oprettelse af backup. Der kræves mindst %%required%% GB ledig plads (%%available%% GB er til rådighed)',

    'change-subscriptions-owner.ownerSection' => 'Ny ejer',
    'change-subscriptions-owner.subscriptionsSection' => 'Valgte abonnementer',
    'change-subscriptions-owner.owner' => 'Ejer',
    'change-subscriptions-owner.subscriptionName' => 'Abonnement',
    'change-subscriptions-owner.ownerName' => 'Ejer',
    'change-subscriptions-owner.currentIpAddress' => 'Nuværende IP-adresser',
    'change-subscriptions-owner.newIpAddress' => 'Nye IP-adresser',
    'change-subscriptions-owner.noIpAddress' => 'Ingen tilgængelige IP-adresser',
    'change-subscriptions-owner.submit' => 'Omfordel',
    'change-subscriptions-owner.warningCustom' => "Abonnementet bliver frigjort fra sin nuværende serviceplan og bliver 'Brugerdefineret'.",
    'change-subscriptions-owner.warningEmptyPool' => "IP-puljen for den nye ejers udbyder er tom. Sørg for, at udbyderen har mindst én IP-adresse i puljen.",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, Disk I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Opsæt grænser for systemressource-forbrug vha. et abonnement. Plesk bruger en Linux-kernel funktion, der kaldes for control groups (cgroups) til at sikre, at grænserne ikke overskrides.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Begræns individuelle abonnementer til den angivne mængde CPU-forbrug.',
    'cgroups-settings.cpuPeriodLimit' => 'Periode til kontrol af CPU-forbrug',
    'cgroups-settings.percentUsageDescription' => 'Den totale mængde CPU-tid er lig med %%total%%%%units%% for din server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Begræns individuelle abonnementer til den angivne mængde RAM-forbrug. Bemærk, at hvis et abonnement overskrider denne grænse, vil de processer, der forbruger mest, blive standset.',
    'cgroups-settings.ramPeriodLimit' => 'Periode til kontrol af RAM-forbrug',
    'cgroups-settings.diskSettings' => 'Disk-I/O',
    'cgroups-settings.diskReadSettings' => 'Disklæsning',
    'cgroups-settings.diskReadSettingsDescription' => 'Tillad individuelle abonnementer kun at bruge disklæsningsbåndbredde indenfor den angivne grænse.',
    'cgroups-settings.diskReadPeriodLimit' => 'Periode til kontrol af disklæseforbrug',
    'cgroups-settings.diskWriteSettings' => 'Diskskrivning',
    'cgroups-settings.diskWriteSettingsDescription' => 'Tillad individuelle abonnementer kun at bruge diskskrivningsbåndbredde indenfor den angivne grænse.',
    'cgroups-settings.diskWritePeriodLimit' => 'Periode til kontrol af diskskriveforbrug',
    'cgroups-settings.limit' => 'Begrænsning',
    'cgroups-settings.threshold' => 'Adviser ved overskridelse',
    'cgroups-settings.limitNotificationEnabled' => 'Advisering aktiveret',
    'cgroups-settings.periodFiveMinutes' => '5 minutter',
    'cgroups-settings.periodHour' => '1 time',
    'cgroups-settings.periodDay' => '1 dag (24 timer)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sek.',

    'custom-button.privateLabel' => 'Vis kun for mig',
    'custom-button.textLabel' => 'Knapmærke',
    'custom-button.tooltipLabel' => 'Værktøjstip-tekst:',
    'custom-button.iconLabel' => 'Baggrundsbillede',
    'custom-button.priorityLabel' => 'Prioritet',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Føj parametre til URL',
    'custom-button.placeLabel' => 'Placering',
    'custom-button.internalLabel' => 'Åbn URL i Plesk',
    'custom-button.internalDescription' => 'Angiv om URL skal åbnes på en Plesk-side eller i et nyt browservindue.',
    'custom-button.noFrameLabel' => 'Brug ikke rammer',
    'custom-button.noFrameDescription' => 'Hvis du tilføjer en brugerdefineret knap, der fører til en Plesk-udvidelse i Kundepanelet, kan du angive, hvordan denne udvidelse/dette program skal vises: i en ramme eller som del af Plesk GUI.',
    'custom-button.urlParamLabel_dom_id' => 'Medtag abonnements-ID, domæne-ID og domænealias-ID',
    'custom-button.urlParamLabel_dom_name' => 'Inkludér primært domænenavn',
    'custom-button.urlParamLabel_ftp_user' => 'Inkludér FTP-brugernavn',
    'custom-button.urlParamLabel_ftp_pass' => 'Inkludér FTP-adgangskode',
    'custom-button.urlParamLabel_cl_id' => 'Inkludér kunde-ID',
    'custom-button.urlParamLabel_cname' => 'Inkludér kundens firmanavn',
    'custom-button.urlParamLabel_pname' => 'Inkludér kundens kontaktnavn',
    'custom-button.urlParamLabel_email' => 'Inkludér kundens e-mailadresse',
    'custom-button.buttonPlace_navigation' => 'Fælles adgang',
    'custom-button.buttonPlace_admin' => 'Administrators startside',
    'custom-button.buttonPlace_admin-settings' => 'Administrator\'s Funktioner og indstillinger side',
    'custom-button.buttonPlace_reseller' => "Forhandlerens startside",
    'custom-button.buttonPlace_reseller-settings' => 'Forhandlers \'s Væktøjer og tilbehør side',
    'custom-button.buttonPlace_client' => 'Kundens Hjem-side',
    'custom-button.buttonPlace_domain' => "Websteder og domæner side for abonnement",
    'custom-button.buttonPlace_domain_powerUser' => "Websteder og domæner side for webspace",
    'custom-button.buttonPlace_domain-properties' => 'Webstedsværktøjer',
    'custom-button.fileNotUploaded' => 'Filen kan ikke uploades.',

    'database-server-change-password.adminPassword' => 'Administrators adgangskode',
    'database-server-change-password.success' => 'Administratorens adgangskode blev opdateret.',

    'database-server-create.general' => 'Generelt',
    'database-server-create.type' => 'Databaseservertype:',
    'database-server-create.unixSocket' => '(lokal forbindelse)',
    'database-server-create.host' => 'Host name or IP address',
    'database-server-create.port' => 'Portnummer',
    'database-server-create.portDescription' => 'Lad feltet være tomt for standard portnummer',
    'database-server-create.version' => 'Databaseserverversion',
    'database-server-create.default' => 'Brug denne server som standard til %%type%%',
    'database-server-create.externalConnections' => 'Tillad local MariaDB/MySQL server at acceptere eksterne forbindelser',
    'database-server-create.externalConnectionsDescription' => 'Ændring af denne indstilling ved medføre, at Local MariaDB/MySQL server genstartes. Du kan aktivere ekstern adgang til andre MariaDB/MySQL servere, der er registrerede i Plesk, ved manuelt at ændre deres konfiguration.',
    'database-server-create.authentication' => 'Godkendelse',
    'database-server-create.authenticationAddDescription' => 'Angiv databaseadministratorens akkreditiver, som Plesk vil bruge til adgang til databaseserveren.  En administratorkonto med disse akkreditiver skal være tilstede på databaseserveren.',
    'database-server-create.authenticationEditDescription' => 'Her kan du ændre de akkreditiver, som Plesk et bruger til adgang til databaseserveren. Disse akkreditiver skal matche databaseadministratorens akkreditiver. Hvis du f.eks. har ændret administratorens akkreditiver på databaseserveren, er det nødvendigt også at ændre dem i Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Her kan du ændre de akkreditiver, som Plesk et bruger til adgang til databaseserveren.  Hvis du ændrer brugernavn eller adgangskode herunder, vil database-brugerkontoen med administrative rettigheder blive opdateret både på databaseserveren og i Plesk.',
    'database-server-create.adminLogin' => 'Brugernavn',
    'database-server-create.adminPassword' => 'Adgangskode',
    'database-server-create.createSuccess' => 'Databaseserver oprettet korrekt.',
    'database-server-create.createError' => 'Databaseserveren blev oprettet med fejl: %%error%%',
    'database-server-create.updateSuccess' => 'Databaseserver opdateret korrekt.',
    'database-server-create.updateError' => 'Databaseserveren blev opdateret med fejl: %%error%%.',
    'database-server-create.backupSettings' => 'Sikkerhedskopiering',
    'database-server-create.backupTempDir' => 'Midlertidigt bibliotek',
    'database-server-create.backupTempDirDescription' => 'Stien til den fysiske mappe på den eksterne server, hvor MS SQL-serveren er placeret. MS SQL-serveren skal kunne få adgang til denne mappe til læsning og skrivning af midlertidige sikkerhedskopifiler. F.eks. C:\\MappeSti',
    'database-server-create.backupNetworkTempDir' => 'Midlertidig netværksmappe.',
    'database-server-create.backupNetworkTempDirDescription' => 'Stien til netværksshare for den ovenfor angivne fysiske mappe. Plesk vil tilgå den delte mappe ved op- og download af sikkerhedskopifiler. Eksempelvis \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Brugernavn',
    'database-server-create.backupNetworkUserDescription' => 'Brugernavnet på en netværksbruger, oprettet på den eksterne server. Eksempelvis ServerName\\UserName. Brugeren skal have adgang til den ovenfor angivne delte mappe.',
    'database-server-create.backupNetworkPassword' => 'Adgangskode',

    'domain.connection-info.title' => 'Oplysninger om forbindelse',
    'domain.connection-info.systemUserCredentials' => 'Systembruger-akkreditiver',
    'domain.connection-info.systemUserCredentialsHint' => 'Adgang via FTP er altid aktiveret, adgang via SSH eller fjernskrivebord – kun hvis %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'tilladelse gives',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Adgangen til SSH eller fjernskrivebord er aktiveret, og du kan ikke administrere tilstanden.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Adgangen til SSH eller fjernskrivebord er deaktiveret, og du kan ikke administrere tilstanden.',
    'domain.connection-info.ipAddress' => 'IP-adresse',
    'domain.connection-info.copyIpAddressTooltip' => 'Kopiér IP-adresse til udklipsholder',
    'domain.connection-info.username' => 'Brugernavn',
    'domain.connection-info.copyUsernameTooltip' => 'Kopiér brugernavn til udklipsholder',
    'domain.connection-info.password' => 'Adgangskode',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Ændring af systembruger-adgangskode',
    'domain.connection-info.changePasswordTooltip' => 'Skift adgangskode',
    'domain.connection-info.newPassword' => 'Ny adgangskode',
    'domain.connection-info.manageAccess' => 'Administrér adgang',
    'domain.connection-info.additionalFtpAccounts' => 'Ekstra FTP-konti',
    'domain.connection-info.database' => 'Database',
    'domain.connection-info.databaseHint' => '1 af %%number%% databaser, der hører til abonnementet.',
    'domain.connection-info.databaseNotCreatedHint' => 'Databasen er ikke oprettet.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Vært',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Databasenavn',
    'domain.connection-info.addDatabase' => 'Tilføj database',
    'domain.connection-info.manageDatabases' => 'Administrer databaser',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Ændring af databasebruger-adgangskode',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Husk at opdatere adgangskoden i konfigurationsfilerne til din applikation, når du har ændret den her.',
    'domain.connection-info.buttonSave' => 'Gem',
    'domain.connection-info.buttonSaving' => 'Gemmer...',
    'domain.connection-info.buttonCancel' => 'Annuller',
    'domain.connection-info.copyHostTooltip' => 'Kopiér værtsnavn til udklipsholder',
    'domain.connection-info.copyDatabaseNameTooltip' => 'Kopier databasenavn til udklipsholderen',
    'domain.connection-info.copyDatabaseUserTooltip' => 'Kopiér databasebruger til udklipsholder',

    'domain.move.title' => 'Flyt domænet %%name%%',
    'domain.move.hint' => 'Domænet vil blive flyttet til et nyt abonnement sammen med dets indhold, konfigurationsfiler, logfiler og APS-applikationer.',
    'domain.move.hintMain' => 'Domænet vil blive flyttet til et nyt abonnement sammen med dets indhold, konfigurationsfiler, logfiler, databaser, databasebrugere, ekstra FTP-brugere, planlagte opgaver, smb-brugere og APS-applikationer.',
    'domain.move.hintSubdomains' => 'Underdomænealias(er) %%subdomains%% vil blive flyttet sammen med det overordnede domæne.',
    'domain.move.hintAliases' => 'Domænealias(er) %%aliases%% vil blive flyttet sammen med det overordnede domæne.',
    'domain.move.hintSubdomainsAndAliases' => 'Underdomæne(r) %%subdomains%% og domænealias(er) %%aliases%% vil blive flyttet sammen med det overordnede domæne.',
    'domain.move.labelDatabases' => 'Efter flytning af domænet skal du åbne fanen "Databaser" for at flytte de tilknyttede databaser.',
    'domain.move.hintDatabases' => 'Om nødvendigt kan du flytte databaserne separat.',

    'domain.move.Form.submitButton' => 'Flyt',
    'domain.move.Form.cancelButton' => 'Annuller',

    'domain.move.selectTarget' => 'Abonnementer til rådighed',
    'domain.move.nothingFound' => 'Intet fundet',
    'domain.move.targetIsRequred' => 'Vælg abonnement domænet skal flyttes til.',
    'domain.move.selectNewSubscription' => 'Opret et nyt abonnement',
    'domain.move.ipv4Address' => 'IPv4-adresse',
    'domain.move.ipv4AddressHint' => 'IP-adressen hvorpå webstedet hostes er netværksadressen på webstedets virtuelle mappe.',
    'domain.move.ipv6Address' => 'IPv6 adresse',
    'domain.move.ipv6AddressHint' => 'IP-adressen hvorpå webstedet hostes er netværksadressen på webstedets virtuelle mappe.',
    'domain.move.ipAddressIsNotSelected' => 'Der skal vælges mindst én IP-adresse.',
    'domain.move.username' => 'Brugernavn',
    'domain.move.usernameHint' => 'Systembrugerkonto associeret med webspacen. Anvendes til adgang til de hostede filer via FTP og SSH.',
    'domain.move.usernameIsRequred' => 'Du skal angive et brugernavn.',
    'domain.move.password' => 'Adgangskode',
    'domain.move.passwordIsRequred' => 'Du skal angive en adgangskode.',
    'domain.move.noAvailableSubscriptions' => 'Ingen abonnementer til rådighed',
    'domain.move.noWebHosting' => 'Ingen systembruger vil blive oprettet lige nu, da domænet ikke har webhosting.',

    'domain.rename.title' => 'Rediger domænenavn',
    'domain.rename.titleAlias' => 'Rediger domænealias-navn',
    'domain.rename.hint' => 'Du ændrer nu domænenavnet %%domainName%%',
    'domain.rename.hintAlias' => 'Du ændrer nu domænealias-navnet %%domainName%%',
    'domain.rename.name' => 'Nyt domænenavn',
    'domain.rename.nameAlias' => 'Nyt domænealias-navn',
    'domain.rename.domainNameIsRequired' => 'Dette obligatoriske felt er tomt. Du skal angive en værdi.',
    'domain.rename.submitButton' => 'Rediger',
    'domain.rename.submitButtonProgress' => 'Ændrer',
    'domain.rename.successMessage' => 'Domænenavnet %%oldName%% blev ændret til %%newName%%.',
    'domain.rename.successMessageAlias' => 'Domænealias-navnet %%oldName%% blev ændret til %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Annuller',

    'domain.outgoing-messages.hint' => 'Her kan du ændre grænsen for antallet af udgående meddelelser for dette domæne. Det vil ikke være muligt at sende flere meddelelser end det specificerede antal.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Standard (%%domainOutgoingMessages%% meddelelser pr. time)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'meddelelser pr. time',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Begrænsning på udgående meddelelser',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Brugerdefineret værdi for dette domæne',

    'domain.tech-domain-name.title' => 'Vælg dit domænenavn',
    'domain.tech-domain-name.techDomainTitle' => 'Midlertidigt domænenavn',
    'domain.tech-domain-name.customDomainTitle' => 'Registreret domænenavn',
    'domain.tech-domain-name.techDomainText' => 'Jeg har endnu ikke et registreret domænenavn',
    'domain.tech-domain-name.customDomainText' => 'Jeg har allerede et registreret domænenavn',
    'domain.tech-domain-name.techDomain' => 'Dit midlertidige domænenavn',
    'domain.tech-domain-name.customDomain' => 'Registreret domænenavn',
    'domain.tech-domain-name.domainName' => 'Domænenavn',
    'domain.tech-domain-name.techDomainDesc' => 'Midlertidige domænenavne bruges til adgang til dit websted inden du køber og registrerer et rigtigt domænenavn. De leveres gratis under følgende betingelser:',
    'domain.tech-domain-name.techDomainRandom' => 'Navnene genereres tilfældigt',
    'domain.tech-domain-name.techDomainDns' => 'De er hostede i Plesk-sidens DNS-zone',
    'domain.tech-domain-name.techDomainSwitch' => 'Du kan på ethvert tidspunkt skifte til et registreret domænenavn ved at omdøbe domænet i domæneindstillingerne.',
    'domain.tech-domain-name.error' => 'Der opstod en uventet fejl.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Du skal vælge IP-adressen.',
    'domain.tech-domain-name.generating' => 'Genererer...',

    'get-password.label' => 'Nulstil adgangskode',
    'get-password.text' => 'Indtast den email-adresse eller det brugernavn, der er registreret i Plesk, hvorefter vi vil sende dig en adgangskode-reset email.',
    'get-password.emailLabel' => 'E-mailadresse',
    'get-password.loginLabel' => 'Brugernavn',
    'get-password.send' => 'Send',
    'get-password.cancel' => 'Annuller',
    'get-password.errorInvalidEmail' => 'Email-adressen blev ikke genkendt. Dobbelttjek og prøv igen.',
    'get-password.messageSend' => "Adgangskode-reset email'en blev sendt til den tilknyttede email-adresse.\nHvis email 'en ikke kommer frem, bedes du kontakte din Plesk-administrator.",
    'get-password.rateLimitReached' => "For mange forsøg på nulstilling af adgangskode. Prøv igen senere.",
    'iis-settings.formGeneralHint' => 'Her kan du specificere IIS-webserver indstillinger for dit websted ved at ændre standardværdierne. Brugerdefineret IIS-konfiguration er eksempelvis nyttig hvis du vil bruge en ny type index-filer på dit websted, eller hvis du vil knytte en bestemt MIME-type sammen med bestemte filnavnsudvidelser. Standardværdierne defineres af din hosting-udbyder.',
    'iis-settings.formGeneralHint_powerUser' => 'Her kan du angive IIS webserver-indstillinger for dette websted. Brugerdefineret IIS-konfiguration er eksempelvis nyttig hvis du vil bruge en ny type index-filer på dit websted, eller hvis du vil knytte en bestemt MIME-type sammen med bestemte filnavnsudvidelser. Standardværdien betyder, at IIS vil bruge det korresponderende direktiv fra standardkonfigurationen.',
    'iis-settings.virtualDirectoryLoadError' => 'Kunne ikke hente egenskaberne for den angivne virtuelle mappe: %%errorMessage%%',
    'iis-settings.general' => 'Almindelige indstillinger',
    'iis-settings.example' => "F.eks.:\n%%example%%",
    'iis-settings.settingOn' => 'Aktiveret',
    'iis-settings.settingOff' => 'Fra (standard)',
    'iis-settings.settingDefault' => 'Standard',
    'iis-settings.settingCustom' => 'Indtast brugerdefineret værdi',
    'iis-settings.mimeTypes' => 'MIME-typer',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME-typer knytter filnavnsudvidelser sammen med filtyper. Typisk bruges dette til oprettelse af en brugerdefineret filnavnsudvidelse til almindelige filtyper.',
    'iis-settings.documents' => 'Standarddokumenter',
    'iis-settings.documentsOff' => 'Deaktiveret',
    'iis-settings.documentsCustom' => 'Indtast værdier',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Hvis browsere ikke angiver navnet på et dokument på webstedet, vil IIS søge efter det angivne standarddokument og vise det først fundne. Hvis du ikke specificerer standarddokumenter, men deaktiverer mappe-browsing, vil mappelisten blive vist i stedet for indekssiden.',
    'iis-settings.expires' => 'Udløber',
    'iis-settings.expiresFullDescription' => 'Webserveren vil tilføje “Expires” responsheaders til websider. Udløbs-tidsmærket hentes ved at tillægge den mængde tid, der er angivet ud over den tid det tager at anmode om en webside.',
    'iis-settings.expiresUnitDays' => 'dage',
    'iis-settings.expiresUnitHours' => 'timer',
    'iis-settings.expiresUnitMinutes' => 'minutter',
    'iis-settings.expiresUnitSeconds' => 'sekunder',
    'iis-settings.headers' => 'Yderligere headers',
    'iis-settings.headersExample' => "Cache-kontrol: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: AFVIS",
    'iis-settings.headersFullDescription' => 'Webserveren tilføjer de angivne HTTP-responsheadere.',
    'iis-settings.directoryBrowsing' => 'Biblioteksgennemsyn',
    'iis-settings.directoryBrowsingDescription' => 'Tillader brugere at se webstedets mappelistning i webbrowsere, f.eks. når standard index-siden ikke er til rådighed.',
    'iis-settings.securityTabDirectory' => 'Mappe-sikkerhedsindstillinger',
    'iis-settings.allowAnonymous' => 'Anonym godkendelse',
    'iis-settings.allowAnonymousDescription' => 'Anonym godkendelse tillader brugere at få adgang til det offentlige indhold af dit websted. Password Adgangsbeskyttet indhold på webstedet, samt indhold der er beskyttet på systemniveau, vil ikke være tilgængeligt til anonyme brugere.',
    'iis-settings.allowWindows' => 'Windows-godkendelse',
    'iis-settings.allowWindowsDescription' => 'Windows-godkendelse (der tidligere hed NTLM) beskytter indholdet af webstedet på filsystem-niveau.',
    'iis-settings.requireSsl' => 'Kræver -SSL/TLS',
    'iis-settings.requireSslDescription' => 'hvis du har aktiveret SSL/TLS-understøttelse for dit websted, vil denne indstilling tvinge webklienter (browsere) til udelukkende at anvende sikre HTTPS-forbindelser.',
    'iis-settings.securityTabIpDeny' => 'Indstillinger for adgangsbegrænsning',
    'iis-settings.deny' => 'Nægt adgang til webstedet',
    'iis-settings.denyOff' => 'Standard',
    'iis-settings.denyCustom' => 'Indtast brugerdefineret værdi',
    'iis-settings.allow' => 'Udelukker',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angivne hosts og netværk må ikke tilgå stedet. Brug '*' for at afvise alle forbindelser.",
    'iis-settings.allowExample' => "192.168.0.0/16 \n10.1.1.21 \n \nDe angivne hosts og netværk har tilladelse til at tilgå stedet.",
    'iis-settings.dynamicIpSecurity' => 'Forhindring af DoS-angreb vha. IIS dynamisk IP-begrænsning',
    'iis-settings.isDenyByConcurrentRequests' => 'Afvis IP-adresser baseret på antallet af samtidige anmodninger fra en unik IP-adresse',
    'iis-settings.maxConcurrentRequests' => 'Maksimalt antal samtidige anmodninger',
    'iis-settings.isDenyByRequestRate' => 'Afvis IP-adresser baseret på antallet af anmodninger over en tidsperiode',
    'iis-settings.maxRequests' => 'Maksimalt antal anmodninger',
    'iis-settings.requestInterval' => 'Tidsperiode (i millisekunder)',

    'ip-addresses-selector.ipAddress' => 'IP-adresse',
    'ip-addresses-selector.ipv4Address' => 'IPv4-adresse',
    'ip-addresses-selector.ipv4AddressHint' => "IP-adressen hvorpå webstedet hostes er netværksadressen på webstedets virtuelle mappe.",
    'ip-addresses-selector.ipv6Address' => 'IPv6 adresse',
    'ip-addresses-selector.ipv6AddressHint' => "IP-adressen hvorpå webstedet hostes er netværksadressen på webstedets virtuelle mappe.",
    'ip-addresses-selector.noIpAddressHint' => 'Ingen',
    'ip-addresses-selector.shared' => 'delt',
    'ip-addresses-selector.exclusive' => 'dedikeret',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP-serveren understøtter ikke IPv6. Reservér mindst én IPv4 adresse, eller vil brugeren ikke kunne uploade filer til serveren over FTP.',

    'license-key-revert.description' => 'Licensnøglen med følgende egenskaber vil blive gendannet:',
    'license-key-revert.submitButton' => 'Rul tilbage',

    'license-key-upload.description' => 'Installer din licensnøgle ved at angive en aktiveringskode.',
    'license-key-upload.descriptionWithFileUpload' => 'Installer din licensnøgle ved at angive en aktiveringskode eller ved at uploade en licensnøgle-fil.',
    'license-key-upload.type' => 'Vælg en af følgende:',
    'license-key-upload.code' => 'Indtast en aktiveringskode',
    'license-key-upload.codeDescription' => 'Indsæt den modtagne aktiveringskode.',
    'license-key-upload.file' => 'Upload en licensnøglefil.',
    'license-key-upload.fileDescription' => 'Angiv stien til den fil, der indeholder licensnøglen.',
    'license-key-upload.submitButton' => 'Installer',

    'log-rotation.customLogsDescription' => 'Bemærk, at dine brugerdefinerede logge ikke roteres.',
    'log-rotation.logRotation' => 'Log-rotation',
    'log-rotation.logRotationCondition' => 'Logrotationstilstand',
    'log-rotation.logRotationBySize' => 'Efter størrelse',
    'log-rotation.logRotationByTime' => 'Efter tidspunkt',
    'log-rotation.logRotationDaily' => 'Dagligt',
    'log-rotation.logRotationWeekly' => 'Hver uge',
    'log-rotation.logRotationMonthly' => 'Hver måned',
    'log-rotation.logRotationSizeDescription' => 'Størrelsesværdien skal være mellem %%min%% og %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Maksimalt antal logfiler',
    'log-rotation.compress' => 'Komprimer logfiler',
    'log-rotation.sendLogToEmail' => 'Når Plesk henter data fra logfiler på web- og FTP-servere, send da loggene via e-mail til denne adresse',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Periode kan ikke være længere end den serverbrede grænse %%max%%.',

    'login.loginLabel' => 'Brugernavn',
    'login.passwdLabel' => 'Adgangskode',
    'login.loginButtonLabel' => 'Log ind',
    'login.enterUsername' => 'Angiv dit brugernavn.',
    'login.enterPassword' => 'Angiv din adgangskode.',
    'login.whatUsernamePassword' => 'Hvilket brugernavn og adgangskode skal du bruge?',
    'login.forgotPasswordLabel' => 'Glemt din adgangskode?',
    'login.cookies' => 'Politik for cookies i Plesk',
    'login.avoidSSLWarningsMsg' => 'For at undgå SSL-advarsler under Plesk-login, skal du bruge %%link%%',
    'login.digitalOceanMsg' => 'Første gang med Plesk på DigitalOcean? Brug "root" og den adgangskode, der blev angivet under oprettelsen af denne droplet, til at logge på med. %%link%%',
    'login.amazonLightsailMsg' => 'Første gang med Plesk på Lightsail? Hvis du vil logge på Plesk, skal du tilgå serveren via SSH og bruge kommandoen "plesk login". %%link%%',
    'login.readGuide' => 'Læs hele vejledningen.',
    'login.mobileApplicationMessage' => 'For en bedre oplevelse anbefaler vi, at du installerer applikationen %%name%%.',
    'login.mobileApplicationInstall' => 'Installér nu',
    'login.mobileApplicationHide' => 'Nej tak',

    'force-reset-password.saveButton' => 'Gem',
    'force-reset-password.title' => 'Skift din adgangskode',
    'force-reset-password.passwordLabel' => 'Ny adgangskode',

    'panel-access.title' => 'Tilpasning af Plesk URL',
    'panel-access.hint' => 'Vælg brugerdefinerede URL\'er til indlogning i Plesk. Dette vil ikke fjerne muligheden for at logge ind i Plesk via porten %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Flere oplysninger',
    'panel-access.proxyEnabled' => 'Alle domæner og underdomæner, der opløses til serverens IP-adresse, men som ikke anvendes til hosting',
    'panel-access.proxyDomain' => 'Det angivne domæne eller underdomæne, der opløses til serverens IP-adresse, men som ikke anvendes til hosting',
    'panel-access.proxyDisabled' => 'Ingen brugerdefinerede URL\'er. Kun https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Gem',
    'panel-access.Form.cancelButton' => 'Annuller',

    'panel-access.domainNameIsRequired' => 'Du skal angive et domænenavn.',
    'panel-access.successMessage' => 'Den metode til logning, der blev anvendt.',
    'panel-access.notSupported' => 'Din Plesk understøtter ikke den valgte indlogningsmetode.',
    'panel-access.notViaDomainName' => 'Hvis du vil anvende denne indlogningsmetode, skal du vælge den første mulighed ("Alle domæner og underdomæner..."), logge ind i Plesk via https://%%domainName%%, og derefter vælge den anden mulighed.',
    'panel-access.notViaPort' => 'Hvis du vil anvende denne indlogningsmetode, skal du først logge ind i Plesk via https://<server-IP-or-hostname>:%%httpsPort%%',

    'php-settings.performance' => 'Ydelses- og sikkerhedsindstillinger',
    'php-settings.performanceSettingsNote' => 'Disse værdier kan ikke ændres individuelt for hvert domæne via .htaccess-, php.ini- eller .user.ini-filerne, medmindre domænet tilhører et abonnement, der har tilladelsen "Administration af hosting-ydelsesindstillinger".',
    'php-settings.settings' => 'Almindelige indstillinger',
    'php-settings.fastCgiSettings' => 'FastCGI-indstillingerne',
    'php-settings.fpmSettings' => 'PHP-FPM-indstillinger',
    'php-settings.enableFastcgi' => 'Aktiver FastCGI-indstillingerne',
    'php-settings.plainTextEditing' => 'Yderligere direktiver',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Du kan definere ethvert PHP-parameter ved at føje dem til felterne herunder. Direktiverne vil blive inkluderet i PHP-konfigurationen. Brug den samme syntaks som du bruger til php.ini. Hvis du f.eks. ønsker automatisk at indlæse udvidelsen mSQL, skal du tilføje linjen: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Hvis du ikke kan finde bestemte PHP-parametre, kan du føje dem til felterne herunder. Disse yderligere direktiver vil blive flettet sammen med direktiverne i hovedserviceplanen. Brug den samme syntaks som du bruger til php.ini. Hvis du f.eks. ønsker automatisk at indlæse udvidelsen mSQL, skal du tilføje linjen: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Du kan definere ethvert PHP-parameter ved at føje dem til felterne herunder. Direktiverne vil blive inkluderet i PHP-konfigurationen. Brug den samme syntaks som du bruger til php.ini. Hvis du f.eks. ønsker automatisk at indlæse udvidelsen mSQL, skal du tilføje linjen: extension=msql.so. For at tilpasse PHP-FPM puljeindstillingerne, skal du tilføje [php-fpm-pool-settings] separatoren og indtaste de ønskede indstillinger derunder.',
    'php-settings.additionalConfigurationDirectives' => 'Yderligere konfigurationsdirektiver',
    'php-settings.defaultValue' => 'Standard',
    'php-settings.predefinedValue' => 'Vælg værdi',
    'php-settings.customValue' => 'Indtast brugerdefineret værdi',
    'php-settings.phpSettingDescription_memory_limit' => 'Den maksimale mængde hukommelse i bytes som et script må reservere.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Den maksimale tid i sekunder, som et script må køre inden det termineres.',
    'php-settings.phpSettingDescription_max_input_time' => 'Den maksimale tid i sekunder et script må bruge på at fortolke inputdata.',
    'php-settings.phpSettingDescription_post_max_size' => 'Den maksimale størrelse i bytes af data, der kan postes med POST-metoden. Skal typisk være større end upload_max_filesize og mindre end memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Maksimal størrelse i bytes for en uploadet fil.',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP sikker tilstand lægger et antal begrænsninger på afviklingen af scripts, hovedsagelig af sikkerhedsgrunde.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Filer i den angivne mappe kan tilgås af PHP-scripts, når direktivet safe_mode er aktiveret. Mappen skal også være i include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programmer i den angivne mappe kan afvikles af PHP-scripts når direktivet safe_mode er aktiveret.',
    'php-settings.phpSettingDescription_include_path' => 'Listen over mapper som scripts kigger i efter filer (svarer til systemets PATH-variabel). Du kan adskille mapper vha. et kolon (:) under Linux og et semikolon (;) under Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Mappen til opbevaring af PHP-sessionsfiler.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Yderligere parametre til den mail() funktion.',
    'php-settings.phpSettingDescription_register_globals' => 'Registrer indholdet af EGPCS (Environment, GET, POST, Cookie, Server) variabler som globale variabler.',
    'php-settings.phpSettingDescription_open_basedir' => 'Filer i de angivne mapper kan ikke tilgås af PHP-scripts. Du kan adskille mapper vha. et kolon (:) under Linux og et semikolon (;) under Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Fejlrapporteringsniveau',
    'php-settings.phpSettingDescription_display_errors' => 'Bestemmer om fejl skal vises som en del af output.',
    'php-settings.phpSettingDescription_log_errors' => 'Aktivér logning af PHP-fejl.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Tillader PHP-filfunktioner at hente data fra eksterne steder over FTP eller HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Tillader upload af filer over HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Tillader den korte form ( ) af PHP\'s open tag.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Indstiller magic_quotes tilstand for GPC (Get/Post/Cookie) handlinger. Når magic_quotes er aktiveret, bliver alle \' (enkelt-anførselstegn), " (anførselstegn), (backslash), og NULL specialtegn automatisk escaped med \\ (backslash).',
    'php-settings.phpSettingDescription_disable_functions' => 'Med dette direktiv kan du deaktivere visse funktioner. Det anvender en kommasepareret liste med funktionsnavne',
    'php-settings.phpSupport' => 'PHP-understøttelse',
    'php-settings.phpRunAs' => 'Kør PHP som',
    'php-settings.phpVersion' => 'PHP-version',
    'php-settings.phpHandlerOutdated' => '(Forældet)',
    'php-settings.phpHandlerDeprecated' => '(Utidssvarende)',
    'php-settings.phpServedByApache' => 'betjent af Apache',
    'php-settings.phpServedByNginx' => 'betjent af nginx',
    'php-settings.phpSettingsPhpVersion' => 'Din PHP-version er %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP er deaktiveret.',
    'php-settings.phpHandlerTypeHint' => 'Herunder er oplysningerne om webstedets PHP-konfiguration. Du kan ændre PHP-konfigurationen, hvis hostingudbyderen giver dig de nødvendige tilladelser.',
    'php-settings.fpmDedicatedHandlerHint' => 'Brug af denne handler øger stabiliteten på et websted, men bruger også mere hukommelse.',
    'php-settings.phpHandlerChangeHint' => 'Du har ændret PHP handler indstillingerne. Hvis du gemmer disse ændringer, vil PHP scripts på dit websted muligvis stoppe i %%interval%% sekunder på grund af din serverkonfiguration.',
    'php-settings.phpHandlerOutdatedHint' => 'For at kontrollere, om den nye PHP-version er tilgængelig, følg %%link%% og tjek kategorien "Webhosting" for produktkomponenterne.',
    'php-settings.phpHandlerOutdatedHintLink' => 'åbn Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Lær hvordan du vælger de mest egnende PHP-indstillinger',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP-understøttelse kan ikke aktiveres, da aktuel hosting-konfiguration ikke inkluderer nogle PHP-versioner til rådighed for dette domæne.',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP-understøttelse kan ikke aktiveres, da aktuel Plesk-konfiguration ikke inkluderer nogle PHP-versioner til rådighed.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Find ud af hvordan du aktiverer andre PHP-versioner.',
    'php-settings.phpSupportEditable' => '(PHP-version %%version%%, kør PHP som %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(version: %%version%%; handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(ikke registreret) %%link%%',
    'php-settings.showPhpInfo' => 'Vis siden phpinfo()',
    'php-settings.phpSettingsFormError' => 'Kunne ikke indlæse PHP-indstillingerne, da de nødvendige data ikke findes.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Kan ikke hente PHP-indstillinger, fordi denne PHP-version ikke er installeret. For at fortsætte skal du installere den valgte PHP-version eller vælge en anden til domænet.',
    'php-settings.showPhpInfoTitle' => 'Vis phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Nogle af dine PHP-indstillinger er blevet ændret, men ændringerne er endnu ikke gemt. Hvis du vil se de nye værdier på siden phpinfo(), skal du overføre ændringerne først. I modsat fald vises de nuværende værdier.',
    'php-settings.showPhpInfoButton' => 'Vis phpinfo()',
    'php-settings.onState' => 'Aktiveret',
    'php-settings.offState' => 'Deaktiveret',
    'php-settings.description' => 'Denne side viser PHP-konfigurationen for webstedet. Disse indstillinger er specifikke for webstedet, og påvirker ikke andre websteder i abonnementet. Du kan ændre PHP-konfigurationen, hvis hostingudbyderen giver dig de nødvendige tilladelser. Brugerdefineret PHP-konfiguration kan f.eks. bruges hvis du vil begrænse system-ressourceforbruget for PHP-scripts eller opfylde et bestemt webprograms krav. Når du indstiller et parameter til standardværdien, vil PHP bruge parameterets værdi fra den server-brede PHP-konfiguration.',
    'php-settings.availableVariables' => 'Du kan bruge følgende pladsholdere i parameterværdier',
    'php-settings.variableDocroot' => '{DOCROOT} for dokument-rodmappen på dette websted. Den aktuelle værdi er %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'HTTPS-dokumentets rodbibliotek er det samme som for http.',
    'php-settings.variableDocrootHttpsDifferent' => 'HTTPS-dokumentets rodbibliotek er %%DOCROOT%%.',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} for dokument-rodmappen på abonnentens primære websted.',
    'php-settings.variableTmp' => '{TMP} for den mappe hvori midlertidige filer opbevares.',
    'php-settings.note' => 'Bemærk: Indstillingerne nedenfor kan overskrives af parametre, der er angivet i filerne htaccess-, php.ini- eller .user.ini.',
    'php-settings.showHelp' => 'Vis hjælp',
    'php-settings.select-ariaLabel' => 'vælg værdi',
    'php-settings.tuxCarePhpPromo' => 'Websteder, der bruger forældede PHP-versioner, kan blive til angrebsvektorer. Beskyt dem nu med %%link%%',
    'php-settings.tuxCarePhpLink' => 'TuxCare Extended Lifecycle Support til PHP.',
    'php-settings.phpHandlerLabel' => 'PHP-handler',
    'php-settings.phpHandlerIdLabel' => 'Kør PHP som',

    'pmm.agent.sync.check' => 'Migration & Transfer Agenten kontrollerer om der er opdateringer.',
    'pmm.agent.sync.updating' => 'Synkroniserer og downloader Migration & Transfer Agent',
    'pmm.agent.sync.done' => 'Migration & Transfer Agenten blev synkroniseret korrekt.',
    'pmm.agent.sync.downloadLink' => 'Klik for at downloade Migration & Transfer Agent filen, som du skal installere på kilde-host\'en, inden migreringen indledes.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agenten kunne ikke hente opdateringer. Prøv igen senere.',

    'restore-password.title' => 'Skift din adgangskode',
    'restore-password.passwordLabel' => 'Ny adgangskode',
    'restore-password.buttonRestore' => 'Gem',
    'restore-password.buttonCancel' => 'Annuller',
    'restore-password.isEmpty' => 'Det obligatoriske felt er tomt. Du skal angive en værdi.',
    'restore-password.errorInvalidSecret' => 'Ugyldig hemmelig kode',
    'restore-password.errorNotFoundSecret' => 'Anmod om en ny hemmelig kode',
    'restore-password.restoreSuccess' => 'Adgangskoden blev opdateret. Brug den nye adgangskode til at logge på Plesk eller på din email-adresse.',

    'scheduler.settings.schedulerNotification' => 'Planlæg notifikation',
    'scheduler.settings.notificationOff' => "Deaktiveret",
    'scheduler.settings.notificationDefault' => "Send til standard e-mail (%%email%%)",
    'scheduler.settings.notificationCustom' => "Send til den e-mail jeg angiver",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Vis opgaveplanlægning vha. en tidszone',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Brug systemets standard tidszone (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Brug systemets standard tidszone',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Brug tidszone I angiv',

    'scheduler.task.active' => 'Aktiv',
    'scheduler.task.subscription' => 'Abonnement',
    'scheduler.task.subscription_powerUser' => 'Webspace',
    'scheduler.task.type' => 'Opgavetype',
    'scheduler.task.typeCommand' => 'Kør en kommando',
    'scheduler.task.typeUrl' => 'Hen en URL',
    'scheduler.task.typeScript' => 'Kør et PHP-script',
    'scheduler.task.command' => 'Kommando',
    'scheduler.task.arguments' => 'med argumenter',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Angiv en absolut URL, eksempelvis http://eksempel.com. Hvis responsstatus-koden er 2xx eller 3xx, betragtes opgaven som værende korrekt udført.',
    'scheduler.task.script' => 'Scriptsti',
    'scheduler.task.scriptRelativePathDescription' => 'Eksempel: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Angiv fuld sti til script. Eksempel: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Brug PHP version',
    'scheduler.task.scriptPathPopupTitle' => 'Scriptsti',
    'scheduler.task.chooseFile' => 'Vælg fil',
    'scheduler.task.run' => 'Kør',
    'scheduler.task.on' => 'på',
    'scheduler.task.at' => 'i',
    'scheduler.task.sysUser' => 'Systembruger',
    'scheduler.task.hourly' => 'Hver time',
    'scheduler.task.daily' => 'Dagligt',
    'scheduler.task.weekly' => 'Hver uge',
    'scheduler.task.monthly' => 'Hver måned',
    'scheduler.task.yearly' => 'Årligt',
    'scheduler.task.cronStyle' => 'Cron style',
    'scheduler.task.cronStyleHint' => 'Brug UNIX crontab formatet "minut dag-i-måned måned ugedag". Eksempel "0 22 * * 1-5". Plesk vil bruge standard system-tidszonen ved kørsel af opgaven.',
    'scheduler.task.cronStyleWinHint' => 'Brug formatet "minut time dag-i-måned måned ugedag", f.eks "0 22 * * 6,7". Plesk vil bruge standard system-tidszonen ved kørsel af opgaven.',
    'scheduler.task.notify' => 'Give besked',
    'scheduler.task.notifyIgnore' => 'Adviser ikke',
    'scheduler.task.notifyErrors' => 'Kun fejl',
    'scheduler.task.notifyAlways' => 'Hver gang',
    'scheduler.task.notifyErrorsHint' => 'Adviseringer indeholder standardfejl-strømmen for kommandoen. Hvis strømmen er tom, sendes ingen advisering.',
    'scheduler.task.notifyErrorsHintWin' => 'Adviseringer indeholder kommandooutput og sendes kun, hvis exit-koden ikke er nul.',
    'scheduler.task.notifyAlwaysHint' => 'Adviseringer indeholder kommando-outputtet. Hvis output er tomt, sendes ingen advisering.',
    'scheduler.task.notifyAlwaysHintWin' => 'Adviseringer indeholder kommandooutput og sendes uanset exit-koden.',
    'scheduler.task.emailType' => 'Send adviseringer til',
    'scheduler.task.emailTypeDefault' => 'Standard systembruger (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Abonnementsejer (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrator (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Andre brugere',
    'scheduler.task.emailTypeCustomDescription' => 'Du kan angive flere adresser, adskilt med komma.',
    'scheduler.task.minute' => 'minut',
    'scheduler.task.shortMinute' => 'Min',
    'scheduler.task.dayOfMonth' => 'dag',
    'scheduler.task.description' => 'Beskrivelse',
    'scheduler.task.scheduleTimezoneHint' => 'Tidszonen for kørsel af opgaven er %%timezone%%',
    'scheduler.task.runTaskNow' => 'Kør nu',
    'scheduler.task.runningTask' => 'Kører opgaven "%%task%%"...',

    'server-settings.submitDone' => "Server-indstillingerne blev ændret.",
    'server-settings.systemSettings' => "Systemindstillinger",
    'server-settings.fullHostName' => "Fuldt host-navn",
    'server-settings.trafficStatisticsPeriod' => "Bevar web- og trafikstatistik for",
    'server-settings.trafficStatisticsPeriodUnit' => "Måneder",
    'server-settings.diskSpaceUsageCalculation' => "Inkludér i beregningen af diskpladsforbrug",
    'server-settings.includeLogs' => "logfiler",
    'server-settings.includeLogsAndStats' => "logfiler og statistikrapporter",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL-databaser",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL-databaser",
    'server-settings.includePgsqlDatabases' => "PostgreSQL-databaser",
    'server-settings.includeDatabases' => "databaser",
    'server-settings.includeRemoteDatabases' => "eksterne databaser",
    'server-settings.includeMailboxes' => "mailbokse",
    'server-settings.includeMailLists' => "mailinglister",
    'server-settings.includeDomainDumps' => "domænesikkerhedskopifiler",
    'server-settings.includeAdminDumps' => "sikkerhedskopifiler oprettet af administratoren",
    'server-settings.calculatingDiskSpaceUsage' => "Ved beregning af diskpladsforbrug, optæl",
    'server-settings.typeByte' => "filstørrelse",
    'server-settings.typeBlock' => "mængden af forbrugt diskplads",
    'server-settings.trafficCalculation' => "Inkludér i beregningen af trafik",
    'server-settings.inboundAndOutbound' => "indgående og udgående trafik",
    'server-settings.onlyInbound' => "kun indgående trafik",
    'server-settings.onlyOutbound' => "kun udgående trafik",
    'server-settings.forbidCreateDnsSubZone' => "Forbyd brugere at oprette DNS-underzoner i andre brugeres DNS-superzoner.",
    'server-settings.webDeployIncludePassword' => "Medtag brugerens adgangskode i filen med webdeployerings-indstillinger",
    'server-settings.forbidSysUserRename' => "Kunder kan ændre navnet på deres systembrugere",
    'server-settings.alwaysAllowSysUserRename' => "altid",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "kun hvis tilladelsen Hostingadministration er givet",
    'server-settings.neverAllowSysUserRename' => "aldrig",
    'server-settings.forbidSubscriptionRename' => "Forbyd kunder og forhandlere at ændre deres hoved-domænenavn",
    'server-settings.preferredDomain' => "Foretrukket domæne for websteder",
    'server-settings.preferredDomainNone' => "ingen",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "IP-logning",
    'server-settings.disableIpLogging' => "Deaktiver IP-logning i IIS, FTP og maillogs",
    'server-settings.disableIpLoggingDescription' => "Hvis valgt, skriver IIS og MailEnable ikke længere  IP-adresser til logfiler",
    'server-settings.anonymizeIps' => "Anonymiser IP-adresser",
    'server-settings.logrotateAnonymizeIps' => "Anonymiser IP-adresser under logrotation og indsamling af webstatistik",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Postrotate-scriptet erstatter den sidste oktet i IPv4-adresser i roterede logfiler med "0" før arkivering. I IPv6 adresser erstatter scriptet den sidste sektion af adressen (to oktetter efter det sidste kolon) med "0000" (i den fulde form) eller "0" (i kort form)',
    'server-settings.logrotate' => "Logrotation",
    'server-settings.logrotateForce' => "Gennemtving daglig logrotation for alle domæner",
    'server-settings.allowToStoreLogs' => "Tillad lagring af webstedslogfiler for",
    'server-settings.logrotatePeriod' => "dage",
    'server-settings.configureUpdatePolicy' => "Konfigurer opdateringspolitik",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Standard server-bred værdi (%%default%% meddelelser pr. time)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Brugerdefineret værdi for planen',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Brugerdefineret værdi for abonnementet',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'beskeder',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Udgående meddelelser fra en mailboks (pr. time)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Udgående meddelelser fra et domæne (pr. time)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Udgående meddelelser fra et abonnement (pr. time)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Procentdelen af meddelelser over pr.-time grænsen der skal sendes indenfor den næste time',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Hvis grænsen for udgående e-mails pr. time fra en mailboks er 100, og procenten er 10%, vil brugeren kunne sende 110 e-mails pr. time; 100 e-mails vil blive sendt i løbet af timen, og 10 e-mails vil blive lagt i en e-mail kø og planlægges afsendt indenfor den næste time.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail anvendelsespolitik',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Standard server-brede indstillinger (Sendmail er tilladt)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Standard server-brede indstillinger (Sendmail er ikke tilladt)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Brugerdefinerede indstillinger for planen',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Brugerdefinerede indstillinger for abonnementet',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Tillad brug af Sendmail for scripts og brugere i dette abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Scripts og brugere vil kunne sende e-mails (på vegne af abonnementets systembruger) ved at anvende Sendmail, selv hvis grænserne for en mailboks og et domæne er overskredet. Det maksimale antal e-mails der kan sendes via Sendmail vil blive defineret af grænsen for hele abonnementet.',

    'setup.hint' => 'Velkommen til Plesk, et kontrolpanel, der hjælper dig med administration af serveren. Plesk er et ready-to-code miljø, der giver dig et sæt kraftige extensions som en hjælp til udvikling af websteder og apps. Afslut opsætningsprocessen og start med at bruge Plesk (det tager kun et minuts tid).',
    'setup.contactInfoSection' => 'Kontaktinformation',
    'setup.contactInfoSectionHint' => 'Indtast dit navn og din e-mailadresse fo at identificere dig som serverens ejer og modtage vigtige adviseringer om serveren. Hvis du er en virksomheds-serveradministrator, må du ikke angive dit eget navn eller din personlige e-mail adresse. Brug din jobtitel og din virksomheds-e-mailadresse for at undgå mulige overtrædelser af databeskyttelseslovgivningen.',
    'setup.contactName' => 'Dit kontaktnavn',
    'setup.emptyContactName' => 'Angiv et kontaktnavn.',
    'setup.contactNameTooLong' => 'Kontaktnavnet er for langt (maksimalt %max% tegn er tilladt).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Angiv en mailadresse.',
    'setup.passwordSection' => 'Adgangskode',
    'setup.passwordSectionHint' => 'Næste gang du logger på Plesk, skal du bruge \'admin\' brugernavnet og den adgangskode, du har indtastet herunder.',
    'setup.password' => 'Adgangskode',
    'setup.licenseSection' => 'Licens',
    'setup.licenseSectionHint' => 'Du skal installere en licens for at kunne bruge Plesk.',
    'setup.licenseType' => 'Vælg din licenstype',
    'setup.licenseTypePaid' => 'Fortsæt med en betalt licens',
    'setup.activationCodeLabel' => 'Indtast din aktiveringskode her',
    'setup.onlineStoreLink' => 'Online butik',
    'setup.licenseTypeTrial' => 'Fortsæt med en full-featured prøvelicens',
    'setup.activationCodeHint' => 'Hvis du allerede har købt en Plesk-licens, skal du indsætte den modtagne aktiveringskode her.  ikke,kan du købe en ny licens i %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'WebPros\' politik om beskyttelse af personlige oplysninger',
    'setup.trialLicenseAgreement' => 'For at kunne udstede en prøvelicens vil WebPros International GmbH anvende og behandle de afgivne informationer i sine interne systemer i henhold til %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Jeg bekræfter, at jeg har læst og accepteret %%link%%',
    'setup.eula' => 'Slutbrugerlicensaftale',
    'setup.invalidEulaAgreementValue' => 'Du skal acceptere slutbrugerlicensaftalen',
    'setup.sendButton' => 'Kom i gang med Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Nulstil administratorens adgangskode ved næste login',

    'spam-filter.add.titleBlack' => 'Føj adresser til sortlisten',
    'spam-filter.add.titleWhite' => 'Føj adresser til hvidlisten',
    'spam-filter.add.fileDescription' => 'Upload en tekstfil i UTF-8-kodning (f.eks. en *.txt- eller *.csv-fil).',
    'spam-filter.add.listDescription' => 'Regler for formatering: <ul><li>Adskil individuelle adresser med komma, semikolon eller ny linje, mellemrum eller tabulatortegn.</li><li>Brug ikke ikke-ASCII-tegn til venstre for @-tegnet.</li><li>Du kan bruge jokertegnene "*" og "?" (f.eks. <nobr>*@domain.com,</nobr> <nobr>bruger?@*.com</nobr>).</li><li>Brug ikke jokertegn i ikke-ASCII-dele af domænenavne.</li></ul>',
    'spam-filter.add.fromFile' => 'Fra fil',
    'spam-filter.add.fromList' => 'Fra liste',
    'spam-filter.add.success' => 'Adresser blev tilføjet',

    'ssl-certificate.add.name' => 'Certifikatnavn',
    'ssl-certificate.add.longName' => 'Det angivne certifikatnavn er for langt (maksimalt %max% tegn er tilladt).',
    'ssl-certificate.add.certificateNameUsed' => 'Der findes allerede en mappe med navnet %%name%% .',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS-certifikatet blev udstedt. For at få det til at fungere, skal du tilknytte certifikatet for at sikre et domæne, mail eller webmail.',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS-cetifikatet blev korrekt opdateret.',
    'ssl-certificate.add.settings' => 'Indstillinger',
    'ssl-certificate.add.settingsHint' => 'Brug denne formular til at generere en certifikatanmodning, til køb af et certifikat fra din udbyder, eller for at generere et selvunderskrevet certifikat.',
    'ssl-certificate.add.settingsHint2' => 'En anmodning er en CSR-fil der indeholder de informationer om dit domæne, du har specificeret i formularen.  Du kan sende anmodningen til den ønskede certificeringsmyndighed, så disse udsteder certifikatet til dig. Du kan herefter upload det vha. af en af nedenstående upload-formularer.',
    'ssl-certificate.add.settingsHint3' => 'Et selvunderskrevet certifikat er et identitetscertifikat, der er underskrevet af dets egen udsteder. Hvis du bruger sådan et certifikat betyder det, at du selv står inde for dine websteders identitet. Selvom et selvunderskrevet certifikat lader dig bruge SSL/TLS, er sådanne certifikater mindre tillidsskabende og de betragtes generelt som mindre sikre.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'Land',
    'ssl-certificate.add.state' => 'Område eller provins',
    'ssl-certificate.add.longState' => 'Navnet på den angivne stat eller provins er for langt.',
    'ssl-certificate.add.city' => 'Sted (By)',
    'ssl-certificate.add.longCity' => 'Det angivne bynavn er for langt.',
    'ssl-certificate.add.shortCity' => 'Det angivne bynavn er for kort.',
    'ssl-certificate.add.companyName' => 'Organisationens navn (firma)',
    'ssl-certificate.add.longCompanyName' => 'Det angivne firmanavn er for langt.',
    'ssl-certificate.add.companyUnitName' => 'Organisationsafdeling eller divisions-navn',
    'ssl-certificate.add.longCompanyUnitName' => 'Det angivne organisations-afdelingsnavn er for langt (maksimalt %max% tegn er tilladt).',
    'ssl-certificate.add.domainName' => 'Domænenavn',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Anmodning',
    'ssl-certificate.add.buyCertificate' => 'Køb SSL-TLS certifikat',
    'ssl-certificate.add.selfSigned' => 'Selvsigneret',
    'ssl-certificate.add.invalidCertificateParams' => 'Nogle felter er tomme, eller indeholder ugyldige værdier. Værdien skal begrænses til 64 tegn.  Hvis du bruger et internationaliseret domænenavn skal du være sikker på, at ingen del af domænenavnet mellem punktummer overstiger 63 tegn, når de omdannes til ASCII-format.  Kontrollér felterne:',
    'ssl-certificate.add.unableCreateCsr' => 'Kan ikke oprette et CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Kan ikke oprette et selvunderskrevet certifikat: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Kunne ikke indstille certifikatdata: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Kan ikke gemme certifikatet i databasen: %%error%%.',
    'ssl-certificate.add.uploadFiles' => 'Upload certifikatfilerne',
    'ssl-certificate.add.uploadFilesHint' => 'Brug denne formular til upload af et certifikats komponenter som konsistente filer.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Privat nøgle (*.key)",
    'ssl-certificate.add.certificate' => "Certifikat (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA-certifikat (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Upload certifikat",
    'ssl-certificate.add.fileNotUploaded' => 'Kunne ikke uploade certifikatfilen %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Kan ikke indstille den private nøgle: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Kan ikke indstille certifikatet: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Kan ikke indstille CA-certifikatet: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Kan ikke kontrollere, om CA-certifikatet underskriver certifikatet: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Fjern',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Vil du virkelig fjerne CA-certifikatet?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Kan ikke rydde CA-certifikatet: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'CA-delen af certifikatet blev fjernet.',
    'ssl-certificate.add.rename' => 'Omdøb',
    'ssl-certificate.add.unableRenameCertificate' => 'Kan ikke omdøbe certifikatet: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Certifikatet blev omdøbt til %%name%%.',
    'ssl-certificate.add.uploadText' => "Upload certifikatet som tekst",
    'ssl-certificate.add.uploadTextHint' => 'Brug denne formular til upload af et certifikats komponenter som tekst. Kopiér indholdet af en fil og indsæt den i det korresponderende felt.',
    'ssl-certificate.add.sendText' => "Upload certifikat",
    'ssl-certificate.add.componentIsMissing' => 'Komponenten mangler.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Upload certifikatet her',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Hvis du oprettede en certifikat-underskriftsanmodning på denne server og modtog certifikatfilen, skal du uploade den her. Hvis du vil uploade et certifikat- og privatnøgle-par, der er genereret på en anden server, eller generere et selvunderskrevet certifikat, skal du klikke på <b>Tilføj SSL/TLS- certifikat</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Efter tilføjelse af et SSL/TLS-certifikat til et domæne, skal du aktivere SSL/TLS-understøttelse og vælge det pågældende certifikat i webstedets hosting-indstillinger: <b>Websteder og domæner</b>> <b>Hosting indstillinger</b>  for dette domæne> <b>Sikkerhed</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certifikat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Upload certifikat',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Kan ikke uploade certifikatfilen.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Ugyldigt certifikatformat',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Kunne ikke finde en passende privat nøgle til certifikatet.',

    'ssl-certificate.secure.certificate' => 'Vælg certifikat',
    'ssl-certificate.secure.serverPool' => 'Serverpulje',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Dato",
    'system-time.dateAndTime' => "Dato og klokkeslæt",
    'system-time.daylight' => "Tilpas automatisk uret til sommertid",
    'system-time.dayMonthYear' => "Dag-Måned-År",
    'system-time.domainNameOrIp' => "Domænenavn eller IP",
    'system-time.hoursMinutesSeconds' => "Timer:Minutter:Sekunder",
    'system-time.networkTime' => "Netværkstid",
    'system-time.submitDone' => "Systemtidsindstillinger blev ændret.",
    'system-time.synchronizedSystemTime' => "Synkronisér systemuret",
    'system-time.title' => "Systemdato og klokkeslæt",
    'system-time.timezone' => "Tidszone",
    'system-time.time' => "Tidspunkt",
    'system-time.updateSystemTime' => "Opdatér systemuret",
    'system-time.yourTimezone' => "Din tidszone",

    'web-app-firewall.pageHint' => 'Webapplikation-firewall\'en beskytter webapplikationer mod angreb ved at tjekke og filtrere indkommende HTTP-anmodninger, baseret på brugerdefinerede regler.',
    'web-app-firewall.webSitePageHint' => 'Her kan du konfigurere web-programmets firewall (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Webprogram firewall-tilstand',
    'web-app-firewall.ruleEngineOn' => 'Aktiveret',
    'web-app-firewall.ruleEngineOnDescription' => 'Hver indkommende HTTP-anmodning og den relaterede respons tjekkes op imod et sæt regler. Hvis dette tjek gennemføres med succes, videresendes HTTP-anmodningen til webstedsindholdet. Hvis tjekket mislykkes, logges hændelsen, en notifikation sendes, og HTTP-responsen leveres med en fejlkode.',
    'web-app-firewall.ruleEngineOff' => 'Deaktiveret',
    'web-app-firewall.ruleEngineOffDescription' => 'Indkommende HTTP-anmodninger og relaterede svar kontrolleres ikke.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Kun detektering',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Hver indkommende HTTP-anmodning og den relaterede respons tjekkes op imod et sæt regler. Hvis dette tjek gennemføres med succes, videresendes HTTP-anmodningen til webstedsindholdet. Hvis tjekket mislykkes, logges hændelsen, og ModSecurity udfører ingen yderligere handlinger. andre services (f. eks. Fail2ban) kan stadig udføre egne handlinger på HTTP-anmodninger, der ikke slap gennem tjekket.',
    'web-app-firewall.ruleSetsSection' => 'Regelsæt',
    'web-app-firewall.ruleSetsSectionHint' => 'Vælg hvilket regelsæt (en pakke med filer, der indeholder sikkerhedsregler), der skal bruges til tjek af de indkommende HTTP-anmodninger.',
    'web-app-firewall.ruleSet' => 'Regelsæt',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratis)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set er yderst restriktivt og vil muligvis blokere nogle funktioner (eksempelvis fildeling, webmail) samt nogle af web-applikationernes features (eksempelvis WordPress-plugins).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Anvende ændringerne?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP-reglerne kan være for restriktive og derved blokere for visse funktioner som f.eks. fildeling, webmail og visse web-applikationer.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratis, kan opgraderes til Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'En starterversion af ModSecurity Rules fra Atomicorp. De yder grundlæggende beskyttelse, og opdateres hver måned.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Sådan opgraderes dette regelsæt til Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Køb %%linkPleskStore%% på Plesk\'s websted og %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Avancerede ModSecurity regler fra Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'installer den købte udvidede licensnøgle',
    'web-app-firewall.ruleSetTortixSelect' => 'Vælg dette regelsæt, der så vil skifte navn til “Atomic Advanced (købt fra Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (købt fra Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules fra Atomicorp inkluderer Atomic Standard-regler plus et antal avancerede features.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (købt af Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules fra Atomicorp inkluderer Atomic Standard-regler plus et antal avancerede features.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Skift til en anden Atomicorp-konto.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Regelsæt er aktiveret.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Hvis du allerede har en Atomicorp konto med de købte Atomic Advanced regler, kan du indtaste kontoakkreditiver herunder for at aktivere dette regelsæt.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Hvis du allerede har Atomicorp-kontoen med de købte Atomic Advanced-regler, skal du angive kontoakkreditiverne herunder for at skifte konto.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Brugernavn',
    'web-app-firewall.ruleSetAtomicPassword' => 'Adgangskode',
    'web-app-firewall.ruleSetComodo' => 'Comodo (gratis abonnement)',
    'web-app-firewall.ruleSetComodoDescription' => 'Gratis ModSecurity-regler fra Comodo. De giver grundlæggende beskyttelse.',
    'web-app-firewall.ruleSetComodoInstall' => 'Skift til en anden Comodo-konto.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Regelsæt er aktiveret.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Sådan aktiveres dette regelsæt:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Sådan skifter du til en anden konto:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registrer dig på Comodo-webstedet.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Indtast dit brugernavn og adgangskoden på det websted.',
    'web-app-firewall.ruleSetComodoLogin' => 'Brugernavn',
    'web-app-firewall.ruleSetComodoPassword' => 'Adgangskode',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratis)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Gratis ModSecurity-regler fra Comodo. De giver grundlæggende beskyttelse.',
    'web-app-firewall.ruleSetCustom' => 'Brugerdefinerede regelsæt',
    'web-app-firewall.ruleSetCustomDescription' => 'Upload et brugerdefineret webapplikations firewall-regelsæt. Understøttede formater: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Vælg en anden fil',
    'web-app-firewall.ruleSetError' => 'Kunne ikke installere ModSecurity regelsæt: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP-regelsættet mangler. Geninstaller ModSecurity ved hjælp af Plesk Installer.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Det brugerdefinerede regelsæt mangler. Geninstaller regelsættet.',
    'web-app-firewall.ruleSetAuthError' => 'Det angivne brugernavn eller adgangskoden er ugyldig.',
    'web-app-firewall.ruleSetInvalid' => 'Det valgte regelsæt kan ikke køres på %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Det valgte regelsæt kan ikke køres på den valgte webserver.',
    'web-app-firewall.webServer' => 'Kør regler på',
    'web-app-firewall.webServerHint' => 'Vælg den ønskede kombination af webserver og ModSecurity-version for at se kompatible regelsæt.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Reverse Proxy Server (nginx) er deaktiveret og kan ikke anvendes til behandling af anmodninger. Vælg <a href="%%serverUrl%%">en anden webserver</a> eller aktiver reverse proxy-serveren på siden <a href="%%servicesUrl%%">Serviceadministration</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Valg af en anden ModSecurity-version kan resultere j at nogle indstillinger ikke længere er gyldige (f. eks. kan du ikke bruge regulære udtryk til deaktivering af sikkerhedsregler med ModSecurity 3). Kontroller, at dine indstillinger fungerer som forventet efter at ændringerne er udført. Alternativt kan du nulstille de indstillinger, der deaktiverer sikkerhedsreglerne til standardværdier.',
    'web-app-firewall.nginxResetCustomizations' => 'Nulstil de server- og domæneindstillinger, der deaktiverer sikkerhedsreglerne, til deres standardværdier.',
    'web-app-firewall.ruleSetUpdate' => 'Opdatering af regelsæt',
    'web-app-firewall.ruleSetUpdateDaily' => 'Dagligt',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Hver uge',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Hver måned',
    'web-app-firewall.currentRuleSet' => 'Regelsæt',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% kører på %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Redigér regelsæt',
    'web-app-firewall.ruleSetRollbackFailed' => 'Kan ikke bruge det nuværende ModSecurity-regelsæt og rulle tilbage til den foregående version, da de indeholder ugyldige regler.',
    'web-app-firewall.configurationSection' => 'Konfiguration',
    'web-app-firewall.configurationSectionHint' => 'Konfigurer webapplikations-firewall\'en vha. enten et prædefineret sæt parametre eller dine egne brugerdefinerede ModSecurity direktiver.',
    'web-app-firewall.configPreset' => 'Prædefineret værdisæt',
    'web-app-firewall.configPresetFast' => 'Hurtig',
    'web-app-firewall.configPresetFastDescription' => 'HTTP-anmodningens URI og dele af headerne vil blive analyseret.',
    'web-app-firewall.configPresetTradeOff' => 'Balanceret',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP-anmodningens URI, headere og anmodningen POST-data vil blive analyseret.',
    'web-app-firewall.configPresetThrough' => 'Grundig',
    'web-app-firewall.configPresetThroughDescription' => 'De fulde HTTP-anmodningsheadere, anmodningens POST-data og HTTP-responsens brødtekstindhold vil blive analyseret.',
    'web-app-firewall.configCustom' => 'Brugerdefinerede direktiver',
    'web-app-firewall.configCustomDescription' => "Indtast et ModSecurity-direktiv her.  Det vil tilsidesætte de tidligere angivne direktiver (regelsæt, specifikke regler, det prædefinerede værdisæt osv.).\nFor eksempel: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Ugyldig ModSecurity-konfiguration: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Kunne ikke bruge den nuværende ModSecurity-konfigurationsfil og rulle tilbage til den foregående version af filen, fordi de begge indeholder en ugyldig konfiguration.',
    'web-app-firewall.rulesSection' => 'Deaktivér sikkerhedsreglerne',
    'web-app-firewall.rulesSectionHint' => 'Her kan du deaktivere sikkerhedsregler. Det er handy, hvis du finder, at en sikkerhedsregel er for restriktiv på visse websteder. Du kan deaktivere sikkerhedsregler ved at angive deres ID\'er (f. eks. 340003 eller 340005-340007), tags (f. eks. CVE-2011-4898), eller almindelige udtryk, brugt i regelmeddelelser (f. eks. XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Her kan du deaktivere sikkerhedsregler. Det er handy, hvis du finder, at en sikkerhedsregel er for restriktiv på visse websteder. Du kan deaktivere sikkerhedsregler ved at angive deres ID\'er (f. eks. 340003 eller 340005-340007), tags (f. eks. CVE-2011-4898), eller almindelige udtryk, brugt i regelmeddelelser (f. eks. Fundet bruger-agent tilknyttet med sikkerhedsscanner).',
    'web-app-firewall.filterById' => 'Sikkerhedsregel-ID\'er',
    'web-app-firewall.filterByIdInvalid' => 'Følgende værdier er ugyldige: %%values%%. Regel-ID\'et bør bestå af enkeltcifre eller en række cifre som f. eks. 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'De følgende intervaller er ugyldige: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Mærker',
    'web-app-firewall.filterByTagActive' => 'Aktiv:',
    'web-app-firewall.filterByTagDeactivated' => 'Deaktiveret:',
    'web-app-firewall.filterByTagInvalid' => 'De følgende valgte værdier er ugyldige: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Almindelige udtryk i regelmeddelelser',
    'web-app-firewall.filterByRegexpInvalid' => 'Følgende værdier er ugyldige: %%values%%. De må ikke indeholde \', " tegn.',
    'web-app-firewall.filterByRegexpNginx' => 'Regelmeddelelser',
    'web-app-firewall.filterByRegexpNginxHint' => 'Kun præcise matches understøttes.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Følgende værdier er ugyldige: %%values%%. Regelmeddelelsen skal bestå af bogstaver, cifre, mellemrum eller tegn -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'ModSecurity revisionslog',
    'web-app-firewall.auditLogHint1' => 'Revisions-logfilen ModSecurity indeholder den mest nyttige information i systemet.  Når ModSecurity finder, at der forekommer en hændelse, genererer den en post i revisionslogfilen.',
    'web-app-firewall.auditLogHint2' => 'Et websted kan holde op med at fungere som forventet efter at du har ændret webprogrammets firewall-tilstand til On fra Off eller Detection only.  I dette tilfælde kan en analyse af revisionslogfilen ModSecurity vise hvad der er sket.  Du kan deaktivere for restriktive sikkerhedsregler eller justere webstedet.',
    'web-app-firewall.auditLogHint3' => 'For at finde ud af, hvorfor en HTTP-anmodning ikke kan gennemføres for et websted:',
    'web-app-firewall.auditLogPoint1' => 'Klik på linket ModSecurity Logfil herunder, og åbn revisionsloggen i et nyt browser-vindue.',
    'web-app-firewall.auditLogPoint2' => 'Brug Søg (Ctrl+F i de fleste browsere) for at finde hændelser for webstedet (domænenavnet) der udviser problemer.  Eksempelvis, your_domain.tld.  Browseren vil fremhæve poster som HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'Find tre linjer over den fremhævede post en streng som denne --eece5138-B--.  De otte symboler mellem bindestregerne (i eksemplet eece5138) er ID\'et for den hændelse, der er udløst af HTTP-anmodningen.',
    'web-app-firewall.auditLogPoint4' => 'Søg videre efter andre poster med det samme hændelses-ID. Led efter en post med bogstavet H efter hændelses-ID\'et (i eksemplet eece5138-H--). Denne post indeholder ID\'et og en beskrivelse af hvilken sikkerhedsregel der blev udløst ved kontrol af HTTP-anmodningen. Sikkerhedsregel-ID\'et er et heltal i anførselstegn med præfiks-ID\'et i firkantklammer (f.eks. [ID "340003"]).',
    'web-app-firewall.auditLogPoint5' => 'Find et sikkerhedsregel-ID i hændelsen vha. en understreng (f.eks. [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Deaktivér sikkerhedsreglen med dette ID i sektionen Sikkerhedsregler herunder, indtast sikkerhedsregel-ID\'et ID (kun cifre) i feltet Sikkerhedsregel-ID\'er og klik på OK.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity logfil',
    'web-app-firewall.auditLogListLink' => 'Log-arkiv',
    'web-app-firewall.errorLogSection' => 'Fejllog',
    'web-app-firewall.errorLogSectionHint' => 'Et websted kan holde op med at fungere som forventet efter at du har ændret webprogrammets firewall-tilstand til On fra Off eller Detection only.  I dette tilfælde kan en analyse af fejlloggen vise hvad der sker. Du kan deaktivere for restriktive sikkerhedsregler eller justere webstedet.',
    'web-app-firewall.errorLogViewLink' => 'Fejllog fil',
    'web-app-firewall.notificationStateEnabled' => 'Plesk UI-adviseringer for regelsæt-opdateringer er aktiverede. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Plesk UI-adviseringer for regelsæt-opdateringer er deaktiverede. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Administrer dem på siden for adviseringer',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Valg af indstillingerne "Balanceret" eller "Grundig" kan, blandt andre uønskede bivirkninger, medføre, at WordPress-websteder ikke fungerer korrekt på grund af følgende <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity-problem</a>.',
    'web-app-firewall.fileNotUploaded' => 'Filen kan ikke uploades.',

    'web-server-settings.selectUnitSize' => 'Vælg enhedsstørrelse',
    'web-server-settings.inputSize' => 'Indtast størrelse',

    'ProtectedDirectory.pathLabel' => 'Mappenavn',
    'ProtectedDirectory.realmLabel' => 'Titel på det beskyttede område',
    'ProtectedDirectory.locationLabel' => 'Mappeplacering',
    'ProtectedDirectory.isNonSslLabel' => 'ikke-SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Rapportnavn',
    'SummaryReport.Layout.isDefault' => 'Brug som standardrapport',
    'SummaryReport.Layout.sections' => 'Sektioner',
    'SummaryReport.Layout.general' => 'Generelt',
    'SummaryReport.Layout.resellers' => 'Forhandlere',
    'SummaryReport.Layout.clients' => 'Kunder',
    'SummaryReport.Layout.personalClients' => 'Egne kunder',
    'SummaryReport.Layout.domains' => 'Domæner',
    'SummaryReport.Layout.personalDomains' => 'Personlige domæner',
    'SummaryReport.Layout.type.full' => 'Fuld',
    'SummaryReport.Layout.type.summary' => 'Oversigt',

    'SummaryReport.Schedule.enable' => 'Aktiver',
    'SummaryReport.Schedule.period' => 'Leveringsfrekvens',
    'SummaryReport.Schedule.daily' => 'Dagligt',
    'SummaryReport.Schedule.weekly' => 'Hver uge',
    'SummaryReport.Schedule.monthly' => 'Hver måned',
    'SummaryReport.Schedule.email' => 'Levér til',
    'SummaryReport.Schedule.isEmpty' => 'Indtast en gyldig e-mailadresse.',

    'MassMailForm.name' => 'Skabelonnavn',
    'MassMailForm.fromEmail' => 'Fra (e-mailadresse)',
    'MassMailForm.sendToAdmins' => 'Send til Plesk-administrator',
    'MassMailForm.sendToResellers' => 'Send til forhandlere',
    'MassMailForm.sendToClients' => 'Send til kunder',
    'MassMailForm.subject' => 'Emne',
    'MassMailForm.body' => 'Beskedtekst',
    'MassMailForm.bodyDescription' => '
Du kan bruge <name>variablen i meddelelsesteksten (men ikke i headeren). Den vil blive erstattet med kundens eller forhandlerens kontaktnavn.',
    'MassMailForm.sendToResellersMode' => 'Send til',
    'MassMailForm.sendToResellersModeAll' => 'Alle forhandlere',
    'MassMailForm.sendToResellersModeSelect' => 'Udvalgte forhandlere',
    'MassMailForm.sendToResellersModeExcept' => 'Alle undtagen markerede forhandlere',
    'MassMailForm.sendToClientsMode' => 'Send til',
    'MassMailForm.sendToClientsModeAll' => 'Alle kunder',
    'MassMailForm.sendToClientsModeSelect' => 'Udvalgte kunder',
    'MassMailForm.sendToClientsModeExcept' => 'Alle undtagen markerede kunder',

    'VirtualDirectory.DirectorySection.title' => 'Virtuel mappe',
    'VirtualDirectory.DirectorySection.name' => 'Navn',
    'VirtualDirectory.DirectorySection.accessSource' => 'Script-kildeadgang',
    'VirtualDirectory.DirectorySection.accessRead' => 'Læserettigheder',
    'VirtualDirectory.DirectorySection.accessWrite' => 'Skrivetilladelse',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => 'Biblioteksgennemsyn',
    'VirtualDirectory.DirectorySection.log' => 'Før logfil over besøg',
    'VirtualDirectory.Path.path' => 'Sti',
    'VirtualDirectory.Path.autoPathLabel' => 'Opret en fysisk mappe med det samme navn som den virtuelle',
    'VirtualDirectory.ApplicationSettingsSection.title' => 'Programindstillinger',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => 'Opret program',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => 'Tillad brug af overordnede stier',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'Tillad programafvikling i MTA (multi-threaded apartment) tilstand',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => 'Udfør tilladelser',
    'VirtualDirectory.SecuritySection.title' => 'Mappesikkerhed',
    'VirtualDirectory.SecuritySection.authAnonymous' => 'Aktiverer anonym godkendelse',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Aktiverer Windows-godkendelse',
    'VirtualDirectory.SecuritySection.requireSSL' => 'Kræver -SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => 'Ingen',
    'VirtualDirectory.scriptExecuteOption.script' => 'Kun scripts',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => 'Scripts og eksekverbare filer',
    'VirtualDirectory.AspSection.title' => 'ASP-indstillinger',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'ASP-bufferens maksimumsstørrelse (KB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'Maksimumstørrelse for hele indholdet af en ASP-anmodning (KB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'Aktiver fejlfinding af ASP-scripts på serversiden',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'Aktiver fejlfinding af ASP-scripts på klientsiden',
    'VirtualDirectory.AspSection.definedByIis' => 'Defineret af IIS',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'Defineret af IIS (%%size%% KB)',
    'VirtualDirectory.AspSection.definedByParent' => 'Defineret af overordnet mappe',
    'VirtualDirectory.AspSection.definedByParentWithSize' => 'Defineret af overordnet mappe (%%size%% KB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => 'Ja',
    'VirtualDirectory.CheckboxField.false' => 'Nej',
    'VirtualDirectory.DocumentsSection.title' => 'Dokumenter',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => 'Brug standarddokumenter',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => 'Standard dokument-søgerorden',
    'VirtualDirectory.DefaultDocsField.remove' => 'Fjern',
    'VirtualDirectory.NewDefaultDoc.add' => 'Tilføj',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => '/Klik for at føje en fil til listen.',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => 'Indtast et filnavn for at føje det til listen.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => 'Der findes allerede en fysisk mappe med samme navn. Hvis du fortsætter, bliver biblioteket utilgængeligt. Vil du fortsætte alligevel?',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => 'Fortsæt',

    'VirtualDirectoryMimeType.extension' => 'Lokalnummer',
    'VirtualDirectoryMimeType.content' => 'Indhold',
    'VirtualDirectoryMimeType.custom' => 'Valgfri',
];