<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Accés denegat. El seu compte s'ha suspès.",
    'login_up__login_has_been_locked' => "Ha intentat iniciar sessió utilitzant una contrasenya incorrecta massa vegades. Per motius de seguretat, durant un temps no podrà iniciar sessió fent servir aquest nom d'usuari.",
    'login_up__unable_to_check_pass' => "No ha estat possible comprovar la contrasenya: %1",
    'login_up__warning_limits_licence_key' => "Un dels següents elements ha excedit el límit definit per la seva clau de llicència: número de comptes d'usuari, dominis, comptes de correu o usuaris web allotjats al seu servidor.\nPosi's en contacte amb el nostre departament comercial per tal d'adquirir una clau que li permeti allotjar el número desitjat d'usuaris i dominis. Si ha rebut aquest missatge per error, agrairíem es posés en contacte amb el nostre departament de suport tècnic.\nEl número màxim de comptes d'usuari/dominis/comptes de correu/usuaris web/paquets d'idioma permès per la llicència: %2.\nEl número de comptes d'usuari/dominis/comptes de correu/usuaris web/paquets d'idioma allotjats: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "La quantitat de recursos utilitzats supera els límits definits per la seva llicència actual del producte. Posi's en contacte amb el nostre departament comercial per tal d'adquirir una clau de llicència nova.",
    'login_up__grace_period' => 'En aquests moments està dins del període de gràcia de la seva llicència del producte. Per actualitzar la llicència, seleccioni l\'opció Recuperar claus a la pàgina %1Informació de la llicència%2.',
    'login_up__partner_license_message' => 'En aquest moment està utilitzant una llicència limitada del producte que requereix el registre abans de poder activar tot el conjunt de prestacions. Per actualitzar la llicència, seleccioni l\'opció Recuperar claus a la pàgina %1Informació de la llicència%2.',
    'login_up__system_admin_disabled' => 'Per motius de seguretat, els super usuaris (compte d\'administrador o root) no pode accedir a Plesk.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Guia de l'administrador de Plesk",
    'plesk_guide_reseller' => "Guia del revenedor de Plesk",
    'plesk_guide_client' => "Guia del client de Plesk",
    'plesk_guide_domain_admin' => "Guia de l'administrador de domini de Plesk",
    'plesk_guide_mailuser' => "Guia de l'usuari de correu de Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Buscar', // multiple usage: TBI
    'nav__general' => 'Menú principal',
    '__home' => 'Inici',
    '__applications' => 'Aplicacions',
    '__settings' => 'Configuració',
    'nav__system' => 'Sistema',
    '__master' => 'Principal',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Nivell superior',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Eliminar',
    'bt_make_default' => 'Fer per defecte',

    // common list object search keys
    'bt_show_all' => "Restablir cerca",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Actiu',
    '__object_off' => 'Suspès',

    '__home_description' => 'Torni a la pàgina inicial.',
    'indicator_title' => '%1% utilitzat, %2% disponible', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'S\'ha sol·licitat una URL que no és vàlida.',

    // business objects
    'mn_list__mail_names_for_client' => 'Comptes de correu sota el compte d\'usuari %1',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'Nom',
    'domains_list__state__filter_title' => 'Ús de recursos',
    'domains_list__filter_state_any' => 'Qualsevol',
    'domains_list__filter_state_overuse' => 'Sobreús',
    'domains_list__filter_state_normal' => 'Dins dels límits',
    'domains_list__status__filter_title' => 'Estat',
    'domains_list__filter_status_any' => 'Qualsevol',
    'domains_list__filter_status_blocked' => 'Suspès',
    'domains_list__filter_status_active' => 'Actiu',
    'domains_list__subrows__filter_title' => 'Mostrar',
    'domains_list__subrows_off' => 'Només dominis',
    'domains_list__subrows_subdomain_domainaliases' => 'Amb subdominis i àlies',
    'domains_list__subrows_subdomain' => 'Amb subdominis',
    'domains_list__subrows_domainaliases' => 'Amb àlies',

    // objects list
    'domains_list__owner__title' => 'Propietari',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Cercar aplicacions",
    'site_apps__promo_main_text' => "El catàleg APS (Application Packaging Standard) conté la llista d'aplicacions que poden aprovisionar-se en un domini o espai web. Si desitja aprovisionar aplicacions que en aquest moment no estan presents al catàleg, pot fer-ho fàcilment seguint les instruccions de creació de paquets d'APS disponibles a www.apsstandard.com",
    'site_apps__promo_download_now' => "Descarregar aplicacions:",
    'site_apps__promo_close' => "Tancar aquest bloc",
    'site_apps__promo_preset__mostused' => '%1 més populars',
    'site_apps__promo_preset__lessused' => 'Següents %1 més populars',
    'site_apps__promo_preset__all' => "Tots",
    'site_apps__promo_disclaimer_note' => 'Tingui en compte que les aplicacions instal·lades mitjançant el catàleg APS són proporcionades per tercers i Plesk no n\'ofereix suport.',
    'site_apps__promo_preset__page_title' => '%1 aplicacions APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Afegint aplicacions...',

    // Errors
    'site_apps__no_applications_for_update' => 'No té cap aplicació instal·lada a l\'application vault.',
    'site_apps__incorrect_download_preset_configuration' => 'S\'han detectat errors a la configuració dels valors predefinits de descàrrega del catàleg APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'L\'URL indicada no és vàlida.',
    'site_apps__no_updates_at_the_moment' => 'En aquest moment no hi ha cap actualització disponible.',
    'site_apps__incorrect_content_returned_by_catalog' => 'S\'ha rebut una informació incorrecta des del catàleg d\'aplicacions APS. Torni-ho a provar en uns minuts.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'No s\'ha desat la configuració del catàleg APS, si bé Plesk no ha pogut establir una connexió al catàleg APS indicat a la configuració del catàleg APS (%1). Comprovi que l\'adreça del catàleg APS és correcta i que el catàleg està actiu en aquesta adreça.',
    'site_apps__cannot_retrieve_updates' => 'En aquest moment no es poden descarregar actualitzacions per a l\'aplicació. No ha estat possible connectar-se al catàleg APS (%1). Comprovi que l\'adreça del catàleg APS és correcta i que el catàleg està actiu en aquesta adreça.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'No hi ha cap aplicació web disponible per a ser instal·lada.',
    'site_apps__site_applications_already_installed_in_root' => 'Als directoris arrel d\'aquests hosts virtuals ja s\'han instal·lat altres aplicacions web',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "A les plataformes Unix/Linux no es suporten aplicacions web .NET",
    'site_apps__server_wide_packages_not_supported' => 'No es suporten aplicacions web a nivell de servidor',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 aplicacions web més estan programades per a ser afegides a l'application vault.",
    'site_apps__applications_all_in_vault' => "Les aplicacions web seleccionades ja estan presents a l'application vault.",
    'site_apps__applications_already_in_download_queue' => "%1 aplicacions web seleccionades s'estan afegint a l'application vault en aquest moment.",
    'site_apps__applications_already_in_valut' => "%1 aplicacions web seleccionades ja estan presents a l'application vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Altre (sense categoria)',

    // Errors
    'site_apps__no_applications_in_category' => 'No hi ha cap aplicació disponible en aquesta categoria. Seleccioni una altra categoria.',
    'site_apps__no_category_selected__please_specify' => 'Seleccioni una categoria al menú de l\'esquerra. En aquesta finestra es detallen totes les aplicacions disponibles a la categoria seleccionada.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Compte d\'administrador',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'General',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Canviar nom de host',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Seguretat',
    'bt_setup_firewall' => 'Configurar firewall',
    'bt_manage_firewall_rules' => 'Gestionar regles de firewall',
    'cu_firewall__rule' => 'Crear una regla de firewall',
    'cu_firewall__protocol' => 'Establir un protocol per a la regla (\'tcp\' o \'udp\')',
    'cu_firewall__name' => "Establir un nom per a la regla",
    'cu_firewall__disabled' => 'En cas de ser \'true\', la regla es desactiva un cop finalitzada la creació',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Seleccionar servidor DNS', // PFW
    'bt_soa_records_template' => 'Plantilla de registres SOA',
    'bt_restrict_creation_of_subzones' => 'Restringir la creació de subzones',

    'databases' => 'Bases de dades',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplicacions',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Correu',
    'bt_select_mailserver' => 'Seleccionar servidor de correu', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Seleccionar antivirus', // PFW
    'bt_virus_protection_settings' => 'Configuració de protecció antivirus',
    'bt_select_spamfilter' => 'Seleccionar filtre antispam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Seleccionar webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Registres i estadístiques',
    'bt_server_statistics_settings' => 'Configuració d\'estadístiques del servidor',
    'bt_select_web_statistics' => 'Software d\'estadístiques web disponible', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interfície de Plesk',

    'components_and_modules' => 'Components i mòduls',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'Configurar VPN', // PFU
    'bt_setup_samba' => 'Configurar Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'Compte d\'administrador de domini',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Configuració del compte',

    'domain' => 'Domini',
    'bt_dns_soa_records' => 'Registres SOA del DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Configuració del planificador de tasques',

    'website' => 'Lloc web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting per a usuaris web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Seleccionar certificat SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Estadístiques web',
    'bt_log_rotation_settings' => 'Configuració de rotació de registres',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Límits", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Directiva de sobreventa i sobreús",
    'limits__overuse_policy_legend' => "Sobreús",
    'limits__oversell_policy_legend' => "Sobreventa",
    'limits__reseller_overuse_description' => "La directiva de sobreús indica a Plesk què cal fer quan es fa un ús excessiu dels recursos.",
    'limits__overuse_text' => "Directiva de sobreús",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Espai al disc i trànsit',
    'limit__disk_space' => 'Espai al disc',
    'limit__max_traffic' => 'Trànsit',
    'limit_group__client' => 'Clients',
    'limit__max_cl' => 'Clients',
    'limit_group__domain' => 'Dominis',
    'limit__max_dom' => 'Dominis',
    'limit__max_dom_powerUser' => 'Subscripcions',
    'limit__max_subdom' => 'Subdominis',
    'limit__max_dom_aliases' => 'Àlies de domini',
    'limit__max_wu' => 'Usuaris web',
    'limit__max_subftp_users' => 'Comptes FTP addicionals', // PFW
    'limit_group__mail' => 'Correu',
    'limit__max_box' => 'Bústies de correu',
    'limit__mbox_quota' => 'Tamany de la bústia de correu',
    'limit__total_mboxes_quota' => 'Quota total de bústies de correu', // PFW
    'limit__max_maillists' => 'Llistes de correu',
    'limit_group__database' => 'Bases de dades',
    'limit__max_mssql_db' => 'Bases de dades Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Quota total de bases de dades MS SQL', // PFW
    'limit__max_odbc' => 'Connexions ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Quota de bases de dades MariaDB/MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Quota de bases de dades PostgreSQL', // PFW
    'limit_group__application' => 'Aplicacions',
    'limit__max_iis_app_pools' => 'Conjunts d\'aplicacions IIS', // PFW
    'limit_group__security' => 'Seguretat',
    'limit_group__validity' => 'Data de caducitat',
    'limit__expiration' => 'Data de caducitat',
    'limit__validity' => 'Període de validesa',
    'limit__max_site_builder' => 'Llocs publicats amb Presence Builder',
    'limit__max_site' => 'Dominis',
    'limit__mssql_dbase_filesize' => 'Tamany de l\'arxiu de la base de dades MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Tamany de l\'arxiu de registre de la base de dades MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'El tamany màxim de l\'arxiu d\'una base de dades Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'El tamany màxim de l\'arxiu de registre d\'una base de dades Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'El límit de dominis no és vàlid. El valor mínim és 1.',

    'property__has_wrong_value' => 'La propietat %1 presenta un valor incorrecte.',
    'property__name_outgoing_messages_domain_limit' => 'Estableix el límit de correus sortints des d\'un domini (per hora). Si desitja establir un valor il·limitat, especifiqui "-1". Indiqui "default" per establir el valor indicat a la configuració a nivell del servidor.',
    'property__name_outgoing_messages_mbox_limit' => 'Estableix el límit de correus sortints des d\'una bústia de correu (per hora). Si desitja establir un valor il·limitat, especifiqui "-1". Indiqui "default" per establir el valor indicat a la configuració a nivell del servidor.',
    'property__name_outgoing_messages_subscription_limit' => 'Estableix el límit de correus sortints des d\'una subscripció (per hora). Si desitja establir un valor il·limitat, especifiqui "-1". Indiqui "default" per establir el valor indicat a la configuració a nivell del servidor.',

    // for CLI report & email notifications
    '__resource_notify' => 'Notificar',
    '__general' => 'General',
    '__template_shared' => 'Plantilla compartida',
    'limit__overuse' => 'Directiva de sobreús',
    'limit__max_traffic_soft' => 'Notificar quan l\'ús de trànsit assoleixi',
    'limit__disk_space_soft' => 'Notificar quan l\'ús d\'espai al disc assoleixi',
    '__overuse' => 'Directiva de sobreús',
    'performance__title' => 'Rendiment',
    'performance__bandwidth' => 'Ús màxim de l\'amplada de banda (KB/s)',
    'performance__max_connections' => 'Connexions limitades a',

    'gch__hosting_php_isapi' => 'Executar PHP com a extensió ISAPI',
    'gch__hosting_ssi_html' => 'Utilitzar SSI per arxius *.htm i *.html',
    'gch__hosting_php_handler_type' => 'executar PHP com a',
    'gch__hosting_php_handler_id' => 'executar PHP com a',
    'gch__hosting_php_served_by_nginx' => 'PHP servit per nginx',
    'gch__hosting_unpaid_website_status' => 'Estat dels llocs web en subscripcions suspeses',
    'gch__mn_no_autoresponder' => 'No s\'ha configurat cap resposta automàtica pel compte de correu.',
    'gch__no_clients_selected' => "No s'ha seleccionat cap compte de client",
    'gch__no_domains_selected' => "No s'ha seleccionat cap domini",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/mes",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nom del recurs',
    '__resource_usage' => 'Utilitzat',
    '__resource_limit' => 'Límit',

    '__never_expires' => 'Mai caduca',
    '__resource_free' => '%1 disponible de %2',
    '__resource_unlimited' => '%1 utilitzat d\'il·limitat',

    '__unlimited' => 'Il·limitats',
    '__increment' => "Augmentar (+)",
    '__decrement' => "Disminuir (-)",
    '__pt' => 'unitats',
    '__procent' => '%',
    '__overused' => 'En sobreús',
    '__left' => 'restant',
    '__available' => 'disponible',
    '__not_available' => 'No inclòs',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nom del revenedor', // reseller report
    'report__full_client_name' => 'Nom del client', // customer report
    'report__full_domain_name' => 'Nom de domini', // domain report
    'report__full_owner' => 'Propietari', // customer & domain reports
    'report__full_creation_date' => 'Data de creació',
    'report__full_size' => 'Tamany',
    'report__full_traffic' => 'Trànsit',
    'report__full_active_clients' => 'Clients actius', // reseller report
    'report__full_clients' => 'Clients', // reseller report
    'report__full_active_domains' => 'Dominis actius', // reseller & customer reports
    'report__full_domains' => 'Dominis', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Bcorreu',
    'report__full_disk_space' => 'Espai al disc',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Llistcor',
    'report__full_web_users' => 'UsuWeb',
    'report__full_mysql_databases' => 'Base de dades de MariaDB/MySQL',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'Base de dades PostgreSQL',

    // common summary report
    'report__section_general' => 'General',
    'report__version' => 'Versió del producte',
    'report__build' => 'Build del producte',
    'report__status' => 'Estat',
    'report__company_name' => 'Nom de l\'empresa',
    'report__personal_name' => 'Nom',
    'report__login' => 'Nom d\'usuari',
    'report__phone' => 'Telèfon',
    'report__fax' => 'Fax',
    'report__email' => 'Email',
    'report__address' => 'Adreça',
    'report__city' => 'Ciutat',
    'report__state' => 'Província o estat',
    'report__zip_code' => 'Codi postal',
    'report__country' => 'País',
    'report__creation_date' => 'Data de creació',
    'report__expiration_date' => 'Data de caducitat',
    'report__dumps_total_size' => 'Tamany total dels arxius de backup',
    'report__section_resellers' => 'Revenedors',
    'report__active_resellers' => 'Revenedors amb subscripcions actives',
    'report__resellers' => 'Revenedors',
    'report__section_full_resellers' => 'Revenedors',
    'report__section_clients' => 'Clients',
    'report__active_clients' => 'Clients amb subscripcions actives',
    'report__clients' => 'Clients',
    'report__section_full_clients' => 'Clients',
    'report__section_personal_clients' => 'Els meus clients',
    'report__active_personal_clients' => 'Els seus propis clients amb subscripcions actives',
    'report__personal_clients' => 'Els meus clients',
    'report__section_full_personal_clients' => 'Els meus clients',
    'report__section_domains' => 'Dominis',
    'report__disk_usage' => 'Ús del disc',
    'report__traffic' => 'Trànsit',
    'report__active_domains' => 'Dominis actius',
    'report__domains' => 'Dominis',
    'report__subdomains' => 'Subdominis',
    'report__mboxes' => 'Bústies de correu',
    'report__mail_groups' => 'Reenviaments de correu',
    'report__mail_autoresp' => 'Respostes automàtiques',
    'report__mail_lists' => 'Llistes de correu',
    'report__web_users' => 'Usuaris web',
    'report__mysql_databases' => 'Bases de dades MariaDB/MySQL',
    'report__mssql_databases' => 'Bases de dades MSSQL',
    'report__pgsql_databases' => 'Bases de dades PostgreSQL',
    'report__section_full_domains' => 'Dominis',
    'report__section_personal_domains' => 'Dominis personals',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Dominis personals',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Llocs publicats amb Presence Builder',
    'report__invalid_email' => 'Indiqui una adreça de correu vàlida.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Usuaris web',
    'report__section_mailnames' => 'Comptes de correu',
    'report__section_maillists' => 'Llistes de correu',
    'report__section_databases' => 'Bases de dades',
    'report__section_siteapps' => 'Aplicacions web',
    'report__section_aspnetapps' => 'Aplicacions ASP.NET', // PFW
    'report__owner_pname' => "Nom del proveïdor",
    'report__owner_login' => "Nom d'usuari del proveïdor",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'El paquet d\'idioma indicat està instal·lat però no activat al sistema.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'El token de sessió ha caducat.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Els següents comptes de revenedor es convertiran en comptes de client',
    'downgradeResellers__downgrade' => 'Comptes de revenedor que es convertiran',
    // controls
    'downgradeResellers__submit_downgrade' => 'Realitzi la conversió de comptes.',
    'downgradeResellers__cancel_downgrade' => 'Cancel·li la conversió del compte.',
    'downgradeResellers__confirm' => 'Confirmi la conversió',
    'downgradeResellers__confirm_message' => 'Confirmi la conversió del compte per continuar',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'Els següents comptes de client es convertiran en comptes de revenedor',
    'upgradeClients__upgrade' => 'Comptes de client que es convertiran',
    // controls
    'upgradeClients__submit_upgrade' => 'Realitzi la conversió de comptes.',
    'upgradeClients__cancel_upgrade' => 'Cancel·li la conversió del compte.',
    'upgradeClients__confirm' => 'Confirmi la conversió',
    'upgradeClients__confirm_message' => 'Confirmi la conversió del compte per continuar',
    // errors
    'upgradeClient__user_is_already_reseller' => 'No ha estat possible convertir el compte \'%1\' en compte de revenedor: \'%1\' ja és un revenedor.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Els següents comptes d\'administrador de domini es convertiran en comptes de client',
    'upgradeDomainUser__upgrade' => 'Comptes d\'administrador de domini que es convertiran',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Realitzi la conversió de comptes.',
    'upgradeDomainUser__cancel_upgrade' => 'Cancel·li la conversió del compte.',
    'upgradeDomainUser__confirm' => 'Confirmi la conversió',
    'upgradeDomainUser__confirm_message' => 'Confirmi la conversió del compte per continuar',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Comptes d\'administrador de domini que no es poden convertir',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Els comptes d\'administrador de domini detallats a continuació no s\'han pogut convertir en comptes de client:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Hi ha varis comptes d\'administrador de domini que no s\'han pogut convertir en comptes de client. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'El compte d\'administrador de domini no existeix',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "El domini hauria de pertànyer directament a l'administrador del servidor o bé a un revenedor.",
    'upgradeDomainUser__all_logins_already_used' => 'No ha estat possible crear un compte per al client resultant.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'El compte d\'administrador de domini ha estat convertit',
    'upgradeDomainUser__upgrade_notification_body' => 'El seu compte d\'administrador de domini s\'ha convertit en compte de client, tenint \'%%login%%\' com a nom d\'usuari i \'%%password%%\' com a contrasenya.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'El revenedor seleccionat no disposa del permís \'%1\', però alguns dels clients sí que tenen aquest permís.',
    'clientOwnerChanger__application_not_allowed' => 'L\'aplicació \'%1\' no està disponible per al revenedor seleccionat però sí per a alguns dels clients.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Ús màxim d\'amplada de banda (%1)',
    'hosting_performance__max_connection_label' => 'Connexions limitades a',
    'performance__invalid_value' => "El valor no és vàlid. Aquest hauria de ser un número enter entre %1 i %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Clients de webmail disponibles',
    'webmail__none' => 'Cap',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Grup d\'adreces IP del servidor',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Backup del servidor.",
    '__default_backup_comment_reseller' => "Backup del compte de revenedor creat per %1.",
    '__default_backup_comment_client' => "Backup del compte de client creat per %1.",
    '__default_backup_comment_domain' => "Backup de la subscripció creat per %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Grup d'adreces IP del client %1",
    'backup__ip_mapping__resellers_ip' => "Grup d'adreces IP del revenedor %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Host virtual',
    'backup__restore__object_plesk_admin' => 'Administrador de Plesk',
    'backup__restore__object_ftpuser' => 'Compte FTP',
    'backup__restore__object_frontpageuser' => 'Compte FrontPage',
    'backup__restore__object_webuser' => 'usuari web',
    'backup__restore__object_domain' => 'domini',
    'backup__restore__object_subdomain' => 'subdomini',
    'backup__restore__object_domainalias' => 'àlies de domini',
    'backup__restore__object_client' => 'client',
    'backup__restore__object_reseller' => 'revenedor',
    'backup__restore__object_autoresponder' => 'resposta automàtica',
    'backup__restore__object_mailalias' => 'àlies de correu',
    'backup__restore__object_database' => 'base de dades',
    'backup__restore__object_mailname' => 'compte de correu',
    'backup__restore__object_db_user' => 'usuari de base de dades',
    'backup__restore__object_ssl_certificate' => 'Certificat SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Els revenedors detallats a continuació no poden restaurar-se perquè s\'han convertit en clients: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Els clients detallats a continuació no poden restaurar-se perquè s\'han convertit en revenedors: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Els clients detallats a continuació no poden restaurar-se perquè s\'han mogut a un altre propietari: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'No hi ha prou espai al disc en el servidor de destí per migrar totes les subscripcions seleccionades. Disponible: %1 MB. Necessari: %2 MB. Nota: L\'espai necessari és la suma del contingut web, de correu i de la base de dades dels dominis. Aquest càlcul es fa un cop al dia i s\'emmagatzema a la memòria cau, de manera que la mida real dels dominis pot ser diferent de la mida calculada. Si està segur que els dominis seleccionats no ocupen més espai que el disponible, pot continuar amb la migració.',
    'backup__restore__capability_not_enough_disk_windows_text' => 'No hi ha prou espai al disc en el disc "%1" del servidor de destí per migrar totes les subscripcions seleccionades. Disponible: %2 MB. Necessari: %3 MB. Nota: L\'espai necessari és la suma del contingut web, de correu i de la base de dades dels dominis. Aquest càlcul es fa un cop al dia i s\'emmagatzema a la memòria cau, de manera que la mida real dels dominis pot ser diferent de la mida calculada. Si està segur que els dominis seleccionats no ocupen més espai que el disponible, pot continuar amb la migració.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Per continuar amb la migració, alliberi espai al disc en el servidor de destí.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Al servidor d\'origen no hi ha suficient espai al disc per a emmagatzemar els arxius temporals per a la transferència. Disponible: %1 MB. Necessari: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Alliberi espai al disc al servidor d\'origen.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informació del servidor',

    'backup__restore__capability_not_installed_component_text' => 'El component %1 no està instal·lat al servidor de destí. %1 no estarà disponible per a tots els objectes restaurats.',
    'backup__restore__capability_not_installed_component_resolution' => 'Instal·li %1. Tingui en compte que aquesta acció tardarà uns minuts en completar-se.',
    'backup__restore__capability_existing_sys_user_text' => 'Al servidor de destí ja existeix un usuari del sistema anomenat %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Canviï el nom de l\'usuari del sistema existent al servidor de destí.',
    'backup__restore__capability_license_usage_text' => 'Un cop finalitzada la transferència de dades, al servidor de destí s\'excediran els límits de recursos detallats a continuació i definits per la clau de llicència:',
    'backup__restore__capability_license_usage_resolution' => 'Al servidor de destí, instal·li una altra clau de llicència que proporcioni la quantitat de recursos desitjada.',
    'backup__restore__capability_max_allowed_packet_text' => "El paràmetre 'max_allowed_packet' al servidor de base de dades d'origen és %1, sent superior al del servidor de destí, que és %2. És possible que no es puguin restaurar alguns objectes de la base de dades per als dominis especificats a continuació.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Augmenti el valor 'max_allowed_packet' al servidor de bases de dades de destí.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'No ha estat possible transferir les bases de dades PostgreSQL perquè la versió de PostgreSQL present al servidor de destí és anterior a la present al servidor d\'origen. La versió actual és %1, mentre que la versió necessària és %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Instal·li la versió necessària de PostgreSQL al servidor de destí.',
    'backup__restore__capability_db_server_connection_problems' => 'No ha estat possible connectar-se al servidor de bases de dades PostgreSQL de destí. A menys que restauri la connexió, les bases de dades no seran transferides.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Comprovi la configuració de la connexió al servidor de bases de dades de destí.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'El component %1 està desactivat al servidor de destí.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Activi %1 al servidor de destí.',
    'backup__restore__capability_not_configured_component_text' => 'El component %1 no està configurat al servidor de destí.',
    'backup__restore__capability_not_configured_component_resolution' => 'Configuri %1 a la pàgina Eines i configuració.',

    'backup__restore__capability_webmail_is_not_available' => 'El servei de webmail %1 no està disponible al servidor de destí. En aquest cas, Plesk farà servir el següent servei de webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Si desitja utilitzar el mateix webmail que el del servidor d\'origen, instal·li\'l a aquest servidor.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Si desitja fer servir el mateix webmail que el del servidor d\'origen, instal·li\'l al servidor de destí.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "El webmail '%1' no està disponible al servidor de destí. Com a conseqüència, a les següents subscripcions: %3, Plesk farà servir el següent servei de webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Instal·li el webmail desitjat al servidor de destí.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Configuració del webmail',

    'backup__restore__capability_shell_is_not_available' => 'El shell %1 no està disponible al servidor de destí. En aquest cas, s\'utilitzarà un dels shells disponibles.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Si desitja fer servir el mateix shell que el del servidor d\'origen, instal·li\'l o activi\'l (a /etc/shells) al servidor de destí.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'El servidor DNS de destí no suporta xarxes a la plantilla de restriccions de transferència. Els registres amb adreces IP de xarxa a les restriccions de transferència del DNS no seran restaurats.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'El servidor DNS de destí no suporta xarxes a la plantilla de restriccions de transferència, si bé algunes subscripcions tenen xarxes a les restriccions de transferència del DNS. Els registres amb adreces IP de xarxa a les restriccions de transferència del DNS no seran restaurats.',

    'backup__restore__capability_wrong_php_handler_text' => 'El controlador de PHP %1 no està disponible al servidor de destí. En aquest cas, Plesk farà servir el següent controlador de PHP: %2.',
    'backup__restore__capability_no_php_handler_text' => 'El controlador PHP %1 no està disponible en el servidor de destí.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Si desitja fer servir el mateix controlador de PHP que el del servidor d\'origen, activi\'l o instal·li\'l al servidor de destí.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'El controlador de PHP %1 no està disponible. En aquest cas, Plesk farà servir %2 per als següents plans de serveis: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'El controlador de PHP %1 no està disponible. En aquest cas, Plesk farà servir %2 per als següents llocs web: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'El controlador de PHP %1 no està disponible. Aquest no estarà disponible per als següents llocs web: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 no està disponible al servidor de destí. En aquest cas es farà servir la versió predeterminada.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Si desitja fer servir el mateix %1 que el del servidor d\'origen, activi\'l o instal·li\'l al servidor de destí.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'La directiva d\'ús de l\'antivirus al servidor de destí no permet establir una configuració antivirus personal (per adreça de correu) per al correu sortint. Aquesta configuració no serà transferida.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'La directiva d\'ús de l\'antivirus al servidor de destí no permet establir una configuració personal (per adreça de correu) per al correu entrant. Aquesta configuració no serà transferida.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'La directiva d\'ús de l\'antivirus al servidor de destí no permet establir una configuració antivirus personal (per adreça de correu). Aquesta configuració no serà transferida.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Per tal de poder transferir una configuració antivirus personal (per adreça de correu), activi les opcions corresponents a Eines i configuració> Configuració de protecció antivirus.",
    'backup__restore__capability_antivirus_not_active_text' => 'No hi ha activat cap software antivirus. La configuració antivirus del servidor d\'origen no funcionarà fins que seleccioni el software antivirus al servidor de destí.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Seleccioni el software antivirus a Eines i configuració> Configuració de protecció antivirus> secció Configuració de l\'antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'El software antivirus %2 no està disponible al servidor de destí. En aquest cas, es farà servir %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Si desitja fer servir el mateix antivirus que el que fa servir al servidor d\'origen, instal·li\'l i seleccioni\'l a Eines i configuració> Configuració de protecció antivirus> secció Configuració de l\'antivirus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI no està disponible al servidor de destí. Els llocs webs que tinguin la mateixa adreça IP no podran utilitzar certificats SSL/TLS individuals.',
    'backup__restore__capability_not_available_sni_resolution' => "Comprovi que el sistema operatiu del servidor de destí suporta SNI i que el seu suport està activat a Plesk a través de la casella 'Activar suport per a SNI, que permet l'ús de certificats SSL/TLS individuals als llocs web amb la mateixa adreça IP' a Eines i configuració> Configuració del servidor.",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Configuració del servidor',

    'backup__restore__capability_vhost_already_exists_text' => 'El lloc web %1 no es pot transferir. Al servidor de destí ja existeix un lloc web amb aquest nom.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Canviï el nom del lloc web o elimini el lloc web amb el mateix nom del servidor.',
    'backup__restore__capability_removed_vhosts' => 'Les subscripcions detallades a continuació no es restauraran, ja que contenen noms de domini que ja existeixen al servidor de destí: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'El servidor d\'origen hi ha %3 controladors de PHP diferents de tipus %1 i versió %2. En comptes de fer servir aquests controladors, al servidor de destí es farà servir un controlador del tipus i versió apropiats. Tingui en compte que la configuració de PHP al servidor d\'origen i al servidor de destí pot ser diferent.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer no suporta Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer no suporta Python. Instal·li Python manualment.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Configuració del servidor de correu',

    'backup__restore__capability_ftps_disabled' => 'L\'ús de FTPS segur es permet al servidor d\'origen però no al servidor de destí. Les apps de l\'usuari que utilitzin FTP pot ser que no funcionin correctament.',
    'backup__restore__capability_ftps_required' => 'L\'ús de FTP no segur es permet al servidor d\'origen però no al servidor de destí. Les apps de l\'usuari que utilitzin FTP pot ser que no funcionin correctament.',
    'backup__restore__capability_ftps_policy_resolution' => 'Canviï la directiva de Secure FTP a Eines i configuració> Directiva de seguretat.',

    'backup__restore__capability_too_much_download_time_text' => 'Es transferiran %1 megabytes de dades del servidor d\'origen al servidor de destí en %2 hores.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Per tal que la transferència es realitzi més ràpidament, comprovi la connexió de xarxa entre el servidor d\'origen i el de destí i resolgui qualsevol possible incidència.',
    'backup__restore__too_low_download_speed' => "inferior a 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Per tal que la transferència es realitzi més ràpidament, comprovi la connexió de xarxa entre el servidor d\'origen i el de destí i resolgui qualsevol possible incidència.',
    'backup__restore__capability_zero_download_speed_text' => 'La velocitat mínima de descàrrega acceptable es de %1 MBps. La velocitat de descàrrega entre el servidor d\'origen i el de destí es de %0 MBps. La causa pot ser possibles incidències en la connexió de xarxa. No és possible realitzar la transferència.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Comprovi la connexió de xarxa entre el servidor d\'origen i el de destí i resolgui qualsevol possible incidència.',
    'backup__restore__capability_too_slow_download_speed_text' => 'La velocitat mínima de descàrrega acceptable es de %2 MBps. La velocitat de descàrrega entre el servidor d\'origen i el de destí es de %1 MBps. Tingui en compte que això pot augmentar el temps necessari per a completar la transferència. Al seu entorn actual, la migració de %3 MB tardarà %4 hores.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'La velocitat mínima de descàrrega acceptable es de %2 MBps. La velocitat de descàrrega entre el servidor d\'origen i el de destí es de %1 MBps. Tingui en compte que això pot augmentar el temps necessari per a completar la transferència.',

    'backup__restore__capability_remote_database_migration' => "Els següents dominis estan utilitzant bases de dades remotes: %1 ",
    'backup__restore__capability_remote_database_migration_resolution' => "No elimini aquests dominis del servidor d'origen un cop finalitzada la transferència si la versió de Plesk present al servidor d'origen és anterior a la versió 11.5. En aquest cas, suspengui els dominis. Si els elimina, les bases de dades s'eliminaran del servidor remot. Nota: Els arxius de buidatge de bases de dades remotes s'emmagatzemaran al directori %1 del servidor d'origen.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'És possible que els arxius de backup de servidors de bases de dades MySQL anteriors a la versió 5.1 (%1) no puguin restaurar-se a MySQL 5.1.x, ja que MySQL 5.1.x gestiona els caràcters Unicode d\'una altra manera.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Si desitja més informació, llegeixi l\'article 136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP no està instal·lat al servidor de destí.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Instal·li Courier-IMAP a través de Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot no està instal·lat al servidor de destí.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Instal·li Dovecot a través de Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'El període de preservació d\'estadístiques de trànsit a les configuracions dels objectes detallats a continuació és inferior al valor a nivell del servidor al servidor de destí.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Canviï el valor a nivell del servidor pel període de preservació d\'estadístiques al servidor de destí. Aquest període ha de ser igual o inferior al valor més petit a les configuracions dels dominis.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'El període durant el qual es preservaran les estadístiques de trànsit en alguns dominis és inferior al valor establert a nivell del servidor (%1). El valor es canviarà a %1 per a aquests dominis.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'El període durant el qual es conservaran les estadístiques de trànsit en alguns plans de serveis és inferior al valor establert a nivell del servidor (%1). El valor es canviarà a %1 per a aquests plans de serveis.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'L\'assignació d\'una adreça IP exclusiva a una adreça compartida farà que es desactivi el HTTPS i FTP anònim, a menys que s\'hagi habilitat el suport per a SNI.',

    'backup__restore__no_postgresql_commands_text' => 'La subscripció utilitza una base de dades PostgreSQL remota i no és possible generar el seu arxiu de backup temporal perquè les ordres pg_dump i psql no estan presents al servidor d\'origen.',
    'backup__restore__no_postgresql_commands_resolution' => 'Instal·li qualsevol paquet del client PostgreSQL que suporti aquestes ordres.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Els següents mòduls Apache estan desactivats al servidor de destí: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Activi aquests mòduls per així evitar possibles problemes.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Els següents mòduls Apache no estan instal·lats al servidor de destí: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Instal·li i activi aquests mòduls per així evitar possibles problemes.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'La seva llicència no suporta la limitació dels missatges sortints. Els paràmetres de configuració corresponents no seran transferits.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Al servidor de destí, instal·li una altra clau de llicència que proporcioni les característiques desitjades.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'La limitació dels missatges sortints està desactivada al servidor de destí. Els paràmetres de configuració corresponents no seran transferits.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Activi la limitació dels missatges sortints al servidor de destí.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Configuració de correu a nivell del servidor',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'El servidor de correu que es fa servir al servidor de destí no suporta la limitació dels missatges sortints des d\'una bústia de correu. El valor d\'aquest límit no es transferirà.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Canviï el servidor de correu per tal que sigui el mateix que el que utilitza al servidor d\'origen.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Configuració de correu a nivell del servidor',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'El servidor de correu que es fa servir al servidor de destí no suporta la limitació dels missatges sortints des d\'un domini. El valor d\'aquest límit no es transferirà.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Canviï el servidor de correu per tal que sigui el mateix que el que utilitza al servidor d\'origen.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Configuració de correu a nivell del servidor',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'El servidor de correu que es fa servir al servidor de destí no suporta la limitació dels missatges sortints des d\'una subscripció. El valor d\'aquest límit no es transferirà.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Canviï el servidor de correu per tal que sigui el mateix que el que utilitza al servidor d\'origen.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Configuració de correu a nivell del servidor',

    'bu_conflict_resolver_absent_phosting' => 'No ha estat possible restaurar els arxius especificats perquè no existeix hosting físic per a restaurar-los. Creï un domini amb hosting físic i a continuació torni a iniciar la restauració del backup.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Les dades dels revenedors no seran restaurades, ja que no es suporta la gestió de revenedors.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'El component ModSecurity no està instal·lat al servidor de destí.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Instal·li ModSecurity si desitja seguir fent servir el firewall per a aplicacions web per als llocs transferits. Tingui en compte que la instal·lació tardarà uns minuts en completar-se.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Instal·li ModSecurity si desitja transferir els paràmetres de configuració del firewall per a aplicacions web. Tingui en compte que la instal·lació tardarà uns minuts en completar-se.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'El component ModSecurity no està configurat al servidor de destí.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configuri ModSecurity si desitja seguir fent servir el firewall per a aplicacions web per als llocs transferits.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall per aplicacions web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity està desactivat al servidor de destí.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Activi ModSecurity si desitja seguir fent servir el firewall per a aplicacions web per als llocs transferits.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall per aplicacions web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'El component ModSecurity no està instal·lat. La configuració del firewall per a aplicacions web no es restaurarà per als següents objectes: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Els llocs web no poden restaurar-se perquè pertanyen a la subscripció %1 que no s'ha trobat a Plesk.",
    'bu_conflict_resolver_attend_websites_subscription' => "Alguns llocs web no es poden restaurar perquè hi ha subscripcions amb els mateixos noms: %1.",
    'backup__restore__capability_not_installed_dns_text' => 'El component %1 no està instal·lat al servidor de destí. El servei de DNS no estarà disponible i es perdrà la configuració de DNS. Els llocs web de tots els clients deixaran d\'estar operatius.',
    'bu_conflict_resolver_dns_not_installed' => 'El servei de DNS no està instal·lat. La configuració de DNS no es restaurarà per als següents objectes: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Les subscripcions detallades a continuació no poden restaurar-se perquè s\'han mogut a altres propietaris: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Les subscripcions detallades a continuació no poden restaurar-se perquè s\'han mogut a altres proveïdors: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'No ha estat possible trobar l\'utilitat de restauració de Web Presence Builder per tal de restaurar les dades de Web Presence Builder. Probablement Web Presence Builder no està instal·lat.',
    'backup__restore__capability_renamed_db' => 'El nom de base de dades "%1" ja està sent utilitzat per una altra subscripció. El nom de la base de dades restaurada serà "%2".',
    'backup__restore__capability_renamed_db_user' => 'El nom d\'usuari de la base de dades "%1" ja està sent utilitzat per una altra subscripció. El nom de l\'usuari de la base de dades restaurat serà "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer no suporta Perl. Instal·li ActiveState Perl manualment.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% servida per Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% servida per nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflictes d\'ús de recursos',
    'backup__restore__hint_resource_usage_conflicts' => 'Els conflictes d\'ús de recursos apareixen quan un cop completada la restauració s\'excedeixen els límits d\'ús de recursos de l\'objecte restaurat.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Permetre sobreús',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Restauri els objectes i permeti que aquests puguin utilitzar més recursos dels proporcionats inicialment.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'No restaurar',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'No restauri els objectes que presentin conflictes d\'ús de recursos.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflictes de configuració',
    'backup__restore__hint_configuration_conflicts' => 'Els conflictes de configuració apareixen quan l\'objecte restaurat disposa d\'una configuració i d\'aplicacions web que no estan disponibles o bé estan prohibits per la directiva del propietari de l\'objecte o del servidor actual. Per exemple, aquests apareixen si els comptes de correu restaurats presenten una configuració individual de filtració d\'spam mentre que la directiva a nivell del servidor actual no permet als comptes de correu tenir aquesta configuració.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automàtica',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Restauri l\'objecte i activi automàticament totes les opcions de configuració que ocasionin conflictes possibles en funció dels seus permisos.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'No restaurar',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'No restauri els objectes que presentin conflictes de configuració.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'A la configuració del conjunt d\'aplicacions IIS no es permeten conjunts d\'aplicacions IIS dedicats.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Canviï la configuració del seu conjunt d\'aplicacions IIS a Eines i configuració> Conjunt d\'aplicacions IIS> Configuració global.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'A la configuració de l\'inventari d\'aplicacions IIS no es permeten conjunts d\'aplicacions IIS dedicats.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Canviï la configuració del seu conjunt d\'aplicacions IIS a Eines i configuració> Conjunt d\'aplicacions IIS> Configuració global.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Al servidor de destí no es permet l\'ús de noms curts de comptes de correu POP3/IMAP.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Els noms curts per a comptes de correu no estaran disponibles un cop finalitzada la restauració de les dades.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'No ha estat possible obrir l\'arxiu de registre.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'No ha estat possible restaurar la subscripció %1. Aquesta s\'ha eliminat del seu compte i no disposa del permís necessari per crear subscripcions. Si necessita restaurar-la, posi\'s en contacte amb el seu proveïdor de serveis.',

    'backup__error11' => 'No es disposa de suficient espai en disc per a crear el backup.',
    'backup__error3011' => 'La connexió ha estat rebutjada. No hi ha cap programa que escolti a l\'adreça i al port indicats.',
    'backup__error3012' => 'Temps de connexió esgotat.',
    'backup__error3013' => 'La xarxa no respon.',
    'backup__error3014' => 'Cap ruta al host.',
    'backup__error3015' => 'S\'ha produït un error de connexió.',
    'backup__error3016' => 'No ha estat possible resoldre el nom del host.',
    'backup__error3017' => 'Nom d\'usuari o contrasenya incorrectes.',
    'backup__error3018' => 'S\'ha produït un error de connexió SSH.',

    'backup__error3110' => 'No ha estat possible connectar-se a l\'agent de migració remota. Connexió al host no disponible.',
    'backup__error3111' => 'L\'agent de migració està bloquejat a causa d\'una tasca de migració que no ha pogut completar-se o bé està sent utilitzat per un altre procés de migració. Reiniciï l\'agent de migració al servidor d\'origen.',
    'backup__error3112' => 'La connexió al host no està disponible o bé l\'agent de migració no està en execució al host d\'origen.',
    'backup__error3113' => 'No ha estat possible desplegar l\'agent de migració a un host Linux. Comprovi la connexió SSH al host d\'origen.',
    'backup__error3114' => 'No ha estat possible desplegar l\'agent de migració a un host Linux. S\'ha produït un error de connexió SSH.',
    'backup__error3115' => 'Nom d\'usuari o contrasenya incorrectes.',
    'backup__error3116' => 'L\'usuari especificar no disposa de privilegis administratius.',

    'dns_t__unable_to_remove_ns_record' => 'No ha estat possible eliminar el registre NS de la plantilla del DNS. Cada zona DNS al menys ha de tenir un registre NS.',
    'dns__unsupported_server_zone_transfer' => 'No ha estat possible transferir la plantilla de restriccions de transferència degut a la configuració DNS a nivell del servidor. Al servidor d\'origen, les adreces de xarxa detallades a continuació poden utilitzar-se per a la transferència de zones, però Microsoft DNS Server no permet l\'ús d\'aquestes adreces: %1',
    'dns__unsupported_domain_zone_transfer' => 'No ha estat possible transferir la plantilla de restriccions de transferència degut a la configuració DNS del domini. En alguns dominis, les adreces de xarxa detallades a continuació poden utilitzar-se per a la transferència de zones, però Microsoft DNS Server no permet l\'ús d\'aquestes adreces: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'No ha estat possible accedir al directori de xarxa temporal compartit per a arxius de backup. Examini el directori de xarxa i les opcions de contrasenya i nom d\'usuari. Error: %1',

    'dbbackup__temp_dir_wrong_value' => 'S\'ha especificat un valor per al directori temporal que no és vàlid.',
    'dbbackup__network_temp_dir_wrong_value' => 'S\'ha especificat un valor per al directori de xarxa temporal que no és vàlid.',
    'dbbackup__server_backup_not_configured' => 'Al servidor no s\'han configurat els paràmetres de backup de bases de dades.',
    'dbbackup__temp_dir' => 'Directori temporal',
    'dbbackup__temp_dir_hint' => 'La ruta a una carpeta física al servidor remot on hi ha el servidor MS SQL. El servidor MS SQL ha de poder accedir a aquesta carpeta per llegir i escriure als arxius de backup temporals. Per exemple, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'La ruta al recurs compartit de xarxa assignada a la carpeta física indicada a sobre. Plesk accedirà a la carpeta compartida per a descarregar i carregar arxius de backup. Per exemple, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'El nom d\'usuari d\'un usuari de la xarxa creat al servidor remot. Per exemple, ServerName\\UserName. L\'usuari ha de tenir accés a la carpeta compartida indicada a dalt.',
    'dbbackup__network_password_hint' => 'La contrasenya de l\'usuari de la xarxa',

    'dbbackup__success_import_without_dublicate_users' => 'No s\'han pogut importar els següents usuaris: %1. Aquests ja existeixen al servidor de base de dades.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Comprimir arxius de registre",
    'log_rot__log_rot_status' => "Estat de rotació d'arxius",
    'log_rot__log_rot_period' => "Condició de rotació de registres",
    'log_rot__log_rot_size' => "per tamany",
    'log_rot__log_rot_time' => "per hora",
    'log_rot__logrotation_enable' => "Activar rotació de registres",
    'log_rot__mail' => "Enviar arxius de registre processats per email",
    'log_rot__max_number_of_logfiles' => "Número màxim d'arxius de registre",
    'log_rot__time_period' => "període",
    'log_rot__unable_turn_off' => 'No ha estat possible desactivar la rotació de registres perquè aquesta s\'imposa a nivell del servidor',
    'log_rot__unable_set_period' => 'No ha estat possible establir un període de rotació de registres que no sigui \'a diari\' porque aquest s\'imposa a nivell del servidor',
    'log_rot__unable_set_max_log_files' => 'No ha estat possible establir un número màxim d\'arxius de registre superior al límit a nivell del servidor de %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Número esperat: %1",
    'actionlog__incorrect_rotation' => "S'han indicat uns paràmetres de rotació de registres que no són vàlids: %1",
    'actionlog__unknown_rot_period' => "Període de rotació desconegut: %1",
    'actionlog__unknown_rot_type' => "Tipus de rotació desconegut: %1",
    'actionlog__session_preferences' => 'Configuració de la sessió',
    'actionlog__nis2_delete_prohibited' => 'Eliminar els registres d\'acció està prohibit a causa de les restriccions de les directives NIS2.',
    'actionlog__nis2_forbidden_rot_type' => "El tipus de rotació '%1' no es pot fer servir a causa de les restriccions de les directives NIS2.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Informació de l\'administrador',
    'actionlog__admin_preferences' => "Preferències de l'administrador",
    'actionlog__service' => 'Servei',
    'actionlog__ip_addr' => 'Adreça IP',
    'actionlog__client' => 'Compte de client',
    'actionlog__client_status' => 'Estat del compte del client',
    'actionlog__client_preferences' => "Preferències d'interfície del client",
    'actionlog__client_ip_pool' => "Grup d'adreces IP del client",
    'actionlog__client_siteapp' => "Conjunt d'aplicacions web del client",
    'actionlog__client_guid' => "GUID del client",
    'actionlog__domain' => 'Domini predeterminat (el primer domini afegit a una subscripció)',
    'actionlog__domain_owner' => 'Propietari de la subscripció',
    'actionlog__domain_plan' => 'Pla de serveis de la subscripció',
    'actionlog__domain_status' => 'Domini predeterminat, estat',
    'actionlog__domain_dns' => 'Domini predeterminat, zona DNS',
    'actionlog__subdomain' => 'Subdomini d\'un domini predeterminat',
    'actionlog__domain_alias' => 'Domini predeterminat, àlies',
    'actionlog__domain_alias_dns' => 'Domini predeterminat, zona DNS de l\'àlies',
    'actionlog__site' => 'Domini',
    'actionlog__site_status' => 'Estat del domini',
    'actionlog__site_dns' => 'Zona DNS del domini',
    'actionlog__site_guid' => 'GUID del domini',
    'actionlog__site_subdomain' => 'Subdomini',
    'actionlog__site_alias' => 'Àlies de domini',
    'actionlog__site_alias_dns' => 'Zona DNS de l\'àlies de domini',
    'actionlog__domain_limits' => 'Límits de la subscripció',
    'actionlog__domain_limit_size' => 'Límit d\'espai al disc per a la subscripció',
    'actionlog__domain_limit_traffic' => 'Límit de trànsit per a la subscripció',
    'actionlog__domain_limits_powerUser' => 'Límits de la subscripció',
    'actionlog__domain_limit_size_powerUser' => 'Límit d\'espai al disc per a la subscripció',
    'actionlog__domain_limit_traffic_powerUser' => 'Límit de trànsit per a la subscripció',
    'actionlog__domain_guid' => "Domini predeterminat, GUID",
    'actionlog__cp_user' => 'Usuari de Plesk',
    'actionlog__mailname' => 'Compte de correu',
    'actionlog__maillist' => 'Llista de correu',
    'actionlog__phosting' => 'Configuració de hosting',
    'actionlog__forwarding' => 'Hosting amb redireccionament per marcs o estàndard',
    'actionlog__webuser' => 'Compte d\'usuari web',
    'actionlog__site_application' => 'Aplicació web',
    'actionlog__license' => 'Clau de llicència',
    'actionlog__additional_license' => 'Clau de llicència addicional',
    'actionlog__template_domain' => "Pla de serveis del revenedor",
    'actionlog__template_admin' => "Pla de serveis de l'administrador",
    'actionlog__template_reseller' => 'Pla de revenedor',
    'actionlog__admin_alias' => 'Compte d\'administrador addicional', // PFW
    'actionlog__ftpuser' => 'Compte FTP addicional', // PFW
    'actionlog__db_server' => 'Servidor de base de dades',
    'actionlog__db' => 'Base de dades',
    'actionlog__db_user' => 'Compte d\'usuari de la base de dades',
    'actionlog__client_sapppkg_pool' => "Aplicació web de l'usuari", // PFW, not used?
    'actionlog__remote_dns' => 'Estat del servidor DNS remot', // PFW
    'actionlog__reseller' => 'Compte de revenedor',
    'actionlog__reseller_guid' => 'GUID del revenedor',
    'actionlog__reseller_ip_pool' => "Grup d'adreces IP del revenedor",
    'actionlog__reseller_limit_size' => 'Límit d\'espai en disc pel compte de revenedor',
    'actionlog__reseller_limit_traffic' => 'Límit de trànsit pel compte de revenedor',
    'actionlog__reseller_limits' => 'Límits del compte de revenedor',
    'actionlog__reseller_permissions' => 'Permisos del revenedor',
    'actionlog__reseller_preferences' => "Preferències d'interfície del revenedor",
    'actionlog__reseller_siteapp' => "Aplicacions web a l'inventari del revenedor",
    'actionlog__reseller_status' => 'Estat del compte de revenedor',
    'actionlog__health_status' => 'Estat del servidor',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'assolit',
    'actionlog__added' => 'afegit',
    'actionlog__removed' => 'eliminat',
    'actionlog__change' => 'canviat',
    'actionlog__update' => 'actualitzat',
    'actionlog__move' => 'transferit',
    'actionlog__upgrade' => 'actualitzat', // PFU?
    'actionlog__update_or_add' => 'actualitzat o afegit',
    'actionlog__expired' => 'caducat',
    'actionlog__create' => 'creat',
    'actionlog__delete' => 'eliminat',
    'actionlog__clear' => 'esborrat',
    'actionlog__service_stop' => 'aturat',
    'actionlog__service_restart' => 'reiniciat',
    'actionlog__service_start' => 'iniciat',
    'actionlog__login' => 'connectat',
    'actionlog__logout' => 'desconnectat',
    'actionlog__install' => 'instal·lat',
    'actionlog__uninstall' => 'desinstal·lat',
    'actionlog__reconfigure' => 'reconfigurat',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Petició de restabliment de contrasenya',
    'actionlog__event_admin_update' => 'Informació de l\'administrador actualitzada',
    'actionlog__event_admin_preferences_update' => "Preferències de l'administrador actualitzades",
    'actionlog__event_service_restart' => 'Servei reiniciat',
    'actionlog__event_service_start' => 'Servei iniciat',
    'actionlog__event_service_stop' => 'Servei aturat',
    'actionlog__event_ip_address_create' => 'Adreça IP creada',
    'actionlog__event_ip_address_delete' => 'Adreça IP eliminada',
    'actionlog__event_ip_address_update' => 'Adreça IP actualitzada',
    'actionlog__event_client_create' => 'Compte de client creat',
    'actionlog__event_client_delete' => 'Compte de client eliminat',
    'actionlog__event_client_update' => 'Compte de client actualitzat',
    'actionlog__event_client_status_update' => 'Estat del compte del client actualitzat',
    'actionlog__event_client_preferences_update' => "Preferències d'interfície del client actualitzades",
    'actionlog__event_client_siteapp_added' => "Aplicació web afegida al conjunt d'aplicacions del compte de client",
    'actionlog__event_client_siteapp_removed' => "Aplicació web eliminada del conjunt d'aplicacions del compte de client",
    'actionlog__event_domain_limit_size_reached' => 'Límit d\'espai en disc per a la subscripció assolit',
    'actionlog__event_domain_limit_traffic_reached' => 'Límit de trànsit per a la subscripció assolit',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Límit d\'espai en disc per a la subscripció assolit',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Límit de trànsit per a la subscripció assolit',
    'actionlog__event_dns_record_create' => 'Registre DNS creat',
    'actionlog__event_dns_record_delete' => 'Registre DNS eliminat',
    'actionlog__event_dns_record_update' => 'Registre DNS actualitzat',
    'actionlog__event_dns_zone_soa_record_update' => 'Registre DNS SOA actualitzat',
    'actionlog__event_dns_zone_switch_to_master' => 'La zona DNS ha canviat a principal',
    'actionlog__event_dns_zone_switch_to_slave' => 'La zona DNS ha canviat a secundària',
    'actionlog__event_dns_zone_turn_off' => 'Zona DNS desactivada',
    'actionlog__event_dns_zone_turn_on' => 'Zona DNS activada',
    'actionlog__event_pw_admin_force_reset' => 'Ha canviat la contrasenya d\'un compte d\'administrador marcat per al restabliment obligatori de la contrasenya',

    'actionlog__domain_limit_database' => 'Quota de bases de dades per a la subscripció',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Quota de bases de dades MariaDB/MySQL per a la subscripció assolida',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Quota d\'advertiment de bases de dades MariaDB/MySQL per a la subscripció assolida',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Quota de bases de dades del servidor Microsoft SQL per a la subscripció assolida',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Quota d\'advertiment de bases de dades del servidor Microsoft SQL per a la subscripció assolida',
    'actionlog__event_plesk_component_upgrade' => 'Component de Plesk actualitzat',
    'actionlog__event_plesk_component_install' => 'Component de Plesk instal·lat',
    'actionlog__event_plesk_component_uninstall' => 'Component de Plesk desinstal·lat',
    'actionlog__event_domain_create' => 'Domini predeterminat (el primer domini afegit a una subscripció) creat',
    'actionlog__event_domain_delete' => 'Domini predeterminat (el primer domini afegit a una subscripció) eliminat',
    'actionlog__event_domain_update' => 'Domini predeterminat (el primer domini afegit a una subscripció) actualitzat',
    'actionlog__event_domain_owner_change' => 'Propietari de la subscripció modificat',
    'actionlog__event_domain_plan_change' => 'Pla de serveis de la subscripció modificat',
    'actionlog__event_domain_status_update' => 'Domini predeterminat, estat actualitzat',
    'actionlog__event_domain_dns_update' => 'Domini predeterminat, zona DNS actualitzada',
    'actionlog__event_subdomain_create' => 'Subdomini d\'un domini predeterminat creat',
    'actionlog__event_subdomain_delete' => 'Subdomini d\'un domini predeterminat eliminat',
    'actionlog__event_subdomain_update' => 'Subdomini d\'un domini predeterminat actualitzat',
    'actionlog__event_domain_alias_create' => 'Domini predeterminat, àlies creat',
    'actionlog__event_domain_alias_delete' => 'Domini predeterminat, àlies eliminat',
    'actionlog__event_domain_alias_update' => 'Domini predeterminat, àlies actualitzat',
    'actionlog__event_domain_limits_update' => 'Límits de la subscripció actualitzats',
    'actionlog__event_cp_user_login' => 'L\'usuari de Plesk ha iniciat sessió',
    'actionlog__event_cp_user_logout' => 'L\'usuari de Plesk ha tancat la sessió',
    'actionlog__event_mailname_create' => 'Compte de correu creat',
    'actionlog__event_mailname_delete' => 'Compte de correu eliminat',
    'actionlog__event_mailname_clear' => 'Compte de correu buidat',
    'actionlog__event_mailname_update' => 'Compte de correu actualitzat',
    'actionlog__event_maillist_create' => 'Llista de correu creada',
    'actionlog__event_maillist_delete' => 'Llista de correu eliminada',
    'actionlog__event_maillist_update' => 'Llista de correu actualitzada',
    'actionlog__event_phys_hosting_create' => 'Hosting físic creat',
    'actionlog__event_phys_hosting_delete' => 'Hosting físic eliminat',
    'actionlog__event_phys_hosting_update' => 'Hosting físic actualitzat',
    'actionlog__event_forwarding_create' => 'Hosting amb redireccionament per marcs o estàndard creat',
    'actionlog__event_forwarding_delete' => 'Hosting amb redireccionament per marcs o estàndard eliminat',
    'actionlog__event_forwarding_update' => 'Hosting amb redireccionament per marcs o estàndard actualitzat',
    'actionlog__event_webuser_create' => 'Compte d\'usuari web creat',
    'actionlog__event_webuser_delete' => 'Compte d\'usuari web eliminat',
    'actionlog__event_webuser_update' => 'Compte d\'usuari web actualitzat',
    'actionlog__event_siteapp_install' => 'Aplicació web instal·lada',
    'actionlog__event_siteapp_reconfigure' => 'Aplicació web reconfigurada',
    'actionlog__event_siteapp_uninstall' => 'Aplicació web desinstal·lada',
    'actionlog__event_license_update' => 'Clau de llicència actualitzada',
    'actionlog__event_admin_alias_create' => 'Compte d\'administrador addicional creat',
    'actionlog__event_admin_alias_delete' => 'Compte d\'administrador addicional eliminat',
    'actionlog__event_admin_alias_update' => 'Compte d\'administrador addicional actualitzat',
    'actionlog__event_ftpuser_create' => 'Compte FTP addicional creat',
    'actionlog__event_ftpuser_update' => 'Compte FTP addicional actualitzat',
    'actionlog__event_ftpuser_delete' => 'Compte FTP addicional eliminat',
    'actionlog__event_template_domain_create' => "Pla de serveis de revenedor creat",
    'actionlog__event_template_domain_update' => "Pla de serveis de revenedor actualitzat",
    'actionlog__event_template_domain_delete' => "Pla de serveis de revenedor eliminat",
    'actionlog__event_template_admin_create' => "Pla de serveis d'administrador creat",
    'actionlog__event_template_admin_update' => "Pla de serveis de l'administrador actualitzat",
    'actionlog__event_template_admin_delete' => "Pla de serveis d'administrador eliminat",
    'actionlog__event_database_server_create' => 'Servidor de bases de dades creat',
    'actionlog__event_database_server_update' => 'Servidor de base de dades actualitzat',
    'actionlog__event_database_server_delete' => 'Servidor de base de dades eliminat',
    'actionlog__event_remote_dns_status_update' => 'Estat del servidor DNS remot actualitzat',
    'actionlog__event_session_preferences_update' => 'Configuració de la sessió actualitzada',
    'actionlog__event_domain_alias_dns_update' => 'Domini predeterminat, zona DNS de l\'àlies del domini actualitzat',
    'actionlog__event_domain_move' => 'Domini predeterminat transferit a una nova subscripció',
    'actionlog__event_site_move' => 'Domini transferit a una nova subscripció',
    'actionlog__event_site_subdomain_move' => 'Subdomini transferit a una nova subscripció',
    'actionlog__event_subdomain_move' => 'Subdomini d\'un domini predeterminat transferit a una nova subscripció',
    'actionlog__event_license_expired' => 'La llicència de Plesk ha caducat',
    'actionlog__event_database_create' => 'Base de dades creada',
    'actionlog__event_database_delete' => 'Base de dades eliminada',
    'actionlog__event_database_user_create' => 'Compte d\'usuari de la base de dades creat',
    'actionlog__event_database_user_update' => 'Configuració del compte d\'usuari de la base de dades actualitzat',
    'actionlog__event_database_user_delete' => 'Compte d\'usuari de la base de dades eliminat',
    'actionlog__event_client_guid_update' => "GUID del client actualitzat",
    'actionlog__event_domain_guid_update' => 'Domini predeterminat, GUID actualitzat',
    'actionlog__event_reseller_create' => 'Compte de revenedor creat',
    'actionlog__event_reseller_delete' => 'Compte de revenedor eliminat',
    'actionlog__event_reseller_update' => 'Compte de revenedor actualitzat',
    'actionlog__event_reseller_guid_update' => 'GUID del revenedor actualitzat',
    'actionlog__event_reseller_ip_pool_update' => "Grup d'adreces IP del revenedor actualitzat",
    'actionlog__event_reseller_limit_size_reached' => 'Límit d\'espai en disc pel compte de revenedor assolit',
    'actionlog__event_reseller_limit_traffic_reached' => 'Límit de trànsit pel compte de revenedor assolit',
    'actionlog__event_reseller_limits_update' => 'Límits del compte de revenedor actualitzats',
    'actionlog__event_reseller_permissions_update' => 'Permisos del compte de revenedor actualitzats',
    'actionlog__event_reseller_preferences_update' => "Preferències d'interfície del revenedor actualitzades",
    'actionlog__event_reseller_siteapp_added' => "Aplicació afegida al conjunt d'aplicacions del compte de revenedor",
    'actionlog__event_reseller_siteapp_removed' => "Aplicació eliminada del conjunt d'aplicacions del compte de revenedor",
    'actionlog__event_reseller_status_update' => 'Estat del compte de revenedor actualitzat',
    'actionlog__event_template_reseller_create' => 'Pla de revenedor creat',
    'actionlog__event_template_reseller_delete' => 'Pla de revenedor eliminat',
    'actionlog__event_template_reseller_update' => 'Pla de revenedor actualitzat',
    'actionlog__event_health_status_change' => 'Estat del servidor modificat',
    'actionlog__event_siteapp_upgrade' => 'App web actualitzada',
    'actionlog__event_extension_install' => 'Extensió instal·lada',
    'actionlog__event_extension_uninstall' => 'Extensió desinstal·lada',
    'actionlog__event_extension_upgrade' => 'Extensió actualitzada',
    'actionlog__event_extension_status_update' => 'Estat de l\'extensió actualitzat',
    'actionlog__event_additional_license_expired' => 'La llicència addicional ha caducat',
    'actionlog__event_hostname_changed' => 'Nom de host del servidor modificat',
    'actionlog__event_smb_user_create' => 'Usuari addicional creat',
    'actionlog__event_smb_user_delete' => 'Usuari addicional eliminat',
    'actionlog__event_smb_user_update' => 'Usuari addicional actualitzat',
    'actionlog__dns_record' => 'Registre DNS',
    'actionlog__dns_zone' => 'Zona DNS',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "L'API RPC de Plesk no està instal·lada al host remot. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda.",
    'rsession_no_account_errmsg' => "No ha estat possible accedir al servei remot sota el seu compte. El més probable és que encara no s'hagi activat el servei per al seu compte. Esperi uns minuts i torni-ho a intentar. Si torna a experimentar aquest error, posi's en contacte amb el seu administrador del sistema.",
    'rsession_no_domain_errmsg' => "No ha estat possible accedir al servei remot per aquest domini. El més probable és que encara no s'hagi activat el servei per aquest domini. Esperi uns minuts i torni-ho a intentar. Si torna a experimentar aquest error, posi's en contacte amb el seu administrador del sistema.",
    'rsession_unknown_errmsg' => "El servidor remot ha rebutjat l'intent d'establir una sessió. Posi's en contacte amb el seu administrador del sistema per tal d'obtenir suport. L'error ha estat: %1",
    'rsession_unknown2_errmsg' => "Error desconegut mentre s'establia una sessió remota. El més probable és que el servidor remot no respongui o que no ho faci correctament. Demani al seu administrador del sistema que comprovi els detalls de l'error al registre d'errors del servidor web.",
    'rsession_no_connect_errmsg' => "No ha estat possible accedir al servei remot: error de connexió a la sessió remota. Posi's en contacte amb el seu administrador del sistema per tal d'obtenir suport.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Permetre la càrrega al directori entrant",
    'anonftp__allow_create_dirs' => 'Permetre la creació de directoris al directori entrant',
    'anonftp__allow_download_incoming' => 'Permetre la descàrrega des del directori entrant',
    'anonftp__display_login' => 'Mostrar missatge de benvinguda',
    'anonftp__login_text' => 'Text del missatge',
    'anonftp__limit_incoming_disk_space' => "Limitar l'espai en disc al directori entrant",
    'anonftp__limit_maximum_bandwidth' => "Limitar l'amplada de banda de descàrrega per aquest domini FTP virtual",
    'anonftp__limit_maximum_connections' => "Limitar el número de connexions simultànies",
    'anonftp__unable_init' => "No ha estat possible inicialitzar el compte FTP anònim: %1",
    'anonftp__unable_set_quota' => "No ha estat possible establir el límit d'espai en disc al directori entrant: %1",
    'anonftp__unable_update' => "No ha estat possible actualitzar les propietats del compte FTP anònim: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificats SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => " El certificat de l'autoritat de certificació bo signa el certificat.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Parell de certificat/clau privada no compatible.",
    'class_sslcertificate__invalid_cert_format' => "Format del certificat no vàlid.",
    'class_sslcertificate__invalid_private_key_format' => "Format de la clau privada no vàlid.",
    'class_sslcertificate__prob_invalid_priv_key' => "Probablement el format de la clau privada no és vàlid.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Cap arxiu a carregar.',
    'login_up__access_denied_no_permission' => "Accés denegat. No disposa del permís necessari per a iniciar sessió.",
    'mail__unable_remove_pattern' => "No ha estat possible eliminar l'adreça de la llista negra del servidor: %1", // PFW
    'mail__incorrect_network_format' => 'El format de la xarxa no és correcte: %1', // PFW
    'initconf__unable_change_passwd' => "No ha estat possible canviar la contrasenya de l'administrador: %1",
    'initconf__unable_get_passwd' => 'No ha estat possible obtenir la contrasenya de l\'administrador actual: error a %1: %2',
    'initconf__invalid_hostname' => 'Error al nom de host "%1"',
    'initconf__unable_reconfig' => 'No ha estat possible configurar Plesk: error reconfig: %1',
    'initconf__unable_update_admin' => 'No ha estat possible actualitzar la informació de contacte de l\'administrador: %1',
    '__refresh' => 'Actualitzar',
    '__dalias_not_exist' => 'L\'àlies de domini no existeix.',
    '__bug146523_explanation' => ' Les versions anteriors de Plesk permetien que els noms d\'usuari FTP tinguessin fins a 16 caràcters. Aquesta versió de Plesk limita el número màxim de caràcters a 15. Per resoldre la incidència, estableixi noms d\'usuari FTP que tinguin un màxim de 15 caràcters i canviï almenys un caràcter als noms d\'usuari afectats per així evitar incidències de col·lisió de noms d\'usuari. Sentim les molèsties que aquest canvi pugui ocasionar-li.',
    'domain__cannot_change_webmail' => 'No ha estat possible canviar el webmail pel domini. %1',
    'sb_publish_disable_warning' => 'Si desactiva la creació de llocs web amb Presence Builder, s\'eliminarà el lloc web creat anteriorment a Presence Builder i es perdran totes les dades del lloc web. Si desitja continuar, faci clic a ACCEPTAR.',
    '__sbnet_client_use_sbnet' => "Crear un compte d'usuari corresponent a Presence Builder",
    'mail_resp_activate' => 'Activar resposta automàtica',
    'limitsManger__limit_available_error' => 'No ha estat possible assignar la quantitat necessària de recursos ("%%limitName%%"): només disposa de %%available%% per al seu compte.',
    'limitsManger__limit_reserved_error' => 'No ha estat possible assignar menys recursos ("%%limitName%%") que els ja utilitzats.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'No ha estat possible canviar el nom del domini. Ja existeix un directori virtual amb el nom indicat.',
    'domain_unable_to_rename' => 'No ha estat possible canviar el nom del domini.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'General',
    'spamfilter__spamassassin_status_legend' => 'Filtració d\'spam d\'SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Configuració d\'SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Activar la filtració d'spam d'SpamAssassin a nivell del servidor",
    'spamfilter__spamassassin_user_status_legend' => 'Activar filtració d\'spam a través d\'SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Activar la protecció antispam greylisting a nivell del servidor',
    'spamfilter__personal_settings_not_allowed' => 'La directiva del sistema no permet l\'ús d\'una configuració individual de filtració d\'spam.',
    'spamfilter__required_score' => 'La puntuació que ha de rebre un missatge per considerar-lo spam',
    'spamfilter__rewrite_header_subject' => 'Afegir el següent text al principi de l\'assumpte de cada missatge considerat spam',
    'spamfilter__use_mailuser_prefs' => 'Aplicar configuració individual a la filtració d\'spam',
    'spamfilter__score_error' => 'La puntuació no pot ser negativa. La part prèvia al punt decimal ha de ser inferior a 100 i després del punt decimal no hi poden haver més de dos dígits.',
    'spamfilter__rewrite_header_error' => 'L\'assumpte del missatge pot incloure qualsevol caràcter imprimible excepte el símbol #.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Tornar',
    'nonexistent_mail__mode_discard' => 'Descartar',
    'nonexistent_mail__mode_catch_addr' => 'Reenviar a l\'adreça de correu',
    'nonexistent_mail__mode_catch_ip' => 'Reenviar a IP',
    'nonexistent_mail__bounce_not_supported' => 'Mode de devolució no suportat',
    'nonexistent_mail__discard_not_supported' => 'Mode descartar no suportat',
    'nonexistent_mail__catch_not_supported' => 'Reenviament a l\'adreça de correu no suportat',
    'nonexistent_mail__redirect_not_supported' => 'No es suporta el reenviament a IPs',
    'nonexistent_mail__ip_used_on_this_host' => 'L\'adreça IP resol a localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Com que el control dels correus sortints està activat, l\'adreça de correu %1 per als destinataris no existents hauria de pertànyer al domini seleccionat. De no ser així, s\'aplicarà la directiva "Rebutjar" enlloc del reenviament.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Com que el control dels correus sortints està activat, l\'adreça de correu indicada pel reenviament de correu (%1) hauria de pertànyer al domini seleccionat. De no ser així, els correus enviats a aquesta adreça no es comptabilitzaran al control dels correus sortints.',
    // mail acc extras
    '__antivirus' => "Antivirus",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'El suport per ASP.NET està desactivat per aquest lloc web.',
    'phosting__php_forced_by_site_isolation' => 'No ha estat possible canviar la configuració de PHP. No s\'ha concedit el permís per a substituir la directiva de seguretat a nivell del servidor.',
    'phosting__option_forced_by_site_isolation' => 'No ha estat possible canviar la configuració de %1. No s\'ha concedit el permís per a substituir la directiva de seguretat a nivell del servidor.',
    'phosting__php_handler_id_not_registered' => 'A la configuració d\'aïllament dels llocs no es permet el controlador de PHP. En aquest cas es farà servir el controlador de PHP predeterminat.',
    'phosting__php_served_by_nginx_is_not_available' => 'A la configuració d\'aïllament dels llocs no es permet el controlador de PHP (aplicació FPM servida per nginx). En aquest cas es farà servir el controlador de PHP predeterminat.',

    // tooltips

    'b_get_password_cancel' => 'Torni a la pantalla anterior sense enviar el correu.',
    'b_get_password_send' => 'Faci clic a ACCEPTAR per a enviar un missatge de recuperació de contrasenya a l\'adreça de correu registrada al sistema.',

    'b_back' => 'Torni a la pàgina anterior.',
    'b_next' => 'Vagi a la pàgina següent.',

    'b_dnsnstemplatelist_remove' => 'Elimini els servidor de noms seleccionats.',
    'b_dnsnstemplatelist_search' => 'Introdueixi un patró de cerca i faci clic per a trobar servidors de noms.',
    'b_dnsnstemplatelist_show_all' => 'Vegi tots els servidors de noms.',

    'l_dnsnstemplatelist_ns' => 'Ordeni els registres de la plantilla DNS per servidor de noms.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Generar enllaços segurs als arxius i carpetes',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Habilitar arxius públics',
    'cu__serverfilesharing_fsPublicFolder' => 'Carpeta per a l\'emmagatzematge d\'arxius públics',
    'cu__serverfilesharing_fsPublicUrl' => 'URL a través de la qual els visitants poden accedir als arxius públics',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Activar protecció amb contrasenya pels arxius públics',
    'cu__serverfilesharing_fsPartnerFolder' => 'Carpeta per a l\'emmagatzematge d\'arxius protegits amb contrasenya',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nom d\'usuari per a accedir als arxius',
    'cu__serverfilesharing_fsPartnersPassword' => 'Contrasenya per a accedir als arxius',
    'cu__serverfilesharing_fsDomain' => 'URL arrel de la carpeta web. Nom del domini',
    'cu__serverfilesharing_fsPrefix' => 'URL arrel de la carpeta web. Prefix',
    'cu__serverfilesharing_commandUpdate' => 'Actualitzar la configuració de compartició d\'arxius',
    'cu__serverfilesharing_commandInfo' => 'Mostrar configuració actual de compartició d\'arxius',
    'subscription_rename_is_forbidden' => 'La directiva a nivell de servidor prohibeix el canvi de nom de les subscripcions.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "Comptes FTP sota el domini %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Comptes FTP",
    'ftp__user_name' => "Nom del compte FTP",
    'ftp__user_home' => "Directori principal",
    'ftp__invalid_path' => "La ruta indicada no és vàlida",
    'i_ftp_ses_sub_user' => 'Sessió de compte FTP.',
    '__new_passwd' => "Nova contrasenya %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'No ha estat possible configurar un servidor web al host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "No ha estat possible generar l'arxiu de configuració del servidor web al host <%%host%%> degut als següents errors:\n\n%%error%%\n\nCorregeixi els error a les plantilles de configuració del servidor web i torni a generar l'arxiu.",

    'apacheConfigurationMessageAdminTitle' => 'Error al generar la configuració del servidor web',
    'apacheConfigurationMessageClientTitle' => 'Advertiment',

    'apacheConfigurationFailedAdminHomeMessage' => 'No s\'ha creat el nou arxiu de configuració degut a l\'existència d\'errors a les plantilles de configuració. El missatge d\'error detallat se li ha enviat a la seva adreça de correu. Comprovi\'l, corregeixi els errors i faci clic %1 per intentar tornar a generar la configuració.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'aquí', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'No s\'ha creat la nova configuració pel domini %1 degut a l\'existència d\'errors a les plantilles de configuració. El missatge d\'error detallat se li ha enviat a la seva adreça de correu. Comprovi\'l, corregeixi els errors i faci clic %2 per intentar tornar a generar la configuració.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'aquí', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'La configuració del servidor web per al domini %1 pot ser incoherent. Contacti amb l\'administrador del servidor per resoldre el problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'No s\'ha creat la nova configuració per alguns dels dominis degut a l\'existència d\'errors a les plantilles de configuració. El missatge d\'error detallat se li ha enviat a la seva adreça de correu. Comprovi\'l, corregeixi els errors i faci clic %1 per intentar tornar a generar la configuració.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'aquí', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'La configuració del servidor web per alguns dels seus dominis pot ser incoherent. Contacti amb l\'administrador del servidor per resoldre el problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documents d'error personalitzats",
    'dom_pref__webusers_script' => "Permetre als usuaris web utilitzar scripts",
    '__seoRedirect' => 'Configurar el domini preferit com ',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Cap',

    '__sites' => 'Dominis',
    'domain_plan__perm_denied_manage_phosting' => 'No disposa del permís necessari per a gestionar la configuració de hosting.',
    '__owned_by_client' => 'propietat del client',
    'backup__restore__object_client_template' => 'Plantilla de client',
    '__template_name' => 'Nom del pla de serveis',
    'template__not_exists' => 'Aquest pla de serveis no existeix',
    'template__exists' => 'Ja existeix un pla anomenat %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'L\'adreça IP especificada no està present al grup d\'adreces IP del revenedor.',
    '__owner_name' => 'Propietari del pla de serveis',

    'chown__error_check' => 'S\'han experimentat alguns problemes mentre s\'intentava assignar algunes de les subscripcions a un nou propietari.',

    '__redirect_hint' => 'D\'aquí a 15 segons se\'l redireccionarà a la nova adreça... Si no és així, activi javascript o faci clic a l\'enllaç %%link%%.',

    'backup__restore__object_maillist' => 'Llista de correu',
    'backup__restore__object_site' => 'Lloc',
    'backup__restore__object_user' => 'Usuari',
    'backup__restore__object_role' => 'Rol',

    'limit__name_max_site' => 'llocs',

    'iis_pool__unable_rename_client' => "No ha estat possible canviar el nom del conjunt d'aplicacions IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'El servei FTP anònim només es permet en el cas del domini principal d\'una subscripció.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'El servei FTP anònim només es permet en el cas del domini principal d\'una subscripció.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/mes',
    '__tb_month' => 'TB/mes',

    '__customer_total' => 'Total de clients',
    '__site' => 'Lloc',
    '__def_site' => 'Lloc predeterminat',
    '__subscription_name' => 'Nom de la subscripció',
    '__subscription_name_powerUser' => 'Nom de la subscripció',

    'limit__units_max_traffic_suffix' => '/mes',

    'dom_pref__discard' => "Rebutjar",

    'mail__pattern_already_exists' => 'El patró "%1" ja està present a la llista negra.',

    '__not_supported' => 'No suportat',

    'plesk_key__sitebuilder' => 'Llocs publicats amb Presence Builder',
    'limit__name_max_site_builder' => 'Llocs publicats amb Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Suport per a llocs en múltiples idiomes a Presence Builder',

    'login_up__access_denied_no_subscriptions' => "Accés denegat. No hi ha cap subscripció disponible per aquest compte.",

    'interval__day' => '%1 dia/dies',
    'interval__hour' => '%1 hora/hores',
    'interval__minute' => '%1 minut(s)',
    'interval__second' => '%1 segon(s)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Està intentant utilitzar una clau de llicència creada per una altra versió de Plesk. Posi\'s en contacte amb el seu responsable comercial de Plesk per tal d\'obtenir una clau de llicència apropiada.',
    //Standalone or virtualization
    'virtualization_any' => "Servidor físic o qualsevol solució de virtualització",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Servidor Virtuozzo",
    'plesk_key__virtualization' => "Vàlid pels següents entorns:",
    'plesk_key__virtualization_only_key' => 'La clau de llicència només és vàlida per a l\'ús de Plesk en un entorn virtual %1.',
    'plesk_key__virtualizations_only_key' => 'La clau de llicència només és vàlida per a l\'ús de Plesk en els següents entorns virtuals: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'No es permet l\'ús de paquets d\'idioma personalitzats.',
    'plesk_key__allowed-locales' => 'Idiomes disponibles',
    'plesk_key__allowed-locales-any' => 'Qualsevol idioma',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'el directori cgi-bin es troba a',
    '_cgi_bin_mode_webspace' => 'el directori arrel de la subscripció',
    '_cgi_bin_mode_www_root' => 'l\'arrel del document d\'aquest domini',

    /// Custom buttons
    'custom_button__sort_key' => 'Prioritat',
    'custom_button__place' => 'Ubicació',
    'custom_button__place_navigation' => 'Accés comú',
    'custom_button__place_admin' => 'Pàgina inicial de l\'administrador',
    'custom_button__place_admin-settings' => 'Pàgina d\'eines i configuració de l\'administrador',
    'custom_button__place_reseller' => "Pàgina inicial del revenedor",
    'custom_button__place_reseller-settings' => 'Pàgina Eines i utilitats del revenedor',
    'custom_button__place_client' => 'Pàgina inicial del client',
    'custom_button__place_domain' => "Pàgina Llocs web i dominis de la subscripció",
    'custom_button__place_domain_powerUser' => "Pàgina Llocs web i dominis de la subscripció",
    'custom_button__place_domain-properties' => 'Eines per a llocs web',
    'custom_button__private' => 'Només mostrar-m\'ho a mi',
    'custom_button__image' => 'Imatge de fons',
    'custom_button__conhelp' => "Text de l'indicador de funció",
    'custom_button__edit' => "Configuració d'un enllaç a un servei addicional",
    'custom_button__include_client_cname' => "Incloure nom de l'empresa del client",
    'custom_button__include_client_email' => "Incloure email del client",
    'custom_button__include_client_id' => "Incloure ID del client",
    'custom_button__include_client_pname' => "Incloure nom de contacte del client",
    'custom_button__include_domain_id' => "Incloure ID de la subscripció, ID del domini i ID de l'àlies de domini",
    'custom_button__include_domain_id_powerUser' => "Incloure ID de la subscripció, ID del domini i ID de l'àlies de domini",

    'custom_button__include_domain_name' => "Incloure nom del domini principal",
    'custom_button__include_ftp_user' => "Incloure nom d'usuari FTP",
    'custom_button__include_ftp_pass' => "Incloure contrasenya FTP",
    'custom_button__internal_open' => "Obrir l'URL a Plesk",
    'custom_button__text' => "Etiqueta de botó",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'L\'arxiu no es un arxiu d\'imatge.',
    'custom_button__big_image' => 'El tamany de l\'arxiu no pot ser superior a 100 KB.',
    'custom_button__failed_copy_image' => 'No ha estat possible copiar l\'arxiu: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'No es pot restaurar un backup que no sigui de Power User en el mode de visualització de Power User.',
    '__unknown_network_interface' => 'Interfície de xarxa desconeguda',

    'init_conf__ip_address' => 'Adreça IP',

    //Confirmation page
    'bt_confirm' => 'Confirmar',
    'b_confirm' => 'Confirmi la propietat dels seus llocs.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'La configuració del conjunt d\'aplicacions IIS dedicat s\'estableix d\'acord amb la directiva de seguretat a nivell del servidor (configuració d\'aïllament del lloc).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'La configuració del conjunt d\'aplicacions IIS dedicat s\'estableix d\'acord amb la configuració de rendiment a nivell del servidor.',

    '__current' => 'Actual',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Gairebé ha utilitzat tots els dominis proporcionats per la seva llicència de Plesk (90% o més).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Gairebé ha utilitzat tots els dominis.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Gairebé ha utilitzat tots els llocs Presence Builder proporcionats per la seva llicència de Plesk (90% o més).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Gairebé ha utilitzat tots els llocs Presence Builder.',
    'promo__button_hide' => 'Amagar',
    'promo__button_next' => 'Següent>>',
    'promo__button_prev' => '<< Anterior',
    'promo__button_license' => 'Actualitzar llicència',

    'promo__google_integration_title' => 'Integració amb serveis de Google',
    'promo__google_integration' => 'Configuri la integració amb serveis de Google com AdSense, Google Apps o eines per a webmasters.',
    'promo__google_integration_button' => 'Configurar',

    'promo__button_learn_more' => 'Més informació',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Pot personalitzar l\'aparença de la interfície i les opcions de personalització mitjançant l\'ús de temes personalitzats. Si desitja informació sobre com personalitzar els temes de Plesk, consulti el %1.',
    'panel_branding__description_link' => 'següent document',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extreure arxius',
    'filemanager_error_extracting_files' => 'S\'ha produït un error mentre s\'extreien els arxius comprimits: %1',
    'filemanager_no_archive_files_specified' => 'Especifiqui els arxius comprimits que desitja extreure.',
    'filemanager_not_zip_archive_specified' => '%1 no es pot extreure perquè no és un arxiu ZIP.',
    'filemanager_files_successfully_extracted' => 'Els arxius comprimits s\'han extret correctament.',
    'filemanager_error_file_download' => 'Error al descarregar l\'arxiu: %1',
    'filemanager__user_poolgrp' => 'Grup del conjunt d\'aplicacions',

    'loading' => 'Carregant...',
    'bt_create_archive' => 'Afegir a arxiu comprimit',
    'filemanager__pack' => "Ruta a l'arxiu comprimit: %1",
    'filemanager__archive_name' => 'Nom de l\'arxiu comprimit',
    'filemanager__empty_filename' => 'Indiqui el nom de l\'arxiu comprimit.',
    'filemanager_archive_created' => 'L\'arxiu comprimit s\'ha creat correctament.',
    'filemanager_error_creating_archive' => 'No ha estat possible crear l\'arxiu comprimit: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Aquest registre crearà conflictes amb el registre AAAA de la zona.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(El servidor FTP no suporta adreces IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Aquest registre crearà conflictes amb el registre glue de la zona \'%1\'.',
    '__ftp_ipv6_not_supported' => "(El servidor FTP no suporta adreces IPv6.)",
    '__ipv6_not_supported' => 'No es suporta IPv6.',
    'mail__ipv6_not_supported' => 'El servidor de correu no suporta IPv6.',
    'mail__relay_while_list_ipv6_not_supported' => 'El servidor de correu no suporta llistes blanques de tramesa IPv6.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'El valor de la màscara ha de ser múltiple de 16.',
    'mail__ip_or_mask_is_invalid' => 'La màscara o adreça IP no és vàlida.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'No es suporta el reenviament a adreces IP IPv6.',
    'sa__invalid_trusted_networks' => 'Xarxes de confiança no especificades correctament: %1',
    'dns_add__enter_ipv6_address' => "Adreça IPv6",
    'license_trial_days_left' => 'El seu Plesk opera amb una llicència de prova que caducarà d\'aquí a %1 dies.',
    'excl_ipv6_num' => 'Adreça IPv6 dedicada',
    '__ip_mask' => "Màscara de subxarxa",
    '__ipv4_addr' => 'Adreça IPv4',
    '__ipv6_addr' => 'Adreça IPv6',
    'template__num_excl_ipv6s' => 'Assignar adreces IPv6 dedicades al revenedor',
    'anonftp__exclusive_ipv4_required' => 'Per tal de configurar i utilitzar el servei FTP anònim, és necessari disposar d\'una adreça IPv4 dedicada.',
    'anonftp__ipv4_already_used' => 'No pot configurar el servei FTP anònim per a aquest lloc perquè aquesta ja està configurat en un altre domini a la mateixa adreça IPv4.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'Veure el registre',

    'chown__error_ip_absent_in_ip_pool' => 'L\'adreça IP %1 no està present al grup d\'adreces IP de l\'usuari de destí.',
    'chown__error_ip_not_exist' => 'L\'adreça IP amb ID \'%1\' no existeix.',
    'chown__error_domain_ip_not_selected' => 'Al menys hauria de seleccionar una adreça IP per al domini %1. Comprovi els valors seleccionats per a l\'assignació d\'IP.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'La màscara o l\'adreça IPv6 no és vàlida. L\'adreça IP hauria de ser una adreça unicast vàlida.',

    '__subscriptions' => 'Subscripcions',

    '__owned_by_reseller' => 'propietat del revenedor',
    '__owned_by_provider' => 'propietat del proveïdor',

    'service_plan__anonymous' => 'Personalitzat',
    'subscription_not_locked__change_limits_warning' => 'Aquesta subscripció no està bloquejada. Els límits d\'ús de recursos es canviaran durant la sincronització amb el pla de serveis.',
    'subscription_not_locked__change_permissions_warning' => 'Aquesta subscripció no està bloquejada. Els permisos es canviaran durant la sincronització amb el pla de serveis.',

    'subscription__conflict_resolution_policy' => 'Directiva de resolució de conflictes',
    'subscription__conflict_resolution_policy_lock' => "Bloquejar subscripció",

    'backup__list__backup_warnings' => 'Advertiments',
    'backup__list__backup_info' => 'Informació',
    'backup__restore__object_reseller_template' => 'Plantilla de revenedor',
    'backup__restore__object_domain_template' => 'Plantilla de domini',

    'subscription__unable_lock_anonymous' => 'Aquesta subscripció no està vinculada a cap pla de serveis i per aquest motiu no es pot desbloquejar.',
    'subscription__unable_sync_anonymous' => 'Aquesta subscripció no està vinculada a cap pla de serveis i per aquest motiu no es pot sincronitzar.',
    'subscription__unable_sync_locked' => 'Aquesta subscripció està bloquejada i per aquest motiu no es pot sincronitzar.',
    'subscription__locked' => 'La subscripció està bloquejada.',
    'component_name__urlrewrite' => "URL Rewrite",
    '__quantity' => 'Quantitat',
    'hst__www_root_dir_absent' =>  'Important! El directori indicat com l\'arrel del document no existeix.',
    'object_creation__domain_is_not_a_webspace' => 'Aquest objecte només es pot crear en una subscripció.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'La subscripció conté llocs i és per aquest motiu que no es pot canviar el tipus de hosting ni eliminar-la.',
    'phosting__apache_error_docs_are_not_enabled' => 'Els documents d\'error personalitzats no estan activats al domini.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Error: no és possible actualitzar l\'adreça IP. Als dominis complementaris no se\'ls pot assignar una adreça IP que no hagi estat assignada al domini principal de la subscripció.',
    'domain_plan__unable_change' => 'No ha estat possible canviar el pla de serveis. %1.',
    'domain_plan__different_hosting_type' => 'El tipus de hosting actual no és el mateix que el tipus indicat al pla de serveis.',
    'domain_plan__addon_text' => 'Pla complementari',
    'domain_plan__addon_description' => 'El pla complementari s\'utilitza per a complementar un pla de hosting.',
    'asp_net__managed_runtime_version' => 'Versió de temps d\'execució d\'ASP.NET',
    'plan__can_not_change_hosting_type' => 'No és possible canviar el tipus de hosting mentre s\'edita un pla.',
    'plan__apply_problems' => 'El pla no ha estat aplicat a causa de problemes amb la següent funcionalitat: %1',
    'plan_save__subscription_update_problem' => 'No ha estat possible aplicar els canvis a %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "La subscripció està suspesa temporalment fins que finalitzi el procés de backup o restauració. Torni d'aquí a uns minuts.",
    '__login_incorrect_plain_shadow_password' => 'Ha indicat una contrasenya incorrecta pel compte d\'administrador. Utilitzi les credencials de l\'administrador (root) o bé obtingui la contrasenya correcta. Si desitja més informació sobre l\'obtenció de contrasenyes, llegeixi l\'arxiu /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'No pot enviar una adreça IP que no és de la seva propietat',

    'dns__dns_zone_not_synchronized' => 'La zona DNS ha estat modificada. Si desitja aplicar els canvis de la plantilla DNS a aquesta zona, faci clic al botó \'Aplicar canvis de plantilla DNS\' present aquí o bé seleccioni l\'opció \'Aplicar els canvis a totes les zones\' que trobarà al panell d\'administració del servidor> Eines i configuració> Configuració de la plantilla DNS> Aplicar canvis de plantilla DNS.',
    'dns__dns_zone_synchronize_link' => 'Faci clic a',
    'dns__dns_zone_synchronize_done' => 'La zona DNS s\'ha sincronitzat correctament.',

    'dns__dns_zone_template_error' => 'S\'han produït incidències al sincronitzar les zones DNS amb la plantilla de zona DNS.%1',

    'dns__soa_rname_type_owner' => 'Adreça de correu del propietari del lloc web',
    'dns__soa_rname_type_domain' => 'Adreça de correu del domini',
    'dns__soa_rname_type_external' => 'Adreça de correu externa',
    'dns__soa_rname_enforce_email' => 'Prohibir la modificació de l\'adreça de correu RNAME de forma individualitzada pels dominis',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'L\'adreça de correu de la persona responsable de la zona DNS del domini. Tornat pel servidor DNS en resposta a consultes SOA.',

    'dns__dns_zone_soa_sync_title' => 'Substituir la configuració SOA per tots els dominis existents',
    'dns__dns_zone_soa_sync_legend' => 'Es requereix confirmació',
    'dns__dns_zone_soa_sync_text' => 'Desitja actualitzar els registres SOA de tots els dominis allotjats aplicant els canvis efectuats a la plantilla SOA?',

    'cu_db__repair_mysql_dbus' => "Repari contrasenyes d'usuaris de MariaDB/MySQL. Aquesta operació serà imprescindible si actualitza a Plesk 11 des de versions anteriors.",

    'cu_scheduled_backup_comment' => 'Backup programat',
    'cu_scheduled_backup_error' => 'S\'ha produït un error durant el procés de backup: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> S\'ha produït un error durant el backup programat.',
    'cu_scheduled_backup_mail_message' => "%1\nPunt d'entrada a Plesk: %2\n\nS'han produït els següents errors durant el procés de backup programat:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Backup per hora',
    'cu_scheduled_backup_daily' => 'Backup per dia',
    'cu_scheduled_backup_weekly' => 'Backup per setmana',
    'cu_scheduled_backup_monthly' => 'Backup per mes',
    'cu_scheduled_backup_comment_backup_all' => '%1. Tot el contingut i la configuració.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Tota la configuració i el contingut excepte els emails.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Només la configuració i els emails.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Tota la configuració i el contingut excepte les bases de dades d\'usuari.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Tota la configuració i el contingut excepte els arxius d\'usuari.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Només la configuració i les bases de dades d\'usuari.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Només la configuració i els arxius d\'usuari.',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Configuració del domini.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'L\'emmagatzematge de backups programats en un emmagatzematge cloud remot és una funció premium. Posi\'s en contacte amb el seu proveïdor de hosting si desitjat desbloquejar-la.',

    'i_backup_invalid_file' => 'Aquest backup no és vàlid. No es poden restaurar les dades d\'aquest arxiu. Per a més informació, faci clic al nom del backup.',

    'filemanager_resulting_archive_exists' => 'L\'arxiu %1 ja existeix al directori de destí.',

    'agent_unable_to_connect' => 'No ha estat possible connectar-se a l\'agent a \'%2\'. Comprovi que l\'agent està instal·lat i en execució i que no hi ha cap problema de connexió amb el host \'%2\'.',
    'agent_test_connection_failed' => 'Error al connectar-se a l\'agent a \'%2\'.',

    'agent_unable_to_resolve_host' => 'No ha estat possible localitzar el host remot \'%1\'. Comprovi que no hi ha cap problema de connexió amb el host.',
    'agent_unknown_curl_error' => 'Durant la connexió a l\'agent a \'%2\' s\'ha produït l\'error \'%1\'.',
    'agent_unexpected_htp_code' => 'S\'ha rebut el codi HTTP inesperat \'%1\' sobre la petició HTTP a l\'agent a \'%2\'.',
    'agent_unable_to_auth' => 'No ha estat possible autenticar-se al host \'%1\'. Per tal de resoldre la incidència, segueixi les indicacions detallades a http://kb.plesk.com/es/116606.',
    'agent_internal_server_error' => 'S\'ha produït un error intern del servidor durant l\'execució de l\'ordre al host remot \'%1\'.',
    'agent_response_is_empty' => 'S\'ha rebut una resposta buida sobre la petició HTTP a l\'agent a \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'No ha estat possible trobar l\'agent de migracions i transferències a la caché local. Torni a obrir l\'administrador de migracions i transferències per tal de corregir l\'incidència.',

    '__hosting_webdeploy' => "Publicació Web Deploy",
    'cu_domain__webdeploy' => "Publicació Web Deploy (per defecte: %1)",
    'cu_dom_tpl__webdeploy' => "Publicació Web Deploy (per defecte: %1)",
    'cu_subdomain__webdeploy' => "Publicació Web Deploy (per defecte: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy no està instal·lat al servidor",
    'webdeploy__forced_by_site_isolation' => "No ha estat possible canviar la configuració de Web Deploy. No disposa del permís necessari per a substituir la directiva de seguretat a nivell del servidor. Contacti amb el seu proveïdor per obtenir més informació al respecte.",



    'backup__restore_options__admin__server_configuration_license' => 'Clau de llicència',
    'migration_start_migrate_server_license' => 'Transferir clau de llicència',

    'defaultcomponents__delegation_rule_not_exist' => '(la regla de delegació necessària \'appPoolPipeline, appPoolNetFx\' no existeix)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'El backup va ser creat per l\'administrador.',
    'i_backup_created_by_reseller' => 'El backup va ser creat per un revenedor.',
    'i_backup_created_by_client' => 'El backup va ser creat per un client.',

    'migration__object_exists_on_target_host' => '(ja existeix al host de destí)',

    'cu_cl_pref__manage_website_maintenance' => 'Accés a operacions avançades − Copia de lloc web',
    'cu_cl_pref__manage_protected_dirs' => 'Gestió de directoris protegits amb contrasenya',
    'cu_cl_pref__manage_mail_settings' => 'Habilitat per a canviar la configuració de correu',


    'cu__command_update_php_settings' => 'Actualitza la configuració de PHP.',
    'cu__php_settings_option' => 'Estableix la ruta a l\'arxiu amb la configuració de PHP.',

    'cu__additional_php_settings_option' => 'Estableix la ruta a l\'arxiu amb les directives PHP addicionals.',
    'cu__command_show_php_settings' => 'Mostra la configuració actual de PHP.',
    'cu__general_settings' => 'Configuració general:',
    'cu__performance_settings' => 'Configuració de rendiment:',
    'cu__php_fpm_settings' => 'Configuració de PHP-FPM:',
    'cu__additional_directives' => 'Directives addicionals:',

    'php_settings_permission_required' => 'Gestió de la configuració comuna de PHP',
    'php_settings_performance_permission_required' => 'Gestió de la configuració de rendiment de hosting',
    'php_settings_customized' => 'La configuració de PHP ha estat personalitzada.',
    'php_settings_synchronized_with_plan' => 'La configuració de PHP ha d\'estar sincronitzada amb el pla.',
    'phosting__unknown_shell_type' => 'Shell no disponible',

    'login_up__access_denied_subscription_deleted' => 'Accés denegat. La seva subscripció ha estat eliminada.',

    'role_restricted_to_subscription' => '(transferit amb la subscripció: %1)',

    'filemanager__extract' => "Extreure arxius a: %1",

    'cu__license_command_check_installed_license' => 'Comprovar la validesa de la clau de llicència instal·lada (torna el codi de sortida 0 si la clau és vàlida i 1 si no ho és)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Ampliï la funcionalitat de Plesk per tal de poder controlar i monitoritzar el servidor des de dispositius mòbils (BlackBerry, iPhone i Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor ',
    'promo__mobile_monitor' => 'Obtingui la informació més important sobre els seus servidors Plesk estigui on estigui i en qualsevol moment mitjançant el seu dispositiu mòbil (BlackBerry, iPhone i Android).',
    'promo__mobile_button' => 'Més informació',

    'subDomainNameHint' => 'Introdueixi * com a nom de subdomini per tal de crear un subdomini wildcard. Els visitants del lloc seran redireccionats a aquest subdomini sigui quin sigui el nom de subdomini que hagin introduït al navegador.',
    'subdomains__wildcard_name_invalid' => "El nom del subdomini no és vàlid. Només pot fer servir caràcters alfanumèrics, un guionet (-) i un asterisc (*) per als nom de subdominis wildcard.",
    'subdomains__name_invalid' => "El nom del subdomini no és vàlid. Només pot fer servir caràcters alfanumèrics i guionets (-) per als noms dels subdominis.",

    'domain__wildcard_no_www_prefix' => 'No és possible utilitzar el prefix www per a subdominis wildcard.',

    '__service_title__milter' => "Milter de Postfix de Plesk",
    '__service_description__milter' => "Filtre de correu Postfix de Plesk",
    '__milter' => "Milter de Postfix",
    'restart__milter' => "Milter de Plesk (%1)",
    'restart__pop3' => "Servidor Courier POP3",
    'restart__pop3s' => "Servidor Courier POP3 amb suport per a SSL/TLS",
    'restart__imap' => "Servidor Courier IMAP",
    'restart__imaps' => "Servidor Courier IMAP amb suport per a SSL/TLS",
    'restart__authdaemon' => "Daemon d'autenticació de Courier IMAP",
    'restart__imap-pop3' => "Servidor Dovecot IMAP i POP3",


    'addon_packages_not_supported' => 'No s\'admeten complements per a aplicacions web paquetitzades amb APS.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'No ha estat possible assignar una adreça IP al domini de forma automàtica. Indique una adreça IP mitjançant l\'opció -ip.',

    'plesk_key__mb_accounts' => 'Comptes d\'usuari (revenedors i clients) a Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Zona DNS del subdomini',
    'actionlog__site_subdomain_dns' => 'Zona DNS d\'un subdomini sota un domini addicional',

    // PfW only
    'actionlog__event_site_create' => 'Domini creat',
    'actionlog__event_site_delete' => 'Domini eliminat',
    'actionlog__event_site_update' => 'Domini actualitzat',

    'actionlog__event_site_status_update' => 'Estat del domini actualitzat',
    'actionlog__event_site_dns_update' => 'Zona DNS del domini actualitzada',
    'actionlog__event_site_guid_update' => 'GUID del domini actualitzat',

    'actionlog__event_site_subdomain_create' => 'Subdomini creat',
    'actionlog__event_site_subdomain_delete' => 'Subdomini eliminat',
    'actionlog__event_site_subdomain_update' => 'Subdomini actualitzat ',

    'actionlog__event_site_alias_create' => 'Àlies de domini creat',
    'actionlog__event_site_alias_delete' => 'Àlies de domini eliminat',
    'actionlog__event_site_alias_update' => 'Àlies de domini actualitzat',

    'actionlog__event_site_alias_dns_update' => 'Zona DNS d\'un àlies de domini actualitzada',
    'actionlog__event_subdomain_dns_update' => 'Zona DNS d\'un subdomini sota el domini predeterminat actualitzada',
    'actionlog__event_site_subdomain_dns_update' => 'Zona DNS d\'un subdomini actualitzada',
    // End of PfW only

    'win_policy__bad_password' => 'Error de validació. La contrasenya no és vàlida.',
    'win_policy__password_too_short' => 'Error de validació. La contrasenya no compleix els requisits de la directiva de contrasenyes perquè és massa curta.',
    'win_policy__password_too_long' => 'Error de validació. La contrasenya no compleix els requisits de la directiva de contrasenyes perquè és massa llarga.',
    'win_policy__password_not_complex_enough' => 'Error de validació. La contrasenya no és suficientment complexa i no compleix els requisits de la directiva de contrasenyes. Les contrasenyes segures han d\'incloure almenys tot el següent: vuit caràcters, un caràcter en minúscula o majúscula, tres números i un caràcter especial (!, @, #, $, %, ^, &, *, ?, _, ~) o bé un número i dos caràcters especials.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'No ha estat possible actualitzar la llicència del producte.',


    'filemanager__error_path_is_not_allowed' => 'Ruta no permesa',
    'filemanager__error_path_is_invalid' => 'La ruta no és vàlida',
    'filemanager__error_path_not_found' => 'No s\'ha pogut trobar la ruta',
    'filemanager__error_path_already_exists' => 'La ruta ja existeix',
    'filemanager__error_access_is_denied' => 'Accés denegat',
    'filemanager__error_directory_not_empty' => 'La carpeta no està buida',
    'filemanager__error_sharing_violation' => 'Violació de compartició',
    'filemanager__error_not_same_device' => 'La ruta de destí no es troba al mateix dispositiu',
    'filemanager__unable_to_resolve_realpath' => "No ha estat possible trobar l'arxiu %1 a l'ubicació indicada",
    'filemanager__access_to_realpath_denied' => "Accés a realpath denegat: %1 a %2.",
    'bt_exit' => 'Sortir',

    'filemanager__copy_error__' => "No ha estat possible copiar %1 a %2: %3",
    'filemanager__copy_move' => "Copiar (traslladar) arxius de %1",
    'filemanager__count_size__' => 'Tamany de la selecció: %1',
    'filemanager__count_size_error__' => 'No ha estat possible calcular el tamany de %1: %2',
    'filemanager__create_dir_error__' => "No ha estat possible crear el directori %1: %2",
    'filemanager__dir_not_exists' => "El directori %1 no existeix.",
    'filemanager__dirname' => "Nom del directori",
    'filemanager__filename' => "Nom de l'arxiu",
    'filemanager__is_no_such' => "No existeix cap arxiu o directori anomenat %1",
    'filemanager__empty_selection' => "No s'ha seleccionat cap arxiu.",
    'filemanager__move_error__' => "No ha estat possible moure %1 a %2: %3",
    'filemanager__not_allowed' => "No se li permet canviar els permisos per a aquest arxiu.",
    'filemanager__remove' => "Eliminar arxius de %1",
    'filemanager__remove_error__' => "No ha estat possible eliminar l'arxiu %1: %2",
    'filemanager__set_win_permissions_dir' => "Establir permisos per a la carpeta %1",
    'filemanager__set_win_permissions_file' => "Establir permisos per a l'arxiu %1",
    'filemanager__touch_confirm' => "¿Està segur que desitja canviar la data i hora dels arxius seleccionats?",
    'filemanager__upload_error__' => "No ha estat possible carregar %1 a %2: %3",
    'filemanager__upload_file' => "Carregar arxiu",
    'filemanager__upload_file_src' => "Ruta a l'arxiu",

    '__fastcgi_unix_support' => 'Suport de FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Els registres DNS d\'aquest subdomini s\'emmagatzemen a la zona DNS principal. Pot modificar la zona principal %1 o crear una altra zona per al subdomini.',
    'dns__subdomain_dns_zone_parent_link' => 'aquí',
    'dns__no_dns_zone' => 'No hi ha cap zona DNS assignada al domini. Per tal de gestionar la zona DNS per al seu domini, faci clic al botó \'Restaurar opcions per defecte\'.',
    'dns__unable_turn_on_subdomain_zone' => 'No ha estat possible activar la zona del subdomini perquè existeix un registre CNAME per a aquest subdomini a la zona del seu domini principal.',

    '__hosting_write_modify' => 'Permisos d\'escriptura/modificació addicionals',

    'aspdotnet__group_framework_version' => "Versió del framework",

    'bt_restore_default' => "Establir a predeterminat",
    'b_autoinstaller' => 'Actualitzi Plesk o els seus components.',
    'b_autoinstaller_configure' => 'Actualitzi la configuració.',
    'b_autoinstaller_install' => 'Instal·li els components seleccionats.',

    '__iis_app_pool__use_dedicated' => 'Conjunt d\'aplicacions IIS dedicat',
    '__iis_app_pool__use_dedicated_addons' => 'Conjunt d\'aplicacions IIS dedicat per cada lloc web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Habilitar aplicacions de 32 bits',
    '__iis_app_pool__load_user_profile' => 'Carregar el perfil d\'usuari',
    'bt_iis_app_pool' => "Conjunt d'aplicacions IIS",

    'performance__cpu_usage' => 'Ús màxim de la CPU (%)',
    'performance__cpu_usage_action' => 'Acció de límit',
    'performance__cpu_usage_interval' => 'Interval límit (minuts)',
    'performance__cpu_usage_action_not_supported' => 'El servidor web no suporta l\'acció indicada.',

    'performance__idle_timeout_action_not_supported' => 'El servidor web no suporta l\'acció de temps d\'espera d\'inactivitat especificada.',
    'performance__max_worker_processes' => 'El número màxim de processos de treball',
    'performance__idle_timeout' => 'Temps d\'espera d\'inactivitat (minuts)',
    'performance__idle_timeout_action' => 'Acció de temps d\'espera d\'inactivitat',
    'performance__recycling_by_time' => 'Reciclar a intervals de temps regulars (minuts)',
    'performance__recycling_by_requests' => 'Reciclar quan s\'assoleixi el número màxim de peticions',
    'performance__recycling_by_virtual_memory' => 'Reciclar quan s\'utilitzi la quantitat màxima de memòria virtual',
    'performance__recycling_by_private_memory' => 'Reciclar quan s\'utilitzi la quantitat màxima de memòria privada',
    'performance__managed_pipeline_mode' => 'Mode de canalització administrada',
    'performance__managed_pipeline_mode_not_supported' => 'El servidor web no suporta el mode indicat.',

    'iis_app_pool' => 'Gestió del conjunt d\'aplicacions IIS.',
    'b_iis_app_pool' => 'Gestioni el conjunt d\'aplicacions IIS.',
    'iis_app_pool_cl_dom' => 'Gestió del conjunt d\'aplicacions IIS.',

    'bt_protect' => 'Protegir',
    'bt_unprotect' => 'Eliminar protecció',
    'bt_show_additional_users' => 'Mostrar més usuaris',
    'bt_hide_additional_users' => 'Mostrar menys usuaris',
    'error_doc__code_400' => 'Sol·licitud errònia',
    'error_doc__code_401' => 'Sense autoritzar',
    'error_doc__code_401.1' => 'Sense autoritzar - Error d\'inici de sessió',
    'error_doc__code_401.2' => 'Sense autoritzar - Error d\'inici de sessió degut a la configuració del servidor',
    'error_doc__code_401.3' => 'Sense autoritzar - Sense autoritzar degut a ACL al recurs',
    'error_doc__code_401.4' => 'Sense autoritzar - Error d\'autorització per filtre',
    'error_doc__code_401.5' => 'Sense autoritzar - Error d\'autorització per app ISAPI/CGI',
    'error_doc__code_401.7' => 'Sense autoritzar - Denegat degut a la directiva d\'autorització de l\'URL',
    'error_doc__code_403' => 'Prohibit',
    'error_doc__code_403.1' => 'Prohibit - Accés d\'execució denegat',
    'error_doc__code_403.2' => 'Prohibit - Accés de lectura denegat',
    'error_doc__code_403.3' => 'Prohibit - Accés d\'escriptura denegat',
    'error_doc__code_403.4' => 'Prohibit - SSL necessari',
    'error_doc__code_403.5' => 'Prohibit - SSL 128 necessari',
    'error_doc__code_403.6' => 'Prohibit - Adreça IP rebutjada',
    'error_doc__code_403.7' => 'Prohibit - Certificat del client necessari',
    'error_doc__code_403.8' => 'Prohibit - Accés al lloc denegat',
    'error_doc__code_403.9' => 'Prohibit - Massa usuaris',
    'error_doc__code_403.10' => 'Prohibit - Configuració no vàlida',
    'error_doc__code_403.11' => 'Prohibit - Canvi de contrasenya',
    'error_doc__code_403.12' => 'Prohibit - Accés a l\'assignador denegat',
    'error_doc__code_403.13' => 'Prohibit - Certificat del client revocat',
    'error_doc__code_403.14' => 'Prohibit - Escolta al directori denegada',
    'error_doc__code_403.15' => 'Prohibit - Llicències d\'accés del client excedides',
    'error_doc__code_403.16' => 'Prohibit - Certificat del client mal format o no de confiança',
    'error_doc__code_403.17' => 'Prohibit - El certificat del client ha caducat o encara no és vàlid',
    'error_doc__code_403.18' => 'Prohibit - No es pot executar la petició des d\'aquest conjunt d\'aplicacions',
    'error_doc__code_403.19' => 'Prohibit - Accés CGI denegat',
    'error_doc__code_403.20' => 'Prohibit - Error d\'inici de sessió Passport',
    'error_doc__code_404' => 'No s\'ha trobat',
    'error_doc__code_404.2' => 'No s\'ha trobat - Denegat degut a la directiva de blocatge',
    'error_doc__code_404.3' => 'No s\'ha trobat - Denegat degut a la directiva MIMEMAP',
    'error_doc__code_405' => 'Mètode no permès',
    'error_doc__code_406' => 'No acceptable',
    'error_doc__code_407' => 'Autenticació del proxy necessària',
    'error_doc__code_408' => 'Temps d\'espera de la petició',
    'error_doc__code_412' => 'Error de condició prèvia',
    'error_doc__code_414' => 'L\'URI de la petició és massa llarg',
    'error_doc__code_415' => 'Tipus d\'arxiu multimèdia no suportat',
    'error_doc__code_431' => 'Els camps de capçalera de la petició són massa grans',
    'error_doc__code_500' => 'Error intern del servidor',
    'error_doc__code_500.12' => 'Error intern del servidor - Reiniciant aplicació',
    'error_doc__code_500.13' => 'Error intern del servidor - Servidor massa ocupat',
    'error_doc__code_500.15' => 'Error intern del servidor - Es prohibeixen les peticions directes per a GLOBAL.ASA',
    'error_doc__code_500.16' => 'Error intern del servidor - Error d\'accés a UNC',
    'error_doc__code_500.17' => 'Error intern del servidor - No s\'ha trobat el magatzem d\'autorització de l\'URL',
    'error_doc__code_500.18' => 'Error intern del servidor - No es pot obrir el magatzem d\'autorització de l\'URL',
    'error_doc__code_500.19' => 'Error intern del servidor - Metadades de l\'arxiu incorrectes',
    'error_doc__code_500.100' => 'Error intern del servidor - Error d\'ASP',
    'error_doc__code_501' => 'No implementat',
    'error_doc__code_502' => 'Passarel·la no vàlida',
    'error_doc__code_503' => 'Servei temporalment no disponible',

    'mimetype_edit__already_exists' => 'El tipus MIME ja està definit per aquesta extensió',
    'mimetype_edit__not_exists' => 'El tipus MIME no existeix.',

    'php__group_php_version' => "Versió de PHP",

    'virtualdir__path' => 'Ruta',
    'virtualdir__read' => 'Permís de lectura',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Permís d\'escriptura',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Accés al codi font dels scripts',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Navegació pels directoris',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Permisos d\'execució',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Registrar visites',
    'virtualdir__app_create' => 'Crear aplicació',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Activa l\'autenticació anònima.',
    'virtualdir__auth_windows' => 'Activa l\'autenticació de Windows.',
    'virtualdir__auth_not_enabled' => 'L\'autenticació anònima o de Windows ha d\'estar activada.',
    'virtualdir__require_ssl' => 'Requerir SSL/TLS',
    'virtualdir__enable_default_doc' => 'Utilitzar documents predeterminats',
    'virtualdir__default_doc' => 'Ordre de cerca de documents predeterminats',
    'virtualdir__enable_parent_paths' => 'Permetre l\'ús de rutes principals',
    'virtualdir__execute_in_mta' => 'Permetre l\'execució d\'aplicacions en mode MTA (Multi-Threaded Apartment)',
    'virtualdir_create__title' => 'Crear directori virtual a %1',
    'virtualdir_edit__title' => 'Propietats del directori virtual %1',
    'virtualdir_edit__legend' => 'Directori virtual',
    'virtualdir_edit__application_legend' => 'Configuració de l\'aplicació',
    'virtualdir_edit__security_legend' => 'Seguretat del directori',
    'virtualdir_edit__documents_legend' => 'Documents',
    'virtualdir_edit__list_legend' => 'Directoris virtuals niats',
    'virtualdir_error__path_not_in__' => 'La ruta indicada no és vàlida',
    'virtualdir_root' => 'Directoris virtuals',
    'virtualdir_root__title' => 'Directoris virtuals',
    'virtualdir_root__list_legend' => 'Directoris virtuals',
    'virtualdir_se__none' => 'Cap',
    'virtualdir_se__script' => 'Només scripts',
    'virtualdir_se__script_execute' => 'Scripts i executables',
    'virtualdirs__title' => 'Directoris virtuals',
    'virtualdirs__path_not_exists' => 'La ruta no és vàlida.',
    'virtualdirs__select_for_remove' => "Seleccioni els directoris virtuals que desitja eliminar.",
    'virtualdirs_remove__title' => 'Eliminar directoris virtuals',

    'asp_max_buffer_text' => 'Tamany màxim del buffer ASP (KB)',
    'asp_max_body_text' => 'Tamany màxim del cos d\'una petició ASP (KB)',
    'asp_buffers_legend' => 'Configuració d\'ASP',
    'asp_client_debug_text' => 'Habilitar depuració d\'scripts d\'ASP a nivell del client',
    'asp_server_debug_text' => 'Habilitar depuració d\'scripts d\'ASP a nivell del servidor',

    'permissions__group_or_user_name' => 'Noms d\'usuari o grup',
    'permissions__FullControl' => 'Control total',
    'permissions__Modify' => 'Modificar',
    'permissions__ReadAndExecute' => 'Llegir i executar',
    'permissions__ListFolderContents' => 'Crear una llista dels continguts de la carpeta',
    'permissions__Read' => 'Llegir',
    'permissions__Write' => 'Escriure',
    'permissions__ReadControl' => 'Control de lectura',
    'permissions__WriteControl' => 'Control d\'escriptura',
    'permissions__ExecuteControl' => 'Control d\'execució',
    'permissions__TraverseFolderOrExecuteFile' => 'Recórrer carpeta o executar arxiu',
    'permissions__ListFolderOrRead' => 'Crear una carpeta o llegir dades',
    'permissions__CreateFilesOrWrite' => 'Crear arxius i escriure dades',
    'permissions__CreateFoldersOrAppend' => 'Crear carpetes i afegir dades',
    'permissions__DeleteSubfoldersandFiles' => 'Eliminar subcarpetes i arxius',
    'permissions__Delete' => 'Eliminar',
    'permissions__ChangePermissions' => 'Canviar permisos',
    'permissions__TakeOwnership' => 'Prendre possessió',
    'permissions__inherited_from' => 'Heretat de',
    'permissions__not_inherited' => '<no heretat>',
    'permissions__apply_to' => 'Aplicar a',
    'permissions__apply_onto' => 'Aplicar a:',
    'permissions__apply_onto1' => 'Només aquesta carpeta',
    'permissions__apply_onto2' => 'Només a les subcarpetes',
    'permissions__apply_onto3' => 'A aquesta carpeta i subcarpetes',
    'permissions__apply_onto4' => 'Només als arxius',
    'permissions__apply_onto5' => 'A aquesta carpeta i arxius',
    'permissions__apply_onto6' => 'Només a subcarpeta i arxius',
    'permissions__apply_onto7' => 'A aquesta carpeta, subcarpetes i arxius',

    'filemanager__not_allowed_dir' => "No se li permet canviar els permisos per a aquesta carpeta.",

    'filemanager__allow' => "Permetre",
    'filemanager__deny' => "Denegar",
    'filemanager__user_domusr' => 'Administrador del lloc web',
    'filemanager__user_webusr' => 'Usuari web',
    'filemanager__user_admins' => 'Administradors',
    'filemanager__user_system' => 'SISTEMA',
    'filemanager__user_aspnet' => 'Usuari d\'ASP.NET',
    'filemanager__user_poolusr' => 'Usuari del conjunt d\'aplicacions',
    'filemanager__user_sysaccount' => 'Usuari addicional del sistema',

    'bt_permissions_advanced' => 'Avançat',
    'b_permissions_advanced' => 'Faci clic per a veure i establir permisos especials.',

    'hotlink-protection_invalid_friend_domain' => 'Nom no vàlid per domini conegut.',
    'hotlink-protection_duplicate_friend_domain' => 'Nom duplicat per domini conegut.',
    'hotlink-protection_invalid_extensions' => 'Les extensions d\'arxiu contenen caràcters que no són correctes.',

    'i_domain_alias_status_on' => 'L\'àlies de domini està activat.',
    'i_domain_alias_status_off' => 'L\'àlies de domini està desactivat.',
    'i_domain_alias_status_with_parent' => 'L\'àlies de domini està desactivat perquè el domini està desactivat.',
    'i_domain_alias_turn_off' => 'Faci clic per desactivar-lo.',
    'i_domain_alias_turn_on' => 'Faci clic per activar-lo.',

    'domain_alias__control_title' => 'Àlies de domini %1',
    'domain_alias__control_info_legend' => 'Informació',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nom del servei',
    'domain_alias__control_details_title' => 'Detalls',

    'domain_alias__invalid_values' => 'El nom de domini indicat no és vàlid. Els noms de domini poden estar formats per lletres, dígits i guionets. Cada una de les parts del nom de domini entre punts no pot tenir més de 63 símbols.',
    'domain_alias__domain_already_exists' => "Nom incorrecte de l'àlies de domini %1. El domini %1 ja existeix.",
    'domain_alias__www_prefix_domain_already_exists' => "Nom incorrecte de l'àlies de domini www.%1. Aquest àlies ja s'ha creat per al domini %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nom incorrecte del webmail de l\'àlies de domini %1. Aquest àlies ja s\'ha creat per al domini %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nom incorrecte de les llistes l\'àlies de domini %1. Aquest àlies ja s\'ha creat per al domini %1.',
    'domain_alias__dns_record_already_exists' => 'No ha estat possible configurar l\'àlies de domini %1 perquè ja existeix un registre DNS que apunta al host %1.',
    'domain_alias__domain_alias_already_exists' => "Ja existeix un àlies de domini amb aquest nom.",
    'domain_aliases__mail_server_not_support_aliases' => 'El servidor de correu no suporta la funció d\'àlies de domini. És possible que els àlies de domini no funcionin correctament.',
    'domain_alias__restrict_domain_creation' => 'La directiva a nivell del servidor no permet utilitzar el nom indicat per a l\'àlies de domini. Si el nom d\'aquest àlies de domini és de la seva propietat, posi\'s en contacte amb el seu proveïdor de hosting.',
    'domain_alias__restrict_creation_with_www' => 'Indiqui un nom de domini sense el prefix \'www\'. El prefix www per al domini s\'afegirà automàticament a la configuració del servidor web.',
    'domain_unable_to_set_name' => 'El nom %1 no és correcte.',

    'domain_alias__domain_service_dns_disabled' => 'Aquest domini està servit per un altre servidor DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Aquest servidor DNS actua com el servidor de noms principal per a aquesta zona DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Aquest servidor DNS actua com a servidor de noms secundari per a aquesta zona DNS.',
    'domain_alias__domain_service_mail_enabled' => 'El servei de correu està activat per al domini.',
    'domain_alias__domain_service_mail_disabled' => 'El servei de correu està desactivat per al domini.',
    'domain_alias__domain_service_mail_mx' => 'S\'utilitza %1 com a servidor de correu.',

    'domain_alias__service_seoRedirect_hint' => 'Quan els visitants obrin l\'URL de l\'àlies, se\'ls redireccionarà a l\'URL del domini principal. Plesk utilitza el redireccionament HTTP 301 compatible amb els navegadors, el que significa que el posicionament als buscadors no es dividirà entre les diferents URLs.',

    'bt_task_run_now' => 'Executar ara',
    'ftp__read_perm' => "Permís de lectura",
    'ftp__write_perm' => "Permís d'escriptura",

    'filemanager__upload_backup_file_hint' => 'Aquí pot carregar arxius de backup a l\'emmagatzematge de Plesk. El tamany màxim d\'arxiu permès és de 2 GB.',

    '__default_for_mssql' => 'predeterminat per a MS SQL',

    '__login_does_not_pass_validation' => "El nom d'usuari no és vàlid. Comprovi que compleix els següents requisits: %1",
    '__login_allowed_symbols' => 'Només es permet l\'ús de caràcters alfanumèrics, incloent punts, guions i guions baixos. El primer caràcter hauria de ser alfanumèric.',

    'restart__nginx' => 'Servidor proxy invers (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Desitjo rebre informació sobre el producte i novetats de Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Desitjo rebre informació relacionada amb la seguretat i d'altres notificacions de Plesk.",

    '__login_status_inactive' => 'El seu compte no està actiu. Posi\'s en contacte amb l\'administrador de Plesk.',

    'migration__task_keep_in_process' => 'ACCEPTAR',
    'migration__task_keep_in_process_conhelp' => 'Torni a la pàgina Eines i configuració. La migració seguirà efectuant-se en segon pla.',

    'chk_js__warning_about_ftp_login_syntax' => "Al nom d'usuari pot utilitzar símbols alfanumèrics, guions i ratlles baixes.",
    'chk_js__warning_about_passwd_syntax' => "No utilitzi cometes, espais ni caràcters de l'alfabet nacional a les contrasenyes.\nLa contrasenya hauria de tenir una longitud d'entre %1 i %2 caràcters i en cap cas hauria d'incloure el nom d'usuari.",
    'chk_js__warning_about_plesk_login_syntax' => "Al nom d'usuari pot utilitzar lletres en minúscula, símbols alfanumèrics, punts, guions i ratlles baixes.",
    'chk_js__warning_about_admin_passwd_syntax' => "No utilitzi cometes, espais, punt i coma ni caràcters de l'alfabet nacional a les contrasenyes.\nLa contrasenya hauria d'estar formada per %1 - %2 caràcters i en cap cas hauria d'incloure el nom d'usuari.",

    'cmd_server__admin_alias_not_found' => "No ha estat possible trobar el compte d'administrador addicional.",

    'panel_branding__skins_already_exists' => "Nota: el tema '%1' ja existeix. Aquest serà substituït pel tema que està insta·lant en aquest moment.",
    'panel_branding__skins_file_exists' => "No ha estat possible crear un directori per al tema '%1': Ja existeix un arxiu amb aquest nom.",

    'actionlog__login_failed' => 'error d\'inici de sessió',
    'actionlog__event_cp_user_login_failed' => 'L\'usuari de Plesk no ha pogut iniciar sessió',
    'actionlog__api_login_failed' => 'error d\'accés a través d\'API',
    'actionlog__event_cp_user_api_login_failed' => 'L\'usuari de Plesk no ha pogut iniciar sessió a través de l\'API',
    'actionlog__pw_reset' => 'restabliment de contrasenya sol·licitat',
    'actionlog__pw_admin_force_reset' => 'restabliment forçós de contrasenya d\'administrador sol·licitat',

    'ch_pass_admin__email_subject' => "Sol·licitud de restabliment de la contrasenya de Plesk",
    'ch_pass_admin__email_body' => "Hola, %1.\n\nPer motius de seguretat no és possible enviar la contrasenya de l'administrador per email.\n\nPer a iniciar sessió com a 'admin', utilitzi l'ordre 'plesk login'.\n\nSi desitja establir una nova contrasenya 'admin', executi l'ordre 'plesk bin admin --set-password -passwd <new_password>'.\n\n",
    'ch_pass_admin__message_send_error' => 'No ha estat possible enviar l\'email: %1',

    'ch_pass_by_secret__email_subject' => "Vol restablir la seva contrasenya de Plesk?",
    'ch_pass_by_secret__email_body' => "Hola, %2,\n\nSi ha sol·licitat el restabliment de la contrasenya, segueixi aquest enllaç per establir-ne una de nova: %1\n\nEl seu nom d'usuari: %3",
    'ch_pass_by_secret__message_send_error' => 'No ha estat possible enviar el codi secret: %1',
    'ch_pass_by_secret__title' => 'Canvi de la seva contrasenya',
    'ch_pass_by_secret__secret' => 'Codi secret',

    'custom_button__noframe' => "No utilitzar marcs",

    'custom_button__internal_hint' => 'Indiqui si desitja que l\'URL s\'obri en una pàgina de Plesk o bé en una nova finestra del navegador.',
    'custom_button__noframe_hint' => 'Si afegeix un botó personalitzat que redirecciona a una extensió de Plesk o a una aplicació present al panell del client, pot indicar com s\'hauria de mostrar aquesta extensió o aplicació: en un marc o com a part del GUI de Plesk.',


    'actionlog__patch' => 'Actualitzar',
    'actionlog__patch_available' => 'disponible',
    'actionlog__event_patch_available' => 'Actualització disponible',
    'actionlog__patch_installed' => 'instal·lat',
    'actionlog__event_patch_installed' => 'Actualització instal·lada',

    'actionlog__extension' => 'Extensió',
    'actionlog__extension_status' => 'Estat de l\'extensió',
    'actionlog__cloning' => 'Clonació de servidors',
    'actionlog__cloning_complete' => 'completada',
    'actionlog__event_cloning_complete' => 'Clonació de servidors completada',

    'actionlog__ssl_web_binding' => 'Certificat SSL/TLS al domini',
    'actionlog__ssl_web_binding_update' => 'assignat/no assignat',
    'actionlog__event_ssl_web_binding_update' => 'Certificat SSL/TLS al domini assignat/no assignat',

    'actionlog__ssl_web_mail_binding' => 'Certificat SSL/TLS al webmail',
    'actionlog__ssl_web_mail_binding_update' => 'assignat/no assignat',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificat SSL/TLS al webmail assignat/no assignat',

    'actionlog__ssl_mail_binding' => 'Certificat SSL/TLS al servidor de correu',
    'actionlog__ssl_mail_binding_update' => 'assignat/no assignat',
    'actionlog__event_ssl_mail_binding_update' => 'Certificat SSL/TLS al servidor de correu assignat/no assignat',

    'actionlog__ssl_panel_binding' => 'Certificat SSL/TLS a Plesk',
    'actionlog__ssl_panel_binding_update' => 'assignat/no assignat',
    'actionlog__event_ssl_panel_binding_update' => 'Certificat SSL/TLS a Plesk assignat/no assignat',

    'actionlog__hostname' => 'Nom de host del servidor',
    'actionlog__hostname_changed' => 'canviat',

    'actionlog__smb_user' => 'Usuari addicional',
    'actionlog__smb_user_create' => 'Usuari addicional creat',
    'actionlog__smb_user_delete' => 'Usuari addicional eliminat',
    'actionlog__smb_user_update' => 'Usuari addicional actualitzat',

    'actionlog__event_mail_management_status_update' => 'Actualització de l\'estat de gestió de correu',
    'actionlog__mail_management' => 'Estat de gestió de correu',
    'actionlog__mail_management_status_update' => 'actualitzat',

    'virtualization_openvz' => 'OpenVZ',

    'passwordSecurityLevelCheckFailed' => 'La seva contrasenya no és prou complexa. Segons la directiva del servidor, la seguretat mínima de la contrasenya ha de ser %1. Per tal de millorar la seguretat de la contrasenya, utilitzi números, lletres en minúscules i majúscules i caràcters especials com per exemple !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Molt poc segura',
    'passwordSecurityLevelCheckFailedWeak' => 'Poc segura',
    'passwordSecurityLevelCheckFailedMediocre' => 'Mitja',
    'passwordSecurityLevelCheckFailedStrong' => 'Segura',
    'passwordSecurityLevelCheckFailedStronger' => 'Molt segura',

    'dns__dns_default_ipv4_modified' => 'Els registres amb aquesta adreça IP es consideraran registres modificats per l\'usuari i no es sincronitzaran amb la plantilla DNS a nivell del servidor.',
    'dns__dns_default_ipv6_modified' => 'Els registres amb aquesta adreça IP es consideraran registres modificats per l\'usuari i no es sincronitzaran amb la plantilla DNS a nivell del servidor.',

    'dns__view_dns_record_master_title' => 'Visualització de registres de recursos',
    'dns__view_dns_record_off_title' => 'Visualització de registres de servidors de noms',
    'dns__view_dns_record_slave_title' => 'Visualització de registres del servidor DNS principal',

    'dns_unable_to_resolve_hostname' => "No ha estat possible resoldre el nom de host \"%1\": %2\nComprovi que el sistema de resolució DNS del sistema operatiu està configurat i que funciona correctament.",

    'no_database_server_available' => 'No hi ha cap servidor de base de dades disponible per aquesta subscripció.',

    'database_used_by_application_can_not_be_moved' => 'No ha estat possible moure la base de dades. Hi ha una aplicació del lloc web que utilitza aquesta base de dades.',
    'database_user_update_orphaned_is_restricted' => 'No es permet actualitzar comptes d\'usuari orfes de la base de dades. Només pot eliminar-los o reparar-los.',

    'database_unable_to_get_max_filesize_default_message' => 'No ha estat possible determinar el tamany màxim de l\'arxiu de la base de dades: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'No ha estat possible establir el tamany màxim de l\'arxiu de la base de dades: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'No ha estat possible determinar el tamany màxim de l\'arxiu de registre de la base de dades: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'No ha estat possible establir el tamany màxim de l\'arxiu de registre de la base de dades: \'%1\'',

    'database_unable_to_get_max_filesize' => 'No ha estat possible determinar el límit actual del tamany de l\'arxiu de la base de dades Microsoft SQL \'%1\'. No és possible establir un límit nou.',
    'database_unable_to_set_max_filesize' => 'No ha estat possible establir el límit per al tamany de l\'arxiu de la base de dades Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'No ha estat possible determinar el límit actual del tamany de l\'arxiu de registre de la base de dades Microsoft SQL \'%1\'. No és possible establir un límit nou.',
    'database_unable_to_set_max_log_filesize' => 'No ha estat possible establir el límit per al tamany de l\'arxiu de registre de la base de dades Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'No ha estat possible crear la base de dades Microsoft SQL \'%1\'. El tamany del seu arxiu és superior al tamany màxim permès.',
    'database_unable_to_move_because_max_filesize' => 'No ha estat possible moure la base de dades Microsoft SQL \'%1\'. El tamany del seu arxiu és superior al tamany màxim permès: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'No ha estat possible crear la base de dades Microsoft SQL \'%1\'. El tamany del seu arxiu de registre és superior al tamany màxim permès.',
    'database_unable_to_move_because_max_log_filesize' => 'No ha estat possible moure la base de dades Microsoft SQL \'%1\'. El tamany del seu arxiu de registre és superior al tamany màxim permès: %2.',
    'database_unable_to_restore_because_max_filesize' => 'No ha estat possible restaurar la base de dades Microsoft SQL \'%1\'. El tamany del seu arxiu és superior al tamany màxim permès.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'A Plesk ja s\'ha registrat un MS SQL Server idèntic. Especifique un altre MS SQL Server com a entorn de proves.',
    'database_server__mssql_server_registered_as_sandbox' => 'A Plesk ja s\'ha registrat entorn de proves MS SQL Server idèntic. Especifique un altre MS SQL Server com a entorn de proves.',

    'database_server_mysql_unable_to_connect_via_cli' => 'No ha estat possible connectar-se al servidor a través de \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Els nodes de servei detallats a continuació no suporten la funció %1: %2. Aquesta funció es desactivarà per a tots els objectes creats en aquests nodes.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Aquest servidor no suporta la funció %1. Aquesta funció estarà desactivada per a tots els objectes restaurats.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'El component %1 no està instal·lat. Aquest no estarà disponible per als següents llocs web: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'El component %1 no està instal·lat. Aquest es substituirà per %2 per als següents llocs web: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'La versió actual de Plesk no suporta l\'ús de noms d\'usuari que incloguin un punt (.). Els clients i revenedors amb aquest tipus de nom d\'usuari no seran restaurats.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'No ha estat possible trobar cap arxiu de backup amb les dades per a %1 %2. Les dades per a %1 %2 no seran restaurades.',

    'bu_conflict_resolver_zone_master_removed' => "No ha estat possible restaurar el registre principal del DNS. El registre a la zona secundària apunta a l'adreça IP existent %1. El registre principal del DNS s'eliminarà de la zona secundària.",
    'bu_conflict_resolver_dns_not_supported_https' => 'El suport per als registres DNS HTPPS està desactivat. Els registres HTTPS no es restauraran per als dominis següents: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 no es suporta.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 no es suporta. Aquest no estarà disponible per als següents llocs web: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'El component %1 no està instal·lat.',
    'bu_conflict_resolver_disabled_in_multi_server' => ' Aquest no estarà disponible per als següents nodes de servei: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => ' Aquest no estarà disponible per als següents objectes: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Els servidors de base de dades detallats a continuació no estan disponibles en aquest servidor: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'No se suporta l\'administració de l\'smarthost. No es restaurarà la configuració de l\'smarthost.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'L\'arxiu de backup de la base de dades MS SQL s\'emmagatzema en el format nadiu de MS SQL, que només es pot restaurar al servidor MS SQL local o en un servidor MS SQL remot on s\'hagin configurat tots els paràmetres de backup. Algunes de les seves bases de dades no s\'han restaurat perquè a Plesk no s\'ha registrat cap servidor MS SQL apropiat. Els dominis afectats són els següents: {{objects}}. Posi\'s en contacte amb el seu proveïdor de hosting.',

    'bu_conflict_resolver_not_available_webmail' => 'El servei de webmail %1 no està disponible. Aquest es substituirà per %2 per als següents objectes: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'El servei de webmail %1 no està disponible. Aquest es substituirà per %2 per als següents plans de serveis: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Les bases de dades de tipus '%1' no suporten noms d'usuari que coincideixin amb noms de bases de dades. El nom de l'usuari '%2' es canviarà a '%3' per a la base de dades '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'A la configuració del servidor de destí no s\'ha establert el límit d\'ús d\'espai al disc. El valor d\'aquesta opció es canviarà a "Il·limitat".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'A la configuració del servidor de destí no s\'ha establert el límit de connexions. El valor d\'aquesta opció es canviarà a "Il·limitat".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'A la configuració del servidor de destí no s\'ha establert el límit d\'ús de trànsit. El valor d\'aquesta opció es canviarà a "Il·limitat".',
    'cu__pleskrestore_backup_file_extracted' => 'L\'arxiu de backup s\'ha extret a "%1".',
    '__mod_bw_not_supported' => 'El mòdul mod_bw pel servidor web Apache no es suporta degut a la configuració del sistema d\'arxius. Els límits d\'ús de trànsit i el número màxim de connexions no funcionaran.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'No es suporta l\'autorització POP3 per a la transmissió de correu. En aquest cas, s\'utilitzarà l\'autorització SMTP abans que POP3. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Pla de serveis \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 no es suporta. Aquest es substituirà per %2 per als següents plans de serveis: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 no es suporta. Aquest es substituirà per %2 per als següents llocs web: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Els objectes detallats a continuació no s\'han trobat a l\'arxiu de backup: %1',
    'bu_conflict_resolver_absent_domains' => 'Alguns objectes no poden restaurar-se perquè pertanyen als següents dominis que no s\'han trobat a Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Alguns llocs web no poden restaurar-se perquè pertanyen als següents dominis principals que no s'han trobat a Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'No ha estat possible restaurar les zones DNS. El servei de DNS està desactivat a la configuració del servidor.',
    'bu_conflict_resolver_mail_not_supported' => 'No ha estat possible restaurar les bústies de correu. El servei de correu està desactivat a la configuració del servidor.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'El servidor web IIS no suporta l\'acció de límit de CPU especificada. El valor es restablirà a %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Certificat SSL/TLS %1 del servidor',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificat SSL/TLS %2 del domini %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificat SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'El contingut dels objectes detallats a continuació no pot restaurar-se perquè els objectes no s\'han trobat a Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'El contingut de les bústies de correu detallades a continuació no pot restaurar-se perquè les bústies de correu no s\'han trobat a Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'El contingut de les llistes de correu detallades a continuació no pot restaurar-se perquè les llistes de correu no s\'han trobat a Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'El contingut de les bases de dades detallades a continuació no pot restaurar-se perquè les bases de dades no s\'han trobat a Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'No ha estat possible restaurar l\'aplicació "%1" a "%2" perquè ja existeix una altra aplicació instal·lada a "%3". Pot eliminar l\'aplicació instal·lada i tornar-ho a provar.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'No es suporta la funció de respostes automàtiques de correu.',
    'bu_conflict_resolver_not_available_mail_content' => 'No es suporta la restauració del contingut de correu.',
    'bu_conflict_resolver_invalid_mail_name' => 'Les següents bústies de correu no han estat restaurades perquè el subredireccionament de correu es troba activat i algunes adreces de correu inclouen el signe "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Els següents usuaris no han estat restaurats perquè el subredireccionament de correu es troba activat i algunes adreces de correu inclouen el signe "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Les següents llicències han caducat i no seran restaurades: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Les següents llicències no són vàlides o han caducat i no seran restaurades: {{objects}}',
    'expiration_unsupported' => "El límit 'caducitat' no se suporta.",

    'component_name__dbconnector' => "Connector de bases de dades",
    'component_name__mysqlserver' => 'Servidor de MariaDB/MySQL',
    'component_name__troubleshooting' => 'Detecció d\'errors',
    'component_name__savi' => 'Interfície de l\'antivirus Sophos',

    '__subscription_has_no_license_key' => 'Els recursos de la subscripció els proporciona el node de servei #%1, que no té associada cap clau de llicència.',
    '__subscription_has_expired_license_key' => 'Els recursos de la subscripció els proporciona el node de servei #%1, la llicència del qual %2 ha caducat.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> No ha estat possible desar els arxius de configuració',
    '__cfgmonConfigurationFileSaveErrorBody' => "No ha estat possible desar alguns arxius de configuració al host <%%host%%>. S'han produït els següents errors:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Aquesta opció permet configurar adreces de correu d\'estil VERP per llistes de correu',
    'mail__enter_right_ip_mask' => "Introdueixi una màscara IP entre 1 i 32.",
    'mail__enter_right_ip_mask_24' => "Introdueixi una màscara IP entre 24 i 32.",
    'mail__invalid_dom_name' => "El nom de domini %1 no és vàlid.",
    'mail__invalid_pop_lock_time' => "El temps de bloqueig POP3 no és vàlid.",
    'mail__invalid_rbl_server' => "El nom de la zona DNS no és vàlid.",
    'mail__total_files_size' => "Tamany total del repositori: %1",
    'mail__filename_already_in_repository' => "Al repositori ja existeix un arxiu amb aquest nom",
    'mail__no_white_list_mask_feature_24' => "Utilitzi un valor de màscara d'un mínim de 24.\nEl seu servidor de correu no suporta l'establiment de màscares. Només podem emular l'establiment de màscares per valors no inferiors a 24.",
    'mail__unable_add_new_mail_name' => "No ha estat possible afegir el compte de correu: %1",
    'mail_server_is_not_installed' => 'El servidor de correu (Postfix o Qmail) no està instal·lat. Instal·li\'l per a seguir operant.',
    'mail_server_not_available' => 'Al node de servei no hi ha cap servidor de correu suportat.',
    '__not_installed' => '(no instal·lat)',
    'mail__service_node_outgoing_messages_is_disabled' => 'La filtració d\'spam dels correus sortints està desactivada.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'El node de servei no suporta la limitació del número de correus sortints des d\'un domini per al domini %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'El node de servei no suporta la limitació del número de correus sortints des d\'una bústia de correu per al domini %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Especifiqui una adreça d\'almenys un tipus (IPv4 o IPv6).',

    'mail__outgoing_email_mode_invalid' => 'S\'ha indicat un mode d\'enviament dels correus sortits que no és vàlid.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'S\'ha indicat una adreça IPv4 que no és vàlida.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'S\'ha indicat una adreça IPv6 que no és vàlida.',
    'mail__outgoing_email_mode_unavailable' => 'No es suporta el canvi del mode de correu sortint. Probablement això es deu a que en aquest servidor no s\'ha instal·lat el servidor de correu Postfix.',

    'mail__autoresponder_attachment_not_supported' => 'El servidor de correu utilitzat en aquest moment no suporta la gestió d\'adjunts a respostes automàtiques.',

    'mail__smtp_white_list_not_supported' => 'El servidor de correu utilitzat en aquest moment no suporta la inclusió d\'adreces IP a la llista blanca.',
    'mail__smtp_whitelist_cidr_not_supported' => 'El servidor de correu seleccionat en aquest moment no suporta màscares CIDR. Indiqui l\'adreça IP en format \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'El servidor de correu seleccionat en aquest moment no suporta patrons d\'IP wildcard. Indiqui l\'adreça IP en format \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'No ha estat possible canviar la configuració pel servei de verificació DKIM',

    'sfdk_domain__serverwide_disabled' => 'Desactivat segons la directiva del servidor',
    'feature__domainkeys__serverwide_disabled' => 'La protecció antispam DKIM a nivell del servidor està desactivada',

    'defaultcomponents__error_set_default' => 'No ha estat possible establir %1 com a %2 per defecte',
    'defaultcomponents__error_set_default_none' => 'No ha estat possible establir "cap" com el component predeterminat per a %1',
    'defaultcomponents__required_package_not_default' => 'El component %1 necessari per al seu funcionament no és el predeterminat.',

    '__percentage' => '%',
    '__seconds' => 'Segons',
    '__resource_remain' => 'Restant',

    '__not_registered' => '(no registrat)',
    '__php_handler_id' => 'Versió de PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'El controlador de PHP "%1" no està registrat. Probablement s\'ha eliminat del servidor. Registri un controlador amb les mateixes propietats i torni-ho a provar.',
    '__php_handler_not_registered_on_domain' => 'Domini "%1": El controlador de PHP "%2" no està registrat. Probablement s\'ha eliminat del servidor. Registri un controlador amb les mateixes propietats i torni-ho a provar.',
    '__php_fpm_handler' => 'Aplicació FPM',
    '__php_fpm-dedicated_handler' => 'Aplicació FPM dedicada',

    'mailname_create_assigned_user_dublicate_error' => 'No ha estat possible crear un usuari per la bústia de correu. Ja existeix un usuari amb nom d\'usuari %1 i aquest té una altra bústia de correu.',
    'mailname_create_assigned_user_role_absent_error' => 'No ha estat possible crear un usuari per la bústia de correu. El rol predeterminat %1 de l\'usuari no existeix.',

    'gphd__mime_types' => 'Tipus MIME',
    'gphd__handlers' => 'Controladors d\'Apache',
    'gphd__ip_restrictions_allow' => 'Permetre l\'accés al lloc als hosts i xarxes indicats, excloent els denegats',
    'gphd__ip_restrictions_deny' => 'Denegar l\'accés al lloc als hosts i xarxes indicats',
    'gphd__directory_index' => 'Arxius d\'índex',
    'gphd__nginx_transparent_mode' => 'El mode en el que Apache gestionar el contingut estàtic i el dinàmic, mentre que nginx només envia les peticions i respostes HTTP sense modificació.',
    'gphd__nginx_serve_static' => 'Servir arxius estàtics directament a través de nginx',
    'gphd__nginx_static_extensions' => 'Extensions d\'arxius estàtics que han de ser gestionades per nginx',
    'gphd__nginx_serve_php' => 'Processar arxius PHP mitjançant nginx',
    'gphd__www_root' => 'Directori arrel WWW',

    'eol__none' => 'no modificar',
    'eol__lf' => 'convertir en l\'estil d\'Unix',
    'eol__cr' => 'convertir en l\'estil de MacOS',
    'eol__crlf' => 'convertir en l\'estil de Windows',

    'ui__dns_bad_zone' => 'Zona incoherent "%1": ',
    'ui__dns_ns_has_no_address_records' => 'El registre NS "%1" no té registres d\'adreça (A o AAAA).',
    '__dns_bad_zone' => 'Zona incoherent "%1": ',
    '__dns_ns_has_no_address_records' => 'El registre NS "%1" no té registres d\'adreça (A o AAAA).',
    '__dns_ptr_is_wildcard' => 'El registre PTR "%1" no és vàlid. El registre apunta a un domini wildcard.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Permetre accés remota per a l\'usuari \'%3\' de la base de dades del client \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'No ha estat possible permetre connexions remotes per a l\'usuari \'%1\' de la base de dades. No s\'ha pogut determinar el número del port TCP utilitzat pel servidor Microsoft SQL \'%2\'. Això es pot deure a les següents causes: el protocol TCP/IP no està activat a la configuració de xarxa del servidor o bé el servidor s\'ha configurat per a fer servir ports TCP dinàmics. Configuri el servidor per tal que escolti en un port TCP fixe i específic i intenti tornar a permetre connexions remotes.',

    'command__convertResellerHasCustomer' => 'El compte de revenedor \'%1\' té un o varis comptes de client. Per poder convertir aquest compte de revenedor en compte de client, primer cal que transfereixi els comptes de client a un nou propietari o bé que els converteixi en comptes de revenedor.',
    'command__convertResellerNotReseller' => 'Només els comptes de revenedor es poden convertir en comptes de client. \'%1\' no es un revenedor.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'No ha estat possible sincronitzar la subscripció amb el pla de serveis. Els paràmetres de configuració de la subscripció detallats a continuació entren en conflicte amb el pla de serveis: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'El compte \'%1\' és un compte de revenedor. Els comptes de revenedor no poden transferir-se a un altre propietari, ja que són propietat de l\'administrador del servidor.',
    'moveCustomer__wrong_owner_type' => "El compte de client '%1' només es pot transferir a un revenedor o administrador i en cap cas a un altre client.",
    'moveCustomer__customer_already_belongs_to_owner' => 'El compte de client \'%1\' ja pertany al propietari seleccionat.',
    'upgradeClient__user_is_admin' => 'El compte \'%1\' no es pot convertir en compte de revenedor perquè es tracta d\'un compte d\'administrador.',

    'mail__error_setting_max_connections_courier' => 'No ha estat possible establir el número màxim de connexions (IMAP, POP3, IMAP a través d\'SSL/TLS o POP3 a través d\'SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'No ha estat possible establir el número màxim de connexions (IMAP, POP3, IMAP a través d\'SSL/TLS o POP3 a través d\'SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'No ha estat possible establir el número màxim de connexions (IMAP, POP3, IMAP a través d\'SSL/TLS o POP3 a través d\'SSL/TLS) per adreça IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'No ha estat possible establir el número màxim de connexions (IMAP, POP3, IMAP a través d\'SSL/TLS o POP3 a través d\'SSL/TLS) per adreça IP per a un usuari de correu específic: %1',
    'outgoing_messages_limit_value_invalid' => 'El valor ha d\'estar entre %%MIN%%..%%MAX%%. L\'administrador de Plesk és l\'únic que pot modificar aquesta opció.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Els dominis detallats a continuació utilitzen adreces de correu externes per a reenviar els correus enviats a adreces inexistents. Els correus enviats a aquesta adreça no es comptabilitzaran al control dels correus sortints:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Els límits dels correus sortints no s\'aplicaran en el cas de remitents les adreces IP dels quals estiguin presents a la llista blanca del servidor de correu. Per exemple, si a la llista blanca s\'ha inclòs localhost (127.0.0.0 / 8, ::1 / 128), tots els correus procedents de servidor local s\'enviaran correctament sigui quin sigui el límit. Els remitents dels correus poden utilitzar adreces IP locals (llocs web i scripts personalitzats allotjats al servidor local) o adreces IP externes (clients que envien els correus mitjançant clients de correu instal·lats als seus ordinadors o dispositius mòbils). Si desitja que els límits s\'apliquin per a tots els remitents de correu (tant locals com externs), elimini totes les adreces de correu i xarxes de la llista blanca. Tingui en compte que si elimina localhost (127.0.0.0 / 8, ::1 / 128) de la llista blanca, és possible que s\'interrompin les operacions de llocs web i scripts que enviïn correus des d\'aquest servidor. Si desitja més informació sobre la limitació dels correus sortints, consulti la guia de l\'administrador, concretament l\'apartat Protecció contra l\'spam sortint.',
    'outgoing_messages_relay_open' => 'La tramesa de correu està oberta. Els límits dels correus sortints no s\'aplicaran.',

    'notification_aps_app_updates_available' => 'Existeixen actualitzacions per les següents aplicacions:',
    'notification_aps_app_updates_installed' => 'S\'han instal·lat actualitzacions de forma automàtica per les següents aplicacions:',
    'notification_aps_app_updates_requirements' => 'Existeixen actualitzacions per les aplicacions detallades a continuació, si bé no es poden instal·lar perquè la configuració de hosting dels llocs web corresponents no compleix els requisits d\'instal·lació:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" a %%parentName%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" a %%parentName%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" a %%parentName%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" a %%parentName%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). La seva versió: %%from%%. Versió disponible: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" a %%parentName%% (%%url%%). La seva versió: %%from%%. Versió disponible: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" a %%parentName%% (%%url%%). La seva versió: %%from%%. Versió disponible: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versió nova: %%to%%. Versió anterior: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versió nova: %%to%%. Versió anterior: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versió nova: %%to%%. Versió anterior: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versió instal·lada: %%from%%. Versió disponible: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). La seva versió: %%from%%. Versió disponible: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'aplicació externa',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Dominis',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Adreces de correu',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Subscripcions',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 correus/hora',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Il·limitats',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, el límit és %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 intent(s) d\'excedir els límits des de %2 fins a %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 intent(s) d\'excedir els límits des de %2 fins ara',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Prohibició d'adreces IP (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'El component Fail2ban no està instal·lat al servidor de destí.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Instal·li Fail2ban. Tingui en compte que aquesta acció tarda uns minuts en completar-se.',

    'plesk_key__no_reseller_support' => 'Les restriccions de la llicència no li permeten gestionar revenedors.',
    'plesk_key__no_customers_support' => 'Les restriccions de la llicència no li permeten gestionar clients.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'No ha estat possible canviar al mode de visualització de Proveïdor de serveis degut a restriccions de la llicència.',
    'plesk_key__no_security_core_support' => 'Les prestacions de seguretat (ModSecurity i Fail2Ban) no estan disponibles degut a restriccions de la llicència.',
    'plesk_key__outgoing-antispam' => 'Control dels correus sortints',
    'plesk_key__security-core' => 'Prestacions de seguretat (ModSecurity i Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Gestió de comptes',
    'plesk_key__can-manage-subscriptions' => 'Gestió de subscripcions',
    'plesk_key__can-manage-customers' => 'Gestió de clients',
    'plesk_key__can-manage-resellers' => 'Gestió de revenedors',
    'plesk_key__can-manage-custom-view' => 'Disponibilitat del mode restringit',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'La gestió de subscripcions està desactivada però disposa de vàries subscripcions (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'La gestió de revenedors està desactivada però disposa de varis revenedors (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'La gestió de clients està desactivada però disposa de varis clients (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Alguns recursos de la subscripció que ja no poden seguir-se administrant a la interfície de Plesk (com per exemple els límits de bústies de correu o l\'espai en disc dels dominis) ara s\'estableixen a il·limitats.',
    'plesk_key__no_subscriptions_support' => 'Les restriccions de la llicència no li permeten gestionar subscripcions.',
    'plesk_key__no_custom_view_support' => 'No pot utilitzar el mode restringit degut a restriccions de la llicència.',
    'plesk_key__trial_forbidden_region' => 'Ens sap greu, en aquest moment Plesk no està disponible a la seva regió.',
    'additional_key__main_key' => 'La clau és una clau principal. Les claus principal no es poden carregar com a claus addicionals.',

    'gch__hosting_waf_rule_engine' => 'Mode de firewall per a aplicacions web',

    'backup__fieldset__restoration_options' => 'Opcions de restauració',
    'backup__restore_options__restore' => 'Restaurar',
    'backup__restore_options__domain__domain_configuration' => 'Configuració del domini',
    'backup__restore_options__domain__virtual_host_content' => 'Contingut del host virtual',
    'backup__restore_options__domain__mail' => 'Correu',
    'backup__restore_options__domain__databases' => 'Bases de dades',
    'backup__restore_options__client__client_configuration' => 'Configuració del compte de client',
    'backup__restore_options__client__domains' => "Dominis del client",
    'backup__restore_options__reseller__reseller_configuration' => 'Configuració del compte de revenedor',
    'backup__restore_options__reseller__personal_domains' => "Dominis del revenedor",
    'backup__restore_options__reseller__clients' => "Clients del revenedor",
    'backup__restore_options__admin__server_configuration' => 'Configuració del servidor',
    'backup__restore_options__admin__administrator_configuration' => 'Configuració del compte d\'administrador',
    'backup__restore_options__admin__personal_domains' => "Dominis de l'administrador",
    'backup__restore_options__admin__personal_clients' => "Clients de l'administrador",
    'backup__restore_options__admin__resellers' => 'Revenedors',

    'badge_new' => 'Nou',
    'upgrade_php_on_subscription' => 'Actualitzi PHP a la seva subscripció a la versió 5.3.0 o a una versió posterior.',

    'pkey_notify__body_expiration_notification' => 'La clau de llicència ha caducat. Algunes funcions poden no estar disponibles. Posi\'s en contacte amb el seu proveïdor de hosting.',

    'crontab__crontab_entry_exists' => "La tasca programada ja existeix.",
    'crontab__crontab_entry_not_exists' => "La tasca programada no existeix.",
    'crontab__invalid_values_found' => "Valors del paràmetre incorrectes.",
    'crontab__cmd_max_len' => "L'ordre no pot tenir més de %1 caràcters.",

    'domain__domain_exists' => "Existeix un domini amb el prefix 'www' i el mateix nom: %1.%2.",
    'domain__subdomain_exists' => "Existeix un subdomini amb el prefix 'www' i el mateix nom: %1.%2.",
    'domain__dalias_exists' => "Existeix un àlies de domini amb el prefix 'www' i el mateix nom: %1.%2.",
    'domain__record_exists' => "Existeix un registre DNS que apunta al host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "El certificat '%1' no es pot establir com a certificat predeterminat, ja que és necessari disposar d'una clau privada.",
    'ip_addr__update_dns_error' => 'S\'han produït incidències mentre s\'actualitzava l\'adreça IP a les zones DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'No es pot afegir l\'adreça IP. Aquesta interfície de xarxa obté adreces IP de forma automàtica.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'No es pot eliminar l\'adreça IP %1. Aquesta interfície de xarxa obté adreces IP de forma automàtica.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'No es pot reparar l\'adreça IP %1. Aquesta interfície de xarxa obté adreces IP de forma automàtica.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'No és possible canviar la interfície de l\'adreça IP %1 perquè la interfície de xarxa %2 obté les adreces IP de forma automàtica.',

    'shm_lmsg__limit_for_resource_exceeded' => 'S\'ha excedit el límit de %%type%% de la subscripció. El límit és %%limit%% i l\'ús actual és %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'No es permet la creació de %%type%% per aquesta subscripció.',
    'shm_lmsg__resource_title__db-mysql' => 'Bases de dades MariaDB/MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Bases de dades MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Bases de dades PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'usuaris de la base de dades',
    'shm_lmsg__resource_title__iis-application-pool' => 'Conjunts d\'aplicacions IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'comptes FTP addicionals',

    'db_user_unable_remove_mysql_global_privileges' => 'No ha estat possible eliminar el privilegis globals de MariaDB/MySQL de l\'usuari %1 de la base de dades. Motiu: %2',
    'report__client_description' => 'Descripció',

    'db__user_role_error' => 'S\'ha especificat un rol d\'usuari de la base de dades que no és correcte: %1. Seleccioni un dels següents rols: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'No ha estat possible establir el tamany màxim de l\'arxiu per a les següents bases de dades Microsoft SQL Server, ja que aquestes tenen un tamany d\'arxiu superior: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'No ha estat possible establir el tamany màxim de l\'arxiu de registre per a les següents bases de dades Microsoft SQL Server, ja que aquestes tenen un tamany d\'arxiu de registre superior: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'No ha estat possible configurar una adreça IP pública, ja que és necessari disposar d\'una adreça IP privada.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'No ha estat possible configurar una adreça IPv4 pública per a l\'adreça IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'No ha estat possible configurar una adreça IPv6 pública per a l\'adreça IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'No ha estat possible configurar una adreça IP pública: l\'adreça IP no és vàlida.',

    '__user_already_exists' => "L'usuari %1 ja existeix.",
    '__user_name_is_empty' => "Indiqui un nom d'usuari.",

    'upgrade_php_on_domain' => 'No ha estat possible trobar PHP 5.3.0 o una versió posterior a cap dels seus dominis WordPress. Intenti actualitzar PHP.',

    'component_name__waf' => 'Firewall per a aplicacions web',
    'component_name__vcs' => 'Sistema de control de versions',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'S\'ha detectat un possible intent de suplantació d\'identitat. L\'enllaç ha intentat mostrar contingut irrellevant.',
    'forceResetPasswordUpdated' => 'La seva contrasenya ha estat modificada. Empri la contrasenya nova per accedir a Plesk.',

    'php_handlers_error_no_available_instance' => 'No ha estat possible crear un domini, ja que no hi ha cap controlador de PHP disponible.',
    'domain_error_unable_to_apply_hosting_settings' => 'No ha estat possible aplicar la configuració de hosting: %1',

    'plesk_not_configured' => 'Plesk no està configurat. Vagi al panell de control per a realitzar els passos de configuració posteriors a la instal·lació.',
    'cmd_mail__mail_password_duplicated' => 'El parell especificat d\'adreça de correu i contrasenya ja existeix al servidor de correu. Indiqui una altra adreça de correu o contrasenya.',

    'extensionRequirementOs' => 'El paquet no suporta el sistema operatiu (%1).',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 és la versió més antiga suportada pel paquet.',
    'extensionRequirementPleskMaxVersion' => 'El paquet no suporta versions de Plesk a partir de la versió %1.',
    'extensionBlacklisted' => 'No es permet instal·lar l\'extensió %1.',
    'extensionDisabled' => 'L\'extensió està desactivada.',


    'optimization_settings__unable_set_mpm_event' => 'No ha estat possible establir el mode mpm_event. Aquest requereix que el mòdul Apache PHP5 estigui desactivat, però aquest mòdul està sent utilitzat pels dominis.',
    'optimization_settings__unable_turn_off_php' => 'No ha estat possible desactivar el mòdul Apache PHP5. Aquest està sent utilitzat per dominis.',

    'hst_def__fp_admin_login' =>  'Nom d\'usuari FTP',
    'hst_def__fp_admin_passwd' =>  'Contrasenya FTP',

    'database_user_orphaned_old_password_wrong' => "No ha estat possible reparar l'usuari orfe '%1' perquè la contrasenya no és correcta.",
    'cannot_load_partner_central_property_key_no_exist' => "No ha estat possible recuperar les propietats personalitzades, ja que la clau de llicència no existeix.",
    'extensionScriptFailure' => "Error en l'execució de %1 amb el següent missatge:\n%3",
    '__ssl_redirect' => "Redireccionament 301 permanent de HTTP a HTTPS preservant SEO",
    'component_name__dotnetcore' => 'Nucli .NET',
    'mail__dkim_not_supported' => 'No es suporta la gestió de DKIM.',
    'mail__dmarc_not_supported' => 'No es suporta la gestió de DMARC.',
    'mail__relay_white_list_not_supported' => 'No es suporta la gestió de llistes blanques de retransmissió.',
    'mail__black_list_not_supported' => 'No es suporta la gestió de llistes negres.',
    'mail__autoresponder_not_supported' => 'No es suporta la gestió de respostes automàtiques.',
    'mail__autoresponder_message_subject' => 'Resposta automàtica',
    'defaultcomponents__not_supported_version' => '(versió no suportada)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'No s\'ha trobat el certificat \'%1\'.',
    'certificate__unable_setup_certificate' => 'No s\'ha pogut instal·lar el certificat perquè no s\'ha trobat el contingut del certificat i la clau privada.',
    'certificate__used_by_panel' => 'Un dels certificats que està a punt d\'eliminar s\'utilitza per a protegir Plesk.',
    'certificate__used_by_mail_server' => 'Un dels certificats que està a punt d\'eliminar s\'utilitza per a protegir el servidor de correu.',
    'certificate__used_by_domain_service' => 'Un dels certificats que està a punt d\'eliminar és utilitzat pel servei de domini.',
    'mail_server__not_installed' => 'No ha estat possible instal·lar el certificat pel servidor de correu perquè aquest no ha estat instal·lat.',

    'email_activation_mail_subject' => 'Activi el seu compte a Plesk',
    'email_activation_mail_body' => "S'ha creat un compte al servidor Plesk %1\n\nDetalls del compte:\nNom: %2\nAdreça de correu: %3\n\nSi aquesta informació és correcta i vostè ha creat el compte, activi'l mitjançant el següent enllaç:\n\n%4\n\nA l'activar el compte, autoritza al titular del servidor a recopilar, emmagatzemar, processar i utilitzar les seves dades personals (nom i adreça de correu) per a crear i donar suport al seu compte conforme a les lleis de protecció de dades vigents, com a part d'un contracte.",

    'backup_transport_permission_name' => 'Gestió de %1',
    'backup_transport_permission_description' => 'Permet utilitzar %1 per a emmagatzemar backups.',

    'domain_move_err_target_no_hosting' => 'No és possible moure el domini a una subscripció sense hosting.',
    'domain_move_err_already_in_target' => 'El domini ja pertany a la subscripció de destí.',
    'domain_move_err_main_domain' => 'El domini principal no es pot moure.',
    'domain_move_err_subdomain_without_parent' => 'No és possible moure el subdomini %1 sense el domini principal %2.',
    'domain_move_err_root_exists' => 'La ruta de destí per www_root %1 ja existeix.',
    'domain_move_err_nested_roots' => 'No es pot moure el domini perquè comparteix l\'arrel de documents amb un altre domini: %1.',
    'domain_move_err_no_mail_service' => 'No és possible moure el domini perquè el servei de correu està desactivat a la subscripció de destí.',
    'domain_move_err_app' => "L'aplicació instal·lada a %1 no s'ha mogut a la subscripció '%2': %3",
    'domain_move_database_used_by_app' => "La base de dades '%1' a %2 és emprada per l'aplicació moguda. Si desitja tornar a assignar la base de dades a '%3', executi `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "La subscripció de destí '%1' ha estat bloquejada i no es sincronitzarà.",
    'domain_move_filesharing_disabled' => 'La compartició d\'arxius ha estat desactivada.',
    'domain_move_website_preview_disabled' => 'La previsualització de llocs web ha estat desactivada.',
    'domain_move_additional_webserver_settings' => "Revisi les directives del servidor web addicional del domini per tal d'evitar una configuració malmesa.",
    'domain_move_no_permission' => "No es permet %1 per la subscripció '%2'.",
    'domain_move_no_access' => "No es té accés a la subscripció '%1'.",
    'domain_split_no_create_permission' => "No es permet crear dominis.",
    'domain_split_empty_login' => 'Es necessita el nom d\'usuari de l\'usuari del sistema.',
    'domain_split_empty_password' => 'Es necessita la contrasenya de l\'usuari del sistema.',
    'domain_split_err_home_exists' => 'El domini %1 no es pot moure perquè la seva ruta d\'accés principal de destí ja existeix a %2. Canviï el nom del domini per tal de poder-lo moure a una subscripció nova.',
    'domain_split_err_no_hosting_subdomains' => 'El domini no es pot transferir a una nova subscripció, ja que el domini no disposa de hosting però sí de subdominis. Per a transferir-lo, canvii el seu valor "Tipus de hosting" a "Hosting de llocs web" (a Configuració de hosting).',
    'domain_split_target_locked' => "La subscripció de destí '%1' està bloquejada i no es sincronitzarà.",
    'domain_split_target_unsynced' => "La subscripció de destí '%1' no ha estat sincronitzada amb el pla: %2.",
    'domain_merge_scheduled_backup_deactivated' => "El backup programat s'ha desactivat a '%1'.",
    'domain_merge_database_error' => "La base de dades '%1' a %2 no s'ha transferir a la subscripció '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "El FTP anònim a '%1' ha estat desactivat.",
    'domain_merge_smb_user_access' => "L'usuari addicional '%1' s'ha transferit a la subscripció '%2', si bé s'ha revocat l'accés de l'usuari a la subscripció.",
    'domain_merge_scheduled_tasks' => "Les tasques programades s'han transferit a la subscripció de destí. Revisi la configuració de les tasques.",
    'domain_merge_scheduled_tasks_deactivated' => "Les tasques programades s'han transferit a la subscripció de destí i s'han desactivat. Revisi la configuració de les tasques.",
    'domain_merge_no_remove_permission' => "No es permet l'eliminació de subscripcions.",
    'domain_merge_err_has_addons' => 'No es pot transferir el domini principal amb els seus dominis addicionals. Transfereixi primer el(s) domini(s) %1.',
    'domain_merge_err_has_webusers' => 'No és possible transferir el domini principal amb els seus usuaris web.',
    'domain_merge_err_root_exists' => 'La ruta de destí %1 ja existeix.',

    'database_server_edit_used_for_psa' => 'No es permet actualitzar un servidor de base de dades MariaDB/MySQL local.',
    'suggest_repair_main_suggestion_ui' => '<b>Pot corregir aquest error</b> amb l\'utilitat `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Pot corregir aquest error amb l\'utilitat `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'vagi a Diagnosticar i reparar',
    'suggest_repair_using_cli_and_ui' => 'Executi l\'ordre `plesk repair %1` a través del CLI o %2 i faci clic a Reparar present al costat de “Base de dades de Plesk”',
    'suggest_repair_using_cli' => 'Executi l\'ordre `plesk repair %1` a través del CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'El servei DNS no es trobava disponible quan es va crear el backup. De totes maneres, existeixen zones DNS actives al backup i aquestes s\'activaran pels següents objectes: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Controlador de recursos (cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Suport de SmarterMail remot',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(no permès per la clau de llicència)',
    'plesk_key__validation_failed' => '%1 (Codi d\'error: %2)',
    'promo__button_details' => 'Detalls',
    'promo__extension_catalog_title' => 'Catàleg d\'extensions',
    'promo__extension_catalog_description' => 'Doni un cop d\'ull al nou catàleg d\'extensions i optimitzi Plesk al màxim mitjançant una àmplia varietat d\'extensions!',
    'promo__button_open_catalog' => 'Obrir el catàleg',

    'backup__repository_check_login' => "No ha estat possible accedir a l'emmagatzematge: %1\nComprovi que ha indicat les credencials correctes de l'emmagatzematge.",
    'backup__repository_check_error_list' => "No ha estat possible accedir a l'emmagatzematge: %1\nComprovi que ha indicat la configuració correcta de l'emmagatzematge.",
    'backup__repository_check_error_mkdir' => "No ha estat possible crear el directori: %1\nComprovi que disposa dels permisos necessaris per crear carpetes a l'emmagatzematge.",
    'backup__repository_check_error_upload' => "No ha estat possible carregar l'arxiu a l'emmagatzematge: %1\nComprovi que disposa dels permisos necessaris per carregar arxius a l'emmagatzematge.",
    'backup__repository_check_error_download' => "No ha estat possible descarregar l'arxiu de l'emmagatzematge: %1\nComprovi si disposa dels permisos necessaris per carregar i descarregar arxius de l'emmagatzematge.",
    'backup__repository_check_error_resume-upload' => "No ha estat possible reprendre la càrrega de l'arxiu a l'emmagatzematge: %1\nComprovi si disposa dels permisos necessaris per reprendre càrregues a l'emmagatzematge.",
    'backup__repository_check_error_resume-download' => "No ha estat possible descarregar l'arxiu de l'emmagatzematge: %1\nComprovi si disposa dels permisos necessaris per reprendre descàrregues de l'emmagatzematge.",
    'backup__repository_check_error_enable-utf8' => "No ha estat possible operar amb l'emmagatzematge: %1\nComprovi si aquest suporta la codificació UTF8.",
    'backup__repository_check_error_rm' => "No ha estat possible operar amb l'emmagatzematge: %1\nComprovi que disposa dels permisos necessaris per eliminar arxius de l'emmagatzematge.",
    'backup__repository_check_error_rmdir' => "No ha estat possible operar amb l'emmagatzematge: %1\nComprovi que disposa dels permisos necessaris per eliminar carpetes de l'emmagatzematge.",

    'backup__ftp_repository_check_login' => "%1 Pot comprovar-los independentment amb l'ordre:\n %2\n %",
    'backup__ftp_repository_check_error_list' => "%1 Pot comprovar-los independentment amb l'ordre:\n %2\n %",
    'backup__ftp_repository_check_error_mkdir' => "%1 Pot comprovar-ho independentment amb l'ordre:\n %2\n %",
    'backup__ftp_repository_check_error_upload' => "%1 Pot comprovar-ho independentment amb les ordres:\n %2\n %3",
    'backup__ftp_repository_check_error_download' => "%1 Pot comprovar-ho independentment amb les ordres:\n %2\n %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Pot comprovar-ho independentment amb les ordres:\n %2\n %3\n %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Pot comprovar-ho independentment amb les ordres:\n %2\n %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Pot comprovar-ho independentment amb l'ordre:\n %2\n %",
    'backup__ftp_repository_check_error_rm' => "%1 Pot comprovar-ho independentment amb les ordres:\n %2\n %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Pot comprovar-ho independentment amb les ordres:\n %2\n %3",

    'sfdmarc_server_wide_enable_failed' => 'No ha estat possible canviar la configuració de DMARC. Si desitja activar aquesta opció, activi la protecció antispam DKIM i SPF.',
    'spf_server_wide_disable_failed' => 'No ha estat possible canviar la configuració de la protecció antispam SPF. Per desactivar SPF, desactivi DMARC pel correu entrant.',
    'sfdk_server_wide_verify_disable_failed' => 'No ha estat possible canviar la configuració de la protecció antispam DKIM. Per desactivar DKIM, desactivi DMARC pel correu entrant.',

    'ccs_not_supported' => 'L\'emmagatzematge de certificats central d\'IIS no es troba configurada al sistema.',
    'ccs_not_enabled' => 'La gestió d\'emmagatzematge de certificats central d\'IIS no es troba activada a Plesk.',
    'ad_not_supported' => 'El servidor no està associat a cap domini.',

    'component_name__appinit' => "Inici d'aplicacions",
    'component_name__cors' => "Compartició de recursos amb diferents orígens",
    'component_name__httpcompression' => 'Compressió de contingut HTTP',
    'common_feature_is_not_supported' => 'Ja no es suporta aquesta funció.',
    'common_feature_is_not_supported_in_proto' => 'No es suporta aquesta funció per la versió %1 del protocol.',
    'autoinstaller__plesk_component' => 'Component de Plesk',
    'plesk_key__key_expired' => 'La seva clau de llicència ha caducat. Per continuar fent servir Plesk, %1.',
    'plesk_key__key_purchase' => 'compri una nova llicència',
    'plesk_key__key_expired_period' => 'La seva clau de llicència ha caducat fa més de %1 dies.',

    'sa_action_move' => 'Moure l\'spam a la carpeta "Correu brossa"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Ja no es suporten aplicacions Java. Aquestes ja no es trobaran disponibles pels següents llocs web: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Ja no es suporten versions mòbils de llocs web allotjats amb UNITY Mobile. Aquestes ja no es trobaran disponibles pels següents llocs web: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'La directiva d\'ús a nivell del servidor no permet l\'ús d\'una configuració antivirus personal. Aquesta es restaurarà de manera incompleta pels comptes de correu presents als següents dominis: {{objects}}',

    'module__not_installed' => "L'extensió %1 no està instal·lada",

    'mail__mail_autodiscovery_server_error' => 'Indicar un nom de domini personalitzat per la detecció automàtica de correu',
    'mail__error_mail_autodiscovery_enable' => 'No ha estat possible configurar la detecció automàtica de correu: %1',
    'mail__error_mail_autodiscovery_server' => 'No ha estat possible establir un nom de domini personalitzat per la detecció automàtica de correu: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'No ha estat possible reconfigurar el registres DNS de detecció automàtica de dominis: %1',

    'mail__smarthost_not_configured_error' => 'No s\'ha configurat un smarthost.',
    'mail__smarthost_attach_domains_error' => 'L\'addició de dominis a l\'smarthost ha finalitzat amb errors:',

    '__invalid_url' => 'L\'URL "%1" no és vàlida',
    'actionlog__cloning_start' => 'iniciar',
    'actionlog__event_cloning_start' => 'Inici de clonació de servidors',

    '__UPLOAD_ERR_FORM_SIZE' => "L'arxiu carregat excedeix el tamany permès",
    '__UPLOAD_ERR_INI_SIZE' => "L'arxiu carregat excedeix el tamany permès",
    '__UPLOAD_ERR_NO_FILE' => "No s'ha rebut cap arxiu",
    '__UPLOAD_ERR_OK' => "L'arxiu s'ha carregat correctament",
    '__UPLOAD_ERR_PARTIAL' => "L'arxiu s'ha carregat parcialment. Torni-ho a provar.",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'No s\'ha trobat la carpeta temporal',
    '__UPLOAD_ERR_CANT_WRITE' => 'Error a l\'escriure l\'arxiu al disc',
    '__UPLOAD_ERR_UNKNOWN' => 'S\'ha produït un error desconegut de càrrega d\'arxiu',
    '__accounts' => "Comptes",
    '__access' => "Accés",
    '__address' => "Adreça",
    '__addresses' => "Adreces",
    '__acl_records' => 'Registres ACL',
    '__admin_repository' => "Repositori de l'administrador",
    '__all' => 'Tots',
    '__allowed' => "Es permet",
    '__anonftp_status' => "FTP anònim",
    '__antispam' => "Antispam",
    '__apache_restart' => "... el servidor web %1 s'està reiniciant. Esperi ...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Suport de Microsoft ASP.NET",
    '__asp_win_support' => "Suport de Microsoft ASP",
    '__attachments' => "Adjunts",
    '__attachments_list' => "Adjunts",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Ja existeix una resposta automàtica anomenada %1.",
    '__autoresponder' => "Resposta automàtica",
    '__autoresponders' => "Respostes automàtiques",
    '__autoresponders_list' => "Respostes automàtiques",
    '__autoresponder_attachment_files' => "Arxius adjunts de la resposta automàtica",
    '__auto_updates_list' => 'Actualitzacions disponibles',
    '__backup_utilites' => "Utilitats de backup",
    '__bind_status' => "Estat del servidor DNS",
    '__bu_is_not_installed' => "Aquest servei no està disponible en aquests moments perquè no s'ha instal·lat cap utilitat de backup.",
    '__bu_not_support_in_key' => "La clau de llicència no suporta la capacitat de backup.",
    '__notifications_not_support_in_key' => 'La clau de llicència no suporta les notificacions',
    'disabled_by_key' => 'No suportat per la clau de llicència',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "No pot utilitzar les paraules reservades.",
    '__certificate' => "Certificat",
    '__cgi_support' => "Suport per CGI",
    '__city' => "Ciutat",
    '__cl_not_exist' => "El compte de client no existeix.",
    '__client' => 'Client',
    '__client_card' => "Targeta del client",
    '__client_contact_name' => "Nom de contacte del client",
    '__client_form' => "Informació personal",
    '__client_ip_pool' => "Grup d'adreces IP del client",
    '__client_limits' => "Límits del compte de client",
    '__client_permissions' => "Permisos del client",
    '__client_preferences' => "Preferències del client",
    '__client_status' => "Estat del client",
    '__client_total' => "Total de clients",
    '__client_with_login_name_already_exists' => "Ja existeix un usuari amb nom d'usuari \"%1\".",
    '__client_domuser_with_login_already_exists' => "El nom d'usuari '%1' ja l'utilitza l'administrador del domini '%1'.",
    '__clients_global_changes' => "Modificar els comptes de client seleccionats",
    '__cmd_not_found' => "Ordre desconeguda: %1",
    '__comments' => "Comentaris",
    '__component_version' => "Versió del component",
    '__component_not_installed' => "El component %1 no ha estat instal·lat",
    '__confirm_overwrite' => "Confirmi la sobreescritura.",
    '__confirm_stop' => "Confirmi que desitja aturar el procés.",
    '__confirm_passwd' => "Confirmi la contrasenya %1",
    '__conhelp' => "Descripció",
    '__contact_name' => "Nom de contacte",
    '__country' => "País",
    '__countries' => 'País',
    '__country_unknown' => 'No ha estat possible reconèixer el subcodi del país.',
    '__courier-imap' => 'Servidor Courier',
    '__create_domain' => 'Crear un domini',
    '__crypted' => 'xifrat',
    '__cp_access' => "Accés a Plesk",
    '__cp_user' => "Usuari de Plesk",
    '__create' => "Crear",
    '__create_client_template_without_template' => "Crear compte d'usuari sense plantilla",
    '__create_domain_for' => "Crear un domini per <b>%1</b>",
    '__create_domain_template_without_template' => "Crear domini sense plantilla",
    '__creation_date' => "Data de creació",
    '__crontab_unix' => "Planificador",
    '__crontab_win' => "Planificador",
    '__ct_month_jan' => 'Gener',
    '__ct_month_feb' => 'Febrer',
    '__ct_month_mar' => 'Març',
    '__ct_month_apr' => 'Abril',
    '__ct_month_may' => 'Maig',
    '__ct_month_jun' => 'Juny',
    '__ct_month_jul' => 'Juliol',
    '__ct_month_aug' => 'Agost',
    '__ct_month_sep' => 'Setembre',
    '__ct_month_oct' => 'Octubre',
    '__ct_month_nov' => 'Novembre',
    '__ct_month_dec' => 'Desembre',
    '__custom_button' => "Botó personalitzat",
    '__custom_buttons_list' => "Enllaços a serveis addicionals",
    '__daily' => "Cada dia",
    '__database_not_activated' => "%1 no s'ha activat a la pàgina d'administració del servidor.",
    '__database_not_installed' => "La base de dades %1 no està instal·lada.",
    '__database_not_run' => "La base de dades %1 no està en execució.",
    '__database_is_corrupt' => "La base de dades de Plesk s'ha malmès. Per tal de corregir-la, iniciï l'utilitat Reconfigurator.",
    '__databases' => "Bases de dades",
    '__databases_list' => "Bases de dades",
    '__database_type_not_supported_by_key' => 'Per tal d\'utilitzar el servidor %1 és necessari que la seva clau de llicència el suporti. Posi\'s en contacte amb el seu responsable comercial de Plesk.',
    '__date_immediately' => "avui",
    '__date_never' => "mai",
    '__day(s)' => "Dia/dies",
    '__day0' => "Diu",
    '__day1' => "Dil",
    '__day2' => "Dimar",
    '__day3' => "Dime",
    '__day4' => "Dijo",
    '__day5' => "Div",
    '__day6' => "Dis",
    '__days' => "%1 dia/dies",
    '__db_admin_login_empty' => "No s'ha especificat cap nom d'usuari, el que desactiva el control sobre %1 a la interfície. Desitja continuar?",
    '__db_unable_to_unregister' => 'No ha estat possible eliminar els paràmetres de la connexió a la base de dades',
    '__db_db_exists' => 'Almenys hi ha una base de dades al servidor',
    '__db_unable_to_change_server_name' => 'El nom del servidor no es pot canviar',
    '__db_unable_to_change_port' => 'El port del servidor no es pot modificar',
    '__db_already_exist' => "La base de dades %1 ja existeix.",
    '__db_credentials_invalid' => "Les credencials de la base de dades no són vàlides.",
    '__db_invalid_password_characters' => 'La contrasenya conté caràcters que no són vàlids',
    '__db_engine' => "Motor de base de dades", // indirect
    '__db_type' => "Tipus de base de dades",
    '__db_user' => "Usuari de base de dades",
    '__db_server' => 'Servidor de base de dades',
    '__def_domain' => "Domini predeterminat",
    '__default_for_mysql' => 'predeterminat per MySQL',
    '__default_for_mariadb' => 'predeterminat per MariaDB',
    '__default_for_percona' => 'predeterminat per Percona',
    '__default_for_postgresql' => 'predeterminat per PostgreSQL',
    '__delete' => "Eliminar",
    '__demo' => "Aquesta funció no està disponible a la versió de prova.",
    '__directory' => "Directori",
    '__disable_lock_screen' => 'Impedir als usuaris utilitzar Plesk fins que les pantalles de la interfície no s\'hagin carregat completament',
    '__dismiss_news?' => "Està segur que desitja tancar completament el bloc de notícies?\n\nNo tornarà a veure'l fins que no hi hagi notícies noves.",
    '__description' => "Descripció",
    '__disabled' => "desactivat",
    '__disk_space_limit' => "Límit d'espai al disc",
    '__cgroups_cpu_usage_limit' => 'Límit d\'ús de CPU',
    '__cgroups_ram_usage_limit' => 'Límit d\'ús de RAM',
    '__cgroups_disk_read_usage_limit' => 'Límit d\'amplada de banda de lectura del disc',
    '__cgroups_disk_write_usage_limit' => 'Límit d\'amplada de banda d\'escriptura del disc',
    '__disk_usage_by' => "Espai al disc utilitzat per %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "El registre DNS '%1' ja existeix.",
    '__dns_master_should_be_remote' => "És necessari tenir dos servidors de noms autoritatius diferents en hosts diferents.",
    '__dns_record_not_exist' => "El registre DNS no existeix.",
    '__dns_server' => "Servidor DNS", // indirect
    '__dom_id_is_undefined' => "No s'ha definit l'ID del domini.",
    '__dom_name' => "Nom de domini",
    '__dom_name_is_invalid' => "El nom del domini no és vàlid. Comprovi que aquest només conté símbols alfanumèrics, punts i guionets i que no està format per més de 255 símbols. Cada una de les parts del nom de domini entre punts no pot tenir més de 63 símbols.",
    '__dom_not_exist' => "El domini no existeix.",
    '__domain' => "Domini",
    '__domain_' => 'Domini %1',
    '__domain_form' => "Formulari de domini",
    '__domain_id' => "ID de domini",
    '__domain_is_turned_off_for_backup' => "El lloc web %1 està desactivat temporalment perquè s'està copiant o restaurant i actualment no està disponible.",
    '__domain_limits' => "Límits del domini",
    '__domain_name' => "Nom de domini",
    '__mail_name_in_ASCII_form' => "Nom del compte de correu en format ASCII",
    '__message_error' => 'Error',
    '__message_warning' => 'Advertiment',
    '__message_info' => 'Informació',
    '__domain_name_in_ASCII_form' => "Nom del domini en format ASCII",
    '__domain_repository' => "Repositori del domini %1",
    '__domain_status' => "Estat del domini",
    '__domain_found_tech' => "Tecnologia trobada al domini",
    '__domain_dns' => 'Zona DNS del domini',
    '__domain_total_powerUser' => "Quantitat total per la subscripció",
    '__domain_user' => "Administrador del domini",
    '__domains_global_changes' => "Modificar dominis seleccionats",
    '__mailnames_global_changes' => "Modificar comptes de correu seleccionats",
    '__backup_manager' => 'Administrador de backups',
    '__domains_list' => "Dominis",
    'domains_list__list_header' => "dominis",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "El nom de domini comença amb www, si bé s'utilitza el prefix WWW.\nDesitja continuar de totes maneres?",
    '__dovecot' => 'Servidor Dovecot IMAP i POP3',
    '__dsmail' => "Servei de correu",
    '__dsmaillist' => "Servei de llista de correu",
    '__dumps_tot_size' => "Tamany total dels arxius de backup a l'emmagatzematge local",
    '__email' => "Email",
    '__email_addr_is_invalid' => "L'adreça de correu no és vàlida.",
    '__enabled' => "Activada",
    '__enter_cert_text' => "Introdueixi el text del certificat",
    '__enter_size' => "Indiqui el tamany",
    '__exclusive' => "Dedicada",
    '__expiration_date' => "Data de caducitat",
    '__fax' => "Fax",
    '__file' => "Arxiu",
    '__file_is_empty' => "L'arxiu està buit.",
    '__file_name' => "Nom de l'arxiu",
    '__file_type' => 'Tipus d\'arxiu',
    '__filemanager' => "Administrador d'arxius",
    '__filepath_is_empty' => "La ruta a l'arxiu està buida",
    '__files_list' => "Arxius",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Configuració FTP",
    '__ftp_serv' => "Servidor FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Configuri primer les propietats del compte FTP",
    '__ftp_status' => "Estat del servidor FTP",
    '__full_day0' => "Diumenge",
    '__full_day1' => "Dilluns",
    '__full_day2' => "Dimarts",
    '__full_day3' => "Dimecres",
    '__full_day4' => "Dijous",
    '__full_day5' => "Divendres",
    '__full_day6' => "Dissabte",
    '__full_month1' => "Gener",
    '__full_month10' => "Octubre",
    '__full_month11' => "Novembre",
    '__full_month12' => "Desembre",
    '__full_month2' => "Febrer",
    '__full_month3' => "Març",
    '__full_month4' => "Abril",
    '__full_month5' => "Maig",
    '__full_month6' => "Juny",
    '__full_month7' => "Juliol",
    '__full_month8' => "Agost",
    '__full_month9' => "Setembre",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Quota de disc dur",
    '__hard_disk_quota_not_supported' => 'no es suporta la quota de disc dur degut a la configuració del sistema d\'arxius del servidor',
    '__help_topic_not_found' => 'El tema d\'ajuda sol·licitat (%1) no existeix.',
    '__hosting_ip_dns_ip_not_equiv' => "Cap de les adreces IP especificades als registres A del DNS coincideix amb l'adreça IP utilitzada pel hosting.",
    '__hosting_scripting' => "Suport per hosting d'scripting",
    '__hosting_setup_page_title' => "Configuració de hosting web pel domini %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Tipus de hosting",
    '__hostname_is_empty' => "El nom de host està buit.",
    '__hour(s)' => 'Hora/hores',
    '__hst_type_incorrect' => "El tipus de hosting no és correcte.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Temps d'inactivitat",
    '__iface' => "Interfície",
    '__image' => "Imatge",
    '__imap_status' => "Estat del servidor IMAP",
    '__incorrect_databases_login_pass' => "Les credencials especificades per accedir a PostgreSQL no són correctes.",
    '__incorrect_ip_or_network_address' => 'L\'adreça IP o la xarxa no és correcte.',
    '__info' => 'Informació',
    '__install' => "Instal·lar",
    '__install_prefix' => "Instal·lar prefix",
    '__invalid_cert_id' => "ID del certificat no vàlid",
    '__invalid_context' => "El context no és vàlid: %1",
    '__invalid_db_usr_name' => "El nom d'usuari de la base de dades no és vàlid.",
    '__invalid_dir_name' => "El nom del directori no és vàlid",
    '__invalid_dom_name' => "El nom del domini no és vàlid.",
    '__invalid_filename' => "El nom de l'arxiu no és vàlid. No utilitzi cometes ni la combinació \"../\".",
    '__invalid_id' => "L'identificador no és vàlid.",
    '__invalid_lines_num' => "El valor pel número de línies no és apropiat. Només es permet l'ús de dígits.",
    '__invalid_max_letter_size' => "El tamany màxim del correu no és vàlid.",
    '__invalid_restart_apache_interval' => "L'interval de reinici d'Apache no és vàlid.",
    '__invalid_tmpl_name' => "El nom de la plantilla no és vàlid.",
    '__invalid_value' => "Valor incorrecte.",
    '__ip_addr' => "Adreça IP",
    '__ip_address_and_mask' => "Adreça IP i màscara de subxarxa",
    '__ip_alias__mask' => "Adreça IP i màscara de subxarxa",
    '__ip_addr_is_invalid' => "L'adreça IP no és vàlida.",
    '__ip_addr_list' => "Adreces IP",
    '__ip_address_and_mask_hint' => 'Per exemple, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "La seva clau de llicència només es pot utilitzar a Virtuozzo containers.",
    '__key_limits_exceeding' => "Aquesta acció excedeix els límits definits per la seva llicència del software. Si ha rebut aquest missatge, pot posar-se en contacte amb el seu proveïdor per tal que li proporcioni més informació o ampliï els límits d'aquesta llicència.",
    '__kilo' => "K",
    '__keywords' => 'Paraules clau',
    '__lang_unknown' => 'No ha estat possible reconèixer l\'idioma.',
    '__languages' => 'Idioma',
    '__learn_more' => 'Més informació',
    '__loading' => 'Carregant...',
    '__locales' => "Paquets d'idioma",
    '__lists' => "Llistes de correu",
    '__literal_bytes' => "B",
    '__processing' => "Esperi.<br>Carregant...",
    '__locale' => "Idioma de la interfície",
    '__locale_is_not_defined' => "No s'ha definit l'idioma de la interfície.",
    '__local_server_mysql' => 'Servidor de MariaDB/MySQL local',
    '__local_server_postgresql' => 'Servidor PostgreSQL local',
    '__local_server_mssql' => 'Servidor MS SQL local',
    '__log_and_statistics_files' => 'Arxius de registre i informes estadístics',
    '__config_files' => 'Arxius de configuració',
    '__chroot_files' => 'Entorn chrooted',
    '__login' => "Nom d'usuari %1",
    '__login1' => "Nom d'usuari",
    '__login_disabled' => "Nom d'usuari no permès",
    '__login_enabled' => "Nom d'usuari permès",
    '__login_incorrect' => "El nom d'usuari o la contrasenya no són correctes. Torni-ho a provar.",
    '__login_rate_limit_reached' => "Massa intents d'inici de sessió. Torni-ho a provar més tard.",
    '__login_name' => "Nom d'usuari %1",
    '__login_name_is_invalid' => "El nom d'usuari %1 no és vàlid.",
    '__logon_time' => "Hora d'inici de sessió",
    '__ma' => "Àlies de correu",
    '__mail' => "Correu",
    '__mail_alias_name' => "Nom de l'àlies de correu",
    '__mail_autodiscovery' => 'Detecció automàtica de correu',
    '__mail_exchanger_name_is_invalid' => "El nom de l'intercanviador de correu no és vàlid.",
    '__mail_groups' => "Grups de correu",
    '__mail_list_engine' => "Software de llista de correu",
    '__mail_name' => "Compte de correu",
    '__mail_name_form' => "Propietats del compte de correu",
    '__mail_names' => "Comptes de correu",
    '__mail_serv' => "Servidor de correu",
    '__mail_user' => 'Usuari de correu',
    '__mailgroup' => "Grup de correu",
    '__maillist' => "Llista de correu",
    '__maillists' => "Llistes de correu",
    '__maillist_member' => 'Membre de la llista de correu',
    '__mailname' => "Compte de correu",
    '__mailname_redir_self' => "El compte de correu no pot reenviar els correus a sí mateix.",
    '__max_dom_num_reached_for_cl' => "S'ha assolit el número màxim de dominis per aquest compte de client.",
    '__max_file_size_available' => "Tamany d'arxiu màxim permès %1",
    '__max_subdom_num_reached_for_cl' => "S'ha assolit el número màxim de subdominis per aquest compte de client.",
    '__max_subdom_num_reached_for_dom' => "S'ha assolit el número màxim de subdominis pel domini.",
    '__max_subdom_num_reached_for_key' => "S'ha assolit el número màxim de subdominis permès per la clau de llicència.",
    '__max_traffic_limit' => "Límit de trànsit",
    '__maximum_excl_ip_num' => "Comptes de correu",
    '__mb' => "MB",
    '__mbytes' => "megabytes",
    '__mb_month' => "MB/mes",
    '__mb_sec' => "MB/seg",
    '__gb_sec' => "GB/seg",
    '__tb_sec' => "TB/seg",
    '__mega' => "M",
    '__minute(s)' => 'Minut(s)',
    '__mls_not_in_key' => "La seva clau del producte no suporta interfícies multilingües.",
    '__modification_date' => "Data de modificació",
    '__module' => "Extensió",
    '__month' => "Mes",
    '__month(s)' => "Mes(os)",
    '__month1' => "Gen",
    '__month10' => "Oct",
    '__month11' => "Nov",
    '__month12' => "Des",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "Abril",
    '__month5' => "Maig",
    '__month6' => "Juny",
    '__month7' => "Juliol",
    '__month8' => "Ago",
    '__month9' => "Set",
    '__monthly' => "Cada mes",
    '__months' => "Mesos",
    '__moved_permanently' => 'Mogut permanentment',
    '__mssql' => "Servidor Microsoft SQL",
    '__mssql__server' => "Servidor",
    'mssql__server' => "Nom del servidor Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "el nom del servidor no es pot canviar. Aquest allotja almenys una base de dades.",
    '__mssql_status' => "Estat del servidor Microsoft SQL",
    '__multiply_login_deny' => "No ha estat possible completar el seu inici de sessió. Ja hi ha un altre usuari amb el mateix nom d'usuari (%1) connectat a Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Estat del servidor MySQL",
    '__mysql_version' => "Versió de MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Estat del servidor MariaDB",
    '__mariadb_version' => "Versió de MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Estat del servidor Percona",
    '__percona_version' => "Versió de Percona",
    '__name' => "Nom",
    '__name_invalid' => "El nom no és vàlid.",
    '__nameserver' => "servidor de noms",
    '__network' => "Xarxa",
    '__networks' => "Xarxes",
    '__no' => "No",
    '__no_ip_address_with_properly_type_available' => "No ha estat possible restaurar les dades copiades perquè no hi ha cap adreça IP requerida per a la restauració.",
    '__no_clients_specified' => "No s'ha especificat cap compte de client.",
    '__no_comments' => "Sense comentaris.",
    '__nologin' => "Prohibit",
    '__none' => "Cap",
    '__not_configured' => "No configurat",
    '__not_implemented_yet' => "No implementat encara",
    '__not_supported_by_ftp' => "(no suportat pel servidor FTP)",
    '__notification' => "Notificació",
    '__num_displayed' => "Es mostren %1 de %2",
    '__num_is_invalid' => "El número no és vàlid.",
    '__object_not_found' => 'No s\'ha trobat l\'objecte: %1',
    '__off' => "Desactivat",
    '__ok' => "ACCEPTAR",
    '__old_passwd' => "Contrasenya %1 anterior",
    '__on' => "Activat",
    '__others' => "Altres",
    '__other_ip__will_be_added' => 'Altres adreces IP disponibles (s\'afegiran al grup d\'adreces IP del client)',
    '__p' => "P",
    '__passwd' => "%1 Contrasenya",
    '__passwd_is_invalid' => "Contrasenya %1 no vàlida.",
    '__path' => "Ruta",
    '__perl_unix_support' => "Suport per Perl",
    '__perl_win_support' => "Suport per Perl",
    '__perm_denied' => "Permís denegat.",
    '__permissions' => "Permisos",
    '__personal_name' => "Nom",
    '__pg_admin_not_activated' => "PostgreSQL no ha estat desactivat a la pàgina d'administració del servidor.",
    '__pg_not_inst' => "PostgreSQL no ha estat instal·lat.",
    '__pg_not_run_or_inst' => "PostgreSQL no s'ha instal·lat o no està en execució.",
    '__pg_not_support_in_key' => "La clau de llicència no suporta PostgreSQL.",
    '__phone' => "Telèfon",
    '__phosting' => "Hosting físic",
    '__php_support' => "Suport de PHP",
    '__php_run_as_isapi' => "executar com a extensió ISAPI",
    '__php_safe_mode' => "'safe_mode' de PHP activat",
    '__php_version' => "Versió de PHP",
    '__physical' => "Hosting físic",
    '__plesk_stat_pdir' => "Protegir el directori '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Estadístiques de domini",
    '__plesk_stat_protect' => "Protegeixi l'accés a les estadístiques web amb el nom d'usuari i la contrasenya FTP de l'usuari",
    '__plesk_stat_protect_install' => "accessible mitjançant el directori protegit amb contrasenya '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Estat del servidor POP3",
    '__popen_error' => "S'ha produït un error mentre es trucava a la funció popen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Estat de PostgreSQL",
    '__preferences' => "Configuració",
    '__account_preferences' => "Configuració del compte",
    '__interface_preferences_general' => 'General',
    '__interface_preferences_default' => 'Preferències predeterminades de la interfície',
    '__interface_preferences_admin' => "Preferències de la interfície de l'administrador",
    '__interface_template' => 'Plantilla de personalització de la interfície',
    '__interface_preferences' => "Preferències de la interfície",
    '__proceed?' => "Desitja continuar?",
    '__provider_contact_name' => "Nom de contacte del propietari",
    '__python_unix_support' => "Suport per Python",
    '__python_win_support' => "Suport per Python",
    '__quota' => "Quota",
    '__r' => "R",
    '__reconfigure' => "Reconfigurar",
    '__record_type' => "Tipus de registre",
    '__release' => "Build",
    '__remote_db_not_supported_by_key' => 'La seva clau de llicència no suporta el hosting de bases de dades remotes.',
    '__remove_protection' => 'Eliminar protecció',
    '__report' => "Informe",
    '__report_size_na' => "El servei no està disponible",
    '__reports_list' => "Informes",
    '__requested' => "Sol·licitat",
    '__required_fields' => "Camps obligatoris",
    '__resp_name_invalid' => "El nom de la resposta automàtica no és vàlid. Utilitzi únicament símbols alfanumèrics, punts, ratlles baixes i espais.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "El nom del servidor no és vàlid.",
    '__screenshots' => 'Captures de pantalla',
    '__script_warning' => "Com a resultat de l'eliminació de la capacitat d'scripting d'aquest domini, tots els scripts influenciats es mostraran als navegadors com a text sense format. És recomanable que l'administrador elimini tots els scripts dependents del domini en qüestió.",
    '__sec' => "Segons",
    '__second(s)' => "Segon(s)",
    '__see_list_of_logged_in' => "Consulti el llistat d'usuaris connectats en aquest moment.",
    '__select_certs_to_remove' => "Seleccioni els certificats que desitja eliminar.",
    '__select_files_to_remove' => "Seleccioni els arxius que desitja eliminar.",
    '__select_ip' => "Assignar adreça IP",
    '__select_ip_to_remove' => "Seleccioni l'adreça IP que desitja eliminar.",
    '__select_domain_template' => "Utilitzar configuració de plantilla del domini",
    '__select_templates_to_remove' => "Seleccioni les plantilles que desitja eliminar.",
    '__server' => "Servidor",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Servidor de base de dades MariaDB/MySQL",
    '__service_description__mysql' => "Servidor de base de dades MariaDB/MySQL",
    '__service_title__web' => "Servidor web",
    '__service_description__web' => "Servidor web",
    '__service_title__smtp' => "Servidor SMTP",
    '__service_description__smtp' => "Servidor SMTP",
    '__service_title__mail' => "Servidor IMAP/POP3",
    '__service_description__mail' => "Servidor IMAP/POP3",
    '__service_title__dns' => "Servidor DNS",
    '__service_description__dns' => "Servidor DNS",
    '__service_title__postgresq' => "Servidor de base de dades PostgreSQL",
    '__service_description__postgresq' => "Servidor de base de dades PostgreSQL",
    '__service_title__spamassassin' => "Servei de filtració d'spam SpamAssassin",
    '__service_description__spamassassin' => "Servei de filtració d'spam SpamAssassin",
    '__all_services' => "Tots els serveis",
    '__sessions' => "Sessions",
    'sessions__feature_ftp_session_manager_not_supported' => "El servidor FTP actual no suporta la funció Sessions FTP",
    '__sessions_list' => "Sessions",
    '__set' => "Activar",
    '__shared' => "Compartida",
    '__shell_access_warning' => "Permetre l'accés shell al sistema és summament perillós per la seguretat del sistema. Només el permeti si entén completament el que està fent i només concedeixi'l a usuaris de confiança. Realment desitja permetre l'accés?",
    '__siteapp_not_support_in_key' => "La clau de llicència no suporta aplicacions web.",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'La configuració d\'aquesta aplicació web s\'ha modificat manualment. Per tal de protegir les modificacions manuals, ja no es permet la reconfiguració a través de Plesk.',
    '__site_management' => "Publicació web", // indirect
    '__size' => "Tamany",
    '__skins' => 'Skins',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Estat del servidor SMTP",
    '__some_fields_are_empty_or_invalid' => "Alguns camps estan buits o contenen valors que no són correctes.",
    '__no_email_addresses_selected' => 'No s\'ha seleccionat cap adreça de correu.',
    '__unable_to_set_parameters' => "No s'han pogut establir els paràmetres del component.",
    '__spamassassin' => "Filtre antispam",
    '__spamassassin_status' => "Estat d'SpamAssassin",
    '__spamd_status' => 'Estat del filtre antispam',
    '__splited_backup' => "(backup multi volum)",
    '__split_backup_file' => "Crear un backup multi volum",
    '__split_backup_size' => "Tamany del volum",
    '__split_backup_less_than_500' => "No es suporten volums de menys de 500 megabytes",
    '__ssi' => "SSI",
    '__ssi_support' => "Suport per SSI",
    '__ssi_with_html' => "Utilitzar SSI per arxius *.htm i *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Suport d'SSL/TLS",
    '__same_ssl' => "Utilitzar un únic directori per allotjat contingut SSL/TLS i no SSL/TLS",
    '__same_ssl_cu' => "Contingut SSL/TLS i no SSL/TLS comú",
    '__state' => "Província o estat",

    '__status__Active' => 'Actiu',
    '__status__active' => 'Actiu',
    '__status__Passive' => 'Desactivat',
    '__status__passive' => 'desactivat',
    '__status__off' => 'desactivat',
    '__status__with_parent' => 'desactivat',
    '__status__backup_restore' => 'suspès temporalment perquè s\'està efectuant un backup o una restauració',
    '__status__admin' => 'suspès per l\'administrador del servidor',
    '__status__resseler' => 'suspès pel revenedor',
    '__status__client' => 'suspès pel client',
    '__status__unknown' => 'estat desconegut',

    '__status_of' => "Estat de %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Servidor Stunnel", // indirect
    '__subdomain' => "Subdomini",
    '__subdomain_name' => "Nom del subdomini",
    '__subdomain_name_in_ASCII_form' => "Nom del subdomini en format ASCII",
    '__subdomains' => "Subdominis",
    '__domainaliases' => "Àlies de domini",
    '__subdomains_list' => "Subdominis",
    '__subdomains_not_support_in_key' => "La clau de llicència no suporta operacions de subdomini",
    '__sys_user_type' => "Usuari FTP",
    '__sys_user_type_main' => "Utilitzar el compte d'usuari FTP del domini principal",
    '__sys_user_type_native' => "Crear un altre compte d'usuari FTP per aquest subdomini",
    '__target_domain' => "Domini de destí",
    '__template' => "Plantilla",
    '__template_not_accepted' => "No ha estat possible acceptar la plantilla. S'han excedit les següents limitacions.",
    '__templates' => "Plantilles",
    '__templates_list' => "Plantilles",
    '__tera' => "T",
    '__title' => "Títol",
    '__total' => "Total %1",
    '__total_size' => "Tamany total",
    '__total_used' => "Total utilitzat",
    '__traffic' => "Trànsit",
    '__traffic_by_client' => "Trànsit per client",
    '__traffic_by_domain' => "Trànsit per domini",
    '__traffic_by_service' => "Trànsit per servei",
    '__traffic_history' => "Historial de trànsit",
    '__unable_change_locale' => "No ha estat possible canviar l'idioma de la interfície: %1",
    '__unable_create_new_dom' => "No ha estat possible crear un domini: %1",
    '__unable_define_dom_name' => "No ha estat possible definir el nom del domini: %1",
    '__unable_define_necessary_properties' => "No ha estat possible definir totes les propietats obligatòries.",
    '__unable_define_properties' => "No ha estat possible definir les propietats: %1",
    '__unable_exec_util' => "No ha estat possible executar l'utilitat: %1",
    '__unable_get_dns_a_recs' => "No ha estat possible recuperar les adreces IP pels registres A del DNS per aquest compte de hosting: %1",
    '__unable_get_mbox_quota' => "No ha estat possible recuperar la informació sobre el tamany màxim de la bústia de correu.",
    '__unable_redirect_to_myself' => "No ha estat possible redireccionar al mateix compte.",
    '__unable_redirect_to_my_alias' => "No ha estat possible reenviar el correu a un àlies de correu.",
    '__default_domain_redirect_to_myself' => "No ha estat possible establir el domini com a predeterminat per l'adreça IP.\n S'ha detectat un redireccionament a sí mateix.",
    '__unable_remove_client' => "No ha estat possible eliminar el client: %1",
    '__unable_set_up_mbox_quota' => "No ha estat possible establir el tamany màxim de la bústia de correu pel domini: %1",
    '__unable_setup_pass' => "No ha estat possible establir la contrasenya: %1",
    '__unable_to_create_new_account' => "No ha estat possible crear un compte: %1",
    '__unable_to_define_db_size' => "No ha estat possible definir el tamany de la base de dades.",
    '__unable_to_enable_short_names' => "No ha estat possible permetre l'ús de noms curts de comptes de correu per comptes POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "No ha estat possible obtenir les dades enviades: %1",
    '__unable_to_open_file' => "No ha estat possible obrir l'arxiu %1: %2",
    '__unable_to_update_subdomain' => "No ha estat possible realitzar els canvis al subdomini: %1",
    '__unable_update_cl_data' => "No ha estat possible desar els canvis al compte d'usuari: %1",
    '__unable_update_db_params' => "No ha estat possible actualitzar els paràmetres de la base de dades: %1",
    '__unable_update_dom_data' => "No ha estat possible actualitzar les dades del domini: %1",
    '__undefined' => "no definit",
    '__uninstall' => "Desinstal·lar",
    '__unknown_error' => "Error desconegut",
    '__unlimited_lower' => "Il·limitats",
    '__unset' => "Desactivar",
    '__update' => "Actualitzar",
    '__uploaded_file_is_invalid' => "L'arxiu carregat no és vàlid: %1",
    '__url' => "URL",
    '__usage' => "Ús del disc",
    '__user_already_logged' => "Ja hi ha un altre usuari amb el mateix nom d'usuari (%1) connectat a Plesk.",
    '__version' => "Versió",
    '__aps_license' => "Clau de llicència",
    '__vh_type' => "Tipus de host virtual",
    '__vhosts_apache_status' => "Estat del servidor web",
    '__wrong_charset_conversion' => 'El joc de caràcters no és correcte. No es permet la conversió de "%1" a "%2".',
    '__warning_' => "Important!",
    '__warning_excl_ip_num' => "Adreça IP dedicada",
    '__warning_expiration' => "Data de caducitat",
    '__web_scripting' => "Scripting web", // indirect
    '__web_serv' => "Servidor web", // indirect
    '__web_statistic' => "Estadístiques web", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer no s'ha instal·lat al servidor. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda amb la instal·lació de Webalizer.",
    '__webstat_support' => "Estadístiques web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Quan canvia de programa d'estadístiques, tots els informes creats pel programa anterior són eliminats i es creen nous informes d'acord amb la informació present als arxius de registre del servidor. Això significa que si va configurar el sistema (a Dominis> nom del domini> Administrador de registres> Rotació de registres) del tal manera que només es conserven els arxius de registre del darrer mes, només disposarà de les estadístiques web del darrer mes. Desitja canviar a un altre paquet estadístic?",
    '__webstat_perm_denied' => 'No disposa del permís necessari per a gestionar estadístiques web.',
    '__webuser' => "Usuari web",
    '__sysusers_list' => "Usuaris del sistema",
    '__sysuser' => "Usuari del sistema",
    '__weekly' => "Cada setmana",
    '__whats_new_in_version' => "Novetats a Plesk %1",
    '__wrong_hosting_type__virtual_required' => "Aquesta operació només està disponible en el cas de dominis amb hosting web.",
    '__wrong_hosting_type__none' => 'Al domini %1 no s\'ha configurat hosting web.',
    '__wrong_hosting_type__std_fwd' => 'El domini %1 té configurat redireccionament estàndard. Aquesta operació només està disponible en el cas de dominis amb hosting web.',
    '__wrong_hosting_type__frm_fwd' => 'El domini %1 té configurat redireccionament per marcs. Aquesta operació només està disponible en el cas de dominis amb hosting web.',
    '__wu' => "Usuaris web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "El prefix WWW s'ha canviat. Comprovi que ha modificat el certificat SSL/TLS.",
    '__year' => "Any",
    '__year(s)' => "Any(s)",
    '__yes' => "Sí",
    '__you' => "Vostè",
    '__zip_code' => "Codi postal",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avançat",

    'admin_ed__edit_administrator_info' => "Edició del perfil de l'administrador",
    'admin_ed__create_default_client' => "Desitjo crear un compte de client predeterminat.",
    'admin_ed__unable_update' => "No ha estat possible actualitzar la informació de l'administrador: %1",

    'auth__update_admin_info' => "Introdueixi la informació de l'administrador. Aquesta informació és imprescindible per a utilitzar %1.",
    'auth__you_not_have_perm' => "No disposa dels permisos necessaris per gestionar aquest domini.",
    'auth__key_expired_admin' => 'La seva llicència de Plesk ha caducat. Si desitja continuar utilitzant Plesk, renovi la llicència o compri\'n una de nova.',
    'auth__key_expired_admin_restricted' => 'La seva llicència de Plesk ha caducat. Posi\'s en contacte amb el seu proveïdor de serveis per continuar utilitzant Plesk.',
    'auth__key_expired_client' => 'La llicència de Plesk ha caducat. Posi\'s en contacte amb el seu proveïdor de hosting.',
    'autoinstaller__not_installed' => 'El component Autoinstaller no està instal·lat.',
    'autoinstaller__release_action' => 'Operacions disponibles',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Actualitzant a la nova versió de Plesk',
    'autoinstaller__release_action_update' => 'Actualitzant o afegint components nous',
    'autoinstaller__release_action_up2date' => 'La seva versió està degudament actualitzada',
    'autoinstaller__component_action' => 'Estat',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'No instal·lat',
    'autoinstaller__component_action_update' => 'Hi ha actualitzacions disponibles',
    'autoinstaller__component_action_upgrade' => 'Hi ha una actualització disponible',
    'autoinstaller__component_action_up2date' => 'La seva versió està degudament actualitzada',
    'autoinstaller__component_action_error' => 'No hi ha cap actualització disponible',
    'autoinstaller__component_serverbuildtime' => 'Build més recent',
    'autoinstaller__component_localbuildtime' => 'La seva build',
    'autoinstaller__component_installed_version' => 'La seva versió',
    'autoinstaller__component_available_version' => 'Versió més recent',
    'autoinstaller__component' => 'Component',
    'autoinstaller__components' => 'Components',
    'autoinstaller__components_title' => '%1 components',
    'autoinstaller__component_dependency_note' => 'requerida per a la instal·lació dels components seleccionats',
    'autoinstaller__install_confirm' => 'Sí, desitjo instal·lar aquests components',
    'autoinstaller__install_confirm_request' => 'Seleccioni la casella per a confirmar',
    'autoinstaller__install_title' => 'Confirmació de la instal·lació dels components seleccionats',
    'autoinstaller__key_update_confirm' => 'Confirmi l\'omissió de l\'actualització de la clau i la instal·lació de la clau predeterminada',
    'autoinstaller__key_update_confirm_request' => 'Seleccioni la casella per a confirmar.',
    'autoinstaller__key_update_failed' => '<p>Plesk no pot actualitzar la llicència del seu producte.</p><p>%1</p><p>Si continua amb l\'actualització sense disposar d\'una llicència apropiada del producte, s\'instal·larà una llicència predeterminada amb funcionalitat limitada. S\'aconsella als administradors que adquireixin la clau de llicència apropiada abans de continuar amb l\'actualització del producte.</p>',
    'autoinstaller__email' => 'Enviar notificació a',
    'autoinstaller__email_admin' => "Correu de l'administrador",
    'autoinstaller__email_email' => 'Un altre correu...',
    'autoinstaller__release' => 'Nom de la build',
    'autoinstaller__releases' => 'Releases disponibles',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Seleccioni els components que desitja instal·lar',
    'autoinstaller__status_error' => 'Error: %1',
    'autoinstaller__status_install_error' => 'No s\'ha pogut iniciar la instal·lació. %1',
    'autoinstaller__status_install_busy' => 'No s\'ha pogut iniciar la instal·lació. En aquest moment hi ha una altra instal·lació en curs.',
    'autoinstaller__status_install_ok' => 'Instal·lació iniciada. L\'informarem del progrés d\'instal·lació per correu electrònic (%1).',
    'autoinstaller__status_query_busy' => 'Instal·lació en curs.',
    'autoinstaller__status_query_error' => 'No ha estat possible recuperar l\'estat de la instal·lació: %1',
    'autoinstaller__status_unknown' => 'No ha estat possible recuperar l\'estat de l\'autoinstaller.',
    'autoinstaller__status_busy' => 'L\'autoinstaller està ocupat. Agraïm esperi.',
    'autoinstaller__configure_title' => 'Configuració de l\'actualitzador',
    'autoinstaller__preferences_legend' => 'Configuració',
    'autoinstaller__target' => 'Directori de descàrrega temporal',
    'autoinstaller__target_invalid' => "Especifiqui una ruta absoluta",
    'autoinstaller__check_updates' => 'Comprovar l\'existència d\'actualitzacions quan l\'administrador iniciï sessió a Plesk',
    'autoinstaller__check_updates_warning' => 'Hi ha noves <a href="%1">actualitzacions</a> per %2 ',
    'autoinstaller__source_type' => 'Tipus d\'origen',
    'autoinstaller__source' => 'URL d\'origen',
    'autoinstaller_source__preferences_legend' => 'Configuració',
    'autoinstaller_source__type' => 'Tipus d\'origen',
    'autoinstaller_source__url_invalid' => 'L\'origen no és vàlid',
    'autoinstaller_source__url_invalid_network' => 'L\'URL d\'origen no és vàlida (Exemple: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL d\'origen',
    'autoinstaller__source_invalid_network' => 'L\'adreça de xarxa indicada no és vàlida',
    'backup__repository' => 'Ubicació de l\'emmagatzematge d\'arxius de backup',
    'backup__error_notify_email' => 'Si s\'experimenta algun error durant la creació del backup, enviar una notificació a',
    'backup__dump_info' => "Informació del backup",
    'backup__dump_file_name_not_defined' => "No s'ha especificat el nom de l'arxiu de backup",
    'backup__local_file' => 'Arxiu de backup local',
    'backup__domain_ftp' => 'servidor FTP remot',
    'backup__wrong_path' => "La ruta a l'emmagatzematge d'arxius de backup no és correcta. No utilitzi la seqüència de caràcters ../../",
    'backup__unable_to_connect_to_ftp_server' => "No ha estat possible connectar-se al servidor FTP: %1",
    'backup__unable_to_read_file' => 'No ha estat possible llegir l\'arxiu de backup.',
    'backup__backup_task_does_not_exist' => "La tasca de backup no existeix. Crei-la abans de poder-la activar.",
    'backup__restore_params' => "Paràmetres de restauració",
    'backup__confirmation' => "Important! El domini no estarà disponible mentre s'efectuï el backup o la restauració.",
    'backup__backup_method' => 'Mètode de backup',
    'backup__dumpfile_name' => "Nom de l'arxiu de backup",
    'backup__dumpfile_name_is_invalid' => "El nom de l'arxiu de backup no és vàlid. Utilitzi únicament símbols alfanumèrics, guions, punts i ratlles baixes. No es permet l'ús de noms com description.* com a nom d'arxiu de backup.",
    'backup__email_required' => "Necessitem la seva adreça de correu electrònic per tal de mantenir-lo informat sobre els progressos de backup i restauració. Indiqui-la als detalls del compte.",
    'backup__error_during_backup' => "No ha estat possible crear l'arxiu de backup: %1",
    'backup__input_email_warning' => "Indiqui el correu on cal enviar la notificació o bé deseleccioni la casella.",
    'backup__make_download' => "no desar l'arxiu de backup a l'emmagatzematge, només descarregar-lo",
    'backup__make_dump' => 'crear arxiu de backup i desar-lo a l\'emmagatzematge local',
    'backup__makedump_to_ftp' => 'crear arxiu de backup i desar-lo al servidor FTP remot',
    'backup__restore_ip' => "Adreça IP per a la restauració",
    'backup__select_dumpfile' => "Seleccioni un arxiu de backup.",
    'backup__time' => "Hora del backup",
    'backup__day' => 'Dia de creació del backup',
    'backup__view_dump_info' => "Veure la informació del backup pel domini %1",
    'backup__wrong_domain_name' => "L'arxiu de backup conté les dades del domini %1, motiu pel qual no es pot restaurar al domini %2",
    'backup__incorrect_ftp_user_or_passwd' => "L'usuari o la contrasenya FTP no són correctes. Corregeixi les propietats del compte FTP.",
    'backup__access_denied' => "Accés denegat. Corregeixi les propietats del compte FTP.",
    'backup__restore_from' => "Restaurar %1",
    'backup__domain_session_failed' => 'El domini %1 no ha estat copiat.',
    'backup__client_session_failed' => 'El client %1 no ha estat copiat',
    'backup__domain_session_restore_failed' => 'El domini %1 no ha estat restaurat.',
    'backup__client_session_restore_failed' => 'El compte de client %1 no ha estat restaurat',
    'backup__domain_session_complete' => 'El domini %1 ha estat copiat.',
    'backup__domain_session_backup' => 'Backup del domini %1',
    'backup__client_session_backup' => 'Backup del client %1',
    'backup__domain_stop_title' => 'Cancel·lació del backup del domini %1',
    'backup__client_stop_title' => 'Cancel·lació del backup del compte de client %1',
    'backup__domain_restore_stop_title' => 'Cancel·lació de la restauració del domini %1',
    'backup__client_restore_stop_title' => 'Cancel·lació de la restauració del compte de client %1',
    'backup__domain_session_backup_stop' => 'Està a punt de cancel·lar el procés de backup actiu. No es crearà l\'arxiu de backup.',
    'backup__backup_stop_confirm' => 'Sí, desitjo aturar el procés de backup',
    'backup__restore_stop_confirm' => 'Sí, desitjo aturar el procés de restauració',
    'backup__domain_session_restore' => 'Restauració del domini %1',
    'backup__domain_session_restore_stop' => 'Està a punt de cancel·lar el procés de restauració actiu.',
    'backup__domain_backup_file_info' => 'Informació de l\'arxiu de backup del domini',
    'backup__domain_backup_file_list' => 'Arxius de backup existents',
    'backup__domain_backup_progress' => 'Progrés del backup del lloc web %1',
    'backup__domain_restore_progress' => 'Progrés de restauració del lloc web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Temps transcorregut: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Temps transcorregut: %1',
    'backup__domain_restore_session_complete' => 'El domini %1 ha estat restaurat.',
    'backup__domain_restore_session_complete_message' => 'El domini %1 ha estat restaurat.',
    'backup__domain_backup_file_delete' => 'S\'eliminaran els següents arxius de backup:',
    'backup__domain_backup_file_for_remove' => 'Seleccioni els arxius de backup que desitja eliminar',
    'backup__backup_overwrite_file_confirm' => 'Confirmació de la substitució',
    'backup__backup_overwrite_file_confirm_text' => 'Ja existeix un arxiu de backup anomenat "%1". Desitja substituir-lo?',
    'backup__backup_confirm_overwrite' => 'Confirmar la substitució d\'arxius',
    'backup__backup_overwrite_legeng' => 'Substituir',
    'backup__backup_not_contain_domain' => 'L\'arxiu de backup no conté informació sobre el domini %1',
    'backup__backup_not_contain_client' => 'L\'arxiu de backup no conté informació sobre el compte de client %1',
    'backup__backup_client_info' => "Crear backup dels detalls del compte i de la configuració del client",
    'backup__client_backup_progress' => 'Progrés de backup del compte de client %1',
    'backup__client_session_complete' => 'El compte de client %1 ha estat copiat',
    'backup__client_backup_file_info' => 'Informació sobre l\'arxiu de backup del client',
    'backup__restore_client_info' => "Restaurar backup dels detalls del compte i de la configuració del client",
    'backup__client_session_restore' => 'Restauració del compte de client %1',
    'backup__client_db_server_map' => 'Assignació de servidors de base de dades',
    'backup__domain_db_server_map' => 'Assignació de servidors de base de dades',
    'backup__client_restore_session_complete_message' => 'El compte de client %1 ha estat restaurat.',
    'backup__client_restore_session_complete' => 'El compte de client %1 ha estat restaurat.',
    'backup__restore_select_some' => 'Seleccioni els objectes que desitja restaurar.',
    'backup__client_restore_progress' => 'Progrés de restauració pel compte de client %1',
    'backup__new_backup' => 'Creant backup nou',
    'backup__done' => 'Fet:',
    'backup__done_domains' => '%1 domini(s) d\'un total de %2',
    'backup__done_clients' => '%1 client(s) d\'un total de %2',
    'backup__remaining' => 'Restant:',
    'backup__remaining_domains' => '%1 domini(s)',
    'backup__remaining_clients' => '%1 client(s)',
    'backup__overall_backup_progress' => 'Progrés general de backup',
    'backup__comment_n_a' => 'n/d',
    'backup__command_ignore' => 'L\'ordre "%1" és ignorada',
    'backup__no_objects' => 'no hi ha cap objecte a copiar',
    'backup__cli_warning_not_enough_ip' => 'Important! No disposa de suficients adreces IP per a efectuar l\'assignació d\'IP predeterminada: ',
    'backup__local_repository' => "Emmagatzematge de Plesk",
    'backup__ftp_repository' => 'Emmagatzematge FTP',
    'backup__ftp_login' => 'Nom d\'usuari',
    'backup__ftp_password' => 'Contrasenya',
    'backup__ftp_account_settings' => 'Configuració del compte FTP',
    'backup__ftp_account_preferences' => 'Configuració del compte FTP',
    'backup__repository_not_exist' => 'El directori no existeix',
    'backup__repository_not_readable' => 'El directori especificat no es pot llegir',
    'backup__ftp_repository_not_configure' => 'Per tal d\'utilitzar un emmagatzematge de backups FTP, <a href="%1">especifiqui primer el compte FTP</a> .',
    'backup__ftp_repository_list_not_configure' => 'No s\'ha especificat la configuració del compte',
    'backup__repository_list_unable_listing' => 'No ha estat possible recuperar la llista d\'arxius',
    'backup__ftp_repository_unable_listing' => 'No ha estat possible recuperar la llista del directori "%1": ',
    'backup__repository_legend' => 'Emmagatzematge d\'arxius de backup',
    'backup__store_in_repository' => 'Desar arxius a',
    'backup__local_repository_lable' => 'Emmagatzematge local',
    'backup__ftp_repository_lable' => 'Emmagatzematge FTP',
    'backup__ftp_repository_not_configure_hint' => '(no s\'ha indicat la configuració del compte)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(no s\'ha especificat el compte FTP o aquest no es suporta)',
    'backup__other_user_process_modified' => 'Un altre usuari ha aturat el procés de backup o migració.',
    'backup__another_user_exist' => 'L\'operació en curs ha estat iniciada per un altre usuari de Plesk. Aquest usuari encara està connectat a Plesk.',
    'backup__ftp_repository_wait' => 'Esperi mentre es recupera la informació sobre l\'emmagatzematge FTP',
    'backup__ftp_write_test_failed' => 'No s\'han pogut escriure dades de prova al compte FTP %1: ',
    'backup__ftp_storage' => 'Emmagatzematge FTP(S)',
    'bt_upload_to_repository' => 'Carregar arxius a l\'emmagatzematge local',
    'bt_new_restore' => "Restaurar",
    'bt_backup_schedule' => "Programar backup",
    'backup_exist_backups' => "Arxius de backup existents",
    'backup_dialog__page_title' => "Creació d'un arxiu de backup",
    'backup_dialog__please_wait' => "El procés de backup està a punt d'iniciar-se. Aquesta operació pot tardar uns minuts en completar-se. Esperi...",
    'backup_conf__page_title' => 'Configuració de backups',
    'bt_accept' => "Acceptar",
    'bt_access' => "Accés",
    'bt_action_log' => "Registre d'accions",
    'bt_add' => "Afegir",
    'bt_add_client' => "Assignar a usuaris",
    'bt_database_server_add' => 'Afegir servidor de base de dades',
    'bt_add_services' => "Afegir serveis",
    'bt_anonftp_stats' => "Estad. FTP an",
    'bt_anonymous_ftp' => "FTP anònim",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Adjuntar",
    'bt_autoinstaller' => 'Actualitzador',
    'bt_auto-updates' => 'Actualitzador',
    'bt_back' => "<< Enrere",
    'bt_backup' => "Crear backup",
    'bt_backup_configure' => "Configuració del backup",
    'bt_buy_certs' => "Comprar certificats",
    'bt_card' => "Targeta",
    'bt_cert' => "Certificat",
    'bt_certificates' => "Certificats",
    'bt_change_passwd' => "Canviar contrasenya",
    'bt_clear' => "Esborrar",
    'bt_client_templates' => "Plantilles de client",
    'bt_clients' => "Clients",
    'bt_codepage_change' => 'Canviar codificació',
    'bt_comp_info' => "Gestió de components",
    'bt_configure_maillists' => "Configurar Mailman",
    'bt_configure' => 'Configurar',
    'bt_copy' => "Copiar",
    'bt_copy_move' => "Copiar/transferir",
    'bt_create' => "Crear",
    'bt_create_account' => "Crear un compte",
    'bt_create_dir' => "Afegir un directori",
    'bt_create_file' => "Afegir un arxiu",
    'bt_count_size' => "Calcular el tamany",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Planificador de tasques",
    'bt_custom_button_new' => "Afegir un botó",
    'bt_custom_buttons' => "Botons personalitzats",
    'bt_customize' => "Personalitzar",
    'bt_databases' => "Bases de dades",
    'bt_database_servers' => 'Servidors de base de dades',
    'bt_sqlservers' => "Servidors de base de dades",
    'bt_db_usr_new' => "Afegir un usuari de la base de dades",
    'bt_db_new' => "Addició d'una base de dades",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Predeterminat per DB Webadmin",
    'bt_decline' => "Declinar",
    'bt_default' => "Predeterminat",
    'bt_defaultcomponents' => "Serveis de tercers",
    'bt_defaults' => "Predeterminats",
    'bt_delete' => "Eliminar",
    'bt_directories' => "Directoris protegits",
    'bt_disable' => "Desactivar",
    'bt_dns_zone_sync' => 'Aplicar canvis de plantilla DNS',
    'bt_dnsrecord_add' => 'Afegir registre',
    'bt_do_backup' => "Crear backup",
    'bt_do_restore' => "Restaurar",
    'bt_do_upload' => "Carregar",
    'bt_domain_aliases' => "Àlies de domini",
    'bt_domain_templates' => "Plantilles de domini",
    'bt_domain_user' => "Administrador del domini",
    'bt_domain_user_passwd' => "Contrasenya de l'administrador del domini",
    'bt_domains' => "Dominis",
    'bt_domain_alias_add' => 'Afegir àlies de domini',
    'bt_download' => "Descarregar",
    'bt_edit' => "Editar",
    'bt_enable' => "Activar",
    'bt_export' => 'Exportar',
    'bt_extras' => "Extres",
    'bt_finish' => "Finalitzar",
    'bt_ftp_account' => "Propietats del compte FTP",
    'bt_forget_password' => "Ha oblidat la contrasenya?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Estadístiques FTP",
    'bt_get_password' => "Obtenir contrasenya",
    'bt_global_changes' => "Modificar",
    'bt_help' => "Ajuda",
    'bt_hide_aliases' => "Amagar àlies",
    'bt_hide_toolbar' => 'Amagar barra d\'eines',
    'bt_hide_subdomains' => "Amagar subdominis",
    'bt_hide_domainaliases' => "Amagar àlies de domini",
    'bt_home' => "Inici",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Instal·lar",
    'bt_ip_aliasing' => "Adreces IP",
    'bt_ip_add' => "Afegir adreça IP",
    'bt_ip_pool' => "Grup d'adreces IP",
    'bt_key_info' => "Informació de la llicència",
    'bt_key_buyonline_addons' => 'Comprar complements per Plesk',
    'bt_key_buyonline_upgrades' => 'Comprar actualitzacions de Plesk',
    'bt_key_buyonline_new' => 'Comprar clau nova',
    'bt_limits' => "Límits",
    'bt_locale_add' => 'Afegir idioma',
    'bt_locales' => 'Idiomes',
    'bt_log_manager' => "Administrador de registres",
    'bt_login' => "Iniciar sessió",
    'bt_logo' => "Personalització",
    'bt_logo_send_link' => "Adjuntar enllaç",
    'bt_logo_send_logo' => "Adjuntar logo",
    'bt_logout' => "Tancar la sessió",
    'bt_logrotation' => "Rotació de registres",
    'bt_mail' => "Correu",
    'bt_mail_alias_add' => "Afegir àlies de correu",
    'bt_mail_aliases' => "Àlies de correu",
    'bt_mail_group_add' => "Afegir membre",
    'bt_mail_groups' => "Grups",
    'bt_mail_name_add' => "Afegir compte de correu",
    'bt_mail_preferences' => "Configuració",
    'bt_mail_group' => "Grup de correu",
    'bt_mail_mailbox' => "Bústia de correu",
    'bt_mail_redirect' => "Reenviador",
    'bt_mail_resp_add' => "Afegir resposta automàtica",
    'bt_mail_resp_attach_add' => "Afegir adjunt",
    'bt_mail_resp_files' => "Arxius adjunts",
    'bt_mail_responders' => "Respostes automàtiques",
    'bt_mail_spamfilter' => "Filtre antispam",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Afegir llista de correu",
    'bt_maillists' => "Llistes de correu",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Crear backup",
    'bt_manage' => "Gestionar",
    'bt_master' => "Principal",
    'bt_migrate' => 'Migrar',
    'bt_modules_add' => 'Afegir extensió',
    'bt_modules_manage' => 'Gestionar extensions',
    'bt_move' => "Transferir",
    'bt_new_client' => "Afegir compte de client",
    'bt_new_domain' => "Afegir domini",
    'bt_next' => "Següent>>",
    'bt_next_page' => "Següent",
    'bt_network_add' => "Afegir xarxa",
    'bt_notifications' => "Notificacions",
    'bt_off' => "Desactivat",
    'bt_on' => "Activat",
    'bt_on_off' => "Activat/desactivat",
    'bt_performance' => 'Rendiment',
    'bt_permissions' => "Permisos",
    'bt_phpmyadmin' => "phpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Configuració",
    'bt_prev_page' => "Ant",
    'bt_preview' => 'Previsualitzar el lloc',
    'bt_print' => "Imprimir",
    'bt_reboot' => "Reiniciar",
    'bt_reload' => "Tornar a carregar",
    'bt_refresh' => "Actualitzar",
    'bt_register' => "Registrar",
    'bt_remove' => "Eliminar",
    'bt_enable_selected' => 'Activar',
    'bt_disable_selected' => 'Desactivar',
    'bt_repair_ip' => "Reparar IP",
    'bt_report' => "Informe",
    'bt_report_new' => "Afegir presentació",
    'bt_reset' => "Restablir",
    'bt_restart_services' => "Gestió de serveis",
    'bt_save' => "Desar",
    'bt_send_by_email' => "Enviar per correu electrònic",
    'bt_send_file' => "Enviar arxiu",
    'bt_send_mail' => "Enviar correu",
    'bt_send_passwd' => "Enviar contrasenya",
    'bt_send_text' => "Enviar text",
    'bt_server' => "Servidor",
    'bt_server_add' => "Afegir servidor",
    'bt_server_preferences' => "Configuració del servidor",
    'bt_servers_list' => "Servidors",
    'bt_sessions' => "Sessions",
    'bt_set' => "Establir",
    'bt_set_as_default' => "Establir com a predeterminat",
    'bt_setup' => 'Configurar',
    'bt_show_aliases' => "Mostrar àlies",
    'bt_show_subdomains' => "Mostrar subdominis",
    'bt_show_domainaliases' => "Mostrar àlies de domini",
    'bt_shutdown' => "Apagar",
    'bt_site_apppkgs' => "Application vault",
    'bt_site_apppool' => "Conjunt d'aplicacions",
    'bt_application-pool' => "Aplicacions web",
    'bt_site_apps' => "Aplicacions web",
    'bt_site_app_add' => "Instal·lar aplicació",
    'bt_site_builder' => "Suport per Presence Builder",
    'bt_skeleton' => 'Plantilla de host virtual',
    'bt_skins' => 'Skins',
    'bt_skin_add' => 'Afegir skin',
    'bt_skin_manual' => 'Referència d\'skins personalitzats de Plesk', // not used
    'bt_skin_download' => 'Descarregar skin',
    'bt_skin_replace' => 'Actualitzar skin',
    'bt_skip' => 'Ometre',
    'bt_spamassassin' => "Filtre antispam",
    'bt_spamassassin_train' => "Seguiment",
    'bt_spamfilter' => "Filtre antispam",
    'bt_start' => "Iniciar",
    'bt_stop' => "Aturar",
    'bt_recycle' => "Reciclar",
    'bt_statistics' => "Estadístiques",
    'bt_subdomain_new' => "Afegir subdomini",
    'bt_subdomains' => "Subdominis",
    'bt_submit' => "Enviar",
    'bt_summary_report' => "Informe resumit",
    'bt_support' => "Suport",
    'bt_switch' => "Canviar",
    'bt_system_time' => "Hora del sistema",
    'bt_task_new' => "Afegir tasca",
    'bt_dom_tmpl_add' => 'Afegir plantilla de domini',
    'bt_cl_tmpl_add' => 'Afegir plantilla de client',
    'bt_cron_backup' => 'Configuració dels backups programats',
    'bt_test' => "Verificar connexió",
    'bt_text' => "Text",
    'bt_touch' => "Canviar data i hora",
    'bt_traffic' => "Trànsit",
    'bt_traffic_history' => "Historial de trànsit",
    'bt_update' => "Actualitzar",
    'bt_upload' => "Carregar",
    'bt_upload_from_ftp' => "Càrrega FTP",
    'bt_virtualdirs' => 'Directoris virtuals',
    'bt_virtualdir_new' => 'Afegir directori virtual',
    'bt_virtualdir_add' => 'Afegir directori virtual',
    'bt_web_app_new' => "Instal·lar aplicació Java",
    'bt_web_stats' => "Estadístiques web",
    'bt_web_stats_ssl' => "Estadístiques web SSL/TLS",
    'bt_web_user_add' => "Afegir usuari web",
    'bt_web_users' => "Usuaris web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Veure la llista completa de canvis",
    'cert_add__unable_set_ca_cert' => "No ha estat possible establir el certificat CA: %1",
    'cert_add__unable_set_cert' => "No ha estat possible establir el certificat: %1",
    'cert_add__unable_set_private_key' => "No ha estat possible establir la clau privada: %1",
    'certificates_list__certificate_used_as_default' => "Un dels certificats que està a punt d'eliminar s'utilitza com a certificat predeterminat.",
    'certificates_list__certificates_assigned_on_ip' => "Les adreces IP/dominis tenen assignats un o varis certificats.",
    'ch_pass__admin_pass' => "Canvi de la contrasenya de l'administrador",
    'ch_pass__old_pass' => "Contrasenya anterior",
    'ch_pass__pass_confirm' => "Confirmar",
    'ch_pass__unable_change_admin_pass' => "No ha estat possible canviar la contrasenya de l'administrador: %1",
    'check_mail_cycle__aliases' => "Cicle de correu detectat. L'adreça \"%1\" està inclosa a l'àlies d'aquest compte de correu.",
    'check_mail_cycle__autoresponders' => "Cicle de correu detectat. L'adreça \"%1\" està inclosa a les respostes automàtiques d'aquest compte de correu.",
    'check_mail_cycle__mail_groups' => "Cicle de correu detectat. L'adreça \"%1\" està inclosa al grup de correu d'aquest compte de correu.",
    'check_mail_cycle__mail_name' => "Cicle de correu detectat. L'adreça \"%1\" coincideix amb aquest compte de correu.",
    'check_mail_cycle__redirect' => "Cicle de correu detectat. L'adreça \"%1\" coincideix amb el reenviador d'aquest compte de correu.",
    'check_mail_dup__redirect' => "Reenviament duplicat detectat. L'adreça \"%1\" coincideix amb l'adreça de reenviament d'aquest compte de correu.",
    'check_mail_dup__mail_groups' => "Reenviament duplicat detectat. L'adreça \"%1\" està inclosa al grup de correu d'aquest compte de correu.",
    'check_maillist_cycle__admin' => "Cicle de correu detectat. L'adreça de correu electrònic de l'administrador \"%1\" coincideix amb l'adreça d'una llista de correu.",
    'check_maillist_cycle__member' => "Cicle de correu detectat. L'adreça \"%1\" coincideix amb l'adreça d'una llista de correu.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detalls del compte %1",
    'cl_limits__cl' => "Límits del client %1",
    'cl_logo__setup_logo_pref' => "Establir les propietats del logo pel client %1",
    'cl_new__enter_new_cl_data' => "Introdueixi la informació sobre el propietari nou",
    'cl_new__unable_to_sent_notification' => 'El compte d\'usuari s\'ha creat, si bé no s\'ha pogut enviar l\'avís al client: %1',
    'cl_perm__all_ip' => "Totes les IPs disponibles",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Tots els comptes de hosting basats en IP pel client es transferiran a basats en nom.",
    'cl_perm__allow_client_create_domain' => "Els camps que està intentant seleccionar només són aplicables en el cas de clients que puguin crear dominis.",
    'cl_perm__allow_create_nb_w_ip' => "El client pot crear hosting basat en nom utilitzant %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Permetre la creació de comptes de hosting basats en IP",
    'cl_perm__available_ips' => "IPs disponibles",
    'cl_perm__change_limits' => "Ajustament de límits",
    'cl_perm__cl_disk_space' => "Espai al disc total disponible",
    'cl_perm__cl_expiration' => "Període de validesa del compte de client",
    'cl_perm__cl_max_box' => "Bústies de correu",
    'cl_perm__cl_max_db' => "Bases de dades",
    'cl_perm__cl_max_dom' => "Dominis",
    'cl_perm__cl_max_maillists' => "Llistes de correu",
    'cl_perm__cl_max_subdom' => "Subdominis",
    'cl_perm__cl_max_traffic' => "Quantitat total de trànsit disponible",
    'cl_perm__cl_max_wu' => "Usuaris web",
    'cl_perm__cl_mbox_quota' => "El tamany màxim de la bústia de correu per aquest compte d'usuari",
    'cl_perm__current_maximum_exp_date' => "El valor màxim actual del període de validesa del domini és %1. Sol·licitat %2.",
    'cl_perm__current_maximum_mailbox_quota' => "El límit actualment definit sobre la quantitat d'espai al disc assignada per a allotjar bústies de correu sota aquest compte d'usuari és %1,. Sol·licitat %2.",
    'cl_perm__current_total_requested' => "El valor total actual de límits del domini per %1 és %2. Sol·licitat %3.",
    'cl_perm__current_total_requested_dom' => "El número actual de %1 que pertanyen a aquest client és %2. Sol·licitat %3.",
    'cl_perm__disk_space' => "quantitat màxima d'espai al disc",
    'cl_perm__dashboard_stdgui' => 'Interfície d\'usuari',
    'cl_perm__dashboard' => 'Visualització de la pàgina inicial',
    'cl_perm__stdgui' => 'Mode de visualització estàndard',
    'cl_perm__manage_dashboard' => 'Gestió de la pàgina inicial',
    'cl_perm__dashboard_and_stdgui' => 'Es permet visualitzar la pàgina inicial i el mode de visualització estàndard',
    'cl_perm__dashboard_only' => 'Només es permet visualitzar la pàgina inicial',
    'cl_perm__stdgui_only' => 'Només es permet el mode de visualització estàndard',
    'cl_perm__edit_cl' => "Permisos del client %1",
    'cl_perm__exp_date_exceeded' => "El període de validesa que està intentant establir excedeix el límit especificat als dominis individuals relacionats amb aquest client.",
    'cl_perm__invalid_value' => "Ha especificat un valor que no és vàlid, ja que només es permet l'ús de dígits.",
    'cl_perm__limit_disk_space' => "%1 Limitar la quantitat total d'espai al disc",
    'cl_perm__limit_expiration' => "%1 Limitar el període de validesa pel compte de client",
    'cl_perm__limit_max_box' => "%1 Limitar el número màxim de bústies de correu",
    'cl_perm__limit_max_db' => "%1 Limitar el número màxim de bases de dades",
    'cl_perm__limit_max_dom' => "%1 Limitar el número màxim de dominis",
    'cl_perm__limit_max_maillists' => "%1 Limitar el número màxim de llistes de correu",
    'cl_perm__limit_max_subdom' => "%1 Limitar el número màxim de subdominis",
    'cl_perm__limit_max_traffic' => "%1 Limitar la quantitat total de trànsit",
    'cl_perm__limit_max_wu' => "%1 Limitar el número màxim d'usuaris web",
    'cl_perm__limit_mbox_quota' => "%1 Establir la quota de bústia de correu",
    'cl_perm__limits_exceeded' => "Un o varis dels límits que està intentant establir ja són excedits pels límits definits als dominis individuals propietat d'aquest client.\nEl límit total pel client hauria de ser igual o superior a la suma total dels límits del domini definits per aquest compte de client.",
    'cl_perm__mailbox_quota_exceeded' => "La quantitat màxima d'espai al disc assignada a les bústies de correu que està intentant establir excedeix el límit definit als dominis individuals relacionats amb aquest compte de client.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "La quantitat màxima d'espai al disc assignada a les bústies de correu que està intentant establir excedeix la limitació imposada a nivell del servidor.",
    'cl_perm__make_dumps' => "Copia i restauració de dades",

    'cl_perm__max_box' => "número màxim de bústies de correu",
    'cl_perm__max_db' => "número màxim de bases de dades",
    'cl_perm__max_dom' => "dominis",
    'cl_perm__max_maillists' => "número màxim de llistes de correu",
    'cl_perm__max_subdom' => "subdominis",
    'cl_perm__max_traffic' => "quantitat màxima de trànsit",
    'cl_perm__max_wu' => "número màxim d'usuaris web",
    'cl_perm__max_dom_aliases' => "àlies de domini",
    'cl_perm__mbox_quota' => "quota de bústia de correu",
    'cl_perm__not_allow_create_nb_hst' => "El client no pot crear hosting basat en nom.",
    'cl_perm__this_ip_used_vrt_hst' => "Aquesta adreça IP s'utilitza pel hosting virtual.\nSi desitja eliminar-la, elimini el servei de hosting o canviï el seu tipus a basat en nom.",
    'cl_perm__unable_off_ipb_creating' => "El client ja té configurat el servei de hosting basat en IP. Per desactivar aquesta funció pel client, deseleccioni la casella \"Creació de dominis\" o elimini tots els comptes de hosting basats en IP.",
    'cl_perm__unable_off_nb_creating' => "El client ja té configurat el servei de hosting basat en nom. Per desactivar aquesta funció pel client, deseleccioni la casella \"Creació de dominis\" o elimini tots els comptes de hosting basats en nom.",
    'cl_perm__unable_set_domain_limit' => "No ha estat possible limitar el número màxim de dominis. El client ja disposa de %1 dominis.",
    'cl_perm__unable_update_client_limitations' => "No ha estat possible els límits del compte de client: %1",
    'cl_pref__edit_cl' => "Preferències del client %1",
    'class_anonftp__create_ftp_domain' => "No hi ha cap domini FTP virtual per aquest dom_id. Intenti crear-lo primer.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "El límit d'espai al disc que està intentant establir (%1) no hauria de ser superior al límit d'espai al disc total definit a nivell del domini (%2).",
    'class_anonftp__invalid_input_only_digits' => "Ha especificat un valor que no és vàlid, ja que només es permet l'ús de dígits.",
    'class_anonftp__unable_change_ownerships' => "No ha estat possible canviar la propietat o els permisos per l'arxiu de quota: %1",
    'class_anonftp__unable_copy_quota_file' => "No ha estat possible copiar l'arxiu de quota: %1",
    'class_anonftp__unable_get_disk_usage' => "No ha estat possible recuperar la informació sobre l'ús del disc al directori entrant: %1",
    'class_anonftp__unable_parse_quota_file' => "No ha estat possible analitzar l'arxiu de quota.",
    'class_anonftp__unable_read_quota_file' => "No ha estat possible llegir l'arxiu de quota: %1",
    'class_anonftp__unable_update_quota' => "No ha estat possible actualitzar la quota. Els arxius presents al directori entrant utilitzen %1 KBs d'espai al disc, la qual cosa excedeix el nou valor de la quota.",
    'class_anonftp__unable_write_temp_file' => "No ha estat possible escriure a l'arxiu temporal: %1",
    'class_bsdomain__warn_max_date__' => "La data de caducitat s'ha establert a %1",
    'class_client__client_creation_notification' => "Avís de creació de clients.",
    'class_client__client_with_contact_name_already_exists' => "Ja existeix un client anomenat %1.",
    'class_client__disk_space' => "Espai al disc",
    'class_client__invalid_max_dom' => "El valor de número de dominis no és vàlid, ja que només es permet l'ús de dígits.",
    'class_client__limit_exceed' => "No es pot assignar la quantitat sol·licitada de %1 perquè s'excedirien les assignacions pel compte del client %2 (%3). Si desitja assignar més recursos, vagi a Clients> nom del client> Límits i canviï les assignacions. A continuació, torni aquí i intenti tornar a ajustar les assignacions.",
    'class_client__limit_exceed_unlimited' => "Si desitja assignar una quantitat il·limitada de recursos (%1), primer vagi a Clients> nom del client> Límits i seleccioni la casella Il·limitat corresponent al tipus de recurs desitjat. A continuació, torni aquí i intenti tornar a ajustar les assignacions.",
    'class_client__max_box' => "Bústies de correu",
    'class_client__max_db' => "Bases de dades",
    'class_client__max_maillists' => "Llistes de correu",
    'class_client__max_subdom' => "Subdominis",
    'class_client__max_traffic' => "Trànsit màxim",
    'class_client__max_wu' => "Usuaris web",
    'class_client__max_dom_aliases' => "Àlies de domini",
    'class_client__mbox_quota' => "Quota de bústia de correu",
    'class_client__unable_define_cl_status' => "No ha estat possible definir l'estat del compte de client: %1",
    'class_client__unable_define_inactive_dom' => "No ha estat possible definir dominis inactius %1.",
    'class_client__unable_del_ip' => "No ha estat possible eliminar IPs: %1",
    'class_db__db_name_not_set' => "No s'ha definit el nom de la base de dades.",
    'class_db__db_not_exist_for_curr_dom' => "La base de dades no existeix per aquest domini.",
    'class_db__invalid_db_or_dom_name' => "L'ID de la base de dades o del domini no és vàlid o bé no s'ha definit el nom de la base de dades.",
    'class_db__invalid_pass' => "La contrasenya no és vàlida.",
    'class_db__mailgrp_member_exist' => "El membre del grup de correu ja existeix.",
    'class_db__access_hosts_notsupport' => 'No es suporta l\'opció d\'accés als hosts per aquest tipus de base de dades',
    'class_db__unable_add' => 'No ha estat possible afegir el registre d\'accés del host: %1',
    'class_db__unable_del' => 'No ha estat possible eliminar el registre d\'accés del host: %1',
    'class_db__inc_user_not_exist' => 'L\'usuari de la base de dades "%1" no existeix',
    'class_db__inc_access_record_exist' => 'Aquest registre d\'accés ja existeix',
    'class_db__inc_access_record_not_exist' => 'El registre d\'accés especificat no existeix',
    'class_db__inc_unable_del_last_record' => 'No ha estat possible eliminar el darrer registre d\'accés',
    'class_domtmpleditform__dns_master' => "Principal",
    'class_domtmpleditform__dns_slave' => "Secundari",
    'class_domtmpleditform__dns_type' => "Tipus de zona DNS del domini",
    'cmd_dns__a_dns_record_already_exist' => "Aquest registre crearà conflictes amb el registre A de la zona.",
    'cmd_dns__domain_last_ns' => 'No és possible eliminar el darrer registre NS DNS pel domini.',
    'cmd_dns__canonical_dom_name_is_invalid' => "El nom canònic del domini no és vàlid.",
    'cmd_dns__cname_dns_record_already_exist' => "Aquest registre crearà conflictes amb el registre CNAME de la zona.",
    'cmd_dns__cname_in_rr_combination' => 'A la zona DNS hi ha una combinació incorrecta de registres DNS',
    'cmd_dns__cname_coexist_with_data' => 'Un registre de zona DNS CNAME no pot coexistir amb altres registres DNS a la mateixa zona.',
    'cmd_dns__dns_record_type_is_invalid' => "El tipus de registre DNS no és vàlid.",
    'cmd_dns__ext_host_is_not_resolved' => "El nom canònic %1 no resol a cap registre A o AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'No ha estat possible afegir el registre %1 a la zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "El nom de l'intercanviador de correu no és vàlid.",
    'cmd_dns__mx_priority_is_invalid' => "La prioritat MX no és vàlida.",
    'cmd_dns__name_server_is_invalid' => "El servidor de noms no és vàlid.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "El valor de la màscara de xarxa hauria de ser 24, 16 o 8.",
    'cmd_dns__this_dns_record_already_exists' => "Ja existeix aquest registre DNS.",
    'cmd_dns__unable_add_record' => "No ha estat possible afegir el registre '%1': %2",
    'cmd_dns__unable_add_a_record' => "No ha estat possible afegir el registre A: %1",
    'cmd_dns__unable_add_cname_record' => "No ha estat possible afegir el registre CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "No ha estat possible afegir el registre DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "No ha estat possible afegir el registre EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "No ha estat possible afegir el registre NS: %1",
    'cmd_dns__unable_add_ptr_record' => "No ha estat possible afegir el registre PTR: %1",
    'cmd_dns__unable_add_txt_record' => "No ha estat possible afegir el registre TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "No ha estat possible crear la zona DNS %1",
    'cmd_dns__unable_define_dns_record' => "No ha estat possible definir el registre DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "No ha estat possible recuperar l'estat de la zona DNS predeterminada: %1",
    'cmd_dns__unable_insert_a_record' => "No ha estat possible inserir el registre A: %1",
    'cmd_dns__unable_insert_mx_record' => "No ha estat possible inserir el registre MX: %1",
    'cmd_dns__unable_insert_ns_record' => "No ha estat possible inserir el registre NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "No ha estat possible establir l'estat de la zona DNS: %1",
    'cmd_domains__dom_already_exists' => "El domini %1 ja existeix.",
    'cmd_domains__dns_record_already_exists' => "No ha estat possible crear el domini %1 perquè ja existeix un registre DNS que apunta al host %1.",
    'cmd_domains__dom_already_exists1' => "En aquest domini hi ha %2 subdominis. El domini %1 ja existeix.",
    'cmd_domains__dom_already_exists2' => "el subdomini %1 ja existeix.",
    'cmd_domains__dalias_already_exists' => "Aquest àlies ja existeix.",
    'cmd_domains__domain_alias_already_exists' => 'Ja existeix un àlies de domini amb aquest nom.',
    'cmd_domains__unable_del_mail_for_dom' => "No ha estat possible eliminar els serveis de correu pel domini: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "No ha estat possible eliminar el compte FTP anònim pel domini: %1",
    'cmd_domains__unable_update_dom_param' => "No ha estat possible actualitzar els paràmetres del domini: %1.",
    'cmd_domains__unable_rename_client_exist' => "el nom d'usuari de l'administrador del domini ja s'està utilitzant.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "El tipus de hosting no és físic.",
    'cmd_hosting__unable_create_user' => "No ha estat possible crear l'usuari %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "No ha estat possible definir l'adreça IP pels hosts virtuals basats en nom: %1",
    'cmd_hosting__unable_del_old_hst' => "No ha estat possible eliminar el hosting configurat prèviament: %1",
    'cmd_hosting__unable_del_protected_directory' => "No ha estat possible eliminar el directori protegit: %1.",
    'cmd_hosting__unable_del_web_user' => "No ha estat possible eliminar l'usuari web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "No ha estat possible crear o actualitzar el host virtual: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "No ha estat possible configurar el hosting amb redireccionament per marcs.",
    'cmd_hosting__unable_rebuild_ftp_config' => "No ha estat possible tornar a crear l'arxiu de configuració proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "No ha estat possible configurar SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "No ha estat possible eliminar la protecció del directori SSL/TLS : %1",
    'cmd_hosting__unable_update_dest_url' => "No ha estat possible actualitzar l'URL de destí %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "No ha estat possible actualitzar la zona DNS pel domini. Error d'execució de l'utilitat.",
    'cmd_hosting__unable_update_ftp_passwd' => "No ha estat possible actualitzar la contrasenya FTP %1.",
    'cmd_hosting__unable_update_user' => "No ha estat possible actualitzar l'usuari %2: %1",
    'cmd_hosting__unknown_hst_type' => "Tipus de hosting desconegut.",
    'cmd_hosting__you_not_have_permission_del_hst' => "No disposa del permís necessari per a finalitzar el servei de hosting.",
    'cmd_mail__autoresponder__not_configured' => "No s'ha configurat la resposta automàtica per aquest compte de correu",
    'cmd_mail__addr_already_used_in_mail_redirect' => "L'adreça %1 ja s'està utilitzant pel reenviament de correu.",
    'cmd_mail__alias_already_exists' => "l'àlies ja existeix.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "L'ID de la resposta automàtica i l'ID del compte de correu no coincideixen.",
    'cmd_mail__autoresp_id_is_undefined' => "No s'ha definit l'ID de la resposta automàtica.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Ja existeix un àlies de correu amb aquest nom pel compte de correu %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "El compte de correu %1 ja està subscrit a aquesta llista de correu.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "El compte de correu %1 ja existeix en aquest domini.",
    'cmd_mail__mail_name_not_exist' => "El compte de correu no existeix.",
    'cmd_mail__mail_name_passwd_part' => "La contrasenya no hauria d'incloure el nom del compte de correu.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "La llista de correu %1 ja existeix en aquest domini.",
    'cmd_mail__mailname_already_exist_in_mg' => "El compte de correu %1 ja està present en un grup de correu.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "El compte de correu %1 ja existeix en aquest domini.",
    'cmd_mail__mailname_already_exists' => "El compte de correu ja existeix.",
    'cmd_mail__mailname_is_invalid' => "El nom del compte de correu %1 no és vàlid.",
    'cmd_mail__mailname_unable_update' => "No ha estat possible actualitzar les propietats del compte de correu:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "S'ha assolit el número màxim de respostes automàtiques per aquest domini.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "S'ha assolit el número màxim de grups de correu per aquest domini.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "S'ha assolit el número màxim de reenviadors per aquest domini.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "S'ha assolit el número màxim de bústies de correu.",
    'cmd_mail__no_members_specified' => "no s'ha especificat cap membre.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "La contrasenya és massa fàcil. Triï'n una altra.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Aquesta adreça de correu ja s'està utilitzant.",
    'cmd_mail__unable_define_autoresp_id' => "No ha estat possible definir l'ID de la resposta automàtica %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Error al canviar la configuració del servei de correu pel domini %1",
    'cmd_mail__unable_del_mail_for_dom' => "No ha estat possible eliminar el servei de correu del domini %1.",
    'cmd_mail__unable_del_mail_redirection' => "No ha estat possible eliminar el servei de reenviament de correu %1.",
    'cmd_mail__unable_remove_autoresp' => "No ha estat possible eliminar les respostes automàtiques: %1",
    'cmd_mail__unable_remove_mail_group_members' => "No ha estat possible eliminar els membres del grup de correu: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Error al desactivar el grup de correu: %1",
    'cmd_mail__unable_update_mail_redirect' => "No ha estat possible reconfigurar el servei de reenviament de correu %1.",
    'cmd_mail__uploaded_file_is_too_big' => "El tamany de l'arxiu carregat és massa gran.",
    'cmd_mail__additionally' => "Addicionalment: ",
    'cmd_pd__invalid_login' => "Nom d'usuari incorrecte.",
    'cmd_pd__this_user_already_exist' => "Aquest usuari ja existeix.",
    'cmd_pd__unable_define_hst_type' => "No ha estat possible definir el tipus de hosting.",
    'cmd_pd__unable_upd_pd_usr' => "No ha estat possible actualitzar les propietats de l'usuari del directori protegit: %1.",
    'cmd_pd__user_is_undefined' => "No s'ha definit l'usuari.",
    'cmd_server__no_enough_free_disk_space' => "No disposa de suficient espai al disc.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "la contrasenya anterior no és correcta. Torni-ho a provar.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "s'assolit el número màxim d'usuaris web per aquest domini.",
    'cmd_web_usr__unable_create_user' => "no ha estat possible crear l'usuari del sistema: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "no ha estat possible definir el número màxim d'usuaris web: %1",
    'cmd_web_usr__user_already_exists' => "l'usuari ja existeix.",
    'cmd_web_usr__web_user_name_is_invalid' => "el nom d'usuari web %1 no és vàlid.",
    'cmd_web_usr__web_user_not_exist' => "l'usuari web no existeix.",
    'common_func__exec_bad_argument' => "L'argument exec no hauria d'incloure el símbol de cometa simple.",
    '__eol' => 'Salts de línia',
    'eol__binary_file' => 'No ha estat possible canviar l\'estil de salt de línia a l\'arxiu binari.',
    'cp_access_admin_deny' => "L'accés de l'administrador des de l'adreça '%1' està restringit d'acord amb la directiva de restricció d'accés IP aplicada en aquests moments.",
    'create_domain_warn__' => "Durant la creació del domini s'han realitzat les següents excepcions:",
    'create_domain__client_select' => 'Seleccioni el client pel qual desitja crear el domini.',

    'dashboard__nav_button_name' => "Inici",
    'dalias__list_title' => 'Àlies de domini del domini %1',
    'dalias__list_legend' => 'Àlies de domini',
    'dalias__list_header' => 'Àlies de domini',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Nom de l\'àlies de domini',
    'dalias__list_ascii_name' => 'En format ASCII',
    'dalias__remove_title' => 'S\'eliminaran els següents àlies de domini del domini %1:',
    'dalias__select_domain_aliases_to_remove' => 'Seleccioni els àlies de domini que desitja eliminar.',
    'dalias__mail_turn_on_failed' => 'No ha estat possible activar el servei de correu: %1',
    'dalias__web_turn_on_failed' => 'No ha estat possible activar el servei web: %1',
    'db_usr_edit__db_usr_name_old' => "Nom d'usuari anterior de la base de dades",
    'database_server_edit_form__cannot_infer_type' => 'No és possible inferir el mètode de connexió a partir de les dades proporcionades. Indiqui "127.0.0.1" com el nom de host del servidor de base de dades para connectar-se a través de TCP/IP amb el port proporcionat o deixi el camp buit per utilitzar el socket Unix "%1".',
    'database_server_edit_form__duplicate' => 'Ja s\'ha registrar un servidor de base de dades amb aquesta combinació d\'adreça de host i número de port.',
    'database_server_edit_form__host_is_invalid' => 'El nom de host especificat no és vàlid.',
    'database_server_edit_form__port_is_invalid' => 'El número de port especificat no és vàlid.',
    'database_server_error__consult_admin' => 'Posi\'s en contacte amb l\'administrador del servidor.',
    'database_server_error__last__connection_failed' => 'L\'últim intent per controlar aquest servidor de base de dades ha fallat degut a problemes de xarxa.',
    'database_server_error__last__permission_denied' => 'L\'últim intent per controlar aquest servidor de base de dades ha fallat perquè el compte indicat no disposa de privilegis administratius.',
    'database_server_error__last__credentials_not_set' => "L'últim intent per connectar-se a aquest servidor ha fallat perquè no s'han indicat unes credencials d'administrador vàlides.",
    'database_server_error__last__other_error' => 'L\'últim intent per controlar aquest servidor de base de dades ha fallat.',
    'database_server_error__real__connection_failed' => 'La connexió al servidor de base de dades ha fallat degut a problemes de xarxa:',
    'database_server_error__real__permission_denied' => 'La connexió al servidor de base de dades ha fallat perquè el compte indicat no disposa de privilegis administratius.',
    'database_server_error__real__duplicate_object' => 'La connexió al servidor de base de dades ha fallat degut a un conflicte entre noms:',
    'database_server_error__real__unacceptable_name' => 'La connexió al servidor de base de dades ha fallat degut a un nom d\'objecte que no és vàlid:',
    'database_server_error__real__unacceptable_password' => 'La connexió al servidor de base de dades ha fallat degut a una contrasenya que no es pot acceptar:',
    'database_server_error__real__credentials_not_set' => "Plesk no pot connectar-se al servidor de base de dades perquè no s'han indicat unes credencials d'administrador vàlides.",
    'database_server_error__real__other_error' => 'La connexió al servidor de base de dades ha fallat:',
    'database_server_error__test__connection_failed' => 'La connexió de prova al servidor de base de dades ha fallat degut a problemes de xarxa:',
    'database_server_error__test__permission_denied' => 'La connexió de prova al servidor de base de dades ha fallat perquè el compte indicat no disposa de privilegis administratius.',
    'database_server_error__test__duplicate_object' => 'La connexió de prova al servidor de base de dades ha fallat degut a un conflicte entre noms:',
    'database_server_error__test__unacceptable_name' => 'La connexió de prova al servidor de base de dades ha fallat degut a un nom d\'objecte que no és vàlid:',
    'database_server_error__test__unacceptable_password' => 'La connexió de prova al servidor de base de dades ha fallat degut a una contrasenya que no es pot acceptar:',
    'database_server_error__test__credentials_not_set' => "La connexió de prova a aquest servidor ha fallat perquè no s'han indicat unes credencials d'administrador vàlides.",
    'database_server_error__test__other_error' => 'La connexió de prova al servidor de base de dades ha fallat:',

    'db__create_new_db' => "Addició d'una base de dades",
    'db__db_add' => "Afegir base de dades",
    'db__db_for_dom' => "Bases de dades del lloc web %1",
    'db__db_id_undefined' => "No s'ha definit l'ID de la base de dades.",
    'db__db_name' => "Nom de la base de dades",
    'db__db_not_exist' => "La base de dades no existeix.",
    'db__db_type' => "Tipus",
    'db__db_server' => "Servidor de base de dades",
    'db_server_not_exist' => "El servidor de base de dades no existeix.",
    'db__db_user_not_exist' => "L'usuari de la base de dades no existeix.",
    'db__domain_not_exist' => "El domini no existeix.",
    'db__enter_db_name' => "Indiqui el nom nou de la base de dades.",
    'db__invalid_db_id' => "L'identificador de la base de dades no és vàlid.",
    'db__invalid_db_name' => "El nom de la base de dades no és vàlid. Aquest només pot incloure símbols alfanumèrics de l'alfabet llatí, dígits, ratlles baixes o guions. Així mateix, no pot estar format per més de 63 símbols.",
    'db__max_db_reached_for_dom' => "S'ha assolit el número màxim de bases de dades per aquest domini.",
    'db__max_mssql_db_reached_for_dom' => "S'ha assolit el número màxim de bases de dades Microsoft SQL Server per aquest domini.",
    'db__postgres_not_connect_for_admin' => "No ha estat possible connectar-se a PostgreSQL. Activi el suport per PostgreSQL a la pàgina d'administració del servidor.",
    'db__postgres_not_connect_for_client' => "No ha estat possible connectar-se a PostgreSQL. Posi's en contacte amb el seu administrador del sistema per tal d'obtenir ajuda.",
    'db__remove_db_on_domain' => "S'eliminaran les següents bases de dades sota el lloc web %2 propietat del client %1:",
    'db__remove_db_on_domain_of_cl' => "S'eliminaran les següents bases de dades pel domini %2 propietat del client %1:",
    'db__remove_db_linked_resource' => 'Aquesta base de dades està sent utilitzada per una aplicació web. Només pot eliminar-la un cop s\'hagi desinstal·lat l\'aplicació web en qüestió.',
    'db__remove_db_users' => "S'eliminaran els següents usuaris de la base de dades %3 sota el lloc web %2 propietat del client %1:",
    'db__remove_db_users_of_cl' => "S'eliminaran els següents usuaris de la base de dades %3 sota el lloc web %2 propietat del client %1:",
    'db__select_db_for_remove' => "Seleccioni les bases de dades que desitja eliminar.",
    'db__select_db_users_for_remove' => "Seleccioni els usuaris de la base de dades que desitja eliminar.",
    'db__unable_create_db_user' => "No ha estat possible crear l'usuari de la base de dades: %1",
    'db__unable_define_db_name' => "No ha estat possible definir el nom de la base de dades: %1",
    'db__unable_define_db_user' => "No ha estat possible definir l'usuari de la base de dades: %1",
    'db__unable_define_db_users' => "No ha estat possible definir els usuaris de la base de dades: %1",
    'db__unable_select_dom_name' => "No ha estat possible seleccionar el nom de domini: %1",
    'db_edit__db_for_dom' => "Usuaris per la base de dades %1 al domini %2",
    'db_edit__invalid_db_name' => "El nom de la base de dades no és vàlid.",
    'db_edit__no_users' => "No hi ha cap usuari amb credencials per aquesta base de dades.",
    'db_edit__unable_define_db_usrs' => "No ha estat possible definir els usuaris de la base de dades: %1",
    'db_edit__unable_select_db_usr' => "No ha estat possible seleccionar l'usuari de la base de dades.",
    'db_edit__db_user_password_for_' => "Introdueixi la contrasenya per a iniciar sessió com l'usuari de la base de dades %1 ",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Afegir usuari de la base de dades",
    'db_usr_edit__db_usr_name' => "Nom d'usuari de la base de dades",
    'db_usr_edit__edit_db_usr' => "Establir credencials pel compte d'usuari de la base de dades",
    'db_usr_edit__for_db' => " a la base de dades %1",
    'db_usr_edit__not_create_pass' => "Com a resultat d'aquesta operació, es crearà un compte d'usuari de la base de dades sense contrasenya.\nDesitja crear un usuari sense assignar-li una contrasenya?",
    'dbuser__only_one_user_can_be_default' => "Només es pot establir un únic usuari com a usuari predeterminat.",
    'db_server__cannot_delete_default' => "El servidor de base de dades predeterminat no es pot eliminar.",
    'db_server__cannot_delete_local' => "El servidor de base de dades local no es pot eliminar.",
    'db_server__cannot_delete_used' => 'No es pot eliminar cap servidor de base de dades mentre aquest allotgi bases de dades o usuaris de base de dades.',
    'demo__disabled_in_demo' => "Aquesta operació no se suporta a la versió de prova.",
    'defaultcomponents__title' => "Selecció dels components predeterminats",
    'defaultcomponents__select_default' => "Seleccioni el component %1 predeterminat", //to check
    'defaultcomponents__not_installed' => "(no instal·lat)",
    'defaultcomponents__not_configured' => "(no configurat)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Algunes categories de serveis contenen seleccions que no són vàlides o no s'ha efectuat cap selecció.",
    'defaultcomponents__depends_on' => "(requereix %1)",
    'defaultcomponents__parameters' => "Paràmetres de %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Servidor DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Servidor FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Servidor de correu",
    'component_name__local_mailserver' => "Servidor de correu local",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Scripting web",
    'component_name__spamfilter' => "Filtre antispam",
    'component_name__stats' => "Estadístiques web",
    'component_name__stunnel' => "Contenidor SSL/TLS",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Publicació web",
    'component_name__webserver' => "Servidor web",
    'dns__dns_record_invalid_values' => 'S\'han especificat uns valors de registre DNS que no són correctes: %1: %2',
    'dns__dns_record_not_found' => 'Registre DNS no trobat',
    'dns__dns_zone_invalid_values' => 'S\'han especificat uns paràmetres per la zona DNS que no són correctes.',

    'dns__soa_mname_title' => 'Servidor de noms principal',
    'dns__soa_mname_legend' => 'Servidor de noms',
    'dns__soa_mname_autoselect' => '(Selecció automàtica)',

    'dns__dns_zone_off_remove_title' => "Els següents registres de recursos s'eliminaran de la zona %1:",
    'dns__dns_zone_master_remove_title' => "Eliminació de registres de recursos de la zona DNS %1",
    'dns__dns_zone_slave_remove_title' => "S'eliminaran els següents registres del servidor de noms principal per %1:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Introduir la cadena de registre',
    'dns_add__is_spf_syntax' => 'Registre SPF',
    'dns_add__spf_value_is_invalid' => "El valor del registre SPF no és correcte, ja que aquest ha de començar amb 'v=spf'",
    'dns__dns_zone_status' => "Estat de la zona DNS.",
    'dns__invalid_ip_address' => "L'adreça IP del nou servidor DNS principal no és vàlida o està buida.",
    'dns__ip_address' => "Adreça IP",
    'dns__master_dns_type' => "és un servidor DNS principal",
    'dns__masters' => "servidors DNS principals",
    'dns__soa_minimum_too_large' => 'No es recomana emmagatzemar a la memòria respostes negatives durant més de tres hores.',
    'dns__select_masters_to_remove' => "Seleccioni els servidors DNS principals que desitja eliminar.",
    'dns__select_template_record_to_remove' => 'Seleccioni els registres de la plantilla DNS que desitja eliminar.',
    'dns__nameservers_for_domain' => "Servidors de nom pel domini",
    'dns__remove_dns_zone_of_domain__' => "Eliminació de registres DNS del domini %1",
    'dns__remove_dns_zone_template__' => "Els següents registres DNS s'eliminaran de la plantilla:",
    'dns__remove_this_dns_record?' => "Està segur que desitja eliminar aquest registre DNS?",
    'dns__restore_default' => "Restaurant la zona DNS a través de la plantilla",
    'dns__restore_default_confirm' => "La restauració de la zona DNS descartarà la configuració actual de la zona DNS. Desitja continuar de totes maneres?",
    'dns__restore_default_error' => "Error al restaurar la zona DNS:",
    'dns__slave_dns_type' => "és un servidor DNS secundari",
    'dns__subdomain_dns_rec_removed' => "El registre A s'ha eliminat de la zona del subdomini %1.",
    'dns__zone_switched_off_no_ns' => "La zona ha estat desactivada perquè no existeix cap registre NS %1, que hauria d'estar present a la zona. Per afegir el registre a la zona, faci clic al botó Afegir registre.",
    'dns__cant_switch_on_no_ns' => "La zona no es pot activar perquè no existeix cap registre NS %1, que hauria d'estar present a la zona. Per afegir el registre a la zona, faci clic al botó Afegir registre.",
    'dns__unable_activate/deactivate_dns' => "No ha estat possible activar/desactivar el DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "No ha estat possible afegir el servidor DNS principal: entrada duplicada.",
    'dns__unable_add_dns_master_local_ip' => "No ha estat possible afegir l'adreça IP pel servidor DNS principal. Aquest registre s'hauria de crear en un servidor remot.",
    'dns__unable_define_dns_record' => "No ha estat possible definir el registre DNS: %1",
    'dns__unable_get_dns_template_status' => "No ha estat possible recuperar l'estat de la plantilla DNS.",
    'dns__unable_remove_dns_rec' => "No ha estat possible eliminar el registre DNS: %1",
    'dns__warnings__' => "Resultat de la modificació de la zona DNS:",
    'dns__you_not_have_perm_manage_dns' => "No disposa del permís necessari per gestionar la zona DNS per aquest domini.",
    'dns__cant_create_record_with_server_ip' => "No ha estat possible afegir aquesta adreça IP perquè aquesta coincideix amb l'adreça IP d'aquest servidor gestionat per Plesk.",

    'dns__tabs_acl' => "Transferències de zona",
    'dns__acl_add_network_legend' => "Afegir xarxa",
    'dns__acl_add_ip_legend' => "Afegir adreça IP",
    'dns__acl_network_not_allowed' => "Aquesta adreça de xarxa no està permesa pel DNS a Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Adreça IP/màscara",
    'dns__acl_enter_ip_address' => "Adreça IP",
    'dns__acl_list_network_legend' => "Xarxes que poden obtenir una còpia de la zona DNS",
    'dns__acl_list_ip_legend' => "Adreces IP que poden obtenir una còpia de la zona DNS",
    'bt_dns_acl_add_network' => "Afegir xarxa",
    'bt_dns_acl_add_ip' => "Afegir adreça IP",

    'dns_add__add_rec_for_zone' => "Afegir %1 per la zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "El nom canònic del domini no és vàlid.",
    'dns_add__enter_canonical_name' => "Nom canònic",
    'dns_add__enter_dom_name' => "Nom de domini",
    'dns_add__enter_ip_address' => "Adreça IP",
    'dns_add__enter_ip_mask' => "Adreça IP i màscara de xarxa",
    'dns_add__enter_mail_domain' => "Domini de correu",
    'dns_add__enter_mail_exchanger' => "Servidor d'intercanvi de correu",
    'dns_add__enter_nameserver' => "Servidor de noms",
    'dns_add__enter_txt_record' => "Registre TXT",
    'dns_add__enter_service_name' => "Nom del servei",
    'dns_add__hint_service_name' => "Exemple: SIP (sense el símbol de subratllat)",
    'dns_add__enter_protocol' => "Protocol",
    'dns_add__hint_protocol_name' => "Exemple: TCP (sense el símbol de subratllat)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioritat",
    'dns_add__specify_weight_of_service' => "Pes relatiu dels registres amb la mateixa prioritat",
    'dns_add__enter_target_host' => "Host de destí",
    'dns_add__hint_target_host' => "Exemple: example.com",
    'dns_add__enter_target_port' => "Port de destí",
    'dns_add__caa_tag' => "Etiqueta",
    'dns_add__caa_value' => "Valor",
    'dns_add-invalid-A_ip' => "L'adreça IP no és vàlida.",
    'dns_add-invalid-AAAA_ip' => "L'adreça IP no és vàlida.",
    'dns_add-invalid-PTR_ip_mask' => "El parell màscara de xarxa/adreça IP no és vàlid.",
    'dns_add-invalid-SRV_service_name' => "El nom del servei no és vàlid",
    'dns_add-invalid-SRV_protocol_name' => "El protocol no és vàlid",
    'dns_add-invalid-SRV_target_port' => "El port de destí no és vàlid",

    'dns_add__invalid_ip' => "L'adreça IP no és vàlida.",
    'dns_add__low' => "baixa",
    'dns_add__mail_dom_name_is_invalid' => "El nom del domini de correu no és vàlid.",
    'dns_add__nameserver_is_invalid' => "El servidor de noms no és vàlid.",
    'dns_add__record' => "Registre %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Especifiqui la prioritat del servidor d'intercanvi de correu",
    'dns_add__unable_insert_new_dns_rec' => "No ha estat possible afegir el nou registre DNS: %1",
    'dns_add__very_high' => "molt alta",
    'dom_ctrl__allowed' => "Es permet",
    'dom_ctrl__db' => "Bases de dades MariaDB/MySQL",
    'dom_ctrl__mssql_db' => "Bases de dades MS SQL",
    'dom_ctrl__disk_space' => "Espai al disc",
    'dom_ctrl__dom_adm' => "Domini %1 de %2",
    'dom_ctrl__dom_cl' => "Domini %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "S'ha configurat redireccionament del domini amb una URL de redireccionament no definida",
    'dom_ctrl__domain_has_frame_forwarding' => "El domini té redireccionament per marcs a l'URL %1",
    'dom_ctrl__domain_has_no_hosting' => "No s'ha configurat hosting pel domini",
    'dom_ctrl__domain_has_physical_hosting' => "S'ha configurat hosting web per aquest domini a l'adreça IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "El domini té redireccionament estàndard a l'URL %1",
    'dom_ctrl__maillists' => "Llistes de correu",
    'dom_ctrl__mboxes' => "Bústies de correu",
    'dom_ctrl__mg' => "Reenviaments de correu",
    'dom_ctrl__resource_name' => "Recurs",
    'dom_ctrl__resp' => "Respostes automàtiques",
    'dom_ctrl__subdom' => "Subdominis",
    'dom_ctrl__dom_aliases' => "Àlies de domini",
    'dom_ctrl__traffic' => "Trànsit",
    'dom_ctrl__unable_activate/deactivate_dom' => "No ha estat possible activar/desactivar el domini: %1",
    'dom_ctrl__used' => "Utilitzat",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Usuaris web",
    'dom_pref__bounce_with_phrase' => "Tornar amb un missatge",
    'dom_pref__bounce' => "Tornar",
    'dom_pref__catch_addr' => "Reenviar a l'adreça",
    'dom_pref__reject' => 'Rebutjar',
    'dom_pref__confirm_domain_removing' => "No oblidi informar als visitants del domini sobre el canvi del nom de domini. Està segur que desitja canviar el nom del domini?",
    'dom_pref__db_inconsystency' => "incoherència de base de dades.",
    'dom_pref__dbs' => "bases de dades",
    'dom_pref__delete_traffic_stat' => "Conservar estadístiques web i de trànsit",
    'dom_pref__delete_traffic_stat_older' => "Conservar estadístiques web i de trànsit",
    'dom_pref__dom_level_name_conflict' => "El nom d'usuari de l'administrador del domini entra en conflicte amb un nom d'usuari d'un dels clients.",
    'dom_pref__invalid_disk_space_limit' => "El límit d'espai al disc no és vàlid. Valor màxim: %1",
    'dom_pref__invalid_expiration_date_limit' => "El període de validesa no és vàlid.",
    'dom_pref__invalid_max_traffic_limit' => "El límit de trànsit no és vàlid. Valor màxim: %1",
    'dom_pref__limits_of_dom' => "Límits pel domini %1",
    'dom_pref__mail_grps' => "grups de correu",
    'dom_pref__mail_nonexistent_user' => "Accions a realitzar amb els correus enviats a usuaris de correu inexistents",
    'dom_pref__mail_redirs' => "reenviadors de correu",
    'dom_pref__mail_resps' => "respostes automàtiques de correu",
    'dom_pref__max_limit_is_invalid' => "%1 no és vàlid.",
    'dom_pref__max_num_of_%objects_is_invalid' => "El número màxim de %1 no és vàlid.",
    'dom_pref__new_limit_less_currently_used' => "%1: sol·licitat - %2, utilitzat en aquests moments - %3",
    'dom_pref__older_that' => " per ",
    'dom_pref__postboxes' => "bústies de correu",
    'dom_pref__preferences_of_dom' => "Configuració pel domini %1",
    'dom_pref__redirect_to_itself' => "El domini es redireccionarà a sí mateix",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Ha indicat un període durant el qual preservar les estadístiques del trànsit del domini inferior al valor total definit pel servidor (%1 mes(os)). Aquest període s'ha establert al mateix valor que el valor predeterminat pel servidor (%1 mes(os)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "No ha estat possible afegir un prefix www al domini: %1",
    'dom_pref__unable_define_physical_hst_param' => "No ha estat possible definir els paràmetres de hosting físic: %1",
    'dom_pref__unable_rename_domain' => "No ha estat possible canviar el nom del domini %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "No ha estat possible establir la quota de bústia de correu per aquest domini: %1",
    'dom_pref__unable_set_up_web_user_script' => "No ha estat possible configurar l'scripting per usuaris web: %1",
    'dom_pref__unlimited' => "Il·limitats",
    'dom_pref__web_usrs' => "usuaris web",
    'dom_pref__you_already_have_%object' => "Ja disposa de %1",
    'cu_domain__error_unable_update_ftp_users' => 'No ha estat possible actualitzar els usuaris FTP del domini: %1',
    'dom_cli__warning_ignore_quota' => 'Important! S\'ha ignorat l\'opció "-hard_quota". No es suporta la quota de disc dur.',
    'dom_user_client_login_exist' => "No ha estat possible permetre l'accés de l'administrador del domini a Plesk al domini %1. Ja s'està utilitzant aquest nom d'usuari.",
    'domain__unable_to_turn_on_service' => "No s'ha pogut activar el servei %1.",
    'domains__change_the_status_of_domain?' => "Està segur que desitja canviar l'estat del domini %1?",
    'domains__unable_to_change_client_status' => "No ha estat possible canviar l'estat del compte de client: %1",
    'domains__unable_update_apache_settings' => "No ha estat possible actualitzar la configuració d'Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "No disposa dels permisos necessaris per eliminar dominis.",
    'domains_list__unable_remove_doms' => "No ha estat possible eliminar dominis: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Seleccioni els àlies de domini que desitja eliminar.',
    'domain_aliases_remove__title' => 'Eliminació d\'àlies de domini',
    'domain_aliases__max_aliases_reached_for_dom' => "S'ha assolit el número màxim d'àlies per aquest domini.",
    'domain_edit__edit_title' => 'Editar nom de l\'àlies de domini',
    'domain_alias_edit__type' => 'Tipus d\'àlies de domini',
    'domain_aliases__list_header' => 'Àlies de domini',
    'domain_aliases__name' => 'Nom',
    'domain_aliases__type' => 'Tipus',
    'domain_aliases__type_full' => 'Web+FTP+Correu',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Àlies de domini',
    'domain_aliases__legend' => 'Àlies de domini',
    'domain_alias__domain_exists' => 'Ja existeix un domini amb aquest nom.',
    'domain_alias__subdomain_exists' => 'Ja existeix un subdomini amb aquest nom.',
    'domain_alias__dns_record_exists' => 'Ja existeix un registre DNS A amb el nom de l\'àlies de domini especificat.',
    'domain_alias__domain_alias_exists' => "Ja existeix un àlies de domini amb aquest nom.",
    'domain_alias__invalid_type_full' => 'El servidor de correu no suporta àlies de domini',
    'domain_alias__redirect_exists' => 'S\'ha detectat un redireccionament a sí mateix.',

    'ds__anonymous_ftp' => "FTP anònim",
    'drweb__pagetitle' => 'Configuració de l\'antivirus',
    'drweb__drweb' => 'Comprovació antivirus al correu',
    'drweb__drweb_direction' => 'Analitzant el correu per comprovar l\'existència de virus',
    'drweb__drweb_direction_off' => 'No detectar virus',
    'drweb__drweb_direction_any' => 'Correu entrant i sortint',
    'drweb__drweb_direction_from' => 'Només correu sortint',
    'drweb__drweb_direction_to' => 'Només correu entrant',
    'drweb__disable_reason_key' => 'La clau de llicència no suporta l\'antivirus.',
    'drweb__disable_reason_perm' => 'No disposa del permís necessari per a gestionar l\'antivirus.',
    'drweb__disable_reason_install' => 'L\'antivirus no està instal·lat.',
    'drweb__filters' => 'Filtres antivirus',
    'ds__dns' => "Zona DNS",
    'ds__mail' => "Correu",
    'dumps_list__deletion_page_title' => "S'eliminaran els següents arxius de backup del domini %1:",
    'dumps_list__dumpfile_is_invalid' => "L'arxiu %1 no és un arxiu de backup de domini vàlid.",
    'dumps_list__page_title' => "Emmagatzematge d'arxius de backup",
    'dumps_upload__page_title' => "Càrrega d'arxius de backup a l'emmagatzematge",
    'dumps_list__repository_is_not_exist' => "L'emmagatzematge d'arxius de backup no existeix",
    'dumps_list__unable_to_remove' => "No ha estat possible eliminar l'arxiu de backup: %1",
    'dumps_list__dumpfile_can_conflict' => "El nom d'arxiu especificat entra en conflicte amb l'arxiu %1. Indiqui un altre nom d'arxiu.",
    'dusr_ed__allow_dl_usr_access' => "Permetre l'accés a l'administrador del domini",
    'dusr_ed__information' => "Propietats de l'administrador del domini %1",
    'dusr_ed__locale' => "Idioma de l'administrador del domini",
    'dusr_ed__skin' => "Skin de la interfície de l'administrador del domini",
    'dusr_ed__personal_information' => 'Informació personal',
    'ess__error' => "Error",
    'example__' => "Exemple: %1",
    'extras__allow_certificate_purchasing' => "Permetre la compra de certificats",
    'extras__allow_domain_registration' => "Permetre el registre de dominis",
    'extras__allow_extras' => "Permetre serveis addicionals",
    'extras__buy_new_key' => "La seva llicència actual no li permet modificar aquests objectes.",
    'extras__setup_services' => "Configurar serveis addicionals",

    'ruleeditform__error' => 'No és possible actualitzar la regla de firewall.',
    'ruleeditform__name_is_required' => 'Especifiqui el nom de la regla.',
    'ruleeditform__profiles_is_required' => 'Seleccioni almenys un perfil.',
    'ruleeditform__invalid_ip' => 'L\'adreça IP o la xarxa especificada no és vàlida.',
    'ruleeditform__invalid_port' => 'El port especificat no és vàlid. Els possibles valors són 1000 o 1000-1051.',

    'get_password__encrypted_password' => "No ha estat possible la informació sobre la contrasenya. La contrasenya està xifrada.",
    'get_password__mail_error' => "S'ha produït un error mentre s'intentava enviar la contrasenya a l'adreça de correu %1: %2",
    'get_password__mail_ok' => "La contrasenya s'ha enviat correctament a l'adreça de correu: %1",
    'get_password__message' => "El seu nom d'usuari per accedir al sistema: %1\nLa seva contrasenya és %2",
    'get_password__subject' => "Contrasenya per accedir al sistema",
    'groups__available' => "Grups de correu disponibles",
    'groups__groups_for_mailname' => "Grups de correu als que està subscrit el compte de correu %1",
    'groups__member_of' => "Membre dels següents grups de correu",
    'help__help_area' => "Àrea d'ajuda.",
    'hst_def__auth_disabled' => "prohibit",
    'hst_def__auth_enabled' => "es permet",
    'hst_def__change_curr_dns_ip' => "Es canviarà l'adreça IP actual del registre A del DNS",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Cap de les adreces IP del registre A del DNS coincideix amb l'adreça IP assignada al compte de hosting que s'està creant",
    'hst_def__dest_url' => "URL de destí",
    'hst_def__disk_quota' => "Quota de disc",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "El límit d'espai al disc que està intentant establir excedeix el límit d'espai al disc al directori entrant de l'FTP anònim. El límit d'espai al disc al directori entrant de l'FTP anònim no pot excedir el límit d'espai al disc del domini.",
    'hst_def__frame_forwarding_definition' => "Assignació de redireccionament per marcs pel domini %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Important! L'usuari FTP %1 s'utilitza a la configuració del compte de hosting però no existeix al sistema.",
    'hst_def__hst_type_is_not_defined' => "No s'ha definit el tipus de hosting",
    'hst_def__ip_based' => "Basat en IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "La transferència d'aquest compte de hosting a una adreça IP compartida farà que el servei d'FTP anònim no estigui disponible en aquest domini. Desitja continuar de totes maneres?",
    'hst_def__password_is_invalid_password_syntax' => "La contrasenya no és vàlida.\nNo utilitzi cometes simples ni caràcters de l'alfabet nacional a les contrasenyes.\nLes contrasenyes han d'estar formades per 5-14 caràcters. La contrasenya no hauria de contenir el nom d'usuari.",
    'hst_def__shell' => "Accés al shell del servidor mitjançant SSH sota l'usuari del sistema de la subscripció",
    'hst_def__shell_windows' => "Accés al servidor mitjançant escriptori remot sota l'usuari del sistema de la subscripció",
    'hst_def__standard_forwarding_definition' => "Assignació de redireccionament estàndard pel domini %1",
    'hst_def__title_name_based' => "Basat en nom",
    'hst_def__unable_create/update_physic_hst' => "No ha estat possible crear/actualitzar el hosting físic: %1",
    'hst_def__unable_create/update_std_fwd' => "No ha estat possible crear/actualitzar el redireccionament estàndard: %1",
    'hst_def__unable_create_forwarding_myself' => "No ha estat possible crear el redireccionament al propi domini.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "No ha estat possible permetre l'ús d'un únic directori per l'emmagatzematge de contingut SSL/TLS i no SSL/TLS perquè no s'ha activat el suport d'SSL/TLS.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "No ha estat possible activar el suport d'SSL/TLS perquè no s'ha instal·lat cap certificat SSL/TLS.",
    'hst_def__url_is_invalid' => "L'URL no és vàlida.",
    'hst_def__virtual_host_access' => "Accés al host virtual pel domini %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "Important! Aquest host virtual està utilitzant una adreça IP inexistent pel hosting.",
    'hst_def__you_have_no_ips' => "No disposa de cap adreça IP disponible i no se li permet crear hosting basat en nom.",
    'hst_sel__header' => "Si desitja allotjar un lloc web en aquest servidor, seleccioni l'opció de hosting físic.\n Per tal de configurar redireccionament del domini a un lloc present en una altra màquina, seleccioni l'opció de redireccionament per marcs o redireccionament estàndard.\n Si opta pel redireccionament estàndard, l'usuari serà redireccionat al lloc i al navegador de l'usuari es mostrarà l'URL actual del lloc. Per tant, l'usuari serà coneixedor d'aquest redireccionament. En el cas del redireccionament per marcs, l'usuari serà redireccionat però no sabrà que de fet el lloc es troba en una altra ubicació.",
    'hst_sel__physical_hst' => "Hosting físic",
    'hst_sel__select_hst_type' => "Seleccioni el tipus de hosting pel domini",
    'hst_sel__select_hst_type_warning' => "Seleccioni el tipus de hosting pel domini",
    'hst_sel__hosting_exists' => "No ha estat possible crear hosting, ja que aquest ja s'ha configurat per aquest domini. Se'l redireccionarà a la pàgina de gestió del hosting.",
    'hst_sel__standard_frw' => "Redireccionament estàndard",
    'hst_sel__frame_frw' => "Redireccionament per marcs",
    '__frame_frw' => "Redireccionament per marcs",
    '__hosting_exists' => "No ha estat possible crear hosting, ja que aquest ja s'ha configurat per aquest domini. Se'l redireccionarà a la pàgina de gestió del hosting.",
    '__choose_hst_type' => "Seleccioni el tipus de hosting requerit.",
    '__no_hst_conf' => "No s'ha configurat cap hosting pel seu domini.",
    '__physical_hst' => "Hosting físic",
    '__select_hst_type' => "Seleccioni el tipus de hosting pel domini",
    '__standard_frw' => "Redireccionament estàndard",
    '__warning' => "Important! Es descartaran tots els paràmetres configurats anteriorment. Està segur que desitja canviar el tipus de hosting?",
    'i_cl_off' => "El client no està actiu.",
    'i_cl_off_by_admin' => "El compte de client ha estat suspès per l'administrador del servidor.",
    'i_cl_off_expired' => "El compte de client ha caducat.",
    'i_cl_on' => "El client està actiu.",

    'icf__title' => 'Firewall de connexió a Internet',
    'icf__if_legend' => 'Interfícies',
    'icf__mode' => 'Mode',

    'invalid_value' => 'El valor no és vàlid',

    'ip_addr__already_exists' => "L'adreça IP %1 ja existeix.",
    'ip_addr__cant_add' => "L'adreça IP %1 no existeix o pertany al grup d'adreces IP d'un altre client",
    'ip_alias__interface' => "Interfície ",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "L'adreça IP %1 per hosting virtual basat en nom no és vàlida.",
    'ip_alias__invalid_ip_or_netmask' => "El parell màscara de xarxa/adreça IP no és vàlid.",
    'ip_alias__orig_ip_can_not_be_deleted' => "L'adreça IP %1 és l'adreça IP original del servidor i per aquest motiu no pot eliminar-la.",
    'ip_alias__ip_is_invalid' => "L'adreça IP %1 no és vàlida.",
    'ip_alias__ip_mask_is_invalid' => "La màscara IP %1 no és vàlida.",
    'ip_alias__ip_not_exist' => "L'adreça IP %1 no existeix.",
    'ip_alias__ip_address_and_mask' => 'Adreça IP i màscara de subxarxa',
    'ip_alias__mask' => "Màscara de subxarxa",
    'ip_alias__remove_selected_ip_aliases?' => "Està segur que desitja eliminar les adreces IP seleccionades?",
    'ip_alias__select_ip' => "Seleccioni almenys una adreça IP de la llista per eliminar-la.",
    'ip_alias__this_ip_used_for_domain' => "(%1) aquesta adreça IP s'utilitza pel domini %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) aquesta adreça IP s'utilitza per hosts virtuals basats en nom.",
    'ip_alias__unable_add_ip' => "No ha estat possible afegir l'adreça IP: %1",
    'ip_alias__unable_remove_ip' => "No ha estat possible eliminar l'adreça IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "No pot canviar el tipus d'adreça IP a compartida, ja que aquest canvi faria que l'FTP anònim pel domini '%1' no estigués disponible.",
    'ip_ctrl__ip_addr' => "L'adreça IP %2 a la interfície %1",
    'ip_ctrl__ip_exists_many_pools' => "No pot canviar el tipus d'adreça IP. Aquesta adreça IP pertany als grups d'adreces IP de diversos usuaris.",
    'ip_ctrl__ssl_cert' => "Certificat SSL/TLS",
    'limit__date_in_past' => "El període de validesa no és vàlid. %1 és al passat.",
    'limit__enter_date' => "Introduir data",
    'limit__max_db' => "Bases de dades",
    'limit__name_disk_space' => "espai al disc",
    'limit__name_max_box' => "bústies de correu",
    'limit__name_max_db' => "Bases de dades MariaDB/MySQL",
    'limit__name_max_dom' => "dominis",
    'limit__name_max_maillists' => "llistes de correu",
    'limit__name_max_subdom' => "subdominis",
    'limit__name_max_traffic' => "trànsit",
    'limit__name_max_wu' => "usuaris web",
    'limit__name_mbox_quota' => "quota de bústia de correu",
    'limit__name_max_mn' => "comptes de correu",
    'limit__name_max_cl' => 'clients',
    'limit__name_total_mboxes_quota' => "quota total de bústia de correu",
    'limit__name_mysql_dbase_space' => "Espai de la base de dades MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "Espai de la base de dades MSSQL",
    'limit__name_pgsql_dbase_space' => "Espai de base de dades PostgreSQL",
    'limit__name_expiration' => 'data de caducitat',

    'locale_upload__unable_to_install' => 'No ha estat possible instal·lar l\'arxiu del paquet d\'idioma',
    'locale_upload__wrong_package' => 'L\'arxiu carregat no conté cap paquet d\'idioma vàlid per aquesta versió de Plesk.',
    'locale_upload__wrong_locale' => 'L\'arxiu carregat no conté cap paquet d\'idioma vàlid.',

    'ma__create_title' => 'Creació d\'un àlies de correu per %1',
    'ma__edit_title' => "Edició de l'àlies de correu %1",
    'ma__enter_new_alias' => "Introdueixi el nou àlies.",
    'ma__invalid_alias' => "L'àlies de correu no és vàlid.",
    'ma__mail_aliases_mailname' => "Àlies de correu pel compte de correu %1",
    'ma__mailname_does_not_exist' => "El compte de correu no existeix.",
    'ma__select_ma_for_remove' => "Seleccioni els àlies de correu que desitja eliminar.",
    'ma__unable_to_add_new_ma' => "No ha estat possible afegir un àlies de correu: %1",

    'mail_queue__not_allowed_by_license_key' => 'La clau de llicència no permet gestionar cues de correu.',
    'maillist__' => "Llista de correu %1",
    'maillist__already_exists' => "La llista de correu ja existeix.",
    'maillist__mail_alias_already_exists_in_this_domain' => "L'àlies de correu %1 ja existeix en aquest domini",
    'maillists__' => "Llistes de correu %1",
    'maillists__limit_cl_max_maillists' => "S'ha assolit el número màxim de llistes de correu pel client (límit: %1, utilitzat: %2)",
    'maillists__limit_dom_max_maillists' => "S'ha assolit el número màxim de llistes de correu pel domini.",
    'maillists__list' => "Llistes de correu",
    'maillists__mailman_not_installed_or_conf' => "\nLes extensions de servidor de Mailman no estan instal·lades o configurades\nal servidor. Posi's en contacte amb l'administrador del servidor per tal que les hi instal·li o configuri correctament.",
    'maillists__status' => "El servei de llistes de correu està activat",
    'maillists__unable_to_delete__' => "No ha estat possible eliminar la llista de correu: %1",
    'maillists__disabled_text' => 'No pot gestionar llistes de correu perquè el component de servidor de llistes de correu Mailman no està instal·lat o configurat.',
    'maillist_member__already_exists' => 'El subscriptor de la llista de correu ja existeix.',
    'maillist_member__not_exists' => 'A la llista de correu no existeix aquest usuari.',
    'mailserver_switching_warning' => "Important!\n\nEl canvi de servidor de correu només es aconsellable en el cas de la configuració inicial. Si el servidor ja està en ús, aquest canvi pot ocasionar els següents problemes: pèrdua de la configuració i del contingut de les bústies de correu i, en alguns casos quan el servidor al que desitja canviar ja està configurat, d'altres conflictes.\nSi aquest servidor està en ús en aquests moments i està segur que desitja canviar a l'altre servidor, pot notificar als clients sobre l'operació per tal que així puguin descarregar i desar els seus correus.",
    'manager__access_denied' => "Accés denegat. %1",
    'manager__admin' => "Administrador",
    'manager__client' => 'Client',
    'manager__domain' => "Domini",
    'manager__domain_cl_limit_exceeding' => "S'ha assolit el número màxim de dominis per aquest compte de client.",
    'manager__domain_is_not_yours' => "No és el propietari del domini %1.",
    'manager__domain_key_limit_exceeding' => "S'ha assolit el límit de creació de dominis definit per la seva clau de llicència.",
    'manager__no_perm_to_call' => "No disposa del permís necessari per a trucar %1.",
    'manager__no_perm_to_create_domains' => "No disposa del permís necessari per a crear dominis.",
    'manager__no_perm_to_modify_domain' => "No disposa del permís necessari per a modificar el domini %1.",
    'manager__no_perm_to_modify_domains' => "No disposa del permís necessari per a modificar dominis.",
    'manager__no_perm_to_remove_domain' => "No disposa del permís necessari per a eliminar el domini %1.",
    'manager__no_perm_to_remove_domains' => "No disposa del permís necessari per a eliminar dominis.",
    'manager__node_doesnt_exist' => "%1 no existeix.",
    'manager__user_disabled' => "El seu compte està suspès. No pot utilitzar el sistema.",
    'mail_quota_unsupported' => "no suportada pel servidor de correu",
    'mbox_quota_unsupported' => "no suportada pel servidor de correu",
    'mn__create_title' => "Creació d'un compte de correu",
    'mn__edit_title' => "Configuració",
    'mn__files_list_title' => "Arxius adjunts",
    'mn__files_remove' => "Elimini els arxius del repositori d'adjunts. Possiblement, aquests arxius són utilitzats per les respostes automàtiques. Aquests s'eliminaran tant del repositori com de les respostes automàtiques que els facin servir.",
    'mn__files_select_for_remove' => "Seleccioni els arxius que desitja eliminar.",
    'mn__mail_alias_form' => "Formulari d'àlies de correu",
    'mn__mail_aliases_list' => "Àlies de correu",
    'mn__mailbox' => "Gestió de bústies de correu",
    'mn__unable_define_mn' => "No ha estat possible configurar comptes de correu: %1",
    'mn__unable_remove_mbox_quota' => "No ha estat possible eliminar la quota de bústia de correu: %1",
    'mn__upload_file' => "Carregar arxiu",
    'mn_edit__attach_filename_changed' => 'L\'arxiu carregat %1 ara s\'anomena %2, ja que el seu nom incloïa caràcters que no eren ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Abans d'activar el grup de correu, afegeixi un membre al grup de correu.",
    'mn_edit__add_resp_or_turn_off_box' => "Afegeixi una resposta automàtica o deseleccioni la casella de resposta automàtica.",
    'mn_edit__attachments' => "Adjunts",
    'mn_edit__dom_quota_less_then_quota' => "El tamany d'aquesta bústia de correu no pot excedir la quantitat màxima d'espai al disc assignada a les bústies d'aquest domini.",
    'mn_edit__enter_external_rcpnt_email' => "Introdueixi el correu del membre extern del grup de correu",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Introdueixi una adreça pel reenviament de correu o deseleccioni la casella.",
    'mn_edit__ext_rcpnt_email_invalid' => "L'adreça de correu del destinatari extern no és vàlida.",
    'mn_edit__file_exists' => "L'arxiu ja existeix. Desitja sobreescriure'l?",
    'mn_edit__files_deld_from_repository' => "Aquests arxius s'eliminaran del repositori juntament amb les respostes automàtiques que continguin. Desitja continuar?",
    'mn_edit__mail_name' => "Compte de correu",
    'mn_edit__mail_name_invalid' => "El nom del compte de correu no és vàlid.",
    'mn_edit__mail_redir' => "Reenviadors de correu",
    'mn_edit__mail_redir_add' => "Afegir membre al grup de correu",
    'mn_edit__mail_resps' => "Respostes automàtiques de correu",
    'mn_edit__mailbox' => "Bústia de correu",
    'mn_edit__enable_mailbox' => "Bústia de correu",
    'mn_edit__mailgroup' => "Grup de correu",
    'mn_edit__mailgroup_addresses' => "Membres del grup de correu",
    'mn_edit__mailgroup_disabled' => "Només disponible quan s'hagi afegit un compte de correu.",
    'mn_edit__max_dom_quota' => "Predeterminat pel domini (%1)",
    'mn_edit__mbox_quota_invalid' => "El tamany indicat de la bústia de correu no és vàlid.",
    'mn_edit__new_resp_name' => "Nom nou de la resposta automàtica",
    'mn_edit__no_autoresponders' => "Abans d'activar o desactivar el servei de respostes automàtiques, afegeixi almenys una resposta automàtica.",
    'mn_edit__no_file_sel' => "No ha seleccionat cap arxiu.",
    'mn_edit__no_mail_addresses' => "No s'ha especificat o seleccionat cap adreça de correu.",
    'mn_edit__none' => "Cap",
    'mn_edit__not_create_pass' => "Com a resultat no es crearà cap contrasenya per aquest compte.\nAl no disposar de contrasenya, l'usuari no podrà visualitzar ni enviar correus.",
    'mn_edit__redir_email_invalid' => "L'adreça de reenviament no és vàlida.",
    'mn_edit__redirect_addr' => "Adreça de reenviament",
    'mn_edit__remove_autoresp?' => "Està segur que desitja eliminar la resposta automàtica?",
    'mn_edit__remove_rcpnts?' => "Està segur que desitja eliminar aquests destinataris?",
    'mn_edit__repository' => "Repositori",
    'mn_edit__resps_attach' => "Arxius adjunts de la resposta automàtica",
    'mn_edit__select_rcpnt_from_list' => "Seleccioni almenys un destinatari de la llista per eliminar-lo.",
    'mn_edit__select_registered_users' => "Seleccioni usuaris registrats",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Ha escollit disposar d'una bústia de correu però no ha configurat cap contrasenya per aquesta.",
    'mn_edit__unable_act_deact_mail_group' => "No ha estat possible activar o desactivar el grup de correu: %1",
    'mn_edit__unable_act_deact_mail_redir' => "No ha estat possible activar o desactivar el reenviament de correu: %1",
    'mn_edit__unable_act_deact_postbox' => "No ha estat possible activar o desactivar la bústia de correu: %1",
    'mn_edit__unable_act_deact_resp' => "No ha estat possible activar o desactivar les respostes automàtiques: %1",
    'mn_edit__unable_add_attach' => "No ha estat possible afegir l'arxiu adjunt: %1",
    'mn_edit__unable_add_mail_group_member' => "No ha estat possible afegir el membre al grup de correu: %1",
    'mn_edit__unable_add_resp' => "No ha estat possible afegir la resposta automàtica: %1",
    'mn_edit__unable_change_mail_name' => "No ha estat possible canviar el nom del compte de correu: %1",
    'mn_edit__unable_deactivate_mail_group' => "No ha estat possible desactivar el grup de correu: %1",
    'mn_edit__unable_deactivate_resp' => "No ha estat possible desactivar les respostes automàtiques: %1",
    'mn_edit__unable_define_resp_id' => "No ha estat possible definir l'ID de la resposta automàtica: %1",
    'mn_edit__unable_remove_attach' => "No ha estat possible eliminar el(s) arxiu(s) adjunt(s): %1",
    'mn_edit__unable_remove_autoresp' => "No ha estat possible eliminar la resposta automàtica: %1",
    'mn_edit__unable_remove_mail_group_member' => "No ha estat possible eliminar els membres del grup de correu: %1",
    'mn_edit__wrong_way' => 'Els correus enviats a %1 no seran entregats, ja que aquest compte de correu no disposa de cap bústia de correu o no té activat cap reenviador de correu.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'La bústia de correu a l\'adreça %1 ha estat desactivada. No s\'han eliminat els correus presents a la bústia, si bé no podrà recuperar-los mitjançant el protocol POP3 o IMAP.',
    'mn_list__mail_names_for_domain' => "Comptes de correu sota el domini %1",
    'mn_list__sa_cannot_unable' => "No ha estat possible activar la filtració d'spam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Client',
    'mn_list__tab_title_domain' => 'Domini',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nom",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "No ha estat possible eliminar els comptes de correu: %1",
    'module_upload__module_was_installed' => 'Aquest mòdul ja està instal·lat. Si desitja instal·lar una versió més recent del mòdul, desinstal·li el mòdul a través de Plesk i posteriorment intenti instal·lar-lo.',
    'module_upload__unable_to_install' => 'No ha estat possible instal·lar l\'arxiu del paquet del mòdul',
    'module_upload__wrong_package' => 'L\'arxiu carregat no és un paquet de mòdul suportat.',
    'module_upload__wrong_module' => 'L\'arxiu carregat no conté cap paquet de mòdul.',

    'news_articles_title' => 'Novetats de Plesk',
    'notification_text__invalid_subject_length' => "Longitud de l'assumpte de l'avís no vàlida. Hauria de tenir entre 1 i 255 caràcters.",
    'notification_text__invalid_text_length' => "La longitud del text de l'avís no és vàlida. Aquest hauria de tenir entre 1 i 65533 caràcters.",
    'notification_text__subject' => "Assumpte de l'avís",
    'notification_text__text' => "Text de l'avís",
    'notification_text__title' => "Editar avís",
    'notification_text__unable_set_text' => "No ha estat possible modificar el text de l'avís: ",

    'odbc__cant_add_dsn' => "No ha estat possible afegir el DSN %1: %2",
    'odbc__cant_connect' => "No ha estat possible connectar-se a l'origen de dades utilitzant la configuració definida. El servidor ha tornat: %1",
    'odbc__cant_delete_dsn' => "No ha estat possible eliminar el DSN %1: %2",
    'odbc__cant_get_drivers_info' => "No ha estat possible obtenir la informació sobre els controladors.",
    'odbc__cant_get_drivers' => "No ha estat possible recuperar la llista de controladors ODBC: %1",
    'odbc__cant_open_info_file' => "No ha estat possible obrir l'arxiu que conté la informació sobre els controladors ODBC.",
    'odbc__cant_parse_string' => "No ha estat possible analitzar la cadena de connexió.",
    'odbc__driver_not_set' => "El controlador no està configurat",
    'odbc__driver_or_name_not_set' => "No s'ha definit el controlador o el nom de la connexió ODBC",
    'odbc__dsn_already_exists' => "Al sistema ja existeix un DSN amb aquest nom (%1)",
    'odbc__dsn_not_exists' => "Aquest DSN no existeix",
    'odbc__enter_dsn_name' => "Introdueixi el nom del DSN",
    'odbc__invalid_dsn_name' => "Sintaxi incorrecta pel nom de la connexió ODBC (%1). Utilitzi únicament símbols alfanumèrics.",
    'odbc__no_such_driver' => "No es suporten controladors ODBC amb aquest nom (%1).",
    'odbc__unknown_driver' => "Nom del controlador desconegut (%1).",
    'odbc_dsn_system' => "DSN de sistema",

    'pb__aliases' => "Àlies",
    'pb__anonftp' => "FTP anònim",
    'pb__autoinstaller_releases' => 'Actualitzador',
    'pb__cert' => "Certificats",
    'pb__cl_pool' => "Adreces IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Configuració",
    'pb__cl_rpt' => "Informe",
    'pb__cl_rpt_list' => "Personalitzar",
    'pb__cl_templates' => "Plantilles de client",
    'pb__cl_traffic' => "Trànsit",
    'pb__cl_traffic_history' => "Historial de trànsit",
    'pb__cl_traffic_of' => "Trànsit de %1",
    'pb__client' => "%1",
    'pb__clients' => "Clients",
    'pb__comp_info' => "Components del servidor",
    'pb__common_acl' => 'Permetre transferència ACL',
    'pb__cp_access' => "Accés",
    'pb__crontab' => "Planificador",
    'pb__scheduler' => "Planificador",
    'pb__custom_buttons' => "Botons personalitzats",
    'pb__databases_db' => 'Bases de dades',
    'pb__sqlservers_db' => 'Servidors SQL', //to check
    'pb__db' => "Bases de dades",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Servidors de base de dades',
    'pb__dl_usr_ed' => "Administrador del domini",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Límits del domini",
    'pb__dom_pref' => "Configuració",
    'pb__dom_sum_report' => "Informe resumit del domini",
    'pb__dom_templates' => "Plantilles de domini",
    'pb__dom_traffic' => "Trànsit de %1",
    'pb__domains' => "Dominis",
    'pb__domain_aliases' => 'Àlies de domini',
    'pb__dumps_list' => "Emmagatzematge d'arxius de backup",
    'pb__forwarding_setup' => "Configuració de redireccionament",
    'pb__filemanager' => "Administrador d'arxius",
    'pb__ip_aliasing' => "Adreces IP",
    'pb__ip_clients' => "Eliminació d'adreces IP",
    'pb__license_management' => 'Informació de la llicència',
    'pb__locales' => 'Idiomes',
    'pb__log_files' => "Arxius de registre",
    'pb__mail' => 'Correu',
    'pb__mail_name_files' => "Arxius adjunts",
    'pb__mail_name_redirects' => "Reenviadors de correu",
    'pb__mail_name_resp_attach_add' => "Adjunt nou",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Respostes automàtiques de correu",
    'pb__mail_names' => "Correu",
    'pb__maillists' => "Llistes de correu",
    'pb__modules' => 'Mòduls',
    'pb__modules_management' => 'Gestionar mòduls',
    'pb__notifications' => "Notificacions",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Configuració de hosting físic",
    'pb__prtd_dirs' => "Directoris protegits",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Personalitzar",
    'pb__server' => "Servidor",
    'pb__sessions' => "Sessions",
    'pb__sapp_pool' => "Conjunt d'aplicacions web",
    'pb__siteapp_install' => 'Instal·lació d\'aplicacions web',
    'pb__site_app_pkgs' => 'Aplicacions web',
    'pb__site_apps' => "Aplicacions web",
    'pb__additional_key_info' => 'Propietats de la clau',
    'pb__additional_key_properties' => 'Propietats de la clau',
    'pb__skins' => 'Skins',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtre antispam",
    'pb__statistics' => "Estadístiques",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdominis",
    'pb__templates' => "Plantilles",
    'pb__virtualdirs' => 'Directoris virtuals',
    'pb__web_users' => "Usuaris web",
    'pdir__invalid_hst' => "El tipus de hosting no és vàlid. Aquest ha de ser físic.",
    'pdir__pd_id_is_undefined' => "No s'ha definit l'ID del directori protegit.",
    'pdir__pdir_exist' => "El directori amb aquest nom ja està protegit.",
    'pdir__pdir_not_exist' => "El directori protegit no existeix.",
    'pdir__pdir_usr_not_exist' => "L'usuari del directori protegit no existeix.",
    'pdir__remove_pdir_usrs' => "S'eliminaran els següents usuaris del directori protegit %2 sota el lloc web %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "S'eliminaran els següents usuaris del directori protegit %2 sota el subdomini %1:",
    'pdir__select_pdir_usrs_for_remove' => "Seleccioni els usuaris del directori protegit que desitja eliminar.",
    'pdir__select_pdirs_to_remove' => "Seleccioni els directoris que ja no desitja protegir.",
    'pdir__unable_define_pdir_users' => "No ha estat possible definir els usuaris del directori protegit.",
    'pdir__unable_define_pdirs_properties' => "No ha estat possible establir les propietats dels directoris protegits: %1",
    'pdir__unable_select_dom_param' => "No ha estat possible seleccionar els paràmetres del domini: %1",
    'pdir_ed__dir_already_protect' => "Aquest directori ja està protegit.",
    'pdir_ed__invalid_login' => "El nom d'usuari indicat no és correcte.",
    'pdir_ed__login_exists' => "Aquest usuari ja existeix. Intenti especificar un altre nom d'usuari.",
    'pdir_ed__pdir_users' => "Usuaris del directori protegit",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Seleccioni almenys una casella, ja sigui SSL/TLS o no SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "No ha estat possible crear l'usuari del directori protegit: %1",
    'pdir_ed__unable_create_pdir' => "No ha estat possible crear el directori protegit: %1",
    'pdir_ed__unable_define_hst_type' => "No ha estat possible definir el tipus de hosting.",
    'pdir_ed__unable_update_pdir' => "No ha estat possible desar la configuració del directori protegit: %1",
    'pdir_ed__wrong_symbol_in_header' => "No utilitzi el caràcter %1 al títol del directori.",
    'pdir_usr_ed__not_create_pass' => "Com a resultat no es crearà cap contrasenya pel nou usuari del directori protegit.\nAl no disposar de contrasenya, l'usuari no podrà iniciar sessió.",
    'pdir_usr_ed__unable_select_pdir_usr' => "No ha estat possible seleccionar l'usuari del directori protegit: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "No ha estat possible definir els usuaris del directori protegit: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "No ha estat possible eliminar els usuaris del directori protegit: %1",
    'phosting__anonftp_encrypt' => 'Com que la contrasenya de l\'usuari FTP està xifrada, no es pot utilitzar per a protegir el directori /plesk-stat/webstat/. Torni a introduir la seva contrasenya FTP o bé deseleccioni l\'opció "accessible mitjançant el directori protegit amb contrasenya \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "El nom de domini %%domain_name%% resol a l'adreça IP %%dns_ip_address%%. Al seu lloc web se li ha assignat l'adreça IP %%hosting_ip_address%%. Si el seu lloc web no s'obre en un navegador web quan introdueix el seu nom de domini, vagi a la pantalla de gestió del DNS (Dominis> nom del domini> DNS) i canviï les propietats del registre de recursos A − Assigni l'adreça IP %%hosting_ip_address%% al nom de domini %%domain_name%%.",
    'phosting__ip_change_warning' => "L'adreça IP ha estat modificada. Els canvis corresponents també s'han aplicar a la zona DNS del domini.",
    'phosting__other_hosting_exists_on_ip' => "No ha estat possible canviar el certificat perquè aquesta adreça IP s'utilitza en un o més comptes de hosting.",
    'phosting__unable_to_change_certificate' => "No ha estat possible instal·lar el certificat: %1",
    'phosting__unable_to_change_ip_address' => "No ha estat possible canviar l'adreça IP: %1",
    'phosting__unable_to_set_cert' => "No ha estat possible establir el certificat SSL/TLS: %1",
    'phosting__unable_update' => "No ha estat possible actualitzar la configuració de hosting: %1",
    'phosting__unable_manage' => "No ha estat possible gestionar el hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "No s'ha pogut configurar fail2ban per tal que efectuï un seguiment dels registres del domini. El seguiment es durà a terme automàticament el proper cop que es reinicii el servei fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Seleccioni un registre ACL',
    'picker_autoresponder__title' => 'Seleccioni una resposta automàtica',
    'picker_black_list__domain_name' => 'Seleccioni un nom de domini',
    'picker_certificate' => 'Seleccionar un certificat SSL/TLS',

    'picker_dns_zone_template__title' => 'Seleccioni un registre de recursos',
    'picker_domain__title' => 'Seleccioni un lloc web',
    'picker_domain_alias__title' => 'Seleccioni un àlies de domini',
    'picker_resource_record__title' => 'Seleccioni un registre de recursos',
    'picker_disabled_resource_record__title' => 'Seleccioni un servidor de noms',
    'picker_ip_address__title' => 'Seleccioni una adreça IP',
    'picker_ip_address_clients__title' => 'Seleccioni els clients que utilitzen aquesta adreça IP',
    'picker_mail_queue' => 'Seleccioni correus',
    'picker_site_application__title' => 'Seleccioni una aplicació web',
    'picker_subdomain__title' => 'Seleccioni un subdomini',
    'picker_web_user__title' => 'Seleccioni un usuari web',
    'picker_custom_button__title' => 'Seleccioni un botó personalitzat',
    'picker_license_key__title' => "Selecció de la clau de llicència",
    'picker_spamfilter_address__title' => 'Seleccioni una adreça de filtre antispam',
    'picker_white_list__networks' => 'Selecció de xarxes',

    'plesk_key__action_logs' => "Registre d'accions efectuades pels usuaris de Plesk",
    'plesk_key__app_vault' => "Application vault",
    'plesk_key__backup' => "Funcions de backup i restauració",
    'plesk_key__client_templs' => "Gestió de plans de serveis",
    'plesk_key__clients' => "Comptes d'usuari (revenedors i clients)",
    'plesk_key__resellers_only' => "Comptes d'usuari (revenedors)",
    'plesk_key__customers_only' => "Comptes d'usuari (clients)",
    'plesk_key__domains' => "Dominis",
    'plesk_key__domain_aliases' => "Àlies de domini",
    'plesk_key__subdomains_limit' => "Subdominis",
    'plesk_key__databases' => "Bases de dades",
    'plesk_key__mssql_databases' => "Bases de dades MS SQL",
    'plesk_key__manage_dashboard' => 'Personalització de la pàgina inicial',
    'plesk_key__drweb' => "Gestió de l'antivirus",
    'plesk_key__event_manager' => "Administrador d'events",
    'plesk_key__expirations' => "Gestió de les dates de caducitat dels comptes",
    'plesk_key__group_ops' => "Modificació de múltiples objectes a la vegada",
    'plesk_key__expiration' => "Data de caducitat de la clau",
    'plesk_key__edition_name' => "Edició de Plesk",
    'plesk_key__key_number' => "Número de clau",
    'plesk_key__languages' => "Paquets d'idioma",
    'plesk_key__mailnames' => "Comptes de correu",
    'plesk_key__migration_manager' => "Administrador de migracions i transferències",
    'plesk_key__mssql' => "Suport per Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Enllaços per a l'adquisició de certificats SSL/TLS i la contractació de serveis de registre de dominis",
    'plesk_key__myplesk_server_id' => "Identificador del servidor secundari MPC",
    'plesk_key__notifications' => "Gestió de notificacions",
    'plesk_key__postgresql' => "Suport pel servidor de base de dades PostgreSQL",
    'plesk_key__qmail_queue' => 'Gestió de cues de correu',
    'plesk_key__remote_db' => 'Hosting de bases de dades remotes',
    'plesk_key__slave_servers' => "Servidors secundaris",
    'plesk_key__spamassassin' => "Gestió del filtre antispam",
    'plesk_key__subdomains' => "Gestió de subdominis",
    'plesk_key__sys_access' => "Gestió d'accés al servidor",
    'plesk_key__traffic_reports' => "Informes sobre l'ús del trànsit",
    'plesk_key__tts' => "Servei d'assistència",
    'plesk_key__virtuozzo' => "Únicament vàlid per Virtuozzo containers",
    'plesk_key__webusers' => "Usuaris web",
    'plesk_key__cpu_cores' => 'Nuclis de CPU',
    'plesk_key__ram' => 'Memòria',
    'plesk_key__license_update_date' => 'Propera actualització de la clau de llicència',
    'plesk_key__autoinstaller_config' => 'Gestió de la configuració de l\'actualitzador',
    'plesk_key__check_wrong' => "La clau de llicència no és vàlida. Per tal de poder utilitzar Plesk, obtingui i instal·li una nova clau de llicència vàlida.",
    'plesk_key__upload_check_wrong' => 'La clau de llicència carregada no és vàlida.',
    'plesk_key__revert_check_wrong' => 'La clau de llicència instal·lada anteriorment no és vàlida.',
    'plesk_key__viruozzo_only_key' => 'La clau de llicència només es pot utilitzar en el cas que Plesk operi dins de Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Només pot utilitzar aquesta còpia amb llicència de Plesk amb les següents adreces IP: %2. La seva llicència no cobreix les següents adreces IP: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'La quantitat de recursos utilitzats en aquest moment excedeix els límits definits per la seva llicència.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'El número de llocs web allotjats al servidor excedeix els límits definits per la seva llicència. Té allotjats %2 llocs, mentre que la seva llicència només li permet allotjar-ne %1.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'El número d\'àlies de domini al servidor excedeix els límits definits per la seva llicència. Disposa de %2 àlies de domini, mentre que la seva llicència només li permet allotjar-ne %1.',
    'plesk_key__limits_exceeded_lim-subdom' => 'El nombre de subdominis al servidor excedeix els límits definits per la seva llicència. Disposa de %2 subdomini(s), mentre que la seva llicència només li permet allotjar-ne %1.',
    'plesk_key__limits_exceeded_lim-db' => 'El nombre de bases de dades al servidor excedeix els límits definits per la seva llicència. Disposa de %2 base(s) de dades, mentre que la seva llicència només li permet allotjar-ne %1.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'El nombre de bases de dades MS SQL al servidor excedeix els límits definits per la seva llicència. Disposa de %2 base(s) de dades, mentre que la seva llicència només li permet allotjar-ne %1.',
    'plesk_key__limits_exceeded_lim_cl' => 'El número de comptes de client servits excedeix els límits definits per la seva llicència. Actualment serveix a %2 comptes de client, mentre que la seva llicència només li permet servir-ne %1.',
    'plesk_key__limits_exceeded_lim_mn' => 'El número de comptes de correu servits excedeix els límits definits per la seva llicència. Actualment serveix a %2 comptes de correu, mentre que la seva llicència només li permet servir-ne %1.',
    'plesk_key__limits_exceeded_lim_wu' => 'El número de comptes d\'usuari web servits excedeix els límits definits per la seva llicència. Actualment serveix a %2 comptes d\'usuari web, mentre que la seva llicència només li permet servir-ne %1.',
    'plesk_key__limits_exceeded_MLS' => 'El número de paquets d\'idioma instal·lats en aquest moment excedeix els límits definits per la seva llicència. S\'han instal·lat %2 paquets d\'idioma, mentre que la seva llicència només li permet instal·lar-ne %1.',
    'plesk_key__wrong_version' => 'Està intentant utilitzar una clau de llicència creada per una altra versió de Plesk. Posi\'s en contacte amb el seu responsable comercial de Plesk per tal d\'obtenir la clau de llicència apropiada.',
    'plesk_key__other_product' => 'Està intentant utilitzar una clau de llicència creada per un altre producte. Posi\'s en contacte amb el seu responsable comercial de Plesk per tal d\'obtenir la clau de llicència apropiada.',
    'plesk_key__invalid_machine_id_trial' => 'La seva llicència actual no és vàlida perquè ja s\'ha activat en un altre servidor Plesk. Si desitja seguir utilitzant Plesk, instal·li una nova llicència o torni a instal·lar la seva llicència actual introduint el seu codi d\'activació (de disposar-ne).',
    'plesk_key__invalid_machine_id_retail' => 'La seva llicència actual no és vàlida perquè ja s\'ha activat en un altre servidor Plesk. L\'EULA de WebPros (disponible a https://www.plesk.com/legal/) prohibeix l\'ús d\'una única llicència en dos o més servidors de forma simultània. Si desitja seguir utilitzant Plesk, instal·li una nova llicència o torni a instal·lar la seva llicència actual introduint el seu codi d\'activació. Aquest se li va enviar per email quan va comprar la llicència. <br>No troba el codi d\'activació? Pot recuperar-lo emprant Plesk 360. Accedeixi a https://platform360.io/ amb l\'email que va utilitzar per comprar la llicència, vagi a la pestanya "Llicències" i allà veurà el codi d\'activació de la seva llicència. També pot posar-se en contacte amb l\'equip de suport de compres i llicències de Plesk mitjançant el formulari disponible a https://www.plesk.com/licensing-and-purchase-support/. Recordi mencionar el seu número de llicència a la secció "How can we help you?" del formulari.',
    'plesk_key__limits_exceeded_error' => 'No ha estat possible instal·lar la clau de llicència. La quantitat de recursos utilitzats en aquest moment excedeix els límits definits per la clau de llicència carregada.',
    'plesk_key__limits_exceeded_note' => 'La quantitat de recursos utilitzats en aquest moment excedeix els límits definits per la clau de llicència carregada.',
    'plesk_key__hardware_limits_exceeded' => 'La configuració de hardware excedeix els límits definits per la seva llicència de Plesk.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'El servidor té %1 de memòria instal·lada, però la seva llicència no en permet més de %2.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'El servidor té %1 nuclis de CPU instal·lats, però la seva llicència no en permet més %2.',
    'plesk_key__key_file_invalid' => 'L\'arxiu de clau carregat no és vàlid o no conté cap clau de llicència.',
    'plesk_key__server_request_error' => 'No és possible actualitzar la llicència. Comprovi que les connexions al servidor de llicències ka.plesk.com al port TCP %1 no es troben bloquejades. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Descobreixi com</a>.',
    'key__no_key_file_in_zip' => 'L\'arxiu .zip carregat no conté cap arxiu de clau',
    'key__key_upload' => 'Instal·lació d\'una clau de llicència',
    'additional_key__prop_name' => 'Propietat',
    'additional_key__prop_value' => 'Valor',
    'additional_key__descr_name' => 'Nom de la clau',
    'additional_key__descr_key_number' => 'Número de clau',
    'additional_key__descr_key_vz' => "Aquesta clau de llicència només es pot utilitzar a Virtuozzo containers.",
    'additional_key__descr_key_mailboxes' => 'Bústies de correu',
    'additional_key__descr_lim_date' => 'Data de caducitat',
    'additional_key__descr_license_update_date' => 'Propera actualització de la clau de llicència',
    'additional_key__file_invalid' => 'L\'arxiu de clau carregat no és vàlid o no conté cap clau de llicència.',
    'additional_key__file_incompatible' => 'L\'arxiu de clau carregat no és vàlid per aquesta aplicació.',
    'additional_key__not_exists' => 'No s\'ha instal·lat cap clau de llicència.',
    'additional_key_update__result_response' => 'Resposta del servidor de llicències: %1',
    'additional_key_update__result_network' => 'No ha estat possible connectar-se al servidor de llicències. Comprovi que la seva xarxa permet la comunicació amb %1: %2.',
    'additional_key_update__result_lock' => 'Actualització de la clau en curs',
    'additional_key_update__result_internal_error' => 'S\'ha produït un error mentre s\'actualitzava la clau de llicència: %1',

    'proceed_to_cl_pool' => "Procedir a la configuració del grup d'adreces IP del client",
    'proceed_to_hosting_setup' => "Procedir a la configuració de hosting",
    'removeCerts__remove_certificates_cp' => "S'eliminaran els següents certificats: ",
    'removeCerts__remove_certificates_domain' => "S'eliminaran els següents certificats, propietat de %1: ",
    'removeClientsIP_remove_clients_ip' => "Aquesta adreça IP s'eliminarà dels grups d'adreces IP dels següents clients:",
    'removeMailAliases__remove_mail_aliases' => "S'eliminaran els següents àlies de correu pel compte de correu %1:",
    'removeMailNames__remove_mailnames' => "S'eliminaran els següents àlies i comptes de correu del domini %1:",
    'removeMailNames__remove_mailnames_of_cl' => "S'eliminaran els següents àlies i comptes de correu del domini %2, propietat del client %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Aquests comptes de correu no seran eliminats.",
    'removeFtpSessions__remove_title' => "Es finalitzaran les següents sessions FTP:",
    'removeTemplates__remove_templates' => "S'eliminaran les següents plantilles:",
    'resp_edit__always_respond' => "sempre respondre",
    'resp_edit__reply_subject' => "Assumpte del correu de resposta",
    'resp_edit__answer_subject' => "Respondre amb assumpte",
    'resp_edit__answer_txt' => "Respondre amb text",
    'resp_edit__attach' => "Adjuntar arxius",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "per ",
    'resp_edit__frw_rqst_email' => "En cas de resposta automàtica, reenviar el correu original a l'adreça especificada",
    'resp_edit__fwd_email_invalid' => "L'adreça de destí no és vàlida.",
    'resp_edit__in_body' => "quan al cos del correu es trobin les paraules especificades",
    'resp_edit__in_subject' => "quan a l'assumpte del correu es trobin les paraules especificades",
    'resp_edit__invalid_resp_freq' => "La freqüència de resposta no és vàlida.",
    'resp_edit__invalid_rqst_txt' => "El text de la petició no és vàlid.",
    'resp_edit__invalid_store_lim_num' => "El valor de límit no és vàlid.",
    'resp_edit__limits_title' => "Límits",
    'resp_edit__maximum_allowed_resp_freq_reached' => "El número màxim de respostes diàries excedeix la tasa definida. Es permet: %1, sol·licitat: %2",
    'resp_edit__no_files_sel' => "No ha seleccionat cap arxiu.",
    'resp_edit__no_txt_supplied' => "No s'ha proporcionat cap text.",
    'resp_edit__reply_title' => "Respondre",
    'resp_edit__reply_to_address' => "Adreça de resposta",
    'resp_edit__reply_to_invalid' => "L'adreça de resposta no és vàlida.",
    'resp_edit__reply_uniq_email' => "Respondre a una mateixa adreça de correu no més de",
    'resp_edit__conditions_title' => "Condicions",
    'resp_edit__request_title' => "Sol·licitar",
    'resp_edit__resp' => "Resposta automàtica",
    'resp_edit__resp_name' => "Nom de la resposta automàtica",
    'resp_edit__resp_not_exist' => "La resposta automàtica no existeix.",
    'resp_edit__resp_status' => "Estat de la resposta automàtica",
    'resp_edit__rqst_txt' => 'Indiqui la condició per aquesta resposta automàtica',
    'resp_edit__select_files_on_server_for_attach' => "Seleccioni els arxius que desitja adjuntar",
    'resp_edit__store_up_to' => "Emmagatzemar fins a",
    'resp_edit__subj_line_invalid' => "La línia d'assumpte no és correcta.",
    'resp_edit__text_too_big' => "El text del correu de resposta és massa llarg.",
    'resp_edit__times_in_a_day' => "vegades al dia.",
    'resp_edit__unable_define_resp_cond' => "No ha estat possible definir la condició de la resposta automàtica: %1",
    'resp_edit__unable_define_resp_status' => "No ha estat possible definir l'estat de la resposta automàtica: %1",
    'resp_edit__unable_turn_on_resp' => "No ha estat possible activar la resposta automàtica: %1",
    'resp_edit__uniq_email' => "adreces de correu úniques",
    'resp_edit__content_type' => 'Format d\'enviament de correu',
    'resp_edit__content_type_text' => 'Text sense format',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codificació',
    'restart__dns' => 'Servidor DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Servidor IMAP/POP3 (%1)",
    'restart__mssql' => "Servidor Microsoft SQL",
    'restart__mysql' => "Servidor de MariaDB/MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Serveis",
    'restart__smtp' => "Servidor SMTP (%1)",
    'restart__spamd' => "Filtre antispam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Servidor web (%1)",
    'restart__ftp' => "Servidor FTP (%1)",
    'restart__service_start' => 'Esperi uns minuts fins que s\'iniciï el servei.',
    'restart__service_stop' => 'Esperi uns minuts fins que s\'aturi el servei.',
    'restart__service_restart' => 'Esperi uns minuts fins que es reiniciï el servei.',
    'rm_domains__some_domains_are_not_exist' => "Alguns dels dominis indicats no existeixen. Possiblement han estat eliminats per un altre usuari.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "GCorreu",
    'rpt_cl_dom_mail_lists' => "LlisCorreu",
    'rpt_cl_dom_mail_resps' => "Resp.Aut",
    'rpt_cl_dom_mail_antispam' => "Antispam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "Bcorreu",
    'rpt_cl_dom_redirects' => "Redireccionaments",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "ÀliesDom",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Informe per l'administrador %1",
    'rpt_cl_report_for_reseller__' => "Informe pel revenedor %1",
    'rpt_cl_report_for_cl__' => "Informe sobre el client %1",
    'rpt_cl_section_domains' => "Dominis",
    'rpt_cl_section_full_domains' => "Dominis",
    'rpt_cl_section_general' => "General",
    'rpt_create' => "Crear informe",
    'rpt_empty' => "L'informe almenys hauria d'incloure una secció",
    'rpt_dom_report_for_dom__' => "Informe de domini per %1",
    'rpt_dom_section_databases' => "Bases de dades",
    'rpt_dom_section_full_databases' => "Bases de dades",
    'rpt_dom_section_full_maillists' => "Llistes de correu",
    'rpt_dom_section_full_mailnames' => "Comptes de correu",
    'rpt_dom_section_full_webusers' => "Usuaris web",
    'rpt_dom_section_full_siteapps' => 'Aplicacions web',
    'rpt_dom_section_full_aspnetapps' => 'Aplicacions web ASP.NET',
    'rpt_dom_section_general' => "General",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Llistes de correu",
    'rpt_dom_section_mailnames' => "Comptes de correu",
    'rpt_dom_section_siteapps' => 'Aplicacions web',
    'rpt_dom_section_aspnetapps' => 'Aplicacions web ASP.NET',
    'rpt_dom_section_webusers' => "Usuaris web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Editar informe %1",
    'rpt_enter_email_address' => "Introdueixi l'adreça de correu on s'enviarà l'informe.",
    'rpt_list' => "Presentacions d'informe personalitzades",
    'rpt_section_full' => "Complet",
    'rpt_section_none' => "Cap",
    'rpt_section_summary' => "Resum",
    'rpt_default_full' => 'Informe complet',
    'rpt_default_summary' => 'Informe resumit',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Error a l'enviar l'informe: %1",
    'rpt_send_report_by_email_ok__' => "L'informe s'ha enviat a %1",
    'sa_action' => "Acció",
    'sa_action_del' => "Eliminar",
    'sa_action_desc' => "Accions a realitzar amb el correu spam",
    'sa_action_save' => "Marcar com spam i desar a la bústia de correu",
    'sa_admin_blacklist' => "Llista negra de l'administrador",
    'sa_admin_whitelist' => "Llista blanca de l'administrador",
    'sa_db_del_confirm' => "Està segur que desitja esborrar la base de dades del filtre antispam?",
    'sa_eml_in_ignorelist' => "L'email està present a la llista d'ignorats",
    'sa_empty_email' => "No es poden afegir patrons de correu buits.",
    'sa_exists_email' => "Aquest patró de correu ja existeix.",
    'sa_disabled__mailname_not_filtering' => "La configuració actual del servidor no permet l'ús de la filtració del correu per aquest compte de correu",
    'sa_disabled__filtering_is_disabled' => 'L\'administrador del servidor ha desactivat la filtració d\'spam',
    'sa_disabled__hasnt_mailbox' => "No és possible activar la filtració d'spam si no es disposa de cap bústia de correu",
    'sa_enable_filter' => "Activar filtració d'spam",
    'sa_forget' => "oblidar",
    'sa_from' => "Des de",
    'sa_ham' => "correu desitjat",
    'sa_pattern_is_invalid' => "El patró no és vàlid.",
    'sa_spam' => "Spam",
    'sa_trainer__page_title' => 'Aprenentatge del filtre antispam',
    'sa_trainer__tools_legend' => 'Eines',
    'sa_trainer__info_legend' => 'Informació',
    'sa_trainer__messages_list_legend' => 'Missatges a la seva bústia de correu',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Assumpte',
    'sa_trainer__from' => 'Des de',
    'sa_trainer__date' => 'Data',
    'sa_trainer__info_text' => 'Missatges apresos: %1 com spam, %2 com a no spam, %3 en total.',
    'sa_trainer__messages' => 'missatge(s)',
    'sa_trainer__select__all' => 'Tots',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'No spam',
    'sa_trainer__select__unknown_only' => 'Desconegut',
    'sa_trainer__cannot_remove_messages' => 'Els correus seleccionats no es poden eliminar de la bústia de correu.',
    'sa_trainer__remove_messages_confirm' => 'Està segur que desitja eliminar els missatges seleccionats de la bústia de correu?',
    'sa_subj' => "Assumpte",
    'sa_training' => "Aprenentatge del filtre antispam",
    'sa_training_legend' => "Aprenentatge del filtre antispam bayesian",
    'sa_use_srv_settings' => "Utilitzar configuració a nivell del servidor",
    'sa_user_blacklist' => "Llista negra de l'usuari",
    'sa_user_whitelist' => "Llista blanca de l'usuari",
    'sa_usr_disabled_by_srv' => "L'administrador del servidor no permet establir una configuració individual del filtre antispam",
    'sa_usr_no_postbox' => "No és possible activar la filtració d'spam perquè la bústia de correu està desactivada per aquest compte de correu electrònic.",
    'sa_filters' => 'Filtres antispam',
    'spamfilter__tools_legend' => 'Eines',
    'spamfilter__prefs_legend' => 'Configuració',
    'spamfilter__max_children' => 'Número màxim de processos de treball spamd a executar',
    'spamfilter__rewrite_header_subject_hint' => 'Si no desitja afegir cap text, deixi aquest camp en blanc. Si desitja incloure la puntuació a l\'assumpte del correu, introdueixi _SCORE_ .',
    'spamfilter__reject_spam' => 'Eliminar el correu spam quan arribi a la bústia de correu',
    'spamfilter__enabled' => 'Activada',
    'spamfilter_addresses_list__items' => 'adreces',
    'spamfilter_addresses__remove_title' => 'Les següents adreces s\'eliminaran de la llista:',
    'spamfilter_addresses__empty_selection' => 'No ha seleccionat cap adreça.',
    'server__admin_info' => "Informació de l'administrador",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Introdueixi a continuació la descripció de l'error",
    'server__power_management' => "Administració d'energia",
    'server__services' => "Serveis",
    'server__system' => "Sistema",
    'server__title' => "Administració del servidor",
    'server_preferences__admin_skin' => "Skin de la interfície de l'administrador",
    'server_preferences__default_language' => "Idioma predeterminat",
    'server_preferences__default_skin' => "Skin predeterminat",
    'server_preferences__restart_apache_interval' => "Interval de reinici d'Apache",
    'server_preferences__system' => 'Configuració del sistema',
    'mail__tabs_preferences' => "Configuració",
    'mail__tabs_white_list' => "Llista blanca",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Comprovi les contrasenyes per les bústies de correu al diccionari",
    'sessions__agreement' => "Sí, desitjo finalitzar aquestes sessions.",
    'sessions__select_sessions_for_remove' => "Seleccioni les sessions que desitja finalitzar.",
    'sessions__tabs_cp_sessions' => 'Sessions de Plesk',
    'sessions__tabs_ftp_sessions' => 'Sessions FTP',
    'sessions__ftp_sessions_login' => 'Nom d\'usuari del compte FTP',
    'sessions__ftp_sessions_domain' => 'Nom de domini',
    'sessions__ftp_sessions_path' => 'Ubicació actual',
    'sessions__ftp_sessions_file' => 'Nom de l\'arxiu',
    'sessions__ftp_sessions_action' => 'Estat',
    'sessions__ftp_sessions_speed' => 'Velocitat, KB/S',
    'sessions__ftp_sessions_comp' => 'Progrés, %',

    'site_apps__access_level' => 'Nivell d\'accés',
    'site_apps__access_level_commercial' => 'Comercial',
    'site_apps__access_level_free' => 'Gratuïta',
    'site_apps__action_installer' => "Instal·lació d'aplicacions web",
    'site_apps__action_reconfigure' => "Reconfiguració d'aplicació web",
    'site_apps__custom_button_level' => 'Desitja crear un botó personalitzat per accedir a aquesta aplicació?',
    'site_apps__custom_button_level_false_domain_user_only' => 'No',
    'site_apps__custom_button_level_domain_user_only' => 'Sí',
    'site_apps__custom_button_level_false' => 'No',
    'site_apps__custom_button_level_domain' => 'Sí i fer que només estigui disponible pel domini actual',
    'site_apps__custom_button_level_client' => 'Sí i fer que estigui disponible per tots els dominis del client',
    'site_apps__custom_button_level_admin' => 'Sí i fer que estigui disponible per tots els dominis',
    'site_apps__description' => "Descripció",
    'site_apps__dir_used_by_sapp__' => "El directori \"%1\" és utilitzat per una altra aplicació web",
    'site_apps__dir_used_by_unknown__' => "El directori \"%1\" ja existeix. De continuar, es sobreescriurà el seu contingut.",
    'site_apps__dir_invalid_name__' => "El nom del directori %1 no és correcte",
    'site_apps__file_name' => 'Nom d\'arxiu de l\'aplicació web',
    'site_apps__invalid_install_prefix' => "Prefix d'instal·lació no vàlid",
    'site_apps__invalid_package' => "L'aplicació web no és vàlida",
    'site_apps__key_status' => 'Llicència',
    'site_apps__key_status_free' => 'Es distribueix de forma gratuïta. No es necessita cap clau de llicència.',
    'site_apps__key_status_ok' => 'La clau de llicència requerida està instal·lada.',
    'site_apps__key_status_problem' => 'La clau de llicència requerida no està instal·lada.',
    'site_apps__name' => "Nom",
    'site_apps__no_domains' => 'L\'aplicació web no es pot instal·lar. Ja hi ha una altra aplicació web instal·lada al directori arrel d\'aquest domini. Consideri crear un subdomini per l\'aplicació web.',
    'site_apps__package_info_' => "Informació de l'aplicació web",
    'site_apps__package_integrated' => "aplicació integrada, no es pot eliminar",
    'site_apps__pool_select_packages_to_add' => 'Seleccioni les aplicacions web que desitja afegir a l\'inventari',
    'site_apps__release' => "Build",
    'site_apps__resource_used_by_sapp' => "Aquest recurs l'està utilitzant l'aplicació web instal·lada",
    'site_apps__root_used_by_sapp' => "Aquest recurs l'està utilitzant una aplicació web instal·lada",
    'site_apps__these_domains_will_not_delete' => 'Aquests subdominis no seran eliminats',
    'site_apps__upload_site_app_pkg_title' => 'Carregar aplicació web nova',
    'site_apps__version' => "Versió",
    'site_apps__access_to' => "Accés a %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "No ha estat possible descomprimir l'arxiu comprimit: Probablement, Archiver no està instal·lat al servidor. Posi's en contacte amb l'administrador de {$PROD_NAME} per tal que l'hi instal·li el software.",
    'skeleton__archive_corrupted' => "La prova ha detectat que l'arxiu comprimit està malmès o bé que és d'un tipus no suportat.",
    'skeleton__archive_too_large' => "La prova ha detectat que l'arxiu comprimit és massa gran.",
    'skeleton__not_supported_archive_type' => "No es suporta aquest tipus d'arxiu comprimit (arxiu %1).",
    'skin_download__title' => 'Descarregar skin',
    'skin_download_now__title' => 'Descàrrega d\'skin en curs',
    'skin_download_now__text' => 'En aquest moment s\'està creant el paquet d\'skins.<br>Aquest procediment pot tardar una estona.<br> Un cop aparegui la finestra de diàleg, pot seguir utilitzant Plesk amb normalitat.',
    'skin_file__help_for_using_types' => "Utilitzi els arxius comprimits de l'skin en un dels següents formats:",
    'skin_info__title' => 'Propietats de l\'skin',
    'skin_mng_err__rpm_not_skin' => 'Aquest RPM no és un paquet d\'skins de Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Error a l\'instal·lar l\'skin rpm-based a l\'ubicació especificada.',
    'skin_mng_err__already_exists' => 'El directori d\'instal·lació de l\'skin ja existeix i ja s\'ha desplegat un paquet d\'skins.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'L\'arxiu carregat no és un paquet d\'skins RPM vàlid.',
    'skin_mng_err__rpm_upgrade_noskin' => 'L\'arxiu carregat no és un paquet d\'skins vàlid.',
    'skin_mng_err__rpm_upgrade_base' => "L'arxiu carregat no és un paquet d'skins vàlid de {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'No ha estat possible instal·lar l\'skin. El format de l\'skin no és vàlid.',
    'skin_mng_err__no_a_skin' => "L'arxiu carregat no és un paquet d'skins vàlid de {$PROD_NAME}.",
    'skin_upload__title' => 'Carregar skin nou',
    'skin_upload__already_exists' => "L'skin '%1' ja existeix.",
    'skin_upload__unable_to_apply' => "L'arxiu de clau carregat no conté cap skin de Plesk o bé no es suporta el format de l'arxiu comprimit.",
    'skin_upload__unable_to_rename__' => "No ha estat possible canviar el nom de l'skin %2 a %1: %3.",
    'skin_upload__file_name' => 'Ruta a l\'arxiu del paquet d\'skins',
    'skins_list__title' => 'Repositori d\'skins',
    'skins_remove__title' => 'Eliminació d\'skins',
    'skins_remove__select_skins_for_remove' => 'Seleccioni els skins que desitja eliminar',

    'spf__unable_update' => 'No ha estat possible actualitzar els paràmetres SPF',
    'statistics__active_domains' => "Dominis actius",
    'statistics__clients' => "Clients",
    'statistics__subdomains' => "Subdominis",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Bases de dades",
    'statistics__db_users' => "Usuaris de la base de dades",
    'statistics__dirs' => "Directoris protegits",
    'statistics__dom_active' => "Actiu",
    'statistics__dom_passive' => "Passiu",
    'statistics__dom_problem' => "Problema",
    'statistics__domains' => "Dominis",
    'statistics__domains_with_host' => "Dominis amb hosting",
    'statistics__doms' => "Dominis ",
    'statistics__filesystem' => "Sistema d'arxius",
    'statistics__general' => "General",
    'statistics__hdd_available' => "Disponible",
    'statistics__hdd_capacity' => "Capacitat",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Ús del disc dur",
    'statistics__hdd_used' => "Utilitzat",
    'statistics__ip' => "Adreça IP",
    'statistics__key_number' => "Número de clau",
    'statistics__l1' => "Últim minut",
    'statistics__l15' => "Últims 15 minuts",
    'statistics__l5' => "Últims 5 minuts",
    'statistics__la' => "Ús de la CPU",
    'statistics__mail_autoresponders' => "Respostes automàtiques",
    'statistics__mail_boxes' => "Bústies de correu",
    'statistics__mail_groups' => "Grups de correu",
    'statistics__mail_lists' => "Llistes de correu",
    'statistics__mail_redirects' => "Reenviadors de correu",
    'statistics__mem' => "Ús de la memòria",
    'statistics__mem_usage' => "Ús",
    'statistics__memory_available' => "Disponible",
    'statistics__memory_buffer' => "Búfer",
    'statistics__memory_cached' => "En memòria cau",
    'statistics__memory_free' => "Buit",
    'statistics__memory_shared' => "Compartida",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Utilitzat",
    'statistics__os' => "SO",
    'statistics__problem_clients' => "Clients amb incidències",
    'statistics__problem_domains' => "Dominis amb incidències",
    'statistics__swap' => "Ús d'swap",
    'statistics__swap_free' => "Buit",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Ús",
    'statistics__swap_used' => "Utilitzat",
    'statistics__system_stat' => "Informació del servidor",
    'statistics__unable_define_active_doms' => "No ha estat possible determinar el número de dominis actius: %1",
    'statistics__unable_define_inactive_doms' => "No ha estat possible determinar el número de dominis inactius: %1",
    'statistics__failed_define_swap_usage' => 'No s\'ha pogut definir l\'ús d\'swap',
    'statistics__failed_define_load_averages' => 'No s\'han pogut definir les mitjanes de càrrega',
    'statistics__up_time' => "Sistema funcionant des de: ",
    'statistics__ver' => "Versió",
    'statistics__web_users' => "Usuaris web",
    'statistics__mem_win' => "Ús de la memòria física",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Utilitzat",
    'statistics__memory_free_win' => "Disponible",
    'statistics__swap_win' => "Ús de la memòria virtual",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Utilitzat",
    'statistics__swap_free_win' => "Disponible",
    'status__domain_has_reasons_to_be_off' => "El domini segueix suspès pel següent motiu: %1",
    'subdomain__create__' => "Crear un subdomini al domini %1",
    'subdomain__edit__' => "Gestionar el subdomini %1",
    'subdomain__invalid_name' => "El nom del subdomini no és vàlid. Utilitzi únicament símbols alfanumèrics i guions.",
    'subdomain__incorrect_name' => "El nom del subdomini no és vàlid.",
    'subdomains__maillists_enabled_in_domain' => "Llista de noms de subdominis incorrecta.%1. Aquest nom de domini ja l'utilitzen llistes de correu sota el domini %1.",
    'subdomains__dalias_exists' => 'Ja existeix un àlies de domini amb aquest nom.',
    'subdomains__name_exists' => "Ja existeix un subdomini amb aquest nom.",
    'subdomains__regular_domain_exists' => "Ja existeix un domini amb aquest nom.",
    'subdomains__domain_alias_exists' => 'Ja existeix un àlies de domini amb aquest nom.',
    'subdomains__remove_subdomains_on_domain' => "S'eliminaran els següents subdominis pel domini %1:",
    'subdomains__select_subdomains_for_remove' => "Seleccioni els subdominis que desitja eliminar.",
    'subdomains__webmail_enabled_in_domain' => "Webmail del nom de subdomini incorrecte.%1. Aquest nom de domini s'utilitza per accedir al webmail sota el domini %1.",
    'subdomains__dns_record_already_exists' => 'No ha estat possible crear el subdomini %1 perquè ja hi ha un registre DNS que apunta al host %1.',
    'subdomains__www_prefix_in_domain' => "Nom de subdomini incorrecte www.%1. El domini %1 ja té el prefix WWW.",
    'subdomains__user_type_quota_exceeds' => 'No ha estat possible canviar el compte d\'usuari perquè s\'excediria l\'espai al disc assignat.',
    'subdomains__creation_in_dns_slave' => "El servidor de noms de Plesk actua com a servidor de noms secundari per aquest domini. Per tal que el seu subdomini resolgui correctament, comprovi que l'arxiu de zona al servidor DNS principal conté el registre %1.",
    'sys_user__attributes_not_changed' => "\nEls atributs del següent usuari del sistema no s'han modificat: %1",
    'sys_user__no_access_without_password' => "No ha establert cap contrasenya. Tot i que es crearà l'usuari del sistema, no podrà accedir al sistema fins que se li estableixi una contrasenya. Desitja continuar?",
    'sys_user__no_hard_quota' => "no suportat",
    'sysuser__zero_quota_is_unlimited' => "0 en el cas d'il·limitat",
    'template__num_excl_ips' => "Assignar adreces IP dedicades al client",
    'template__sel_sh_ips' => "Adreces IP compartides seleccionades",
    'template__av_sh_ips' => "Adreces IP compartides disponibles",
    'template__up_to_excl_ip' => "Fins a %1 adreces IP",
    'templates__all_clients' => "tots els clients",
    'templates__cl_domain_templates' => "Plantilles per %1",
    'templates__cl_templates' => "Plantilles de client",
    'time__invalid_ip' => "Nom del domini o adreça IP incorrecta.",
    '__please_select_country' => 'Seleccioni el seu país',
    'time__unable_set_time' => "No ha estat possible establir l'hora del sistema: %1",
    'time__sinchronization_setup_error' => 'No ha estat possible configurar la sincronització d\'hora: error de timemng: %1',
    'time__sinchronization_disable_error' => 'No s\'ha pogut desactivar la sincronització d\'hora: error de timemng: %1',
    'tmpl__create' => "Crear plantilla",
    'tmpl__edit__' => 'Plantilla %1',
    'tmpl__logrotation_warn' => "La rotació de registres al domini creat per aquesta plantilla només s'efectuarà si posteriorment es crea un compte de hosting físic per aquest.",
    'tmpl__name' => "Nom de la plantilla",
    'tmpl__dom_exist' => "A l'inventari de plantilles del client o de l'administrador ja existeix una plantilla de domini amb aquest nom.",
    'tmpl__name_invalid' => "El nom de la plantilla no és vàlid o està buit.",
    'tmpl__use_next_ip_addr' => "S'utilitzarà la següent adreça IP vacant",
    'tmpl_name_already_exists' => "Ja existeix una plantilla anomenada '%1'.",

    'vh_based__no_free_ip_for_vh' => "No hi ha cap adreça IP vacant pel hosting virtual basat en IP. Afegeixi una adreça IP.",

    'wu__at_domains_text' => "Permetre el format d'accés webuser@%1",
    'wu__unable_create' => "No ha estat possible crear l'usuari web: %1",
    'wu_edit__disk_quota' => "Quota de disc",
    'wu_edit__invalid_pass' => "La contrasenya no és vàlida.",
    'wu_edit__invalid_quota' => "El valor de quota d'espai al disc especificat no és vàlid. Indiqui un número enter positiu.",
    'wu_edit__invalid_quota_value' => "La quota d'espai al disc especificada és inferior a l'utilitzada en aquests moments (%1MB). Com a conseqüència, és possible que alguna funcionalitat deixi d'estar disponible. Està segur que desitja continuar?",
    'wu_edit__not_create_pass' => "Com a resultat d'aquesta acció no es crearà cap contrasenya pel nou usuari web.\nAl no disposar de contrasenya, l'usuari no podrà iniciar sessió.",
    'wu_edit__unable_update' => "No ha estat possible actualitzar la propietat de l'usuari web: %1",

    'dns__tabs_general' => 'Configuració de zona',
    'dns__tabs_zone_settings' => 'Registres SOA',
    'soa__seconds' => 'segons',
    'soa__minutes' => 'minuts',
    'soa__hours' => 'hores',
    'soa__days' => 'dies',

    'DomainSubdirectory' => 'Subdirectori de destí',

    'filemanager__select_codepage' => 'Seleccionar pàgina de codi:',

    'bt_server_app_add' => 'Afegir aplicació de servidor',
    'packages_list' => 'Aplicacions de servidor',

    'bt_packages_management' => 'Gestió de paquets',
    'pb__packages_management' => 'Gestió d\'aplicacions',
    'bt_package_new' => 'Afegir aplicació',
    '__packages' => 'Aplicacions de servidor',

    'dom_ctrl__mysql_dbase_space' => 'Quota total de bases de dades MariaDB/MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Quota total de bases de dades MS SQL',

    'dns_add__enter_ixfr_path' => 'Introduir la ruta IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'El registre SPF TXT ja existeix. Només hi pot haver un registre SPF. Per afegir un registre, abans cal que elimini el registre existent.',

    'component_name__network' => 'Funcions de xarxa',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Establir skin',
    'bt_set_skin' => 'Establir skin',
    'firewall__rule_already_exists' => 'Ja existeix una regla anomenada "%1"',
    'firewall__rule_readonly' => 'La regla "%1" és només lectura',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Protecció antivirus',
    'antivirus__antivirus_direction_off' => 'Desactivat',
    'antivirus__antivirus_direction_any' => 'Correu entrant i sortint',
    'antivirus__antivirus_direction_from' => 'Només correu sortint',
    'antivirus__antivirus_direction_to' => 'Només correu entrant',
    'antivirus__unable_to_update_settings' => 'No ha estat possible canviar la configuració de l\'antivirus: %1',




    '__normal' => 'Normal',
    '__low' => 'baixa',
    '__high' => 'elevada',

    'mail__antivirus' => "Antivirus dels servidors de correu interns",
    'mail__use_internal_antivirus' => 'Utilitzar antivirus intern',

    'sa__tabs_blacklist' => 'Llista negra',

    '__mysql_databases' => 'Bases de dades MariaDB/MySQL',

    'cl_perm__mysql_dbase_space' => 'Quota total de bases de dades MariaDB/MySQL',
    'cl_perm__mssql_dbase_space' => 'Quota total de bases de dades MS SQL',
    'cl_perm__max_mssql_db' => 'Número màxim de bases de dades Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Quota total de bústies de correu',

    'i_i_cl_on' => 'El compte de client està actiu.',
    'i_i_cl_off_by_admin' => 'El compte de client ha estat suspès per l\'administrador.',

    'sa_exists_tn' => 'La xarxa ja està present a la llista.',

    'defaultcomponents__not_activated' => 'no activat',

    'bt_traffic_at_domains' => 'Trànsit',

    '__awstats_perl_warning' => 'Si no té instal·lat Perl, AWStats no permetrà als usuaris examinar les estadístiques dels anys anteriors.',

    'class_client__mysql_dbase_space' => 'El valor excedeix el límit del client.',
    'class_client__mssql_dbase_space' => 'El valor excedeix el límit del client.',
    'class_client__max_mssql_db' => 'El valor excedeix el límit del client.',

    'dns__remove_transfer_restrictions_list_items' => 'Les següents xarxes s\'eliminaran de la llista de control d\'accés:',

    'bt_up' => "Amunt",
    'bt_down' => "Avall",

    'bt_install_selected' => 'Instal·lar claus de llicència seleccionades', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'El domini resol a una altra adreça IP: (%1). Corregeixi la configuració de DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'En aquests moments, el servidor de correu utilitzat no suporta l\'activació simultània de grups de correu i bústies de correu. Faci clic a ACCEPTAR per a activar la bústia de correu i desactivar els grups de correu. Faci clic a Cancel·lar per a no efectuar cap canvi.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'En aquests moments, el servidor de correu utilitzat no suporta l\'activació simultània de grups de correu i bústies de correu. Faci clic a ACCEPTAR per a activar els grups de correu i desactivar la bústia de correu. Faci clic a Cancel·lar per a no efectuar cap canvi.',

    'mysql_dbase_space_limit' => 'Límit d\'espai de la base de dades MariaDB/MySQL',
    'mysql_dbase_usage' => 'Ús de l\'espai de la base de dades MariaDB/MySQL',
    'mssql_dbase_space_limit' => 'Límit d\'espai de la base de dades Microsoft SQL Server',
    'mssql_dbase_usage' => 'Ús de l\'espai de la base de dades Microsoft SQL Server',

    '__statistics' => "Estadístiques", //indirect

    'dns__soa_minimum_value_is_big' => 'Establir un valor de TTL mínim a més de 3 hores pot fer que alguns administradors de domini ja no puguin accedir als seus dominis. Per aquest motiu li recomanem establir aquest valor únicament si així li insisteix el seu registrador de noms de domini.',

    'virusfilter__interface_not_available' => 'No hi ha cap filtre antivirus disponible.',
    'virusfilter__none_virus_filter' => 'Cap',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'desactivat',
    'virusfilter__status_any' => 'correu entrant i sortint',
    'virusfilter__status_outgoing' => 'només correu sortint',
    'virusfilter__status_incoming' => 'només correu entrant',

    'visibility__root_override_parse_error' => 'Hi ha un error de sintaxi a l\'arxiu %1, concretament a la línia %2.',

    'sb__not_support_publishing_api' => "El component no suporta la publicació automatitzada",

    'component_name__cphosting' => "Hosting de Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'El servidor de correu actual no suporta la configuració de la quota de bústies de correu.',
    '__unable_get_total_mboxes_quota' => 'El servidor de correu actual no suporta la configuració de la quota de bústies de correu.',

    'install_prefix__parent_not_exists' => "El directori principal no existeix",

    'bt_change_version' => 'Canviar la versió',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Seleccionar tot",
    '__uncheck_all' => "Deseleccionar tot",

    'dns__editing_domain_controller_zone' => "L'edició dels registres de la zona DNS pel controlador del domini pot ocasionar problemes relacionats amb el funcionament del domini",

    'pb__interface_management' => "Gestió de la interfície",
    'interface_management__tabs_skins' => "Skins",
    'interface_management__tabs_interface_templates' => "Plantilles d'interfície",
    'interface_management__tabs_locales' => "Idiomes",
    'locales_list__title' => "Repositori de paquets d'idioma",
    'locales_list__legend' => "Idiomes disponibles",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Paquet d'idioma",
    'locales_list__lang_title' => "Idioma",
    'locales_list__country_title' => "País",
    'locales_list__used_title' => "Utilitzat",

    'backup__suspend_warning_during_backup' => "Durant el procés de backup, el domini no estarà disponible.",
    'backup__suspend_warning_during_restore' => "Durant el procés de restauració, el domini no estarà disponible.",
    'backup__suspend_domain' => "Suspendre domini",

    'locales_list__mls_limit' => "La seva llicència actual de Plesk li permet utilitzar %2 idiomes. En aquest moment els usuaris tenen a la seva disposició %1 idiomes, el que excedeix el número proporcionat per la llicència. Seleccioni els %2 idiomes que desitja utilitzar i deshabiliti la resta d'idiomes fent clic a les seves icones a la columna 'S'.",

    'bt_change_owner' => 'Assignar nou propietari',
    'chown__limit_name' => 'Nom del recurs',
    'chown__error_limits' => "No ha estat possible continuar amb la transferència de la subscripció. Aquesta subscripció requereix més recursos dels proporcionats pel proveïdor del nou propietari.",
    'chown__error_empty_ip_pool' => "No ha estat possible continuar amb la transferència de la subscripció. El grup d'adreces IP del proveïdor del nou propietari està buit. Comprovi que aquest proveïdor almenys disposa d'una adreça IP al grup.",

    'backup__backup_time' => 'Hora del backup',
    'backup__backup_time_hour' => 'hores',
    'backup__backup_time_minute' => 'minuts',
    'backup__every' => 'cada',
    'backup__day_of_month' => 'dia de mes',

    'subdomain__select_hst_type' => 'Seleccioni el tipus de hosting pel subdomini',
    'hst_sel__subdom_subfolder_hst' => 'Subdomini en una subcarpeta',
    'subdomain__www_root_folder_not_exists' => 'El directori inicial del lloc %1 no existeix.',
    '__site_home_dir' => 'Directori inicial del lloc',
    'subdomain__aspnet_disabled_domain' => 'desactivat pel domini',

    'domains__remove_description' => 'Totes del dades del domini, incloent el contingut i la configuració del domini i dels subdominis respectius, dades d\'aplicacions web, continguts de les bústies de correu, correu, configuració de la filtració d\'spam i virus, arxius de registre, dades del repositori de backup del domini i certificats SSL/TLS seran eliminades. Si no disposa de cap arxiu de backup a la seva màquina local, totes les dades es perdran permanentment.',
    'subdomains__remove_description' => 'S\'eliminaran totes les dades del subdomini, incloent la configuració i el contingut del subdomini, les dades de les aplicacions web i els arxius de registre. Si no disposa de cap arxiu de backup a la seva màquina local, totes les dades es perdran permanentment.',

    'mail__tabs_spam_filtering' => 'Filtració d\'spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Utilitzar la configuració predeterminada a nivell del servidor (Detectar)',
    'antivirus__use_server_settings_no_scan' => 'Utilitzar la configuració predeterminada a nivell del servidor (No detectar)',
    'antivirus__check_for_viruses' => 'Detectar virus',
    'antivirus__dont_check_for_viruses' => 'No detectar virus',
    'antivirus__incoming_mail' => 'Correu entrant',
    'antivirus__outgoing_mail' => 'Correu sortint',

    'domain_alias__CNAME_dns_record_exists' => 'Ja existeix un registre DNS CNAME amb aquest nom.',
    'domain_alias__A_dns_record_exists' => 'Ja existeix un registre DNS A amb aquest nom.',
    'domain_alias__bad_prefix' => 'El prefix per l\'àlies de domini no és correcte',
    'domain_alias__domain_doesnt_exist' => "El domini no existeix.",

    'dns__zone_ttl_message_info' => 'Si no s\'indica el valor TTL, per aquest registre DNS s\'utilitzarà el valor present a la plantilla del registre SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Es crearà un arxiu denominat index.html pel redireccionament a l'aplicació web seleccionada. Si ja existeix un arxiu anomenat index.html, aquest es copiarà com a index.html.old i serà substituït pel nou arxiu. Faci clic a ACCEPTAR per a confirmar-ho.",

    'bt_ftp_ctrl' => "Comptes FTP addicionals",
    'ftp_users_no_permission' => "No disposa del permís necessari per gestionar comptes FTP per aquest domini.",
    'ftp_users_limit_reached' => "S'ha assolit el límit de comptes FTP per aquest domini",
    'pb__ftp_ctrl' => "Gestió d'FTP",
    'class_client__max_subftp_users' => "Comptes FTP addicionals",

    '__client_form_settings' => "Configuració del client",
    '__sbnet_client_keep_sbnet' => "Conservar el compre d'usuari corresponent a Presence Builder",
    '__sbnet_cant_add_more_sites' => "S'ha assolit el límit màxim de llocs que poden utilitzar Presence Builder per aquest client",
    '__sbnet_legend_text' => "Integració de Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Crear un compte d'usuari corresponent a Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Està intentant eliminar el compte d'usuari de Presence Builder associat amb aquest client. Com a resultat d'aquesta acció, s'eliminaran tots els llocs web de l'usuari i totes les demés opcions rellevants del sistema Presence Builder, eliminant-se també l'habilitat per editar els llocs web existents a través de Presence Builder, fins i tot en el cas que més endavant activi aquesta opció. Si posteriorment crea un compte d'usuari de Presence Builder, haurà de crear i publicar tots els seus llocs web des de zero. Desitja desactivar la creació i publicació de llocs web a través de Presence Builder?",
    'sb__build_site_with_subdomains' => "Crear subdominis Blog i Galeria fotogràfica",
    '__sbnet_client_dont_have_sbuser' => "No es poden crear ni publicar llocs mitjançant Presence Builder. L'usuari de Presence Builder no existeix.",

    '__component_disabled' => "Component desactivat",

    'subdomains__physical_path_not_exist' => "Hi ha subdominis vinculats a carpetes físiques inexistents.",

    'dnsserver_bind_to_msdns_switching_warning' => "Important! Només es transferiran les primeres 254 adreces IP i subxarxes amb màscares /8 i /16 presents a la llista de control d'accés. Aquestes es transferiran com adreces IP independents. Desitja continuar?",

    '__sbnet_net_framework_required_for_site' => "Els llocs Presence Builder poden requerir suport per ASP.NET 2.0 al seu domini. Li recomanem activar el suport per ASP.NET 2.0 si utilitza Presence Builder.",

    'subdomain_auto_create_dir' => "Crear directori físic pel subdomini",

    'sa_trainer__unable_to_get_messages_list' => "No ha estat possible obtenir la llista de correus presents a la bústia de correu: %1",
    'sa_trainer__pass_doesnt_exist' => "No s'ha trobat la contrasenya per aquest compte de correu",

    '__sitebuilder_error' => "S'ha produït un error mentre s'intentava connectar-se a Presence Builder. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda.",
    'wsb_error_user_not_exist' => "Aquest compte d'usuari de Presence Builder no existeix.",
    'wsb_error_site_already_exist' => "Aquest lloc ja existeix a Presence Builder.",
    'wsb_error_site_limit_reached' => "S'ha assolit el número màxim de llocs Presence Builder.",
    'wsb_error_internal_error' => "S'ha produït un error intern de Presence Builder. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda.",
    'wsb_error_user_already_exist' => "A Presence Builder ja existeix un usuari amb aquest nom.",
    'sb_error_user_not_exist' => "L'usuari de Presence Builder no existeix.",
    'wsb_error_object_not_found' => "Presence Builder no ha pogut trobar l'entrada de host correcta.",

    'mg_no_mail_groups' => "No hi ha cap grup de correu",

    'drweb__drweb_incoming' => 'Detectar virus al correu entrant',
    'drweb__drweb_outgoing' => 'Detectar virus al correu sortint',
    'drweb__disable_reason_serv' => 'El servidor de correu no suporta la configuració del filtre antivirus a nivell de la bústia de correu',

    'vz_sitebuilder3_client_cant_be_created' => "No es pot crear el compte de client. No s'ha instal·lat SiteBuilder 3.1 o una versió anterior.",

    // new limits

    'class_client__max_odbc' => "Connexions ODBC",
    'cl_perm__max_odbc' => "número màxim de connexions ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Nom de l\'àlies de domini',
    'domain_alias__list_ascii_name' => 'En format ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Gestió de la interfície',
    'pb__interface_templates' => 'Gestió de la interfície',
    'pb__interface_clients' => 'Clients que utilitzen %1',

    // service management
    'bt_service_showall' => "Mostrar-ho tot",
    'bt_service_hideall' => "Amagar-ho tot",
    'bt_service_start' => "Iniciar",
    'bt_service_stop' => "Aturar",
    'bt_service_restart' => "Reiniciar",
    'bt_service_disable' => "Desactivar",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Automàtic",
    'service_startup_auto' => 'Automàtica',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Desactivat',
    'service_action_ok' => "L'operació amb el servei %1 s'ha completat correctament",
    'service_action_failed_disabled_service' => "No s'ha pogut completar l'operació amb el servei %1 perquè aquest està desactivat",
    'service_action_failed_error' => "No s'ha pogut completar l'operació. %1",
    'service_group_action_ok' => "L'operació amb els serveis detallats a continuació s'ha completat correctament: \n %1",
    'service_group_action_disabled' => "No s'ha pogut completar l'operació amb els següents serveis perquè aquests estan desactivats: \n %1",
    'service_group_action_failed' => "No s'ha pogut completar l'operació amb els següents serveis: \n %1. \n Si desitja rebre informació detallada sobre l'error, efectuï l'operació amb cada servei per separat",

    // php 4vs5
    'bt_php' => "Configuració de PHP",

    'bt_insert' => "Inserir",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "S'ha produït un error de la base de dades de Presence Builder. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda.",
    'wsb_error_sitebuilder_access_denied_error' => "No ha estat possible accedir a l'arxiu. Presence Builder no té permís d'accés per l'arxiu o la carpeta en qüestió. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda.",
    'wsb_error_sitebuilder_connection_failed' => "No ha estat possible connectar-se a Presence Builder perquè s'ha perdut la connexió. Contacti amb el seu proveïdor de serveis per tal d'obtenir ajuda.",
    'wsb_error_critical_during_operation' => "S'ha produït un error crític de Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "S'ha produït un error de llicència de Presence Builder:\n%1",
    'wsb_error_during_operation' => "S'ha produït un error de Presence Builder:\n%1",
    'wsb_error_license_error' => "S'ha detectat una limitació de la llicència de Presence Builder.",

    // Other
    '__confrim_service_stop' => "Important! Si atura el servei %1, és possible que Plesk deixi de funcionar. Està segur que desitja aturar el servei %1?",
    'index_redirect_help_text' => 'Ara se\'l redireccionarà automàticament al lloc web requerit. Si el seu navegador no suporta redireccionaments, faci clic %1 aquí %2',
    'bt_default_settings' => "Restaurar opcions per defecte",
    'logfiles__remove_failed' => "No ha estat possible eliminar l'arxiu %1. L'arxiu està bloquejat per una altra aplicació. Torni-ho a provar en uns minuts.",
    'subdomain__invalid_homedirectory' => "El directori del subdomini especificat no és vàlid.",
    'scheduler_item__empty_filename' => "Especifiqui l'arxiu executable a executar",
    'subdomains__overlapped_domain_exists' => 'El subdomini és superposat per la zona DNS del domini %1',
    'subdomains__overlapped_domain_alias_exists' => 'El subdomini és superposat per la zona DNS de l\'àlies de domini %1',
    'services_action_none_selected' => 'No s\'ha pogut completar l\'operació. Seleccioni els serveis desitjats.',
    'cl_perm__max_subftp_users' => "número màxim de comptes FTP addicionals",
    'login_up__access_denied_no_cp_access' => 'Accés denegat. No disposa del permís necessari per a accedir a Plesk.',
    'drweb__disable_reason_admin' => "La directiva del servidor no permet la configuració del filtre antivirus a nivell de la bústia de correu.",

    '__use_default' => 'Utilitzar predeterminat',

    'webalizer_hidden_referrer__already_exist' => 'Aquesta entrada ja existeix.',
    'webalizer_group_referrer__already_exist' => 'Ja existeix un grup de referències amb aquest nom.',

    'pb__dashboard' => 'Inici',

    'server_interface__page_title' => 'Configuració de la interfície del servidor',
    'server_interface__tabs_locales' => 'Idiomes',
    'server_interface__tabs_skins' => 'Skins',
    'server_interface__tabs_interface_templates' => 'Plantilles d\'interfície',
    'bt_server_interface' => 'Preferències de la interfície',
    'pb__server_interface' => 'Preferències de la interfície',

    'bt_wizard_next' => 'Següent>>',
    'bt_wizard_prev' => '<< Enrere',

    '__limit_exceeded_max_dom_server' => 'No pot allotjar més dominis en aquest servidor perquè s\'ha assolit el número màxim de dominis permesos al servidor definit per la clau de llicència. Posi\'s en contacte amb el seu proveïdor de serveis per a resoldre aquesta incidència.',
    '__limit_exceeded_max_subdom_server' => 'No pot allotjat més subdominis en aquest servidor. Posi\'s en contacte amb el seu proveïdor de serveis.',
    '__limit_exceeded_max_dom_aliases_server' => 'No pot crear més àlies de domini en aquest servidor. Posi\'s en contacte amb el seu proveïdor de serveis.',
    '__limit_exceeded_max_wu_server' => 'No pot crear més usuaris web perquè s\'ha assolit el número màxim d\'usuaris web permesos al servidor per la clau de llicència. Posi\'s en contacte amb el seu proveïdor de serveis per a resoldre aquesta incidència.',
    '__limit_exceeded_max_mn_server' => 'No pot crear més comptes de correu perquè s\'ha assolit el número màxim de comptes de correu permesos al servidor per la clau de llicència. Posi\'s en contacte amb el seu proveïdor de serveis per a resoldre aquesta incidència.',

    '__limit_exceeded_max_cl_useradmin' => 'Ha assolit el número màxim de comptes de client definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Ha assolit el número màxim de dominis definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Ha assolit el número màxim de subdominis definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Ha assolit el número màxim d\'àlies de domini definit per la seva clau de llicència (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'No disposa de més espai al disc',
    '__limit_exceeded_max_wu_useradmin' => 'Ha assolit el número màxim de comptes d\'usuari web definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Ha assolit el número màxim de bases de dades definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Ha assolit el número màxim de bústies de correu definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Ha assolit el número màxim de comptes de correu definit per la seva clau de llicència (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Ha assolit el número màxim de llistes de correu definit per la seva clau de llicència (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Ha assolit el número màxim de dominis (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Ha assolit el número màxim de subdominis (%2) permès pel seu proveïdor de serveis',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Ha assolit el número màxim d\'àlies de domini (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Ha assolit el límit d\'ús de l\'espai al disc (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Ha assolit el límit d\'ús d\'amplada de banda mensual (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Ha assolit el número màxim d\'usuaris web (%2) permès pel seu proveïdor de serveis.',
    '__limit_exceeded_max_db_userclient' => 'Ha assolit el número màxim de bases de dades (%2)',
    '__limit_exceeded_max_box_userclient' => 'Ha assolit el número màxim de bústies de correu (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Ha assolit el número màxim de llistes de correu (%2)',
    '__limit_exceeded_expiration_userclient' => 'El seu compte va caducar el %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Ha assolit el número màxim de subdominis (%2) permès pel seu proveïdor de serveis',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Ha assolit el número màxim d\'àlies de domini (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Ha assolit el límit d\'ús de l\'espai al disc (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Ha assolit la quantitat màxima d\'amplada de banda utilitzada de forma mensual (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Ha assolit el número màxim de comptes d\'usuari web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Ha assolit el número màxim de bases de dades (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Ha assolit el número màxim de bústies de correu (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Ha assolit el número màxim de llistes de correu (%2)',
    '__limit_exceeded_expiration_userdomain' => 'El seu compte va caducar el %2',

    'sapp_error_validation_not_found' => 'No ha estat possible validar l\'aplicació web perquè no s\'ha trobat un dels arxius requerits (%1). Posi\'s en contacte amb el seu responsable de suport tècnic per tal d\'obtenir ajuda.',
    'sapp_error_validation_spec_failed' => 'L\'aplicació web carregada no compleix les especificacions d\'AppPacks: %1.',
    'sapp_error_validation_register' => 'No ha estat possible registrar l\'aplicació web present al directori "%1": %2 Caldria eliminar l\'aplicació web del servidor, ja que aquesta no funcionarà correctament.',

    'sapp__install_failed' => 'Error d\'instal·lació de l\'aplicació web: %1',
    'sapp__install_res_failed' => 'Error de creació del recurs sol·licitat.',

    'server_preferences__subdomains_blog_and_photo' => 'Crear subdominis Blog i Galeria fotogràfica per defecte',
    'plesk_key__blog_and_photo' => 'Permet gestionar l\'estat predeterminat de la casella Crear subdominis Blog i Galeria fotogràfica',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'No ha estat possible canviar el tipus d\'adreça IP a dedicada perquè aquesta està assignada a més d\'un usuari.',

    // 8.1.1

    '__write_modify_warning' => 'Si selecciona permisos addicionals d\'escriptura o modificació, algunes aplicacions web funcionaran correctament, si bé augmentarà el risc de seguretat de forma notable',
    '__write_modify_subdomain_warning' => 'Si selecciona permisos addicionals d\'escriptura o modificació, algunes aplicacions web funcionaran correctament, si bé augmentarà el risc de seguretat de forma notable',

    'phosting__php_incorrect_version_used' => "S'han detectat problemes amb la versió de PHP. Per tal de resoldre'ls, seleccioni a continuació la casella amb la versió desitjada de PHP i faci clic a ACCEPTAR. Per desactivar PHP en aquest domini, faci clic a ACCEPTAR sense seleccionar cap versió de PHP.",
    'fp__mail_preferences' => 'Configuració de correu',

    'mail__invalid_white_pattern' => 'El valor especificat no és vàlid. Utilitzi els següents formats: mail@example.com en el cas d\'adreces de correu i example.com en el cas de dominis.',
    'mail__invalid_black_pattern' => 'El valor especificat no és vàlid. Utilitzi el següent format: mail@example.com en el cas d\'adreces de correu i example.com en el cas de dominis.',

    'resp_edit__reply_as_html' => 'Enviar com a HTML',
    'exception__path_very_long' => "La ruta és massa llarga. Comprovi que aquesta no està formada per més de %1 caràcters.",

    // 8.2


    //SAPP
    'sapp_on' => 'Activat',
    'sapp_off' => 'Desactivat',
    'sapp_directive_aspect' => 'Obligatori',
    'sapp_databases_num' => 'Bases de dades',
    'sapp_db_required' => 'Obligatori',
    'sapp_Required' => 'Obligatori',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'ID de la base de dades',
    'sapp_db_id_type' => 'Tipus de DB (ID: %1)',
    'sapp_db_id_min_version' => 'Versió mínima de DB (id: %1)',
    'sapp_db_id_table_prefix' => 'DB (ID: %1) prefix de la taula',
    'sapp_Default' => 'Valor predeterminat',
    'sapp_apache_mod_req' => 'Mòdul Apache',
    'sapp_dbtype_not_installed' => 'no instal·lat',
    'sapp_apache_mod_not_installed' => 'no instal·lat',
    'sapp_error_invalid_type' => 'L\'aplicació "%1" no suporta l\'acció sol·licitada.',
    'sapp_error_unknown_app_type' => 'Tipus d\'aplicació no suportat: %1.',
    'sapp__ssl_text' => 'Desitja instal·lar l\'aplicació al host virtual "http://" o "https://"?',
    'sapp__app_to_upgrade' => 'Aplicacions que cal actualitzar',
    'sapp__upgrade_apps_title' => 'Actualitzar aplicacions',
    'sapp__upgrade_to_ver' => 'Actualitzar a la versió',
    'sapp__choose_pkg_ver' => 'Seleccioni un paquet...',
    'sapp__pkg_cant_upgrade_pkg' => 'El paquet "%1" no espot utilitzar per a actualitzar l\'aplicació web "%2".',
    'sapp__app_ugrade_error' => 'No ha estat possible actualitzar l\'aplicació: %1. Posi\'s en contacte amb el seu administrador del sistema.',
    'sapp__no_suitable_db_found' => 'No s\'ha trobat cap base de dades apropiada.',
    'sapp__upgrade_success' =>  'L\'aplicació s\'ha actualitzat correctament.',
    'sapp__pkg_info_changelog' => 'Historial de canvis',
    'sapp_requirement_legend' => 'Funcions de hosting requerides per l\'aplicació',

    // other
    'bt_apply' => 'Aplicar',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Per tal de crear un àlies de correu, la bústia de correu hauria d\'estar activada en aquest compte de correu. Desitja activar la bústia de correu?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Si desactiva la bústia de correu, s\'eliminaran els àlies de correu, ja que aquests deixaran de funcionar. Desitja desactivar la bústia de correu?',
    'antivirus__disable_reason_install' => 'No pot gestionar l\'antivirus perquè aquest no s\'ha instal·lat.',
    'antivirus__disable_reason_key' => 'No pot gestionar l\'antivirus perquè aquest no s\'ha activat amb una clau de llicència apropiada.',
    'antivirus__disable_reason_deny_personal_settings' => 'No pot gestionar l\'antivirus perquè la directiva del servidor prohibeix establir una configuració individual de l\'antivirus.',
    'change_foreign_user_password' => 'Canviar contrasenya',
    'change_foreign_user_password_hint' => "L'usuari no pertany a aquesta aplicació. Faci clic a l'enllaç per anar a una altra aplicació i canviar allà la contrasenya de l'usuari. Per efectuar aquest canvi cal que disposi dels permisos apropiats a l'aplicació.",
    'cf_url_text' => 'URL de JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Format de la cadena de text',
    'lang_unknown' => 'Idioma desconegut',
    'pb__cl_ed' => 'Detalls del client',
    'pb__actionlog' => 'Registre d\'accions',
    'pb__cl_limits' => 'Límits del client',
    'pb__edit' => 'Editar',
    'pb__subdom_edit' => 'Configuració de hosting',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Crear un backup del contingut de les bústies de correu',

    'maillist_import_result' => "\nQuantitat total d'adreces de correu a l'arxiu: %1\nquantitat d'adreces de correu importades: %2\nquantitat d'adreces de correu existents: %3\nquantitat d'adreces de correu duplicades a l'arxiu especificat: %4\nquantitat d'adreces de correu no vàlides a l'arxiu: %5",
    'maillist_import_error' => 'No ha estat possible importar la llista d\'adreces de correu',

    'dom_pref__external_mail_srv' => "Redireccionar a un servidor de correu extern amb l'adreça IP:",
    'mn_edit__store_messages' => 'Bústia de correu',

    // aps

    'sapp__before_upgrade_notice' => 'Abans d\'iniciar l\'actualització, li recomanem crear un backup de l\'aplicació i de les dades dels usuaris.',
    'sapp__application_properties' => 'Propietats de l\'aplicació',
    'sapp__application_root_descr' => 'La pàgina principal de l\'aplicació',

    'sapp__aps_license_invalid_id' => 'La clau de llicència presenta un ID que no és vàlid: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'A la base de dades ja existeix una llicència amb número de clau %1.',
    'sapp__aps_lic_del_used' => 'No ha estat possible eliminar la clau de llicència, ja que aquesta és utilitzada per una de les aplicacions instal·lades.',
    'sapp__aps_lic_del_unknown' => 'No ha estat possible eliminar la clau de llicència: %1',
    'sapp__aps_cappi_duplicate' => "Aquesta aplicació ja està present al conjunt d'aplicacions d'aquest client",
    'sapp__appi_not_shared_no_install' => "Aquesta aplicació no està present al conjunt d'aplicacions del client. Si desitja instal·lar-la en un lloc, primer afegeixi-la al conjunt d'aplicacions del client.",
    'sapp__appi_shared_not_client' => "Aquesta aplicació no està present al conjunt d'aplicacions del client. Si desitja actualitzar-la a la versió especificada, primer afegeixi aquesta versió de l'aplicació al conjunt d'aplicacions del client.",
    'sapp__apply_license_script_not_found' => 'No ha estat possible trobar l\'script "apply-license" per aquesta aplicació web.',
    'sapp__unable_to_activate_key' => 'S\'ha produït un error mentre s\'intentava activar una clau de llicència: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Hi ha instal·lades algunes aplicacions web que necessiten la presència d\'aquesta aplicació web al sistema.',
    'sapp__unable_to_delete_ai_in_pool' => 'Aquesta aplicació encara està present a l\'inventari d\'un client. Si desitja eliminar-la, primer elimini-la dels conjunts d\'aplicacions de tots els clients o faci que l\'aplicació sigui gratuïta.',
    'sapp__unable_to_delete_app_template' => 'No ha estat possible eliminar l\'aplicació #%1: %2',
    'sapp__limit_exceeded_client' => 'Ha assolit el número màxim de vegades que pot instal·lar aquesta aplicació web (%2).',


    // atis module

    '_week_on' => 'setmana activa',
    '__week_first' => 'Primera',
    '__week_second' => 'segona',
    '__week_third' => 'tercera',
    '__week_fourth' => 'quarta',
    '__week_last' => 'Última',
    '__not_started' => 'A l\'espera',
    '__started' => 'En execució',
    '__cancel_pending' => 'Cancel·lant',
    '__canceled' => 'Cancel·lat',
    '__error' => 'Error',
    '__done' => 'Fet',

    '__php_cgi_handler' => 'Aplicació CGI',
    '__php_isapi_handler' => 'Extensió ISAPI',
    '__php_fastcgi_handler' => 'Aplicació FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'executar com a',

    'cf_dbfolder_text' => 'Carpeta de la base de dades',
    'cf_isnewdb_text' => 'Crear base de dades',
    'cf_isnewdb_title' => 'Seleccioni la casella si s\'ha de crear la base de dades',

    'pb__site_apps_upgrade' => 'Actualització d\'aplicacions web',

    'detach' => 'Desconnectar',
    'preferences' => "Canviar contrasenya",

    'toolsbar__switch_user?' => "Està segur que desitja iniciar sessió sota un altre compte d'usuari?",
    '__aps_left' => 'Instal·lacions restants',
    'aps__license_key' => 'Clau de llicència',
    'aps__download_code' => 'Descàrrega i codi d\'activació de la clau de llicència',
    'aps__license_key_hint' => 'Recuperar des del servidor de llicències mitjançant el codi d\'activació',
    'aps__database_not_available' => 'no disponible. Comprovi els límits del client o del domini',
    'aps__yes' => 'sí',
    'aps__no' => 'no',
    '__click_to_enlarge' => 'Faci clic per a engrandir',
    'site_apps__back_to_list' => 'Tornar a la llista',
    'sapp__pkg_info_installation_requirements' => 'Requisits de la instal·lació',
    '__close_window' => 'Tancar',

    //SAPP END

    'skin_info__already_default' => 'L\'skin ja està definit com a skin predeterminat.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Configuració de Plesk Premium Antivirus per %1',
    'drweb:properties_legend' => 'Configuració',
    'drweb:status' => 'Analitzant el correu per comprovar l\'existència de virus',

    // sb integration
    'sitebuilder_wizard' => 'Assistent de Presence Builder',
    'dom_site_builder' => 'Faci clic per accedir a l\'assistent de Presence Builder.',
    'sb_plesk_admin_url' => 'URL del servidor Presence Builder. Comprovi que aquesta adreça resol correctament al DNS.',
    'sb_plesk_admin_login' => 'Nom d\'usuari per l\'inici de sessió de l\'administrador del servidor a Presence Builder',
    'sb_plesk_admin_password' => 'Contrasenya de l\'administrador',
    'sb_sitebuilder_preferences' => 'Credencials de l\'administrador de Presence Builder',
    'sb__server' => 'Preferències de l\'administrador del sistema de Presence Builder',
    'sb__sitebuilder_support' => 'Suport per Presence Builder',
    'sb_keep_sb_user' => 'Conservar el compre d\'usuari corresponent a Presence Builder',
    'sb_create_sb_user' => 'Crear un compte d\'usuari corresponent a Presence Builder',
    'sb__build_site_using_sitebuilder' => "Crear un lloc web mitjançant Presence Builder",
    'sb_no_current_sb_server_set' => 'Encara no s\'ha configurat la connexió a Presence Builder. Afegeixi un registre A a la plantilla de la zona DNS que apuntarà al servidor Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "No ha estat possible recuperar la informació des del sistema Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "No ha estat possible connectar-se a Presence Builder. El nom d'usuari o la contrasenya no és correcte.",
    'sb_init_sb_manager' => "Inicialitzant l'administrador de Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "No ha estat possible connectar-se al sistema Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Aquest client no disposa de cap compte d'usuari a Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder no està configurat.",
    'sb_err_you_dont_have_sbaccount' => "No se l'ha pogut autoritzar a Presence Builder.",
    'sb_error_critical_during_operation' => "S'ha produït el següent error a Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "A Plesk no s'ha activat el suport per Single Sign-On (SSO).",

    'warning__super_zone_exist' => "La zona %1 ha estat creada, si bé aquest nom de zona és una subzona d'una altra zona existent %2, que pertany a un altre usuari %3. En tot cas, comprovi que ha escollit el compte d'usuari correcte.",
    'error__super_zone_exist' => "No ha estat possible crear la zona DNS perquè la seva superzona pertany a un altre usuari.",

    'locales__files_not_exits' => 'No ha estat possible canviar l\'idioma. Al sistema no existeixen els arxius del paquet d\'idioma especificat.',
    'locales__unavailable' => 'No ha estat possible canviar l\'idioma. El paquet d\'idioma especificat no està disponible.',

    // DB BU

    'pb__dbbackup_list' => 'Arxius de backup de la base de dades',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Directori de xarxa temporal',
    'dbbackup__network_user' => 'Nom d\'usuari',
    'dbbackup__network_pass' => 'Contrasenya',
    // domain
    'dbbackup__add_database_legend' => 'Restaurar la base de dades copiada',
    'dbbackup__add_database_restore' => 'Restaurar la base de dades mitjançant un arxiu de backup',
    'dbbackup__add_database_file' => 'Arxiu de backup de la base de dades',
    'dbbackup__add_database_user' => 'Nom d\'usuari predeterminat',
    'dbbackup__add_database_pass' => 'Contrasenya predeterminada de l\'usuari',
    'dbbackup__add_database_pass2' => 'Confirmació de la contrasenya predeterminada de l\'usuari',

    'bt_dbbackup_now' => 'Crear backup',

    'bt_repair' => 'Reparar',

    'dbbackup__mssql_dump_upload_not_allowed' => 'El proveïdor de hosting no permet carregar buidatges de bases de dades SQL Server.',

    // APS categories

    'cf_invalid_password' => 'La contrasenya no pot estar formada per més de 16 caràcters',
    'cf_invalid_description_length' => 'La descripció no por estar formada per més de 256 símbols',
    'ip_addr__ip_used_by_external_mail_server' => 'L\'adreça IP %1 ja l\'està utilitzant el servidor de correu extern',

    // 8.4.1

    '__ftp_login_is_invalid' => 'El nom d\'usuari o la contrasenya del compte FTP no són vàlids. Especifiqui les credencials d\'usuari FTP correctes.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'S\'ha assolit el número màxim de canvis de número de serie. Avui no es pot efectuar cap canvi més a la zona DNS.',
    'dns__zone_apply_changes' => 'Els canvis efectuats als registres DNS encara no s\'han desat. A continuació pot veure destacats els canvis efectuats. Faci clic a Actualitzar per aplicar els canvis a la zona DNS o a Revertir per descartar els canvis.',
    'dns__update_dns_zone' => 'Faci clic per a desar els canvis efectuats als registres DNS',
    'dns__revert_dns_zone' => 'Faci clic per a cancel·lar els canvis efectuats als registres DNS',
    'bt_revert' => 'Revertir',
    'dns__dns_zone_has_beed_updated' => 'Els canvis efectuats als registres DNS han estat desats.',
    'dns__dns_zone_has_beed_reverted' => 'Els canvis efectuats als registres DNS han estat cancel·lats',
    'db__nondefault_server_not_allowed' => 'No es permet l\'ús de servidors de base de dades que no siguin predeterminats',

    'site_apps__non_removable' => 'Elements que no es poden eliminar',
    'site_apps__non_removable_items' => 'Les següents aplicacions web no es poden eliminar:',

    'rpt_reseller_section_general' => 'General',
    'rpt_reseller_section_domains' => 'Dominis',
    'rpt_reseller_section_clients' => 'Clients',
    'statistics__cl_active_domains' => "Dominis actius",
    'rpt_reseller_cl_domains' => "Dominis",
    'rpt_reseller_cl_subdomains' => "Subdominis",
    'by__cl_domains' => "dominis dels clients",
    'dom_ctrl__cl_mboxes' => "Bústies de correu",
    'rpt_reseller_cl_redirects' => "Redireccionaments",
    'rpt_reseller_cl_mail_groups' => "Grups de correu",
    'rpt_reseller_cl_mail_resps' => "Respostes automàtiques",
    'rpt_reseller_cl_mail_lists' => "Llistes de correu",
    'rpt_reseller_cl_web_users' => "Usuaris web",
    'rpt_reseller_cl_data_bases' => "Bases de dades",

    'statistics__active_clients' => 'Clients amb subscripcions actives',
    'statistics__clients_active_domains' => 'Dominis actius',
    'statistics__clients_doms' => 'Dominis',
    'statistics__cl_doms' => 'Dominis',
    '__clients_subdomains' => 'Subdominis',
    '__clients_domains' => 'Dominis',
    'dom_ctrl__clients_mboxes' => 'Bústies de correu',
    'dom_ctrl__clients_redir' => 'Redireccionaments',
    'dom_ctrl__clients_mg' => 'Grups de correu',
    'dom_ctrl__clients_resp' => 'Respostes automàtiques',
    'dom_ctrl__clients_maillists' => 'Llistes de correu',
    'dom_ctrl__clients_wu' => 'Usuaris web',
    'dom_ctrl__clients_db' => 'Bases de dades',

    'dom_ctrl__cl_redir' => 'Redireccionaments', // to resolve!
    'dom_ctrl__cl_mg' => 'Grups de correu', // to resolve!
    'dom_ctrl__cl_resp' => 'Respostes automàtiques', // to resolve!
    'dom_ctrl__cl_maillists' => 'Llistes de correu', // to resolve!
    'dom_ctrl__cl_wu' => 'Usuaris web', // to resolve!
    'dom_ctrl__cl_db' => 'Bases de dades', // to resolve!

    'rpt_cl_section_clients' => 'Clients',

    'rpt_admin_section_general' => 'General',
    'rpt_admin_section_resellers' => 'Revenedors',
    'rpt_admin_section_clients' => 'Clients',
    'rpt_admin_section_personal_clients' => 'Els meus clients',
    'rpt_admin_section_domains' => 'Dominis',
    'rpt_admin_section_personal_domains' => 'Dominis personals',

    'rpt_reseller_section_personal_domains' => 'Dominis personals',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Permetre la sobreventa",
    'limits__reseller_oversell_description' => "La sobreventa permet al revenedor vendre més recursos dels que se li van assignar. Si es permet, el revenedor es regeix per l'ús de recursos actual, enlloc de regir-se per l'assignació inicial de recursos.",
    'limits__overuse_block_text' => "Directiva de sobreús",
    'limits__overuse_block_true_text' => "No es permet el sobreús",
    'limits__reseller_overuse_block_true_description' => "Bloquejar el sobreús de recursos. L'ús actual de recursos no pot excedir l'assignació inicial de recursos.",
    'limits__overuse_block_false_text' => "Es permet el sobreús",
    'limits__reseller_overuse_block_false_description' => "No bloquejar el sobreús de recursos i permetre al revenedor utilitzar més recursos dels proporcionats inicialment. L'ús actual de recursos pot excedir l'assignació inicial de recursos.",
    'limits__reseller_overuse_notify_text' => "Notificar al revenedor quan s'assoleixin els límits de recursos",
    'reseller_perm__manage_sh_access_disabled' => "El revenedor no pot permetre ni prohibir l'accés al shell",
    'reseller_perm__manage_sh_access_chrooted' => "El revenedor només pot permetre l'accés a un entorn chrooted",
    'reseller_perm__manage_sh_access_any' => "El revenedor pot permetre l'accés a qualsevol tipus de shell",
    'template__reseller_num_excl_ips' => "Assignar adreces IP dedicades al revenedor",

    // Reseller's Home page
    'domains__reseller_info' => "%1 clients, %2 dominis, %3 d'espai al disc utilitzat, %4 de dades transferides.",
    'domains__reseller_info_hiding_traffic' => "%1 clients, %2 dominis, %3 d'espai al disc utilitzat.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Ara, totes les aplicacions web s'ordenen per categories, el que simplifica la selecció de l'aplicació a instal·lar.",
    'feature__domainkeys__reseller' => "Pot utilitzar el mecanisme d'autenticació de remitents de correus DKIM per a reduir la quantitat de correu spam i la suplantació d'identitat.",

    '__reseller_form' => "Formulari de revenedor",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Fer que aquesta plantilla disponible per altres usuaris",
    'template__shared_description' => "Seleccioni aquesta opció si desitja que els seus clients puguin utilitzar aquesta plantilla.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "L'administrador del domini no pot permetre ni prohibir l'accés al shell",
    'domain_perm__manage_sh_access_chrooted' => "L'administrador del domini només pot permetre l'accés a un entorn chrooted",
    'domain_perm__manage_sh_access_any' => "L'administrador del domini pot permetre l'accés a qualsevol tipus de shell",

    // APS Catalog
    'bt_add_to_vault' => "Afegir al vault",
    'bt_hide_updates' => "Amagar actualitzacions disponibles",
    'bt_show_updates' => "Mostrar actualitzacions disponibles",

    '__site_apps__applications' => "Aplicacions",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplicacions seleccionades per afegir-les al vault",
    'site_apps__application_selected' => "Seleccionat",
    'site_apps__currently_in_vault' => "Altres versions ja presents al vault:",
    'site_apps__new_versions' => "Versions noves:",
    'site_apps__patches' => "Patchs:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Número d'aplicacions programades per a ser afegides a l'application vault: %1",
    'site_apps__applications_downloading_now' => "En aquests moments s'estan descarregant les següents aplicacions: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Ja present al vault",

    // Server > Action Log
    'bt_skin_edit' => "Editar descripció de l'skin",
    'limits__oversell_legend' => "Sobreventa",
    'limitsManager__limit_available_error' => "No ha estat possible assignar la quantitat necessària de recursos (%%quantity%% %%limitName%%). Només disposa de %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "No ha estat possible establir el límit d'ús de recursos requerit (%%quantity%% %%limitName%%) perquè el nou valor és inferior a la quantitat de recursos reservats pels seus clients o utilitzats per vostè mateix (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "No ha estat possible establir el límit d'ús de recursos requerit (%%quantity%% %%limitName%%) perquè el nou valor és inferior a la quantitat de recursos actualment utilitzada pel seu compte i els seus llocs (%%used%% %%limitName%%).",

    'domains_list__resource__filter_title' => "Ús de recursos",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catàleg d'aplicacions APS",
    'site_apps__applications_have_updates' => "Hi ha noves versions per les següents aplicacions:\n%1\nSi desitja veure les actualitzacions, comprovi que l'àrea de cerca és visible i seleccioni la casella <b>Només mostrar actualitzacions</b> i cerqui les aplicacions desitjades.",
    'site_apps__progress_adding_to_vault' => "Afegint al vault: ",
    'site_apps__progress_done_message' => "Progrés:",
    'site_apps__progress_applications_left' => "%1 de %2 aplicacions restants",
    'site_apps__download_item_long_task_title' => "Descarregar aplicació APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Descarregar aplicacions APS del catàleg APS",
    'site_apps__last_check_for_updates' => "última cerca d'actualitzacions: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Totes les aplicacions programades s'han afegit correctament a l'application vault",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aplicacions programades s'han afegit correctament a l'application vault.",
    'site_apps__no_search_results' => 'No s\'ha trobat cap aplicació. Provi una altra petició de cerca o examini les aplicacions per categories.',
    'site_apps__search_results_title' => 'Resultats de la cerca',
    '__site_apps__search_by_application' => 'Nom de l\'aplicació',
    '__site_apps__search_by_vendor' => 'Proveïdor',
    '__site_apps__search_by_vendor__all' => 'Tots els proveïdors',
    '__site_apps__search_by_packager' => 'Empaquetador',
    '__site_apps__search_by_certification_level' => 'Nivell de certificació',
    '__site_apps__search_by_cert__any' => 'Qualsevol',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver i superior',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold i superior',
    '__retry' => 'Tornar a provar',
    'site_apps__application_packager_site' => 'Empaquetador',
    'site_apps__add_to_pool_message' => "Les aplicacions marcades com \"disponible per tothom\" es distribueixen automàticament a tots els revenedors i clients amb una quantitat il·limitada d'instal·lacions. Les aplicacions restringides es distribueixen manualment a tots els revenedors i clients de forma individualitzada amb el número d'instal·lacions disponibles especificat explícitament.",
    'site_apps__make_available_for_all' => "Fer que les aplicacions seleccionades estiguin disponibles per tots els usuaris",

    'site_apps__broadcast_app_text' => "Les aplicacions marcades com \"disponible per tothom\" es distribueixen automàticament a tots els revenedors i clients amb una quantitat il·limitada d'instal·lacions. Les aplicacions restringides es distribueixen manualment a tots els revenedors i clients de forma individualitzada amb el número d'instal·lacions disponibles especificat explícitament.",
    'site_apps__broadcast_app_name' => 'Fer que l\'aplicació estigui disponible per tots els usuaris',

    // User Application Pool per application
    'site_apps__available_clients' => 'Usuaris disponibles',
    'site_apps__no_more_clients_to_add_to_pool' => 'No hi ha més comptes d\'usuari als que pugui proporcionar aquesta aplicació',

    // Installed application instances
    'site_apps__installations' => 'Instal·lacions',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nom del domini i adreça IP",
    '__assign_ip_address' => "Assignar adreça IP",
    '__switch_on_service' => "Activar el servei",
    '__hosting_configuration' => "Configuració de hosting",
    '__vrt_hst' => "Hosting de llocs web",
    '__vrt_hst_hint' => "Allotgi un lloc web en aquest servidor.",
    '__fwd' => "Reenviament",
    '__web_hosting_settings' => "Configuració de hosting",
    '__fwd_hint' => "Redireccioni els visitants a un altre lloc web.",
    '__none_hint' => "No allotgi cap lloc web en aquest moment.",
    '__login_hint' => "Aquest nom d'usuari s'utilitza per accedir al seu lloc web mitjançant FTP",
    '__password_hint' => "Aquesta contrasenya s'utilitza per accedir al seu lloc web mitjançant FTP",
    '__advanced_hosting_setup' => "Configurar les opcions avançades de hosting de llocs web",
    '__domain_creation_successful' => "El domini ha estat creat.",
    'bt_hosting_settings' => "Configuració de hosting",
    '__change_hosting_type' => "Canvi de tipus de hosting pel domini %1",
    '__hosting_type_change_warning' => "Quan canvia el tipus de hosting a redireccionament o sense hosting, tots els arxius i directoris relacionats amb el seu lloc s'eliminen del servidor. Comprovi que disposa d'una còpia local del seu lloc.",
    '__current_hosting_type' => "Tipus de hosting actual",
    '__new_hosting_type' => "Nou tipus de hosting",
    '__fwd_settings' => "Configuració de redireccionament",
    '__fwd_settings_legend' => "Configuració de redireccionament",
    '__fwd_destination_url' => "URL de destí",
    '__fwd_type' => "Tipus de redireccionament",
    '__fwd_type_standart' => "Redireccionament estàndard",
    '__fwd_type_standart_hint' => "Redireccioni els visitants del lloc web a un altre lloc i mostri l'adreça de destí perquè així siguin conscients del redireccionament.",
    '__fwd_type_frame' => "Redireccionament per marcs",
    '__fwd_type_frame_hint' => "Redireccioni els visitants del lloc web a un altre lloc sense mostrar l'adreça de destí perquè així no siguin conscients d'aquest redireccionament.",
    '__hosting_type_template_warning' => "El tipus de hosting seleccionat no és el mateix que el tipus indicat a la plantilla. De continuat, s'ignorarà la configuració de hosting web a la plantilla seleccionada. Està segur que desitja establir el tipus de hosting seleccionat?",

    '__no_resellers_selected' => "Seleccioni almenys un compte de revenedor.",

    'ippool_Manager__no_available_ips' => "Al grup d'adreces IP no hi ha cap adreça IP vacant.",
    'ippool_Manager__ip_shared' => "compartida",
    'ippool_Manager__ip_exclusive' => "dedicada",

    'ippoolManager__ip_shared' => "compartida",
    'ippoolManager__ip_exclusive' => "dedicada",

    '__users_list' => "Usuaris",
    '__users' => "Usuaris",
    '__user_name' => "Nom de l'usuari",

    'limit__name_max_dom_aliases' => "àlies de domini",
    'limit__name_max_subftp_users' => "comptes FTP addicionals",
    'limit__name_max_mssql_db' => "Bases de dades Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Conjunts d'aplicacions IIS",
    'limit__name_max_odbc' => "Connexions ODBC",
    'total_mboxes_quota_unsupported' => 'no suportada pel servidor de correu',
    'limit_soft__disk_space' => 'Notificar quan s\'assoleixi l\'espai al disc',
    'limit_soft__max_traffic' => 'Notificar quan s\'assoleixi el trànsit',
    'limitsManager__commit_failed' => "No ha estat possible canviar els límits de recursos.",
    'limitsManager__date_in_past' => "La data de caducitat %1 no és correcta.",
    'limitsManager__limit_not_supported' => "No es poden establir els límits pel tipus de recurs %1.",
    'limitsManager__limit_oversell_inconsistency' => "No ha estat possible assignar les quantitats de recursos especificades perquè no es permet la sobreventa.",
    'limitsManager__limit_overuse_inconsistency' => "L'ús de recursos excedeix els límits definits.",
    'limitsManager__no_resource_available' => "Ja no hi ha cap recurs disponible d'aquest tipus (%%limitName%%). Sol·licitat: %%quantity%%; Disponible: %%unused%%.",
    'limitsManager__no_total_resource_available' => "No hi ha cap recurs disponible d'aquest tipus (%%limitName%%) a través del seu proveïdor de serveis. Sol·licitat: %%quantity%%; Disponible: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "La data de caducitat ha de ser igual o inferior a %1.",
    'limitsManager__invalid_disk_space_limit' => "La quantitat d'espai al disc ha de ser igual o inferior a %1.",
    'limitsManager__invalid_max_traffic_limit' => "La quantitat de trànsit ha de ser igual o inferior a %1.",
    'ippoolManager__ip_has_suballocations' => "No es pot canviar el tipus d'adreça IP ja assignada a un usuari. L'adreça IP %%ip%% ja està assignada a usuari(s) com adreça IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Aquesta adreça IP ja està assignada a l'usuari.",
    'ippoolManager__ip_is_not_in_pool' => "No hi ha cap adreça IP %%ip%% al grup d'adreces IP.",
    'ippoolManager__can_not_allocate_ip' => "L'adreça IP %%ip%% només està disponible com a %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "L'adreça IP %%ip%% no es pot assignar com a dedicada.",
    'ippoolManager__ip_used_by_hst_or_frw' => "L'adreça IP %%ip%% ja s'utilitza pel hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "Ja s'ha activat l'accés a l'FTP anònim per l'adreça IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "No hi ha cap adreça IP vacant.",
    'ippoolManager__no_available_ips' => "No hi ha cap adreça IP disponible.",
    'templates__dublicate_name' => "Ja existeix una plantilla amb aquest nom. Seleccioni un altre nom per aquesta plantilla.",
    'cl_perm__client_limits_exceeded' => "Els valors especificats pel límit de recursos excedeixen els valors permesos pel seu pla de hosting o bé aquests valors proporcionen menys recursos que els utilitzats actualment pels seus llocs.",
    'cl_perm__reseller_limits_exceeded' => "Els valors especificats pel límit de recursos excedeixen els valors permesos pel seu pla de hosting o bé aquests valors proporcionen menys recursos que els utilitzats actualment pels llocs i comptes d'usuari.",

    'site_apps__preferences_show_all_versions_title' => "Mostrar la llista completa de versions per cadascuna de les aplicacions recuperades del catàleg",
    'site_apps__preferences_show_all_versions_hint' => "Si selecciona aquesta opció, es tardarà bastant en recuperar totes les versions de cadascuna de les aplicacions cada vegada que obri el catàleg. De no seleccionar-se, només es mostraran les versions més recents.",
    '__select_user_template' => "Crear compte d'usuari basant-se en una plantilla",
    'ip_already_added_to_all_clients' => "Aquesta adreça IP ja està assignada a tots els usuaris.",

    'site_apps__cancelled_apps' => "Ha cancel·lat l'addició de les següents aplicacions: %2",

    'sb_url_is_not_resolved' => 'L\'URL no es pot resoldre. Comprovi la seva configuració de DNS. L\'URL %1 ha de resoldre a l\'adreça IP del servidor on s\'ha instal·lat Presence Builder.',

    'ip_addr__is_last_on_interface' => 'No es pot eliminar l\'adreça IP %%ip%% perquè és l\'última adreça IP present en una interfície de xarxa.',
    'ip_addr__used_for_current_session' => 'No es pot eliminar l\'adreça IP %%ip%% perquè es utilitzada per una sessió activa.',
    'ip_addr__used_for_hosting' => 'No es pot eliminar l\'adreça IP %%ip%% perquè s\'utilitza per allotjar un lloc web.',
    'ip_addr__is_main' => 'No es pot eliminar l\'adreça IP %%ip%% perquè és l\'adreça IP principal d\'una interfície de xarxa.',
    'ip_addr__ip_used_by_message_submission' => 'No es pot eliminar l\'adreça IP %%ip%% perquè s\'utilitza per a enviar correus electrònics.',

    // RESELLER ACTION LOG

    '__cl_domains' => 'dominis de clients',
    'excl_ip_num' => 'Adreça IP dedicada',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder no està instal·lat.',

    '__perm_allow_oversell_can_not_be_revoked' => 'El permís per permetre la sobreventa no es pot revocar de l\'usuari, ja que aquest ja té assignats més recursos del disponibles, pel que ja passa al mode de sobreventa.',
    'limitsManager__invalid_limit_value' => 'El valor %%value%% especificat no és correcte pel límit %%limit_name%%',
    'limit__max_mn' => 'Número màxim de comptes de correu',

    'limits__client_overuse_description' => 'La directiva de sobreús indica a Plesk què cal fer quan l\'ús de recursos excedeix l\'assignació inicial de recursos.',
    'limits__client_overuse_block_true_description' => 'Bloquejar el sobreús de recursos. L\'ús actual de recursos no pot excedir l\'assignació inicial de recursos.',
    'limits__client_overuse_block_false_description' => 'No bloquejar el sobreús de recursos i permetre al client utilitzar més recursos dels proporcionats inicialment. L\'ús actual de recursos pot excedir l\'assignació inicial de recursos.',
    'limits__client_overuse_notify_text' => 'Notificar al client quan s\'assoleixin els límits de recursos',

    'limits__domain_overuse_description' => 'La directiva de sobreús indica a Plesk què cal fer quan l\'ús de recursos excedeix l\'assignació inicial de recursos.',
    'limits__domain_overuse_block_true_description' => 'La directiva de sobreús indica a Plesk què cal fer quan es fa un ús excessiu dels recursos.',
    'limits__domain_overuse_block_false_description' => 'No bloquejar el sobreús de recursos i permetre al domini utilitzar més recursos dels proporcionats inicialment. L\'ús actual de recursos pot excedir l\'assignació inicial de recursos.',
    'limits__domain_overuse_notify_text' => 'Notificar al propietari del domini quan s\'assoleixin els límits de recursos',

    'dns__dns_rr_delete' => 'Elements que s\'eliminaran',
    'dns__delete_rr' => 'Els següents registres DNS s\'eliminaran de la zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Elements que no es poden eliminar',
    'dns__non_delete_rr' => 'Els següents registres DNS no es poden eliminar:',
    'dns__dns_rr_delete_confirm_message' => 'Confirmi l\'eliminació dels registres DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Format desconegut de l\'aplicació web. És possible que aquesta no es pugui instal·lar ni utilitzar.',

    '__php_handler_type_desc' => 'Executar PHP com a',
    'sfdk_domain_sign__failed' => 'S\'ha produït un error no identificat mentre s\'intentava activar la signatura de correus amb DKIM al domini. Si desitja més informació, consulti el registre d\'errors del servidor.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notificació sobre l\'actualització correcta de la clau de Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notificació sobre l\'ajornament de l\'actualització de la clau de Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notificació sobre error a l\'actualitzar la clau de Plesk',
    'pkey_notify__update_successful' => 'Actualització de %1 completada correctament.',
    'pkey_notify__update_failed_no_more_try' => 'No ha estat possible actualitzar %1. La clau que està intentant enviar no és vàlida. No torni a provar actualitzar aquesta clau.',
    'pkey_notify__update_failed_try_later' => 'No ha estat possible actualitzar %1. S\'ha produït un error mentre es processava la seva clau. Pot provar a recuperar la clau manualment a Plesk (Eines i configuració> Informació de la llicència) o bé permetre que Plesk intenti actualitzar-la durant les properes 24 hores. Si no desitja tornar a rebre aquesta notificació, elimini aquesta clau de Plesk.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Dominis',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'ÀliesDom',
    'rpt_reseller_dom_postboxes' => 'Bcorreu',
    'rpt_reseller_dom_redirects' => 'Redireccionaments',
    'rpt_reseller_dom_mail_groups' => 'GCorreu',
    'rpt_reseller_dom_mail_resps' => 'Resp.Aut',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'LlisCorreu',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Clients',
    '__cl_name' => 'Nom del client',
    '__cl_creation_date' => 'Data de creació',
    '__clients_traffic' => 'Trànsit del client',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder no està instal·lat.',
    'sitebuilder_disabled' => 'Presence Builder està desactivat.',
    'b_sitebuilder_disabled' => 'Presence Builder està desactivat.',
    'webmail_not_installed' => 'El software de webmail no està instal·lat.',
    'webmail_disabled' => 'El servei de webmail està desactivat.',
    'spamassassin_not_installed' => 'SpamAssassin no està instal·lat.',
    // pfu:
    'anonymous_ftp_shared' => 'No ha estat possible configurar l\'FTP anònim. L\'adreça IP és compartida.',
    'anonymous_ftp_used' => 'No ha estat possible configurar l\'FTP anònim. Hi ha un altre domini que utilitza l\'adreça IP pel servei d\'FTP anònim.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET no està instal·lat.',
    'site_builder_no_package' => 'Presence Builder no està disponible. Comprovi que Presence Builder està instal·lat i que s\'ha seleccionat com a component actiu.',
    'site_builder_not_configured' => 'Presence Builder no està configurat.',

    // various

    'disabled_by_admin' => 'Desactivat per l\'administrador del servidor',

    '__not_allowed' => 'No permès',

    '__ip_addr_state_unknown' => "L'adreça IP no està operativa en aquests moments perquè el sistema encara està processant la seva petició. Agraïm esperi un minut.",

    'ip_addr__repair_is_not_allowed' => 'L\'adreça IP no es pot reparar sota l\'entorn Virtuozzo.',

    'ippoolManager__ip_used_by_nohost_domain' => "L'adreça IP %%ip%% no es pot eliminar perquè és utilitzada per un o més dominis sense hosting.",
    'ippoolManager__ip_used_for_mail_service' => "L'adreça IP %%ip%% no es pot eliminar perquè és utilitzada per un o més dominis per l'adreça IP del seu servei de correu.",
    'ippoolManager__ip_used_for_send_emails' => "L'adreça IP %%ip%% no es pot eliminar perquè és utilitzada per enviar emails des d'una IP específica (examini la configuració del servidor de correu).",
    'ippoolManager__ip_used_in_dns_zone' => 'L\'adreça IP %%ip%% no es pot eliminar perquè es utilitzada per la zona DNS d\'un o més dominis.',
    'ip_ctrl__cannot_manage_on_vz' => 'Aquesta instal·lació de Plesk opera sota Virtuozzo containers. L\'administrador del node Virtuozzo containers és l\'únic que pot afegir adreces IP noves.',

    'client_template__limits_auto_adjusted' => 'Els límits de la plantilla del client s\'han ajustat automàticament.',

    '__entries' => 'Entrades',

    '__path_is_not_set' => 'No s\'ha especificat cap ruta. Especifiqui una ruta vàlida.',

    'defaultcomponents__imap_required' => '(El servidor de correu actual no suporta IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk només suporta software d\'estadístiques web comercial pel càlcul de les estadístiques dels subdominis. Al sistema no s\'ha instal·lat cap software d\'aquest tipus.',


    'server_settings_invalid_traffic_statistics' => 'Paràmetre de conservació d\'estadístiques de tràfic no vàlid.',
    'server_settings_invalid_logrotate_period' => 'Paràmetre de període de rotació de registres no vàlid.',

    'spam_filter/address/file_size' => 'No ha estat possible carregar l\'arxiu. El tamany màxim dels arxius carregats és de %1.',
    'spam_filter/address/file_empty_content' => 'No s\'han pogut llegir les adreces de l\'arxiu. Comprova que estiguis carregant un arxiu en format UTF-8 i que contingui una o més adreces de correu i, després, torna-ho a intentar.',
    'spam_filter/address/addresses_empty_content' => 'A la llista no hi ha cap adreça de correu.',
    'spam_filter/address/addresses_available' => 'Només s\'afegiran les primeres %1 adreces de correu.',
    'spam_filter/address/invalid_addresses' => 'Les següents adreces de correu no són vàlides: %1.',

    'current_resources' => 'Recursos actuals',
    'plan_limitations' => 'Limitacions del pla',
    'cannot_switch_plan' => 'No es pot canviar al pla seleccionat perquè els recursos actuals següents superen les limitacions del pla:',
];