/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import java.net.InetAddress;
import java.util.List;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.ipfilter.IpFilterType;
import org.apache.ftpserver.ipfilter.RemoteIpFilter;
import org.apache.ftpserver.ipfilter.SessionFilter;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.filter.firewall.Subnet;

public abstract class AbstractListener
implements Listener {
    private final String serverAddress;
    private int port = 21;
    private final SslConfiguration ssl;
    private final boolean implicitSsl;
    private final int idleTimeout;
    private final List<InetAddress> blockedAddresses;
    private final List<Subnet> blockedSubnets;
    private final SessionFilter sessionFilter;
    private final DataConnectionConfiguration dataConnectionConfig;

    @Deprecated
    public AbstractListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets) {
        this.serverAddress = serverAddress;
        this.port = port;
        this.implicitSsl = implicitSsl;
        this.dataConnectionConfig = dataConnectionConfig;
        this.ssl = sslConfiguration;
        this.idleTimeout = idleTimeout;
        this.sessionFilter = AbstractListener.createBlackListFilter(blockedAddresses, blockedSubnets);
        this.blockedAddresses = blockedAddresses;
        this.blockedSubnets = blockedSubnets;
    }

    public AbstractListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, SessionFilter sessionFilter) {
        this.serverAddress = serverAddress;
        this.port = port;
        this.implicitSsl = implicitSsl;
        this.dataConnectionConfig = dataConnectionConfig;
        this.ssl = sslConfiguration;
        this.idleTimeout = idleTimeout;
        this.sessionFilter = sessionFilter;
        this.blockedAddresses = null;
        this.blockedSubnets = null;
    }

    private static SessionFilter createBlackListFilter(List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets) {
        if (blockedAddresses == null && blockedSubnets == null) {
            return null;
        }
        RemoteIpFilter ipFilter = new RemoteIpFilter(IpFilterType.DENY);
        if (blockedSubnets != null) {
            ipFilter.addAll(blockedSubnets);
        }
        if (blockedAddresses != null) {
            for (InetAddress address : blockedAddresses) {
                ipFilter.add(new Subnet(address, 32));
            }
        }
        return ipFilter;
    }

    @Override
    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    @Override
    public DataConnectionConfiguration getDataConnectionConfiguration() {
        return this.dataConnectionConfig;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public List<InetAddress> getBlockedAddresses() {
        return this.blockedAddresses;
    }

    @Override
    public List<Subnet> getBlockedSubnets() {
        return this.blockedSubnets;
    }

    @Override
    public SessionFilter getSessionFilter() {
        return this.sessionFilter;
    }
}

