/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import org.apache.ftpserver.ftplet.DataTransferFtpReply;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpReplyTranslator;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;

public class LocalizedDataTransferFtpReply
extends LocalizedFtpReply
implements DataTransferFtpReply {
    private final FtpFile file;
    private final long bytesTransferred;

    public LocalizedDataTransferFtpReply(int code, String message, FtpFile file, long bytesTransferred) {
        super(code, message);
        this.file = file;
        this.bytesTransferred = bytesTransferred;
    }

    public FtpFile getFile() {
        return this.file;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public static LocalizedDataTransferFtpReply translate(FtpIoSession session, FtpRequest request, FtpServerContext context, int code, String subId, String basicMsg, FtpFile file) {
        String msg = FtpReplyTranslator.translateMessage(session, request, context, code, subId, basicMsg);
        return new LocalizedDataTransferFtpReply(code, msg, file, 0L);
    }

    public static LocalizedDataTransferFtpReply translate(FtpIoSession session, FtpRequest request, FtpServerContext context, int code, String subId, String basicMsg, FtpFile file, long bytesTransferred) {
        String msg = FtpReplyTranslator.translateMessage(session, request, context, code, subId, basicMsg);
        return new LocalizedDataTransferFtpReply(code, msg, file, bytesTransferred);
    }
}

