/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.ButtonDriver;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ButtonOperator
extends ComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Label";
    private static final long PUSH_BUTTON_TIMEOUT = 0L;
    private Timeouts timeouts;
    private TestOut output;
    ButtonDriver driver = DriverManager.getButtonDriver(this.getClass());

    public ButtonOperator(Button b) {
        super(b);
    }

    public ButtonOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((Button)cont.waitSubComponent(new ButtonFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public ButtonOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ButtonOperator(ContainerOperator cont, String text, int index) {
        this((Button)ButtonOperator.waitComponent(cont, (ComponentChooser)new ButtonByLabelFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public ButtonOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public ButtonOperator(ContainerOperator cont, int index) {
        this((Button)ButtonOperator.waitComponent(cont, (ComponentChooser)new ButtonFinder(), index));
        this.copyEnvironment(cont);
    }

    public ButtonOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static Button findButton(Container cont, ComponentChooser chooser, int index) {
        return (Button)ButtonOperator.findComponent(cont, new ButtonFinder(chooser), index);
    }

    public static Button findButton(Container cont, ComponentChooser chooser) {
        return ButtonOperator.findButton(cont, chooser, 0);
    }

    public static Button findButton(Container cont, String text, boolean ce, boolean ccs, int index) {
        return ButtonOperator.findButton(cont, new ButtonByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static Button findButton(Container cont, String text, boolean ce, boolean ccs) {
        return ButtonOperator.findButton(cont, text, ce, ccs, 0);
    }

    public static Button waitButton(Container cont, ComponentChooser chooser, int index) {
        return (Button)ButtonOperator.waitComponent(cont, (ComponentChooser)new ButtonFinder(chooser), index);
    }

    public static Button waitButton(Container cont, ComponentChooser chooser) {
        return ButtonOperator.waitButton(cont, chooser, 0);
    }

    public static Button waitButton(Container cont, String text, boolean ce, boolean ccs, int index) {
        return ButtonOperator.waitButton(cont, new ButtonByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static Button waitButton(Container cont, String text, boolean ce, boolean ccs) {
        return ButtonOperator.waitButton(cont, text, ce, ccs, 0);
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ButtonDriver)DriverManager.getDriver("drivers.button", this.getClass(), anotherOperator.getProperties());
    }

    public void push() {
        this.output.printLine("Push button\n    :" + this.toStringSource());
        this.output.printGolden("Push button");
        this.driver.push(this);
    }

    public void pushNoBlock() {
        this.produceNoBlocking(new Operator.NoBlockingAction("Button pushing"){

            @Override
            public Object doAction(Object param) {
                ButtonOperator.this.push();
                return null;
            }
        });
    }

    public void press() {
        this.output.printLine("Press button\n    :" + this.toStringSource());
        this.output.printGolden("Press button");
        this.driver.press(this);
    }

    public void release() {
        this.output.printLine("Release button\n    :" + this.toStringSource());
        this.output.printGolden("Release button");
        this.driver.press(this);
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((Button)this.getSource()).getLabel() != null) {
            result.put(TEXT_DPROP, ((Button)this.getSource()).getLabel());
        }
        return result;
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            @Override
            public void map() {
                ((Button)ButtonOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public String getActionCommand() {
        return (String)this.runMapping(new Operator.MapAction("getActionCommand"){

            @Override
            public Object map() {
                return ((Button)ButtonOperator.this.getSource()).getActionCommand();
            }
        });
    }

    public String getLabel() {
        return (String)this.runMapping(new Operator.MapAction("getLabel"){

            @Override
            public Object map() {
                return ((Button)ButtonOperator.this.getSource()).getLabel();
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            @Override
            public void map() {
                ((Button)ButtonOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void setActionCommand(final String string) {
        this.runMapping(new Operator.MapVoidAction("setActionCommand"){

            @Override
            public void map() {
                ((Button)ButtonOperator.this.getSource()).setActionCommand(string);
            }
        });
    }

    public void setLabel(final String string) {
        this.runMapping(new Operator.MapVoidAction("setLabel"){

            @Override
            public void map() {
                ((Button)ButtonOperator.this.getSource()).setLabel(string);
            }
        });
    }

    static {
        Timeouts.initDefault("ButtonOperator.PushButtonTimeout", 0L);
    }

    public static class ButtonFinder
    extends Operator.Finder {
        public ButtonFinder(ComponentChooser sf) {
            super(Button.class, sf);
        }

        public ButtonFinder() {
            super(Button.class);
        }
    }

    public static class ButtonByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public ButtonByLabelFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public ButtonByLabelFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof Button && ((Button)comp).getLabel() != null) {
                return this.comparator.equals(((Button)comp).getLabel(), this.label);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Button with label \"" + this.label + "\"";
        }
    }
}

