/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.reader;

import com.google.common.hash.Hashing;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.util.URLUtils;

public class HashTempFileScheme
implements TempFileNameScheme {
    @Override
    public URI generateTempFileName(URI src) {
        assert (src.isAbsolute());
        String ext = FilenameUtils.getExtension((String)src.getPath());
        String path = URLUtils.stripFragment(src.normalize()).toString();
        String hash = Hashing.sha1().hashString((CharSequence)path, StandardCharsets.UTF_8).toString();
        return URLUtils.toURI((String)(ext.isEmpty() ? hash : hash + "." + ext));
    }
}

