/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Pair;

public class PreferenceDialog
extends JDialog {
    private final PreferenceTabbedPane tpPreferences = new PreferenceTabbedPane();
    private final ContextSensitiveHelpAction helpAction = new ContextSensitiveHelpAction();
    private final WindowEventHandler windowEventHandler = new WindowEventHandler();
    private boolean canceled;
    private static Pair<Class<? extends TabPreferenceSetting>, Class<? extends SubPreferenceSetting>> previouslySelected;

    public PreferenceDialog(Component parent) {
        super((Window)GuiHelper.getFrameForComponent(parent), I18n.tr("Preferences", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.setMinimumSize(new Dimension(800, 600));
        this.setMaximumSize(GuiHelper.getScreenSize());
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        JCheckBox expert = new JCheckBox(I18n.tr("Expert Mode", new Object[0]));
        expert.setSelected(ExpertToggleAction.isExpert());
        expert.addActionListener(e -> ExpertToggleAction.getInstance().actionPerformed(null));
        JPanel btns = new JPanel(new FlowLayout(1));
        btns.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        OKAction okAction = new OKAction();
        btns.add(new JButton(okAction));
        btns.add(new JButton(new CancelAction()));
        btns.add(new JButton(this.helpAction));
        pnl.add((Component)expert, GBC.std().insets(5, 0, 0, 0));
        pnl.add((Component)btns, GBC.std().fill(2));
        InputMapUtils.addCtrlEnterAction(pnl, okAction);
        return pnl;
    }

    protected final void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.tpPreferences, "Center");
        this.tpPreferences.buildGui();
        this.tpPreferences.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        c.add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(this.windowEventHandler);
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        this.setHelpContext(HelpUtil.ht("/Action/Preferences"));
    }

    public final void setHelpContext(String helpContext) {
        this.helpAction.setHelpTopic(helpContext);
        HelpUtil.setHelpContext(this.getRootPane(), helpContext);
    }

    public PreferenceTabbedPane getTabbedPane() {
        return this.tpPreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Insets i = this.getParent().getInsets();
            Dimension p = this.getParent().getSize();
            p = new Dimension(Math.min(p.width - i.left - i.right, 700), Math.min(p.height - i.top - i.bottom, 800));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), p)).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void selectPreviouslySelectedPreferences() {
        if (previouslySelected != null && PreferenceDialog.previouslySelected.b != null) {
            this.tpPreferences.selectSubTabByPref((Class)PreferenceDialog.previouslySelected.b);
        } else if (previouslySelected != null && PreferenceDialog.previouslySelected.a != null) {
            this.tpPreferences.selectTabByPref((Class)PreferenceDialog.previouslySelected.a);
        } else {
            this.tpPreferences.setSelectedIndex(0);
        }
    }

    public void selectPreferencesTabByName(String name) {
        this.tpPreferences.selectTabByName(name);
    }

    public void selectPreferencesTabByClass(Class<? extends TabPreferenceSetting> clazz) {
        this.tpPreferences.selectTabByPref(clazz);
    }

    public void selectSubPreferencesTabByClass(Class<? extends SubPreferenceSetting> clazz) {
        this.tpPreferences.selectSubTabByPref(clazz);
    }

    @Override
    public void dispose() {
        previouslySelected = this.tpPreferences.getSelectedTab();
        this.removeWindowListener(this.windowEventHandler);
        this.setVisible(false);
        super.dispose();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Save the preferences and close the dialog", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (PreferenceTabbedPane.ValidationListener listener : PreferenceDialog.this.tpPreferences.validationListeners) {
                if (listener.validatePreferences()) continue;
                return;
            }
            PreferenceDialog.this.tpPreferences.savePreferences();
            PreferenceDialog.this.setCanceled(false);
            PreferenceDialog.this.dispose();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the preferences dialog and discard preference updates", new Object[0]));
        }

        public void cancel() {
            PreferenceDialog.this.setCanceled(true);
            PreferenceDialog.this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }
}

