/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;

public final class MapPaintSettings
implements PreferenceChangedListener {
    public static final MapPaintSettings INSTANCE = new MapPaintSettings();
    private boolean useRealWidth;
    private boolean showDirectionArrow;
    private boolean showOnewayArrow;
    private int defaultSegmentWidth;
    private boolean showOrderNumber;
    private boolean showOrderNumberOnSelectedWay;
    private boolean showHeadArrowOnly;
    private int showNamesDistance;
    private int useStrokesDistance;
    private int showIconsDistance;
    private int selectedNodeSize;
    private int connectionNodeSize;
    private int unselectedNodeSize;
    private int taggedNodeSize;
    private boolean fillSelectedNode;
    private boolean fillUnselectedNode;
    private boolean fillTaggedNode;
    private boolean fillConnectionNode;
    private boolean outlineOnly;
    private Color selectedColor;
    private Color relationSelectedColor;
    private Color highlightColor;
    private Color inactiveColor;
    private Color nodeColor;
    private Color taggedColor;
    private Color connectionColor;
    private Color taggedConnectionColor;

    private MapPaintSettings() {
        this.load();
        Config.getPref().addPreferenceChangeListener(this);
    }

    private void load() {
        this.showDirectionArrow = Config.getPref().getBoolean("draw.segment.direction", false);
        this.showOnewayArrow = Config.getPref().getBoolean("draw.oneway", true);
        this.useRealWidth = Config.getPref().getBoolean("mappaint.useRealWidth", false);
        this.defaultSegmentWidth = Config.getPref().getInt("mappaint.segment.default-width", 2);
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.nodeColor = PaintColors.NODE.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
        this.showOrderNumber = Config.getPref().getBoolean("draw.segment.order_number", false);
        this.showOrderNumberOnSelectedWay = Config.getPref().getBoolean("draw.segment.order_number.on_selected", false);
        this.showHeadArrowOnly = Config.getPref().getBoolean("draw.segment.head_only", false);
        this.showNamesDistance = Config.getPref().getInt("mappaint.shownames", 10000000);
        this.useStrokesDistance = Config.getPref().getInt("mappaint.strokes", 10000000);
        this.showIconsDistance = Config.getPref().getInt("mappaint.showicons", 10000000);
        this.selectedNodeSize = Config.getPref().getInt("mappaint.node.selected-size", 5);
        this.unselectedNodeSize = Config.getPref().getInt("mappaint.node.unselected-size", 3);
        this.connectionNodeSize = Config.getPref().getInt("mappaint.node.connection-size", 5);
        this.taggedNodeSize = Config.getPref().getInt("mappaint.node.tagged-size", 3);
        this.fillSelectedNode = Config.getPref().getBoolean("mappaint.node.fill-selected", true);
        this.fillUnselectedNode = Config.getPref().getBoolean("mappaint.node.fill-unselected", false);
        this.fillTaggedNode = Config.getPref().getBoolean("mappaint.node.fill-tagged", true);
        this.fillConnectionNode = Config.getPref().getBoolean("mappaint.node.fill-connection", false);
        this.outlineOnly = Config.getPref().getBoolean("draw.data.area_outline_only", false);
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        this.load();
    }

    public boolean isUseRealWidth() {
        return this.useRealWidth;
    }

    public boolean isShowDirectionArrow() {
        return this.showDirectionArrow;
    }

    public boolean isShowOnewayArrow() {
        return this.showOnewayArrow;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getSelectedColor(int alpha) {
        return new Color(this.selectedColor.getRGB() & 0xFFFFFF | alpha << 24, true);
    }

    public int getDefaultSegmentWidth() {
        return this.defaultSegmentWidth;
    }

    public Color getRelationSelectedColor() {
        return this.relationSelectedColor;
    }

    public Color getRelationSelectedColor(int alpha) {
        return new Color(this.relationSelectedColor.getRGB() & 0xFFFFFF | alpha << 24, true);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public Color getTaggedColor() {
        return this.taggedColor;
    }

    public Color getConnectionColor() {
        return this.connectionColor;
    }

    public Color getTaggedConnectionColor() {
        return this.taggedConnectionColor;
    }

    public boolean isShowOrderNumber() {
        return this.showOrderNumber;
    }

    public boolean isShowOrderNumberOnSelectedWay() {
        return this.showOrderNumberOnSelectedWay;
    }

    public void setShowHeadArrowOnly(boolean showHeadArrowOnly) {
        this.showHeadArrowOnly = showHeadArrowOnly;
    }

    public boolean isShowHeadArrowOnly() {
        return this.showHeadArrowOnly;
    }

    public int getShowNamesDistance() {
        return this.showNamesDistance;
    }

    public int getUseStrokesDistance() {
        return this.useStrokesDistance;
    }

    public int getShowIconsDistance() {
        return this.showIconsDistance;
    }

    public int getSelectedNodeSize() {
        return this.selectedNodeSize;
    }

    public int getConnectionNodeSize() {
        return this.connectionNodeSize;
    }

    public int getUnselectedNodeSize() {
        return this.unselectedNodeSize;
    }

    public int getTaggedNodeSize() {
        return this.taggedNodeSize;
    }

    public boolean isFillSelectedNode() {
        return this.fillSelectedNode;
    }

    public boolean isFillUnselectedNode() {
        return this.fillUnselectedNode;
    }

    public boolean isFillConnectionNode() {
        return this.fillConnectionNode;
    }

    public boolean isFillTaggedNode() {
        return this.fillTaggedNode;
    }

    public boolean isOutlineOnly() {
        return this.outlineOnly;
    }

    public String toString() {
        return "MapPaintSettings [useRealWidth=" + this.useRealWidth + ", showDirectionArrow=" + this.showDirectionArrow + ", showOnewayArrow=" + this.showOnewayArrow + ", defaultSegmentWidth=" + this.defaultSegmentWidth + ", showOrderNumber=" + this.showOrderNumber + ", showHeadArrowOnly=" + this.showHeadArrowOnly + ", showNamesDistance=" + this.showNamesDistance + ", useStrokesDistance=" + this.useStrokesDistance + ", showIconsDistance=" + this.showIconsDistance + ", selectedNodeSize=" + this.selectedNodeSize + ", connectionNodeSize=" + this.connectionNodeSize + ", unselectedNodeSize=" + this.unselectedNodeSize + ", taggedNodeSize=" + this.taggedNodeSize + ", fillSelectedNode=" + this.fillSelectedNode + ", fillUnselectedNode=" + this.fillUnselectedNode + ", fillTaggedNode=" + this.fillTaggedNode + ", fillConnectionNode=" + this.fillConnectionNode + ", outlineOnly=" + this.outlineOnly + ", selectedColor=" + String.valueOf(this.selectedColor) + ", relationSelectedColor=" + String.valueOf(this.relationSelectedColor) + ", highlightColor=" + String.valueOf(this.highlightColor) + ", inactiveColor=" + String.valueOf(this.inactiveColor) + ", nodeColor=" + String.valueOf(this.nodeColor) + ", taggedColor=" + String.valueOf(this.taggedColor) + ", connectionColor=" + String.valueOf(this.connectionColor) + ", taggedConnectionColor=" + String.valueOf(this.taggedConnectionColor) + "]";
    }
}

