/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Optional;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidationTask;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ValidateAction
extends JosmAction {
    private transient Collection<OsmPrimitive> lastSelection;

    public ValidateAction() {
        super(I18n.tr("Validation", new Object[0]), "dialogs/validator", I18n.tr("Performs the data validation", new Object[0]), Shortcut.registerShortcut("tools:validate", I18n.tr("Validation", new Object[0]), 86, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.doValidate(true);
    }

    public void doValidate(boolean getSelectedItems) {
        Collection<OsmPrimitive> selection;
        MapFrame map = MainApplication.getMap();
        if (map == null || !map.isVisible()) {
            return;
        }
        OsmValidator.initializeTests();
        Collection<Test> tests = OsmValidator.getEnabledTests(false);
        if (tests.isEmpty()) {
            return;
        }
        if (getSelectedItems) {
            selection = this.getLayerManager().getActiveDataSet().getAllSelected();
            if (selection.isEmpty()) {
                selection = this.getLayerManager().getActiveDataSet().allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                this.lastSelection = selection;
            }
        } else {
            selection = Optional.ofNullable(this.lastSelection).orElseGet(() -> this.getLayerManager().getActiveDataSet().allNonDeletedPrimitives());
        }
        MainApplication.worker.submit(new ValidationTask(tests, selection, this.lastSelection));
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveDataSet() != null);
    }

    @Override
    public void destroy() {
        this.lastSelection = null;
    }
}

