/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ToolchainReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.serialization.Cached;
import org.gradle.jvm.toolchain.internal.CurrentInstallationSupplier;

@UntrackedTask(because="Produces only non-cacheable console output")
public abstract class BuildEnvironmentReportTask
extends DefaultTask {
    public static final String TASK_NAME = "buildEnvironment";
    private final ToolchainReportRenderer toolchainReportRenderer = new ToolchainReportRenderer();
    private final DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();
    final Cached<BuildEnvironmentReportModel> reportModel = Cached.of(this::calculateReportModel);

    private BuildEnvironmentReportModel calculateReportModel() {
        return new BuildEnvironmentReportModel(ProjectDetails.of((Project)this.getProject()), ConfigurationDetails.of(this.classpathConfiguration()));
    }

    private Configuration classpathConfiguration() {
        return this.getProject().getBuildscript().getConfigurations().getByName("classpath");
    }

    @Inject
    protected abstract BuildClientMetaData getClientMetaData();

    @Inject
    protected abstract StyledTextOutputFactory getTextOutputFactory();

    @Inject
    protected abstract JvmMetadataDetector getMetadataDetector();

    @TaskAction
    public void generate() {
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        output.append((CharSequence)"Daemon JVM: ");
        this.toolchainReportRenderer.setOutput(output);
        this.toolchainReportRenderer.printToolchainMetadata(this.getMetadataDetector().getMetadata(new CurrentInstallationSupplier().getInstallation()));
        this.reportGenerator().generateReport(Collections.singleton((BuildEnvironmentReportModel)this.reportModel.get()), model -> ((BuildEnvironmentReportModel)model).project, model -> {
            this.renderer.startConfiguration(((BuildEnvironmentReportModel)model).configuration);
            this.renderer.render(((BuildEnvironmentReportModel)model).configuration);
            this.renderer.completeConfiguration(((BuildEnvironmentReportModel)model).configuration);
        });
    }

    private ReportGenerator reportGenerator() {
        return new ReportGenerator((ReportRenderer)this.renderer, this.getClientMetaData(), null, this.getTextOutputFactory());
    }

    private static final class BuildEnvironmentReportModel {
        private final ProjectDetails project;
        private final ConfigurationDetails configuration;

        public BuildEnvironmentReportModel(ProjectDetails project, ConfigurationDetails configuration) {
            this.project = project;
            this.configuration = configuration;
        }
    }
}

