/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.Cast;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.IntermediateBuildActionRunner;
import org.gradle.tooling.provider.model.internal.IntermediateToolingModelProvider;
import org.gradle.tooling.provider.model.internal.PluginApplyingBuilder;
import org.gradle.tooling.provider.model.internal.PluginApplyingParameter;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelProjectDependencyListener;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultIntermediateToolingModelProvider
implements IntermediateToolingModelProvider {
    private final IntermediateBuildActionRunner actionRunner;
    private final ToolingModelParameterCarrier.Factory parameterCarrierFactory;
    private final ToolingModelProjectDependencyListener projectDependencyListener;

    public DefaultIntermediateToolingModelProvider(IntermediateBuildActionRunner actionRunner, ToolingModelParameterCarrier.Factory parameterCarrierFactory, ToolingModelProjectDependencyListener projectDependencyListener) {
        this.actionRunner = actionRunner;
        this.parameterCarrierFactory = parameterCarrierFactory;
        this.projectDependencyListener = projectDependencyListener;
    }

    @Override
    public <T> List<T> getModels(Project requester, List<Project> targets, String modelName, Class<T> modelType, @Nullable Object parameter) {
        if (targets.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> rawModels = this.fetchModels(requester, targets, modelName, parameter);
        return DefaultIntermediateToolingModelProvider.ensureModelTypes(modelType, rawModels);
    }

    @Override
    public <P extends Plugin<Project>> void applyPlugin(Project requester, List<Project> targets, Class<P> pluginClass) {
        List<Object> rawModels = this.fetchModels(requester, targets, PluginApplyingBuilder.MODEL_NAME, DefaultIntermediateToolingModelProvider.createPluginApplyingParameter(pluginClass));
        DefaultIntermediateToolingModelProvider.ensureModelTypes(Boolean.class, rawModels);
    }

    private static <P extends Plugin<Project>> PluginApplyingParameter createPluginApplyingParameter(Class<P> pluginClass) {
        return () -> pluginClass;
    }

    private List<Object> fetchModels(Project requester, List<Project> targets, String modelName, @Nullable Object parameter) {
        this.reportToolingModelDependencies((ProjectInternal)requester, targets);
        BuildState buildState = DefaultIntermediateToolingModelProvider.extractSingleBuildState(targets);
        ToolingModelParameterCarrier carrier = parameter == null ? null : this.parameterCarrierFactory.createCarrier(parameter);
        return buildState.withToolingModels(controller -> this.getModels((BuildToolingModelController)controller, targets, modelName, carrier));
    }

    private List<Object> getModels(BuildToolingModelController controller, List<Project> targets, String modelName, @Nullable ToolingModelParameterCarrier parameter) {
        List fetchActions = targets.stream().map(targetProject -> () -> DefaultIntermediateToolingModelProvider.fetchModel(modelName, controller, (ProjectInternal)targetProject, parameter)).collect(Collectors.toList());
        return this.runFetchActions(fetchActions);
    }

    private static @Nullable Object fetchModel(String modelName, BuildToolingModelController controller, ProjectInternal targetProject, @Nullable ToolingModelParameterCarrier parameter) {
        ProjectState builderTarget = targetProject.getOwner();
        ToolingModelScope toolingModelScope = controller.locateBuilderForTarget(builderTarget, modelName, parameter != null);
        return toolingModelScope.getModel(modelName, parameter);
    }

    private static BuildState extractSingleBuildState(List<Project> targets) {
        if (targets.isEmpty()) {
            throw new IllegalStateException("Cannot find build state without target projects");
        }
        BuildState result = DefaultIntermediateToolingModelProvider.getBuildState(targets.get(0));
        for (Project target : targets) {
            BuildState projectBuildState = DefaultIntermediateToolingModelProvider.getBuildState(target);
            if (result == projectBuildState) continue;
            throw new IllegalArgumentException(String.format("Expected target projects to share the same build state. Found at least two: '%s' and '%s'", result.getDisplayName(), projectBuildState.getDisplayName()));
        }
        return result;
    }

    private static BuildState getBuildState(Project target) {
        return ((ProjectInternal)target).getOwner().getOwner();
    }

    private static <T> List<T> ensureModelTypes(Class<T> implementationType, List<Object> rawModels) {
        for (Object rawModel : rawModels) {
            if (rawModel == null) {
                throw new IllegalStateException(String.format("Expected model of type %s but found null", implementationType.getName()));
            }
            if (implementationType.isInstance(rawModel)) continue;
            throw new IllegalStateException(String.format("Expected model of type %s but found %s", implementationType.getName(), rawModel.getClass().getName()));
        }
        return (List)Cast.uncheckedCast(rawModels);
    }

    private <T> List<T> runFetchActions(List<Supplier<T>> actions) {
        return this.actionRunner.run(actions);
    }

    private void reportToolingModelDependencies(ProjectInternal requester, List<Project> targets) {
        for (Project target : targets) {
            this.projectDependencyListener.onToolingModelDependency(requester.getOwner(), ((ProjectInternal)target).getOwner());
        }
    }
}

