/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.dexmaker.dx.rop.code;

import java.util.ArrayList;
import org.droidparts.dexmaker.dx.rop.code.Insn;
import org.droidparts.dexmaker.dx.rop.code.RegisterSpec;
import org.droidparts.dexmaker.dx.rop.code.RegisterSpecList;
import org.droidparts.dexmaker.dx.rop.code.Rop;
import org.droidparts.dexmaker.dx.rop.code.SourcePosition;
import org.droidparts.dexmaker.dx.rop.cst.Constant;
import org.droidparts.dexmaker.dx.rop.type.StdTypeList;
import org.droidparts.dexmaker.dx.rop.type.Type;
import org.droidparts.dexmaker.dx.rop.type.TypeList;

public final class FillArrayDataInsn
extends Insn {
    private final ArrayList<Constant> initValues;
    private final Constant arrayType;

    public FillArrayDataInsn(Rop opcode, SourcePosition position, RegisterSpecList sources, ArrayList<Constant> initValues, Constant cst) {
        super(opcode, position, null, sources);
        if (opcode.getBranchingness() != 1) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        this.initValues = initValues;
        this.arrayType = cst;
    }

    @Override
    public TypeList getCatches() {
        return StdTypeList.EMPTY;
    }

    public ArrayList<Constant> getInitValues() {
        return this.initValues;
    }

    public Constant getConstant() {
        return this.arrayType;
    }

    @Override
    public void accept(Insn.Visitor visitor) {
        visitor.visitFillArrayDataInsn(this);
    }

    @Override
    public Insn withAddedCatch(Type type) {
        throw new UnsupportedOperationException("unsupported");
    }

    @Override
    public Insn withRegisterOffset(int delta) {
        return new FillArrayDataInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(delta), this.initValues, this.arrayType);
    }

    @Override
    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new FillArrayDataInsn(this.getOpcode(), this.getPosition(), sources, this.initValues, this.arrayType);
    }
}

